/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Attachment;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Revision {
    protected Document document;
    protected String parentRevID;

    @InterfaceAudience.Private
    Revision() {
    }

    @InterfaceAudience.Private
    protected Revision(Document document) {
        this.document = document;
    }

    @InterfaceAudience.Public
    public Database getDatabase() {
        return this.document.getDatabase();
    }

    @InterfaceAudience.Public
    public Document getDocument() {
        return this.document;
    }

    @InterfaceAudience.Public
    public abstract String getId();

    @InterfaceAudience.Public
    public boolean isDeletion() {
        Object deleted = this.getProperty("_deleted");
        if (deleted == null) {
            return false;
        }
        Boolean deletedBool = (Boolean)deleted;
        return deletedBool;
    }

    @InterfaceAudience.Public
    public abstract Map<String, Object> getProperties();

    @InterfaceAudience.Public
    public Map<String, Object> getUserProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> sourceMap = this.getProperties();
        for (String key : sourceMap.keySet()) {
            if (key.startsWith("_")) continue;
            result.put(key, sourceMap.get(key));
        }
        return result;
    }

    @InterfaceAudience.Public
    public List<String> getAttachmentNames() {
        Map<String, Object> attachmentMetadata = this.getAttachmentMetadata();
        if (attachmentMetadata == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(attachmentMetadata.keySet());
    }

    @InterfaceAudience.Public
    public List<Attachment> getAttachments() {
        Map<String, Object> attachmentMetadata = this.getAttachmentMetadata();
        if (attachmentMetadata == null) {
            return new ArrayList<Attachment>();
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>(attachmentMetadata.size());
        for (Map.Entry<String, Object> entry : attachmentMetadata.entrySet()) {
            Attachment attachment = this.toAttachment(entry.getKey(), entry.getValue());
            if (attachment == null) continue;
            result.add(attachment);
        }
        return result;
    }

    @InterfaceAudience.Public
    public Object getProperty(String key) {
        return this.getProperties().get(key);
    }

    @InterfaceAudience.Public
    public Attachment getAttachment(String name) {
        Map<String, Object> attachmentsMetadata = this.getAttachmentMetadata();
        if (attachmentsMetadata == null) {
            return null;
        }
        return this.toAttachment(name, attachmentsMetadata.get(name));
    }

    private Attachment toAttachment(String name, Object attachment) {
        if (attachment == null) {
            return null;
        }
        if (attachment instanceof Attachment) {
            return (Attachment)attachment;
        }
        Map metadata = (Map)attachment;
        return new Attachment(this, name, metadata);
    }

    @InterfaceAudience.Public
    public abstract SavedRevision getParent();

    @InterfaceAudience.Public
    public abstract String getParentId();

    @InterfaceAudience.Private
    abstract long getParentSequence();

    @InterfaceAudience.Public
    public abstract List<SavedRevision> getRevisionHistory() throws CouchbaseLiteException;

    @InterfaceAudience.Public
    public boolean isGone() {
        boolean wasRemovedFromChannel = false;
        Object removed = this.getProperty("_removed");
        if (removed != null) {
            Boolean removedBoolean = (Boolean)removed;
            wasRemovedFromChannel = removedBoolean;
        }
        return this.isDeletion() || wasRemovedFromChannel;
    }

    @InterfaceAudience.Public
    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof SavedRevision) {
            SavedRevision other = (SavedRevision)o;
            if (this.document.getId().equals(other.getDocument().getId()) && this.getId().equals(other.getId())) {
                result = true;
            }
        }
        return result;
    }

    @InterfaceAudience.Public
    public int hashCode() {
        return this.document.getId().hashCode() ^ this.getId().hashCode();
    }

    @InterfaceAudience.Public
    public String toString() {
        return '{' + this.document.getId() + " #" + this.getId() + (this.isDeletion() ? "DEL" : "") + '}';
    }

    @InterfaceAudience.Private
    protected Map<String, Object> getAttachmentMetadata() {
        return (Map)this.getProperty("_attachments");
    }

    @InterfaceAudience.Private
    protected void setParentRevisionID(String parentRevID) {
        this.parentRevID = parentRevID;
    }

    @InterfaceAudience.Private
    protected abstract long getSequence();

    @InterfaceAudience.Private
    protected int getGeneration() {
        return Revision.generationFromRevID(this.getId());
    }

    @InterfaceAudience.Private
    public static int generationFromRevID(String revID) {
        int generation = 0;
        int length = Math.min(revID == null ? 0 : revID.length(), 9);
        for (int i = 0; i < length; ++i) {
            char c = revID.charAt(i);
            if (!Character.isDigit(c)) {
                if (c != '-') break;
                return generation;
            }
            generation = 10 * generation + Character.getNumericValue(c);
        }
        return 0;
    }
}

