/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Misc;
import com.couchbase.lite.internal.RevisionInternal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RevisionList
extends ArrayList<RevisionInternal> {
    public RevisionList() {
    }

    public RevisionList(List<RevisionInternal> list) {
        super(list);
    }

    public RevisionInternal revWithDocIdAndRevId(String docId, String revId) {
        for (RevisionInternal rev : this) {
            if (!docId.equals(rev.getDocID()) || !revId.equals(rev.getRevID())) continue;
            return rev;
        }
        return null;
    }

    public List<String> getAllDocIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (RevisionInternal rev : this) {
            result.add(rev.getDocID());
        }
        return result;
    }

    public List<String> getAllRevIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (RevisionInternal rev : this) {
            result.add(rev.getRevID());
        }
        return result;
    }

    public void sortBySequence() {
        Collections.sort(this, new Comparator<RevisionInternal>(){

            @Override
            public int compare(RevisionInternal rev1, RevisionInternal rev2) {
                return Misc.SequenceCompare(rev1.getSequence(), rev2.getSequence());
            }
        });
    }

    public void sortByDocID() {
        Collections.sort(this, new Comparator<RevisionInternal>(){

            @Override
            public int compare(RevisionInternal rev1, RevisionInternal rev2) {
                return rev1.getDocID().compareTo(rev2.getDocID());
            }
        });
    }

    public void limit(int limit) {
        if (this.size() > limit) {
            this.removeRange(limit, this.size());
        }
    }

    public RevisionInternal revWithDocId(String docId) {
        for (RevisionInternal rev : this) {
            if (rev.getDocID() == null || !rev.getDocID().equals(docId)) continue;
            return rev;
        }
        return null;
    }

    public RevisionInternal removeAndReturnRev(RevisionInternal rev) {
        int index = this.indexOf(rev);
        if (index == -1) {
            return null;
        }
        RevisionInternal resultRev = (RevisionInternal)this.remove(index);
        return resultRev;
    }

    @Override
    public Object clone() {
        return new RevisionList((ArrayList)super.clone());
    }
}

