/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.Revision;
import com.couchbase.lite.UnsavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SavedRevision
extends Revision {
    private RevisionInternal revisionInternal;
    private boolean checkedProperties;
    String parentRevID;

    @InterfaceAudience.Private
    protected SavedRevision(Document document, RevisionInternal revision) {
        super(document);
        this.revisionInternal = revision;
    }

    @InterfaceAudience.Private
    protected SavedRevision(Database database, RevisionInternal revision) {
        this(database.getDocument(revision.getDocID()), revision);
    }

    @InterfaceAudience.Private
    protected SavedRevision(Database database, RevisionInternal revision, String parentRevID) {
        this(database.getDocument(revision.getDocID()), revision);
        this.parentRevID = parentRevID;
        this.checkedProperties = true;
    }

    @Override
    @InterfaceAudience.Public
    public Document getDocument() {
        return this.document;
    }

    @InterfaceAudience.Public
    public boolean arePropertiesAvailable() {
        return this.revisionInternal.getProperties() != null;
    }

    @Override
    @InterfaceAudience.Public
    public List<SavedRevision> getRevisionHistory() throws CouchbaseLiteException {
        ArrayList<SavedRevision> revisions = new ArrayList<SavedRevision>();
        List<RevisionInternal> internalRevisions = this.getDatabase().getRevisionHistory(this.revisionInternal);
        for (RevisionInternal internalRevision : internalRevisions) {
            if (internalRevision.getRevID().equals(this.getId())) {
                revisions.add(this);
                continue;
            }
            SavedRevision revision = this.document.getRevisionFromRev(internalRevision);
            revisions.add(revision);
        }
        Collections.reverse(revisions);
        return Collections.unmodifiableList(revisions);
    }

    @InterfaceAudience.Public
    public UnsavedRevision createRevision() {
        return new UnsavedRevision(this.document, this);
    }

    @InterfaceAudience.Public
    public SavedRevision createRevision(Map<String, Object> properties) throws CouchbaseLiteException {
        boolean allowConflict = false;
        return this.document.putProperties(properties, this.revisionInternal.getRevID(), allowConflict);
    }

    @Override
    @InterfaceAudience.Public
    public String getId() {
        return this.revisionInternal.getRevID();
    }

    @Override
    @InterfaceAudience.Public
    public boolean isDeletion() {
        return this.revisionInternal.isDeleted();
    }

    @Override
    @InterfaceAudience.Public
    public Map<String, Object> getProperties() {
        Map<String, Object> properties = this.revisionInternal.getProperties();
        if (!this.checkedProperties) {
            if (properties == null && this.loadProperties()) {
                properties = this.revisionInternal.getProperties();
            }
            this.checkedProperties = true;
        }
        return properties != null ? Collections.unmodifiableMap(properties) : null;
    }

    @InterfaceAudience.Public
    public SavedRevision deleteDocument() throws CouchbaseLiteException {
        return this.createRevision(null);
    }

    @Override
    @InterfaceAudience.Public
    public SavedRevision getParent() {
        return this.getDocument().getRevisionFromRev(this.getDatabase().getParentRevision(this.revisionInternal));
    }

    @Override
    @InterfaceAudience.Public
    public String getParentId() {
        RevisionInternal parRev = this.getDocument().getDatabase().getParentRevision(this.revisionInternal);
        if (parRev == null) {
            return null;
        }
        return parRev.getRevID();
    }

    @Override
    @InterfaceAudience.Private
    long getParentSequence() {
        SavedRevision parent = this.getParent();
        return parent != null ? parent.getSequence() : 0L;
    }

    @Override
    @InterfaceAudience.Public
    public long getSequence() {
        long sequence = this.revisionInternal.getSequence();
        if (sequence == 0L && this.loadProperties()) {
            sequence = this.revisionInternal.getSequence();
        }
        return sequence;
    }

    @InterfaceAudience.Private
    protected boolean loadProperties() {
        try {
            RevisionInternal loadRevision = this.getDatabase().loadRevisionBody(this.revisionInternal);
            if (loadRevision == null) {
                Log.w("Database", "%s: Couldn't load body/sequence", this);
                return false;
            }
            this.revisionInternal = loadRevision;
            return true;
        }
        catch (CouchbaseLiteException e) {
            throw new RuntimeException(e);
        }
    }
}

