/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.Manager;
import com.couchbase.lite.auth.BaseAuthorizer;
import com.couchbase.lite.auth.LoginAuthorizer;
import com.couchbase.lite.auth.SessionCookieAuthorizer;
import com.couchbase.lite.util.Base64;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.Headers;

public class PersonaAuthorizer
extends BaseAuthorizer
implements SessionCookieAuthorizer {
    public static final String TAG = "Sync";
    public static final String ASSERTION_FIELD_EMAIL = "email";
    public static final String ASSERTION_FIELD_ORIGIN = "origin";
    public static final String ASSERTION_FIELD_EXPIRATION = "exp";
    private static Map<List<String>, String> sAssertions = Collections.synchronizedMap(new HashMap());
    private String email;

    public PersonaAuthorizer(String email) {
        if (email == null) {
            throw new IllegalArgumentException("email is null");
        }
        this.email = email;
    }

    @Override
    public List<Object> loginRequest() {
        String assertion = this.assertion();
        if (assertion == null) {
            return null;
        }
        return Arrays.asList("POST", "_persona", assertion);
    }

    @Override
    public void loginResponse(Object jsonResponse, Headers headers, Throwable error, LoginAuthorizer.ContinuationBlock block) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean implementedLoginResponse() {
        return false;
    }

    public String getEmailAddress() {
        return this.email;
    }

    public void setEmailAddress(String email) {
        this.email = email;
    }

    public static String registerAssertion(String assertion) {
        Map<String, Object> result = PersonaAuthorizer.parseAssertion(assertion);
        if (result == null) {
            return null;
        }
        String email = (String)result.get(ASSERTION_FIELD_EMAIL);
        String origin = (String)result.get(ASSERTION_FIELD_ORIGIN);
        if (origin == null) {
            throw new IllegalArgumentException("Invalid assertion, origin was null");
        }
        try {
            URL originURL = new URL(origin);
            origin = originURL.toExternalForm().toLowerCase();
        }
        catch (MalformedURLException e) {
            String msg = String.format(Locale.ENGLISH, "Error registering assertion: %s", assertion);
            Log.e(TAG, msg, e);
            throw new IllegalArgumentException(msg, e);
        }
        ArrayList<String> key = new ArrayList<String>();
        key.add(email);
        key.add(origin);
        Log.v(TAG, "PersonaAuthorizer registering key: %s", key);
        sAssertions.put(key, assertion);
        return email;
    }

    public static String assertionForEmailAndSite(String email, URL site) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(email);
        key.add(site == null ? null : site.toExternalForm().toLowerCase());
        Log.v(TAG, "PersonaAuthorizer looking up key: %s from list of sAssertions", key);
        return sAssertions.get(key);
    }

    String assertion() {
        String assertion = PersonaAuthorizer.assertionForEmailAndSite(this.email, this.getRemoteURL());
        if (assertion == null) {
            Log.w(TAG, "PersonaAuthorizer<%s> no assertion found for: %s", this.email, this.getRemoteURL());
            return null;
        }
        Map<String, Object> result = PersonaAuthorizer.parseAssertion(assertion);
        if (result == null || this.isAssertionExpired(result)) {
            Log.w(TAG, "PersonaAuthorizer<%s> assertion invalid or expired: %s", this.email, assertion);
            return null;
        }
        return assertion;
    }

    private static Map decodeComponent(String component) {
        byte[] bodyData = Base64.decode(component, 0);
        if (bodyData == null) {
            return null;
        }
        try {
            return (Map)Manager.getObjectMapper().readValue(bodyData, Map.class);
        }
        catch (IOException e) {
            Log.w(TAG, "Failed decode component: %s", e, component);
            return null;
        }
    }

    static Map<String, Object> parseAssertion(String assertion) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] components = assertion.split("\\.");
        if (components.length < 4) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid assertion given, only %d found. Expected 4+", components.length));
        }
        Map body = PersonaAuthorizer.decodeComponent(components[1]);
        Map principal = (Map)body.get("principal");
        result.put(ASSERTION_FIELD_EMAIL, principal.get(ASSERTION_FIELD_EMAIL));
        body = PersonaAuthorizer.decodeComponent(components[3]);
        result.put(ASSERTION_FIELD_ORIGIN, body.get("aud"));
        Long expObject = (Long)body.get(ASSERTION_FIELD_EXPIRATION);
        Date expDate = new Date(expObject);
        result.put(ASSERTION_FIELD_EXPIRATION, expDate);
        return result;
    }

    private boolean isAssertionExpired(Map<String, Object> parsedAssertion) {
        Date now;
        Date exp = (Date)parsedAssertion.get(ASSERTION_FIELD_EXPIRATION);
        if (exp.before(now = new Date())) {
            Log.w(TAG, "PersonaAuthorizer assertion for %s expired: %s", this.email, exp);
            return true;
        }
        return false;
    }
}

