/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import com.couchbase.lite.Manager;
import com.couchbase.lite.util.Log;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Body {
    private byte[] json;
    private Object object;

    public Body(byte[] json) {
        this.json = json;
    }

    public Body(Map<String, Object> properties) {
        this.object = properties;
    }

    public Body(List<?> array) {
        this.object = array;
    }

    public Body(byte[] json, String docID, String revID, boolean deleted) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("_id", docID);
        extra.put("_rev", revID);
        if (deleted) {
            extra.put("_deleted", true);
        }
        if (json.length < 2) {
            this.object = extra;
            return;
        }
        Map props = null;
        try {
            props = (Map)Manager.getObjectMapper().readValue(json, Map.class);
        }
        catch (IOException e) {
            Log.w("Database", "Failed to parse Json document", e);
        }
        props.putAll(extra);
        this.object = props;
    }

    public byte[] getJson() {
        if (this.json == null) {
            this.lazyLoadJsonFromObject();
        }
        return this.json;
    }

    private void lazyLoadJsonFromObject() {
        if (this.object == null) {
            throw new IllegalStateException("Both json and object are null for this body: " + this);
        }
        try {
            this.json = Manager.getObjectMapper().writeValueAsBytes(this.object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getObject() {
        if (this.object == null) {
            this.lazyLoadObjectFromJson();
        }
        return this.object;
    }

    private void lazyLoadObjectFromJson() {
        if (this.json == null) {
            throw new IllegalStateException("Both object and json are null for this body: " + this);
        }
        try {
            this.object = Manager.getObjectMapper().readValue(this.json, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isValidJSON() {
        if (this.object == null) {
            boolean gotException = false;
            if (this.json == null) {
                throw new IllegalStateException("Both object and json are null for this body: " + this);
            }
            try {
                this.object = Manager.getObjectMapper().readValue(this.json, Object.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.object != null;
    }

    public byte[] getPrettyJson() {
        Object properties = this.getObject();
        if (properties != null) {
            ObjectWriter writer = Manager.getObjectMapper().writerWithDefaultPrettyPrinter();
            try {
                this.json = writer.writeValueAsBytes(properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getJson();
    }

    public String getJSONString() {
        return new String(this.getJson());
    }

    public Map<String, Object> getProperties() {
        Object object = this.getObject();
        if (object instanceof Map) {
            return (Map)object;
        }
        return null;
    }

    public Object getPropertyForKey(String key) {
        Map<String, Object> theProperties = this.getProperties();
        if (theProperties == null) {
            return null;
        }
        return theProperties.get(key);
    }

    public boolean compact() {
        try {
            this.getJson();
        }
        catch (RuntimeException re) {
            return false;
        }
        this.object = null;
        return true;
    }

    public void release() {
        this.object = null;
        this.json = null;
    }

    public Object getObject(String key) {
        return this.getProperties() != null ? this.getProperties().get(key) : null;
    }
}

