/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.database;

import com.couchbase.lite.internal.database.OperationCanceledException;

public final class CancellationSignal {
    private boolean mIsCanceled;
    private OnCancelListener mOnCancelListener;
    private boolean mCancelInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            return this.mIsCanceled;
        }
    }

    public void throwIfCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        OnCancelListener listener;
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            if (this.mIsCanceled) {
                return;
            }
            this.mIsCanceled = true;
            this.mCancelInProgress = true;
            listener = this.mOnCancelListener;
        }
        try {
            if (listener != null) {
                listener.onCancel();
            }
        }
        finally {
            cancellationSignal = this;
            synchronized (cancellationSignal) {
                this.mCancelInProgress = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnCancelListener(OnCancelListener listener) {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            this.waitForCancelFinishedLocked();
            if (this.mOnCancelListener == listener) {
                return;
            }
            this.mOnCancelListener = listener;
            if (!this.mIsCanceled || listener == null) {
                return;
            }
        }
        listener.onCancel();
    }

    private void waitForCancelFinishedLocked() {
        while (this.mCancelInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }
}

