/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.database.sqlite;

import java.util.Locale;
import java.util.regex.Pattern;

public final class SQLiteDatabaseConfiguration {
    private static final Pattern EMAIL_IN_DB_PATTERN = Pattern.compile("[\\w\\.\\-]+@[\\w\\.\\-]+");
    public static final String MEMORY_DB_PATH = ":memory:";
    public final String path;
    public final String label;
    public int openFlags;
    public int maxSqlCacheSize;
    public Locale locale;
    public boolean foreignKeyConstraintsEnabled;
    public int walConnectionPoolSize = 0;

    public SQLiteDatabaseConfiguration(String path, int openFlags, int walConnectionPoolSize) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null.");
        }
        this.path = path;
        this.label = SQLiteDatabaseConfiguration.stripPathForLogs(path);
        this.openFlags = openFlags;
        this.walConnectionPoolSize = walConnectionPoolSize;
        this.maxSqlCacheSize = 25;
        this.locale = Locale.getDefault();
    }

    public SQLiteDatabaseConfiguration(SQLiteDatabaseConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null.");
        }
        this.path = other.path;
        this.label = other.label;
        this.updateParametersFrom(other);
    }

    public void updateParametersFrom(SQLiteDatabaseConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null.");
        }
        if (!this.path.equals(other.path)) {
            throw new IllegalArgumentException("other configuration must refer to the same database.");
        }
        this.openFlags = other.openFlags;
        this.maxSqlCacheSize = other.maxSqlCacheSize;
        this.locale = other.locale;
        this.foreignKeyConstraintsEnabled = other.foreignKeyConstraintsEnabled;
    }

    public boolean isInMemoryDb() {
        return this.path.equalsIgnoreCase(MEMORY_DB_PATH);
    }

    private static String stripPathForLogs(String path) {
        if (path.indexOf(64) == -1) {
            return path;
        }
        return EMAIL_IN_DB_PATTERN.matcher(path).replaceAll("XX@YY");
    }

    public boolean isOpenReadOnly() {
        return (this.openFlags & 1) == 1;
    }
}

