/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.database.sqlite;

import com.couchbase.lite.internal.database.CancellationSignal;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnection;
import com.couchbase.lite.internal.database.sqlite.SQLiteDatabase;
import com.couchbase.lite.internal.database.sqlite.SQLiteProgram;

public final class SQLiteQuery
extends SQLiteProgram {
    private final CancellationSignal mCancellationSignal;

    SQLiteQuery(SQLiteDatabase db, String query, CancellationSignal cancellationSignal) {
        super(db, query, null, cancellationSignal);
        this.mCancellationSignal = cancellationSignal;
    }

    SQLiteConnection.PreparedStatement beginQuery() {
        this.acquireReference();
        try {
            SQLiteConnection.PreparedStatement preparedStatement = this.getSession().beginQuery(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), this.mCancellationSignal);
            return preparedStatement;
        }
        finally {
            this.releaseReference();
        }
    }

    void endQuery(SQLiteConnection.PreparedStatement statement) {
        this.acquireReference();
        try {
            this.getSession().endQuery(statement);
        }
        finally {
            this.releaseReference();
        }
    }

    public String toString() {
        return "SQLiteQuery: " + this.getSql();
    }
}

