/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.BlobStore;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class BlobRequestBody {
    public static RequestBody create(final MediaType contentType, final BlobStore blobStore, final BlobKey blobKey, final long declaredLength, final boolean syncGateway) {
        if (blobStore == null) {
            throw new NullPointerException("blobStore == null");
        }
        if (blobKey == null) {
            throw new NullPointerException("blobKey == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() throws IOException {
                if (syncGateway) {
                    return super.contentLength();
                }
                if (blobStore.isEncrypted()) {
                    if (declaredLength > 0L) {
                        return declaredLength;
                    }
                    return super.contentLength();
                }
                return blobStore.getSizeOfBlob(blobKey);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                InputStream in = blobStore.blobStreamForKey(blobKey);
                if (in == null) {
                    throw new IOException("Unable to load the blob stream for blobKey: " + blobKey);
                }
                Source source = null;
                try {
                    source = Okio.source((InputStream)in);
                    sink.writeAll(source);
                }
                finally {
                    Util.closeQuietly((Closeable)source);
                }
            }
        };
    }
}

