/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.TransactionalTask;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.ChangeTracker;
import com.couchbase.lite.replicator.ChangeTrackerClient;
import com.couchbase.lite.replicator.PulledRevision;
import com.couchbase.lite.replicator.RemoteBulkDownloaderRequest;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationInternal;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.replicator.ReplicationTrigger;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.support.Batcher;
import com.couchbase.lite.support.BlockingQueueListener;
import com.couchbase.lite.support.CustomFuture;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.SequenceMap;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.URIUtils;
import com.couchbase.lite.util.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;
import okhttp3.Response;

@InterfaceAudience.Private
public class PullerInternal
extends ReplicationInternal
implements ChangeTrackerClient {
    private static final String TAG = "Sync";
    private static final int MAX_OPEN_HTTP_CONNECTIONS = 16;
    public static final int MAX_REVS_TO_GET_IN_BULK = 50;
    public static final int MAX_NUMBER_OF_ATTS_SINCE = 50;
    public static int CHANGE_TRACKER_RESTART_DELAY_MS = 10000;
    public static final int MAX_PENDING_DOCS = 200;
    private static final int INSERTION_BATCHER_DELAY = 250;
    private ChangeTracker changeTracker;
    protected SequenceMap pendingSequences;
    protected Boolean canBulkGet;
    protected List<RevisionInternal> revsToPull = Collections.synchronizedList(new ArrayList(100));
    protected List<RevisionInternal> bulkRevsToPull = Collections.synchronizedList(new ArrayList(100));
    protected List<RevisionInternal> deletedRevsToPull = Collections.synchronizedList(new ArrayList(100));
    protected int httpConnectionCount;
    protected Batcher<RevisionInternal> downloadsToInsert;
    private String str = null;

    public PullerInternal(Database db, URL remote, HttpClientFactory clientFactory, Replication.Lifecycle lifecycle, Replication parentReplication) {
        super(db, remote, clientFactory, lifecycle, parentReplication);
    }

    @Override
    protected void beginReplicating() {
        Log.v(TAG, "submit startReplicating()");
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (PullerInternal.this.isRunning()) {
                    Log.v(PullerInternal.TAG, "start startReplicating()");
                    PullerInternal.this.initPendingSequences();
                    PullerInternal.this.initDownloadsToInsert();
                    PullerInternal.this.startChangeTracker();
                }
            }
        });
    }

    private void initDownloadsToInsert() {
        if (this.downloadsToInsert == null) {
            int capacity = 200;
            this.downloadsToInsert = new Batcher<RevisionInternal>(this.executor, capacity, 250L, new BatchProcessor<RevisionInternal>(){

                @Override
                public void process(List<RevisionInternal> inbox) {
                    PullerInternal.this.insertDownloads(inbox);
                }
            });
        }
    }

    @Override
    protected void onBeforeScheduleRetry() {
        if (this.changeTracker != null) {
            this.changeTracker.stop();
        }
    }

    @Override
    public boolean isPull() {
        return true;
    }

    @Override
    protected void maybeCreateRemoteDB() {
    }

    protected void startChangeTracker() {
        if (!this.stateMachine.isInState((Object)ReplicationState.RUNNING) && !this.stateMachine.isInState((Object)ReplicationState.IDLE)) {
            return;
        }
        if (this.changeTracker != null && this.changeTracker.isRunning()) {
            return;
        }
        ChangeTracker.ChangeTrackerMode changeTrackerMode = ChangeTracker.ChangeTrackerMode.OneShot;
        Log.d(TAG, "%s: starting ChangeTracker with since=%s mode=%s", new Object[]{this, this.lastSequence, changeTrackerMode});
        this.changeTracker = new ChangeTracker(this.remote, changeTrackerMode, true, this.lastSequence, this);
        this.changeTracker.setAuthenticator(this.getAuthenticator());
        Log.d(TAG, "%s: started ChangeTracker %s", this, this.changeTracker);
        if (this.filterName != null) {
            this.changeTracker.setFilterName(this.filterName);
            if (this.filterParams != null) {
                this.changeTracker.setFilterParams(this.filterParams);
            }
        }
        this.changeTracker.setDocIDs(this.documentIDs);
        this.changeTracker.setRequestHeaders(this.requestHeaders);
        this.changeTracker.setContinuous(this.lifecycle == Replication.Lifecycle.CONTINUOUS);
        this.changeTracker.setActiveOnly(this.lastSequence == null && this.db.getDocumentCount() == 0);
        this.changeTracker.start();
    }

    @Override
    @InterfaceAudience.Private
    protected void processInbox(RevisionList inbox) {
        Log.d(TAG, "processInbox called");
        if (this.db == null || !this.db.isOpen()) {
            Log.w(TAG, "%s: Database is null or closed. Unable to continue. db name is %s.", this, this.db.getName());
            return;
        }
        if (this.canBulkGet == null) {
            this.canBulkGet = this.serverIsSyncGatewayVersion("0.81");
        }
        String lastInboxSequence = ((PulledRevision)inbox.get(inbox.size() - 1)).getRemoteSequenceID();
        int numRevisionsRemoved = 0;
        try {
            numRevisionsRemoved = this.db.findMissingRevisions(inbox);
        }
        catch (SQLException e) {
            Log.e(TAG, String.format(Locale.ENGLISH, "%s failed to look up local revs", this), e);
            inbox = null;
        }
        int inboxCount = 0;
        if (inbox != null) {
            inboxCount = inbox.size();
        }
        if (numRevisionsRemoved > 0) {
            Log.v(TAG, "%s: processInbox() setting changesCount to: %s", this, this.getChangesCount().get() - numRevisionsRemoved);
            this.addToChangesCount(-1 * numRevisionsRemoved);
        }
        if (inboxCount == 0) {
            Log.d(TAG, "%s no new remote revisions to fetch.  add lastInboxSequence (%s) to pendingSequences (%s)", this, lastInboxSequence, this.pendingSequences);
            long seq = this.pendingSequences.addValue(lastInboxSequence);
            this.pendingSequences.removeSequence(seq);
            this.setLastSequence(this.pendingSequences.getCheckpointedValue());
            this.pauseOrResume();
            return;
        }
        Log.v(TAG, "%s: fetching %s remote revisions...", this, inboxCount);
        for (int i = 0; i < inbox.size(); ++i) {
            PulledRevision rev = (PulledRevision)inbox.get(i);
            if (this.canBulkGet.booleanValue() || rev.getGeneration() == 1 && !rev.isDeleted() && !rev.isConflicted()) {
                this.bulkRevsToPull.add(rev);
            } else {
                this.queueRemoteRevision(rev);
            }
            rev.setSequence(this.pendingSequences.addValue(rev.getRemoteSequenceID()));
        }
        this.pullRemoteRevisions();
        this.pauseOrResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void pullRemoteRevisions() {
        ArrayList<RevisionInternal> workToStartNow = new ArrayList<RevisionInternal>();
        ArrayList<RevisionInternal> bulkWorkToStartNow = new ArrayList<RevisionInternal>();
        List<RevisionInternal> list = this.bulkRevsToPull;
        synchronized (list) {
            while (this.httpConnectionCount + workToStartNow.size() < 16) {
                int nBulk;
                int n = nBulk = this.bulkRevsToPull.size() < 50 ? this.bulkRevsToPull.size() : 50;
                if (nBulk == 1) {
                    this.queueRemoteRevision(this.bulkRevsToPull.remove(0));
                    nBulk = 0;
                }
                if (nBulk > 0) {
                    bulkWorkToStartNow.addAll(this.bulkRevsToPull.subList(0, nBulk));
                    this.bulkRevsToPull.subList(0, nBulk).clear();
                    continue;
                }
                if (this.revsToPull.size() == 0 && this.deletedRevsToPull.size() == 0) break;
                if (this.revsToPull.size() > 0) {
                    workToStartNow.add(this.revsToPull.remove(0));
                    continue;
                }
                if (this.deletedRevsToPull.size() <= 0) continue;
                workToStartNow.add(this.deletedRevsToPull.remove(0));
            }
        }
        if (bulkWorkToStartNow.size() > 0) {
            this.pullBulkRevisions(bulkWorkToStartNow);
        }
        for (RevisionInternal work : workToStartNow) {
            this.pullRemoteRevision(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pullBulkRevisions(List<RevisionInternal> bulkRevs) {
        RemoteBulkDownloaderRequest dl;
        int nRevs = bulkRevs.size();
        if (nRevs == 0) {
            return;
        }
        Log.d(TAG, "%s bulk-fetching %d remote revisions...", this, nRevs);
        Log.d(TAG, "%s bulk-fetching remote revisions: %s", this, bulkRevs);
        if (!this.canBulkGet.booleanValue()) {
            this.pullBulkWithAllDocs(bulkRevs);
            return;
        }
        Log.v(TAG, "%s: POST _bulk_get", this);
        final ArrayList<RevisionInternal> remainingRevs = new ArrayList<RevisionInternal>(bulkRevs);
        ++this.httpConnectionCount;
        try {
            dl = new RemoteBulkDownloaderRequest(this.clientFactory, this.remote, true, bulkRevs, this.db, this.requestHeaders, new RemoteBulkDownloaderRequest.BulkDownloaderDocument(){

                @Override
                public void onDocument(Map<String, Object> props) {
                    RevisionInternal rev = props.get("_id") != null ? new RevisionInternal(props) : new RevisionInternal((String)props.get("id"), (String)props.get("rev"), false);
                    int pos = remainingRevs.indexOf(rev);
                    if (pos > -1) {
                        rev.setSequence(((RevisionInternal)remainingRevs.get(pos)).getSequence());
                        remainingRevs.remove(pos);
                    } else {
                        Log.w(PullerInternal.TAG, "%s : Received unexpected rev rev", this);
                    }
                    if (props.get("_id") != null) {
                        PullerInternal.this.queueDownloadedRevision(rev);
                    } else {
                        Status status = ReplicationInternal.statusFromBulkDocsResponseItem(props);
                        CouchbaseLiteException err = new CouchbaseLiteException(status);
                        PullerInternal.this.revisionFailed(rev, err);
                    }
                }
            }, new RemoteRequestCompletion(){

                @Override
                public void onCompletion(Response httpResponse, Object result, Throwable e) {
                    if (e != null) {
                        PullerInternal.this.setError(e);
                        PullerInternal.this.completedChangesCount.addAndGet(remainingRevs.size());
                    }
                    --PullerInternal.this.httpConnectionCount;
                    PullerInternal.this.pullRemoteRevisions();
                }
            });
        }
        catch (Exception e) {
            Log.e(TAG, "%s: pullBulkRevisions Exception: %s", this, e);
            return;
        }
        dl.setAuthenticator(this.getAuthenticator());
        dl.setCompressedRequest(this.canSendCompressedRequests());
        ScheduledExecutorService scheduledExecutorService = this.remoteRequestExecutor;
        synchronized (scheduledExecutorService) {
            if (!this.remoteRequestExecutor.isShutdown()) {
                Future<?> future = this.remoteRequestExecutor.submit(dl);
                this.pendingFutures.add(future);
                this.runnables.put(future, dl);
            }
        }
    }

    private void putLocalDocument(final String docId, final Map<String, Object> localDoc) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    PullerInternal.this.getLocalDatabase().putLocalDocument(docId, localDoc);
                }
                catch (CouchbaseLiteException e) {
                    Log.w(PullerInternal.TAG, "Failed to store retryCount value for docId: " + docId, e);
                }
            }
        });
    }

    private void pruneFailedDownload(final String docId) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    PullerInternal.this.getLocalDatabase().deleteLocalDocument(docId);
                }
                catch (CouchbaseLiteException e) {
                    Log.w(PullerInternal.TAG, "Failed to delete local document: " + docId, e);
                }
            }
        });
    }

    private void queueDownloadedRevision(RevisionInternal rev) {
        if (this.revisionBodyTransformationBlock != null) {
            for (Map.Entry entry : ((Map)rev.getProperties().get("_attachments")).entrySet()) {
                String filePath;
                String name = (String)entry.getKey();
                Map attachment = (Map)entry.getValue();
                attachment.remove("file");
                if (attachment.get("follows") == null || attachment.get("data") != null || (filePath = this.db.fileForAttachmentDict(attachment).getPath()) == null) continue;
                attachment.put("file", filePath);
            }
            RevisionInternal xformed = this.transformRevision(rev);
            if (xformed == null) {
                Log.v(TAG, "%s: Transformer rejected revision %s", this, rev);
                this.pendingSequences.removeSequence(rev.getSequence());
                this.lastSequence = this.pendingSequences.getCheckpointedValue();
                this.pauseOrResume();
                return;
            }
            rev = xformed;
            Map attachments = (Map)rev.getProperties().get("_attachments");
            for (Map.Entry entry : attachments.entrySet()) {
                Map attachment = (Map)entry.getValue();
                attachment.remove("file");
            }
        }
        if (rev != null && rev.getBody() != null) {
            rev.getBody().compact();
        }
        this.downloadsToInsert.queueObject(rev);
    }

    protected void pullBulkWithAllDocs(final List<RevisionInternal> bulkRevs) {
        ++this.httpConnectionCount;
        final RevisionList remainingRevs = new RevisionList(bulkRevs);
        Collection<String> keys = CollectionUtils.transform(bulkRevs, new CollectionUtils.Functor<RevisionInternal, String>(){

            @Override
            public String invoke(RevisionInternal rev) {
                return rev.getDocID();
            }
        });
        HashMap<String, Collection<String>> body = new HashMap<String, Collection<String>>();
        body.put("keys", keys);
        CustomFuture future = this.sendAsyncRequest("POST", "_all_docs?include_docs=true", body, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                Map res = (Map)result;
                if (e != null) {
                    PullerInternal.this.setError(e);
                } else {
                    List rows = (List)res.get("rows");
                    Log.v(PullerInternal.TAG, "%s checking %d bulk-fetched remote revisions", this, rows.size());
                    for (Map row : rows) {
                        RevisionInternal rev;
                        Map doc = (Map)row.get("doc");
                        if (doc != null && doc.get("_attachments") == null) {
                            RevisionInternal rev2 = new RevisionInternal(doc);
                            RevisionInternal removedRev = remainingRevs.removeAndReturnRev(rev2);
                            if (removedRev == null) continue;
                            rev2.setSequence(removedRev.getSequence());
                            PullerInternal.this.queueDownloadedRevision(rev2);
                            continue;
                        }
                        Status status = ReplicationInternal.statusFromBulkDocsResponseItem(row);
                        if (!status.isError() || !row.containsKey("key") || row.get("key") == null || (rev = remainingRevs.revWithDocId((String)row.get("key"))) == null) continue;
                        remainingRevs.remove(rev);
                        PullerInternal.this.revisionFailed(rev, new CouchbaseLiteException(status));
                    }
                }
                if (remainingRevs.size() > 0) {
                    Log.v(PullerInternal.TAG, "%s bulk-fetch didn't work for %d of %d revs; getting individually", this, remainingRevs.size(), bulkRevs.size());
                    for (RevisionInternal rev : remainingRevs) {
                        PullerInternal.this.queueRemoteRevision(rev);
                    }
                    PullerInternal.this.pullRemoteRevisions();
                }
                --PullerInternal.this.httpConnectionCount;
                PullerInternal.this.pullRemoteRevisions();
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    public void insertDownloads(final List<RevisionInternal> downloads) {
        Log.d(TAG, this + " inserting " + downloads.size() + " revisions...");
        final long time = System.currentTimeMillis();
        Collections.sort(downloads, PullerInternal.getRevisionListComparator());
        this.db.getStore().runInTransaction(new TransactionalTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run() {
                boolean success;
                block11: {
                    success = false;
                    try {
                        for (RevisionInternal rev : downloads) {
                            long fakeSequence = rev.getSequence();
                            Database cfr_ignored_0 = PullerInternal.this.db;
                            List<String> history = Database.parseCouchDBRevisionHistory(rev.getProperties());
                            if (history.isEmpty() && rev.getGeneration() > 1) {
                                Log.w(PullerInternal.TAG, "%s: Missing revision history in response for: %s", this, rev);
                                PullerInternal.this.setError(new CouchbaseLiteException(589));
                                continue;
                            }
                            Log.v(PullerInternal.TAG, "%s: inserting %s %s", this, rev.getDocID(), history);
                            try {
                                PullerInternal.this.db.forceInsert(rev, history, PullerInternal.this.remote);
                            }
                            catch (CouchbaseLiteException e) {
                                if (e.getCBLStatus().getCode() == 403) {
                                    Log.i(PullerInternal.TAG, "%s: Remote rev failed validation: %s", this, rev);
                                }
                                Log.w(PullerInternal.TAG, "%s: failed to write %s: status=%s", this, rev, e.getCBLStatus().getCode());
                                PullerInternal.this.setError(new RemoteRequestResponseException(e.getCBLStatus().getCode(), null));
                                continue;
                            }
                            if (rev.getBody() != null) {
                                rev.getBody().compact();
                            }
                            PullerInternal.this.pendingSequences.removeSequence(fakeSequence);
                        }
                        Log.v(PullerInternal.TAG, "%s: finished inserting %d revisions", this, downloads.size());
                        success = true;
                        if (!success) break block11;
                    }
                    catch (SQLException e) {
                        block12: {
                            try {
                                Log.e(PullerInternal.TAG, this + ": Exception inserting revisions", e);
                                if (!success) break block12;
                                PullerInternal.this.setLastSequence(PullerInternal.this.pendingSequences.getCheckpointedValue());
                            }
                            catch (Throwable throwable) {
                                if (success) {
                                    PullerInternal.this.setLastSequence(PullerInternal.this.pendingSequences.getCheckpointedValue());
                                    long delta = System.currentTimeMillis() - time;
                                    Log.v(PullerInternal.TAG, "%s: inserted %d revs in %d milliseconds", this, downloads.size(), delta);
                                    int newCompletedChangesCount = PullerInternal.this.getCompletedChangesCount().get() + downloads.size();
                                    Log.d(PullerInternal.TAG, "%s insertDownloads() updating completedChangesCount from %d -> %d ", this, PullerInternal.this.getCompletedChangesCount().get(), newCompletedChangesCount);
                                    PullerInternal.this.addToCompletedChangesCount(downloads.size());
                                }
                                PullerInternal.this.pauseOrResume();
                                return success;
                            }
                            long delta = System.currentTimeMillis() - time;
                            Log.v(PullerInternal.TAG, "%s: inserted %d revs in %d milliseconds", this, downloads.size(), delta);
                            int newCompletedChangesCount = PullerInternal.this.getCompletedChangesCount().get() + downloads.size();
                            Log.d(PullerInternal.TAG, "%s insertDownloads() updating completedChangesCount from %d -> %d ", this, PullerInternal.this.getCompletedChangesCount().get(), newCompletedChangesCount);
                            PullerInternal.this.addToCompletedChangesCount(downloads.size());
                        }
                        PullerInternal.this.pauseOrResume();
                        return success;
                    }
                    PullerInternal.this.setLastSequence(PullerInternal.this.pendingSequences.getCheckpointedValue());
                    long delta = System.currentTimeMillis() - time;
                    Log.v(PullerInternal.TAG, "%s: inserted %d revs in %d milliseconds", this, downloads.size(), delta);
                    int newCompletedChangesCount = PullerInternal.this.getCompletedChangesCount().get() + downloads.size();
                    Log.d(PullerInternal.TAG, "%s insertDownloads() updating completedChangesCount from %d -> %d ", this, PullerInternal.this.getCompletedChangesCount().get(), newCompletedChangesCount);
                    PullerInternal.this.addToCompletedChangesCount(downloads.size());
                }
                PullerInternal.this.pauseOrResume();
                return success;
            }
        });
    }

    @InterfaceAudience.Private
    private static Comparator<RevisionInternal> getRevisionListComparator() {
        return new Comparator<RevisionInternal>(){

            @Override
            public int compare(RevisionInternal reva, RevisionInternal revb) {
                return Misc.SequenceCompare(reva.getSequence(), revb.getSequence());
            }
        };
    }

    private void revisionFailed(RevisionInternal rev, Throwable throwable) {
        if (!Utils.isTransientError(throwable)) {
            Log.v(TAG, "%s: giving up on %s: %s", this, rev, throwable);
            this.pendingSequences.removeSequence(rev.getSequence());
            this.pauseOrResume();
        }
        this.completedChangesCount.getAndIncrement();
    }

    @InterfaceAudience.Private
    public void pullRemoteRevision(final RevisionInternal rev) {
        Log.d(TAG, "%s: pullRemoteRevision with rev: %s", this, rev);
        ++this.httpConnectionCount;
        StringBuilder path = new StringBuilder(PullerInternal.encodeDocumentId(rev.getDocID()));
        path.append("?rev=").append(URIUtils.encode(rev.getRevID()));
        path.append("&revs=true&attachments=true");
        AtomicBoolean hasAttachment = new AtomicBoolean(false);
        List<String> knownRevs = this.db.getPossibleAncestorRevisionIDs(rev, 50, hasAttachment);
        if (hasAttachment.get() && knownRevs != null && knownRevs.size() > 0) {
            path.append("&atts_since=");
            path.append(PullerInternal.joinQuotedEscaped(knownRevs));
        }
        String pathInside = path.toString();
        CustomFuture future = this.sendAsyncMultipartDownloaderRequest("GET", pathInside, (Map)null, this.db, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                if (e != null) {
                    Log.w(PullerInternal.TAG, "Error pulling remote revision: %s", e, this);
                    if (Utils.isDocumentError(e)) {
                        PullerInternal.this.revisionFailed(rev, e);
                    } else {
                        PullerInternal.this.setError(e);
                    }
                } else {
                    Map properties = (Map)result;
                    PulledRevision gotRev = new PulledRevision(properties);
                    gotRev.setSequence(rev.getSequence());
                    Log.d(PullerInternal.TAG, "%s: pullRemoteRevision add rev: %s to batcher: %s", PullerInternal.this, gotRev, PullerInternal.this.downloadsToInsert);
                    if (gotRev.getBody() != null) {
                        gotRev.getBody().compact();
                    }
                    PullerInternal.this.downloadsToInsert.queueObject(gotRev);
                }
                --PullerInternal.this.httpConnectionCount;
                PullerInternal.this.pullRemoteRevisions();
            }
        });
        future.setQueue(this.pendingFutures);
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    public static String joinQuotedEscaped(List<String> strings) {
        if (strings.size() == 0) {
            return "[]";
        }
        byte[] json = null;
        try {
            json = Manager.getObjectMapper().writeValueAsBytes(strings);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to serialize json", e);
        }
        return URIUtils.encode(new String(json));
    }

    @InterfaceAudience.Private
    protected void queueRemoteRevision(RevisionInternal rev) {
        if (rev.isDeleted()) {
            this.deletedRevsToPull.add(rev);
        } else {
            this.revsToPull.add(rev);
        }
    }

    private void initPendingSequences() {
        if (this.pendingSequences == null) {
            this.pendingSequences = new SequenceMap();
            if (this.getLastSequence() != null) {
                long seq = this.pendingSequences.addValue(this.getLastSequence());
                this.pendingSequences.removeSequence(seq);
                assert (this.pendingSequences.getCheckpointedValue().equals(this.getLastSequence()));
            }
        }
    }

    @InterfaceAudience.Private
    public String getLastSequence() {
        return this.lastSequence;
    }

    @Override
    public OkHttpClient getOkHttpClient() {
        return this.clientFactory.getOkHttpClient();
    }

    @Override
    public void changeTrackerReceivedChange(Map<String, Object> change) {
        try {
            Log.d(TAG, "changeTrackerReceivedChange: %s", change);
            this.processChangeTrackerChange(change);
        }
        catch (Exception e) {
            Log.e(TAG, "Error processChangeTrackerChange(): %s", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeTrackerStopped(ChangeTracker tracker) {
        ScheduledExecutorService scheduledExecutorService = this.executor;
        synchronized (scheduledExecutorService) {
            if (!this.executor.isShutdown()) {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PullerInternal.this.processChangeTrackerStopped(PullerInternal.this.changeTracker);
                        }
                        catch (RuntimeException e) {
                            Log.e("ChangeTracker", "Unknown Error in processChangeTrackerStopped()", e);
                            throw e;
                        }
                    }
                });
            }
        }
    }

    @Override
    public void changeTrackerFinished(ChangeTracker tracker) {
        Log.d(TAG, "changeTrackerFinished");
    }

    @Override
    public void changeTrackerCaughtUp() {
        Log.d(TAG, "changeTrackerCaughtUp");
        this.waitForPendingFuturesWithNewThread();
    }

    protected void processChangeTrackerChange(Map<String, Object> change) {
        String docID = (String)change.get("id");
        if (docID == null || !Document.isValidDocumentId(docID)) {
            return;
        }
        String lastSequence = change.get("seq").toString();
        boolean deleted = change.containsKey("deleted") && change.get("deleted").equals(Boolean.TRUE);
        List changes = (List)change.get("changes");
        for (Map changeDict : changes) {
            String revID = (String)changeDict.get("rev");
            if (revID == null) continue;
            PulledRevision rev = new PulledRevision(docID, revID, deleted);
            rev.setRemoteSequenceID(lastSequence);
            if (changes.size() > 1) {
                rev.setConflicted(true);
            }
            Log.d(TAG, "%s: adding rev to inbox %s", this, rev);
            Log.v(TAG, "%s: changeTrackerReceivedChange() incrementing changesCount by 1", this);
            this.addToChangesCount(1);
            this.addToInbox(rev);
        }
        this.pauseOrResume();
    }

    private void processChangeTrackerStopped(ChangeTracker tracker) {
        Log.d(TAG, "changeTrackerStopped.  lifecycle: %s", new Object[]{this.lifecycle});
        switch (this.lifecycle) {
            case ONESHOT: {
                if (tracker.getLastError() != null) {
                    this.setError(tracker.getLastError());
                }
                this.waitForPendingFuturesWithNewThread();
                break;
            }
            case CONTINUOUS: {
                if (this.stateMachine.isInState((Object)ReplicationState.OFFLINE)) {
                    Log.d(TAG, "Change tracker stopped because we are going offline");
                    break;
                }
                if (this.stateMachine.isInState((Object)ReplicationState.STOPPING) || this.stateMachine.isInState((Object)ReplicationState.STOPPED)) {
                    Log.d(TAG, "Change tracker stopped because replicator is stopping or stopped.");
                    break;
                }
                String msg = "Change tracker stopped during continuous replication";
                Log.w(TAG, msg);
                this.parentReplication.setLastError(new Exception(msg));
                this.fireTrigger(ReplicationTrigger.WAITING_FOR_CHANGES);
                Log.d(TAG, "Scheduling change tracker restart in %d ms", CHANGE_TRACKER_RESTART_DELAY_MS);
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (PullerInternal.this.stateMachine.isInState((Object)ReplicationState.RUNNING) || PullerInternal.this.stateMachine.isInState((Object)ReplicationState.IDLE)) {
                            Log.d(PullerInternal.TAG, "%s still running, restarting change tracker", this);
                            PullerInternal.this.startChangeTracker();
                        } else {
                            Log.d(PullerInternal.TAG, "%s still no longer running, not restarting change tracker", this);
                        }
                    }
                }, (long)CHANGE_TRACKER_RESTART_DELAY_MS, TimeUnit.MILLISECONDS);
                break;
            }
            default: {
                Log.e(TAG, "Unknown lifecycle: %s", new Object[]{this.lifecycle});
            }
        }
    }

    private void waitForPendingFuturesWithNewThread() {
        String threadName = String.format(Locale.ENGLISH, "Thread-waitForPendingFutures[%s]", this.toString());
        new Thread(new Runnable(){

            @Override
            public void run() {
                PullerInternal.this.waitForPendingFutures();
            }
        }, threadName).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(BlockingQueueListener.EventType type, Object o, BlockingQueue queue) {
        if ((type == BlockingQueueListener.EventType.PUT || type == BlockingQueueListener.EventType.ADD) && this.isContinuous() && !queue.isEmpty()) {
            Object object = this.lockWaitForPendingFutures;
            synchronized (object) {
                if (this.waitingForPendingFutures) {
                    return;
                }
            }
            this.fireTrigger(ReplicationTrigger.RESUME);
            this.waitForPendingFuturesWithNewThread();
        }
    }

    @Override
    protected void stop() {
        if (this.stateMachine.isInState((Object)ReplicationState.STOPPED)) {
            return;
        }
        Log.d(TAG, "%s STOPPING...", this.toString());
        if (this.changeTracker != null) {
            this.changeTracker.stop();
        }
        if (this.downloadsToInsert != null) {
            this.downloadsToInsert.flushAll(false);
        }
        super.stop();
        String threadName = String.format(Locale.ENGLISH, "Thread.waitForAllTasksCompleted[%s]", this.toString());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PullerInternal.this.waitForAllTasksCompleted();
                }
                catch (Exception e) {
                    Log.e(PullerInternal.TAG, "stop.run() had exception: %s", e);
                }
                finally {
                    PullerInternal.this.triggerStopImmediate();
                    Log.d(PullerInternal.TAG, "PullerInternal stop.run() finished");
                }
            }
        }, threadName).start();
    }

    @Override
    protected void waitForAllTasksCompleted() {
        while (this.batcher != null && !this.batcher.isEmpty() || this.pendingFutures != null && this.pendingFutures.size() > 0 || this.downloadsToInsert != null && !this.downloadsToInsert.isEmpty()) {
            this.waitBatcherCompleted();
            this.waitPendingFuturesCompleted();
            this.waitDownloadsToInsertBatcherCompleted();
        }
    }

    protected void waitDownloadsToInsertBatcherCompleted() {
        PullerInternal.waitBatcherCompleted(this.downloadsToInsert);
    }

    @Override
    public boolean shouldCreateTarget() {
        return false;
    }

    @Override
    public void setCreateTarget(boolean createTarget) {
    }

    @Override
    protected void goOffline() {
        super.goOffline();
        if (this.changeTracker != null) {
            this.changeTracker.stop();
        }
    }

    protected void pauseOrResume() {
        int pending = this.batcher.count() + this.pendingSequences.count();
        this.changeTracker.setPaused(pending >= 200);
    }

    public String toString() {
        if (this.str == null) {
            String maskedRemote = "unknown";
            if (this.remote != null) {
                this.remote.toExternalForm();
            }
            maskedRemote = maskedRemote.replaceAll("://.*:.*@", "://---:---@");
            String type = this.isPull() ? "pull" : "push";
            String replicationIdentifier = Utils.shortenString(this.remoteCheckpointDocID(), 5);
            if (replicationIdentifier == null) {
                replicationIdentifier = "unknown";
            }
            this.str = String.format(Locale.ENGLISH, "PullerInternal{%s, %s, %s}", maskedRemote, type, replicationIdentifier);
        }
        return this.str;
    }
}

