/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationInternal;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.support.CustomFuture;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RevisionUtils;
import com.couchbase.lite.util.JSONUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import okhttp3.Response;

@InterfaceAudience.Private
public class PusherInternal
extends ReplicationInternal
implements Database.ChangeListener {
    private static final String TAG = "Sync";
    private static long kMaxBulkDocsObjectSize = 5000000L;
    public static final int MAX_PENDING_DOCS = 200;
    private static final int TIMEOUT_FOR_PAUSE = 1000;
    private boolean createTarget;
    private boolean creatingTarget;
    private boolean observing;
    private ReplicationFilter filter;
    private boolean dontSendMultipart = false;
    SortedSet<Long> pendingSequences;
    Long maxPendingSequence;
    final Object pendingSequencesLock = new Object();
    final Object changesLock = new Object();
    boolean doneBeginReplicating = false;
    List<RevisionInternal> queueChanges = new ArrayList<RevisionInternal>();
    private String str = null;
    private boolean paused = false;
    private final Object pausedObj = new Object();
    private ExecutorService supportExecutor;

    @InterfaceAudience.Private
    public PusherInternal(Database db, URL remote, HttpClientFactory clientFactory, Replication.Lifecycle lifecycle, Replication parentReplication) {
        super(db, remote, clientFactory, lifecycle, parentReplication);
    }

    @Override
    protected void finalize() throws Throwable {
        this.terminateSupportExecutor();
        super.finalize();
    }

    @Override
    @InterfaceAudience.Public
    public boolean isPull() {
        return false;
    }

    @Override
    public boolean shouldCreateTarget() {
        return this.createTarget;
    }

    @Override
    public void setCreateTarget(boolean createTarget) {
        this.createTarget = createTarget;
    }

    @Override
    protected void start() {
        this.initSupportExecutor();
        super.start();
    }

    private void initSupportExecutor() {
        if (this.supportExecutor == null || this.supportExecutor.isShutdown()) {
            this.supportExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    String maskedRemote = PusherInternal.this.remote.toExternalForm();
                    maskedRemote = maskedRemote.replaceAll("://.*:.*@", "://---:---@");
                    return new Thread(r, "CBLPusherSupportExecutor-" + maskedRemote);
                }
            });
        }
    }

    private void terminateSupportExecutor() {
        if (this.supportExecutor != null && !this.supportExecutor.isShutdown()) {
            Utils.shutdownAndAwaitTermination(this.supportExecutor, 0L, 5L);
        }
    }

    @Override
    protected void stop() {
        if (this.stateMachine.isInState((Object)ReplicationState.STOPPED)) {
            return;
        }
        Log.d(TAG, "%s STOPPING...", this.toString());
        this.stopObserving();
        this.setPaused(false);
        this.terminateSupportExecutor();
        super.stop();
        String threadName = String.format(Locale.ENGLISH, "Thread-waitForPendingFutures[%s]", this.toString());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PusherInternal.this.waitForPendingFutures();
                }
                catch (Exception e) {
                    Log.e(PusherInternal.TAG, "stop.run() had exception: %s", e);
                }
                finally {
                    PusherInternal.this.triggerStopImmediate();
                    Log.d(PusherInternal.TAG, "PusherInternal stop.run() finished");
                }
            }
        }, threadName).start();
    }

    @Override
    @InterfaceAudience.Private
    protected void maybeCreateRemoteDB() {
        if (!this.createTarget) {
            return;
        }
        this.creatingTarget = true;
        Log.v(TAG, "Remote db might not exist; creating it...");
        CustomFuture future = this.sendAsyncRequest("PUT", "", (Map)null, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                PusherInternal.this.creatingTarget = false;
                if (e != null && e instanceof RemoteRequestResponseException && ((RemoteRequestResponseException)e).getCode() != 412) {
                    Log.e(PusherInternal.TAG, this + ": Failed to create remote db", e);
                    PusherInternal.this.setError(e);
                    PusherInternal.this.triggerStopGraceful();
                } else {
                    Log.v(PusherInternal.TAG, "%s: Created remote db", this);
                    PusherInternal.this.createTarget = false;
                    PusherInternal.this.beginReplicating();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    public void beginReplicating() {
        Log.d(TAG, "%s: beginReplicating() called", this);
        this.doneBeginReplicating = false;
        if (this.creatingTarget) {
            Log.d(TAG, "%s: creatingTarget == true, doing nothing", this);
            return;
        }
        this.pendingSequences = Collections.synchronizedSortedSet(new TreeSet());
        try {
            this.maxPendingSequence = Long.parseLong(this.lastSequence);
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Error converting lastSequence: %s to long.  Using 0", this.lastSequence);
            this.maxPendingSequence = new Long(0L);
        }
        this.filter = this.compilePushReplicationFilter();
        if (this.filterName != null && this.filter == null) {
            Log.w(TAG, "%s: No ReplicationFilter registered for filter '%s'; ignoring", this, this.filterName);
        }
        if (this.isContinuous() && this.isRunning()) {
            this.observing = true;
            this.db.addChangeListener(this);
        }
        long lastSequenceLong = 0L;
        if (this.lastSequence != null) {
            lastSequenceLong = Long.parseLong(this.lastSequence);
        }
        ChangesOptions options = new ChangesOptions();
        options.setIncludeConflicts(true);
        Log.d(TAG, "%s: Getting changes since %d", this, lastSequenceLong);
        RevisionList changes = this.db.changesSince(lastSequenceLong, options, this.filter, this.filterParams);
        if (changes.size() > 0) {
            Log.d(TAG, "%s: Queuing %d changes since %d", this, changes.size(), lastSequenceLong);
            this.submitRevisions(changes);
        } else {
            Log.d(TAG, "%s: No changes since %d", this, lastSequenceLong);
        }
        Object object = this.changesLock;
        synchronized (object) {
            for (RevisionInternal rev : this.queueChanges) {
                if (changes.contains(rev)) continue;
                this.pauseOrResume();
                this.waitIfPaused();
                this.addToInbox(rev);
            }
            this.doneBeginReplicating = true;
        }
    }

    @Override
    @InterfaceAudience.Private
    public void changed(Database.ChangeEvent event) {
        final List<DocumentChange> changes = event.getChanges();
        this.supportExecutor.submit(new Runnable(){

            @Override
            public void run() {
                PusherInternal.this.submitRevisions(changes);
            }
        });
    }

    @InterfaceAudience.Private
    private void stopObserving() {
        if (this.observing) {
            this.observing = false;
            this.db.removeChangeListener(this);
        }
    }

    @Override
    protected void goOffline() {
        super.goOffline();
        this.stopObserving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    private void addPending(RevisionInternal revisionInternal) {
        Object object = this.pendingSequencesLock;
        synchronized (object) {
            long seq = revisionInternal.getSequence();
            this.pendingSequences.add(seq);
            if (seq > this.maxPendingSequence) {
                this.maxPendingSequence = seq;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    private void removePending(RevisionInternal revisionInternal) {
        Object object = this.pendingSequencesLock;
        synchronized (object) {
            boolean wasFirst;
            long seq = revisionInternal.getSequence();
            if (this.pendingSequences == null || this.pendingSequences.isEmpty()) {
                Log.w(TAG, "%s: removePending() called w/ rev: %s, but pendingSequences empty", this, revisionInternal);
                if (revisionInternal.getBody() != null) {
                    revisionInternal.getBody().release();
                }
                this.pauseOrResume();
                return;
            }
            boolean bl = wasFirst = seq == this.pendingSequences.first();
            if (!this.pendingSequences.contains(seq)) {
                Log.w(TAG, "%s: removePending: sequence %s not in set, for rev %s", this, seq, revisionInternal);
            }
            this.pendingSequences.remove(seq);
            if (wasFirst) {
                long maxCompleted;
                if (this.pendingSequences.size() == 0) {
                    maxCompleted = this.maxPendingSequence;
                } else {
                    maxCompleted = this.pendingSequences.first();
                    --maxCompleted;
                }
                this.setLastSequence(Long.toString(maxCompleted));
            }
            if (revisionInternal.getBody() != null) {
                revisionInternal.getBody().release();
            }
            this.pauseOrResume();
        }
    }

    @Override
    @InterfaceAudience.Private
    protected void processInbox(final RevisionList changes) {
        Log.v(TAG, "processInbox() changes=" + changes.size());
        HashMap<String, ArrayList<String>> diffs = new HashMap<String, ArrayList<String>>();
        for (RevisionInternal rev : changes) {
            String docID = rev.getDocID();
            ArrayList<String> revs = (ArrayList<String>)diffs.get(docID);
            if (revs == null) {
                revs = new ArrayList<String>();
                diffs.put(docID, revs);
            }
            revs.add(rev.getRevID());
            this.addPending(rev);
        }
        Log.v(TAG, "%s: posting to /_revs_diff", this);
        CustomFuture future = this.sendAsyncRequest("POST", "_revs_diff", diffs, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object response, Throwable e) {
                Log.v(PusherInternal.TAG, "%s: got /_revs_diff response", this);
                Map results = (Map)response;
                if (e != null) {
                    PusherInternal.this.setError(e);
                } else if (results.size() != 0) {
                    ArrayList<Object> docsToSend = new ArrayList<Object>();
                    RevisionList revsToSend = new RevisionList();
                    long bufferedSize = 0L;
                    for (RevisionInternal rev : changes) {
                        RevisionInternal loadedRev;
                        Map<String, Object> properties = null;
                        Map revResults = (Map)results.get(rev.getDocID());
                        if (revResults == null) {
                            PusherInternal.this.removePending(rev);
                            continue;
                        }
                        List revs = (List)revResults.get("missing");
                        if (revs == null || !revs.contains(rev.getRevID())) {
                            PusherInternal.this.removePending(rev);
                            continue;
                        }
                        rev.setSequence(0L);
                        rev.setBody(null);
                        try {
                            loadedRev = PusherInternal.this.db.loadRevisionBody(rev);
                        }
                        catch (CouchbaseLiteException e1) {
                            Log.w(PusherInternal.TAG, "%s Couldn't get local contents of %s", rev, PusherInternal.this);
                            continue;
                        }
                        if (loadedRev.getPropertyForKey("_removed") != null && ((Boolean)loadedRev.getPropertyForKey("_removed")).booleanValue()) {
                            PusherInternal.this.removePending(rev);
                            continue;
                        }
                        RevisionInternal populatedRev = PusherInternal.this.transformRevision(loadedRev);
                        List possibleAncestors = (List)revResults.get("possible_ancestors");
                        properties = new HashMap<String, Object>(populatedRev.getProperties());
                        Map<String, Object> revisions = PusherInternal.this.db.getRevisionHistoryDictStartingFromAnyAncestor(populatedRev, possibleAncestors);
                        properties.put("_revisions", revisions);
                        populatedRev.setProperties(properties);
                        if (properties.containsKey("_attachments")) {
                            int minRevPos = PusherInternal.findCommonAncestor(populatedRev, possibleAncestors);
                            Status status = new Status(200);
                            if (!PusherInternal.this.db.expandAttachments(populatedRev, minRevPos + 1, !PusherInternal.this.dontSendMultipart, false, status)) {
                                Log.w(PusherInternal.TAG, "%s: Couldn't expand attachments of %s", this, populatedRev);
                                continue;
                            }
                            properties = populatedRev.getProperties();
                            if (!PusherInternal.this.dontSendMultipart && PusherInternal.this.uploadMultipartRevision(populatedRev)) continue;
                        }
                        if (properties == null || !properties.containsKey("_id")) {
                            throw new IllegalStateException("properties must contain a document _id");
                        }
                        revsToSend.add(rev);
                        docsToSend.add(properties);
                        if ((bufferedSize += JSONUtils.estimate(properties)) <= kMaxBulkDocsObjectSize) continue;
                        PusherInternal.this.uploadBulkDocs(docsToSend, revsToSend);
                        docsToSend = new ArrayList();
                        revsToSend = new RevisionList();
                        bufferedSize = 0L;
                    }
                    PusherInternal.this.uploadBulkDocs(docsToSend, revsToSend);
                } else {
                    for (RevisionInternal revisionInternal : changes) {
                        PusherInternal.this.removePending(revisionInternal);
                    }
                }
            }
        });
        future.setQueue(this.pendingFutures);
        this.pendingFutures.add(future);
        this.pauseOrResume();
    }

    @InterfaceAudience.Private
    protected void uploadBulkDocs(List<Object> docsToSend, final RevisionList changes) {
        final int numDocsToSend = docsToSend.size();
        if (numDocsToSend == 0) {
            return;
        }
        Log.v(TAG, "%s: POSTing " + numDocsToSend + " revisions to _bulk_docs: %s", this, docsToSend);
        this.addToChangesCount(numDocsToSend);
        HashMap<String, Object> bulkDocsBody = new HashMap<String, Object>();
        bulkDocsBody.put("docs", docsToSend);
        bulkDocsBody.put("new_edits", false);
        CustomFuture future = this.sendAsyncRequest("POST", "_bulk_docs", bulkDocsBody, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                if (e == null) {
                    HashSet<String> failedIDs = new HashSet<String>();
                    List items = (List)result;
                    for (Map item : items) {
                        Status status = ReplicationInternal.statusFromBulkDocsResponseItem(item);
                        if (!status.isError()) continue;
                        Log.w(PusherInternal.TAG, "%s: _bulk_docs got an error: %s", item, this);
                        if (status.getCode() == 403) continue;
                        String docID = (String)item.get("id");
                        failedIDs.add(docID);
                    }
                    for (RevisionInternal revisionInternal : changes) {
                        if (failedIDs.contains(revisionInternal.getDocID())) continue;
                        PusherInternal.this.removePending(revisionInternal);
                    }
                }
                if (e != null) {
                    PusherInternal.this.setError(e);
                } else {
                    Log.v(PusherInternal.TAG, "%s: POSTed to _bulk_docs", PusherInternal.this);
                }
                PusherInternal.this.addToCompletedChangesCount(numDocsToSend);
            }
        });
        future.setQueue(this.pendingFutures);
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    private boolean uploadMultipartRevision(final RevisionInternal revision) {
        Map<String, Object> body = revision.getProperties();
        Map attachments = (Map)body.get("_attachments");
        boolean attachmentsFollow = false;
        for (String attachmentKey : attachments.keySet()) {
            Map attachment = (Map)attachments.get(attachmentKey);
            if (!attachment.containsKey("follows")) continue;
            attachmentsFollow = true;
        }
        if (!attachmentsFollow) {
            return false;
        }
        Log.d(TAG, "Uploading multipart request.  Revision: %s", revision);
        this.addToChangesCount(1);
        String path = String.format(Locale.ENGLISH, "%s?new_edits=false", PusherInternal.encodeDocumentId(revision.getDocID()));
        CustomFuture future = this.sendAsyncMultipartRequest("PUT", path, (Map)body, attachments, new RemoteRequestCompletion(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                try {
                    if (e != null) {
                        if (e instanceof RemoteRequestResponseException) {
                            if (((RemoteRequestResponseException)e).getCode() == 415) {
                                PusherInternal.this.dontSendMultipart = true;
                                PusherInternal.this.uploadJsonRevision(revision);
                            }
                        } else {
                            Log.e(PusherInternal.TAG, "Exception uploading multipart request", e);
                            PusherInternal.this.setError(e);
                        }
                    } else {
                        Log.v(PusherInternal.TAG, "Uploaded multipart request.  Revision: %s", revision);
                        PusherInternal.this.removePending(revision);
                    }
                }
                finally {
                    PusherInternal.this.addToCompletedChangesCount(1);
                }
            }
        });
        future.setQueue(this.pendingFutures);
        this.pendingFutures.add(future);
        return true;
    }

    private void uploadJsonRevision(final RevisionInternal rev) {
        if (!this.db.inlineFollowingAttachmentsIn(rev)) {
            this.setError(new CouchbaseLiteException(491));
            return;
        }
        String path = String.format(Locale.ENGLISH, "%s?new_edits=false", PusherInternal.encodeDocumentId(rev.getDocID()));
        CustomFuture future = this.sendAsyncRequest("PUT", path, (Map)rev.getProperties(), new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                if (e != null) {
                    PusherInternal.this.setError(e);
                } else {
                    Log.v(PusherInternal.TAG, "%s: Sent %s (JSON), response=%s", this, rev, result);
                    PusherInternal.this.removePending(rev);
                }
            }
        });
        future.setQueue(this.pendingFutures);
        this.pendingFutures.add(future);
    }

    private static int findCommonAncestor(RevisionInternal rev, List<String> possibleRevIDs) {
        String ancestorID;
        if (possibleRevIDs == null || possibleRevIDs.size() == 0) {
            return 0;
        }
        List<String> history = Database.parseCouchDBRevisionHistory(rev.getProperties());
        assert (history != null);
        boolean changed = history.retainAll(possibleRevIDs);
        String string = ancestorID = history.size() == 0 ? null : history.get(0);
        if (ancestorID == null) {
            return 0;
        }
        int generation = RevisionUtils.parseRevIDNumber(ancestorID);
        return generation;
    }

    private void pauseOrResume() {
        int pending = this.batcher.count() + this.pendingSequences.size();
        this.setPaused(pending >= 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPaused(boolean paused) {
        Log.v(TAG, "setPaused: " + paused);
        Object object = this.pausedObj;
        synchronized (object) {
            if (this.paused != paused) {
                this.paused = paused;
                this.pausedObj.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfPaused() {
        Object object = this.pausedObj;
        synchronized (object) {
            while (this.paused && this.isRunning()) {
                Log.v(TAG, "Waiting: " + this.paused);
                try {
                    this.pausedObj.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void submitRevisions(RevisionList changes) {
        int size = this.batcher.getCapacity();
        int start = 0;
        for (int remaining = changes.size(); remaining > 0; remaining -= size) {
            if (size > remaining) {
                size = remaining;
            }
            RevisionList subChanges = new RevisionList(changes.subList(start, start + size));
            this.batcher.queueObjects(subChanges);
            start += size;
            this.pauseOrResume();
            this.waitIfPaused();
            if (this.isRunning()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRevisions(List<DocumentChange> changes) {
        Object object = this.changesLock;
        synchronized (object) {
            try {
                URI remoteUri = this.remote.toURI();
                for (DocumentChange change : changes) {
                    RevisionInternal nuRev;
                    URL source = change.getSource();
                    if (source != null && source.toURI().equals(remoteUri)) {
                        return;
                    }
                    RevisionInternal rev = change.getAddedRevision();
                    if (rev == null || !this.getLocalDatabase().runFilter(this.filter, this.filterParams, rev)) continue;
                    if (this.doneBeginReplicating) {
                        this.pauseOrResume();
                        this.waitIfPaused();
                        if (this.isRunning()) {
                            nuRev = rev.copyWithoutBody();
                            this.addToInbox(nuRev);
                            continue;
                        }
                        break;
                    }
                    nuRev = rev.copyWithoutBody();
                    this.queueChanges.add(nuRev);
                }
            }
            catch (URISyntaxException uriException) {
                Log.e(TAG, "Active replicator found with invalid URI", uriException);
            }
        }
    }

    @Override
    protected void onBeforeScheduleRetry() {
        this.stopObserving();
    }

    public String toString() {
        if (this.str == null) {
            String maskedRemote = "unknown";
            if (this.remote != null) {
                maskedRemote = this.remote.toExternalForm();
            }
            maskedRemote = maskedRemote.replaceAll("://.*:.*@", "://---:---@");
            String type = this.isPull() ? "pull" : "push";
            String replicationIdentifier = Utils.shortenString(this.remoteCheckpointDocID(), 5);
            if (replicationIdentifier == null) {
                replicationIdentifier = "unknown";
            }
            this.str = String.format(Locale.ENGLISH, "PusherInternal{%s, %s, %s}", maskedRemote, type, replicationIdentifier);
        }
        return this.str;
    }
}

