/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.RemoteRequest;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.RequestUtils;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.MultipartDocumentReader;
import com.couchbase.lite.support.MultipartReader;
import com.couchbase.lite.support.MultipartReaderDelegate;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

@InterfaceAudience.Private
public class RemoteBulkDownloaderRequest
extends RemoteRequest
implements MultipartReaderDelegate {
    private static final int BUF_LEN = 1024;
    private Database db;
    private MultipartReader _topReader;
    private MultipartDocumentReader _docReader;
    private BulkDownloaderDocument _onDocument;

    public RemoteBulkDownloaderRequest(HttpClientFactory factory, URL dbURL, boolean cancelable, List<RevisionInternal> revs, Database db, Map<String, Object> requestHeaders, BulkDownloaderDocument onDocument, RemoteRequestCompletion onCompletion) throws Exception {
        super(factory, "POST", new URL(RemoteBulkDownloaderRequest.buildRelativeURLString(dbURL, "/_bulk_get?revs=true&attachments=true")), cancelable, RemoteBulkDownloaderRequest.buildJSONBody(revs, db), requestHeaders, onCompletion);
        this.db = db;
        this._onDocument = onDocument;
    }

    @Override
    protected Request.Builder addHeaders(Request.Builder builder) {
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("Accept", "multipart/related");
        builder.addHeader("User-Agent", Manager.getUserAgent());
        builder.addHeader("X-Accept-Part-Encoding", "gzip");
        builder.addHeader("Accept-Encoding", "gzip, deflate");
        return this.addRequestHeaders(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeRequest(OkHttpClient httpClient, Request request) {
        Object fullBody = null;
        Exception error = null;
        Response response = null;
        try {
            block19: {
                try {
                    Log.v("RemoteRequest", "%s: BulkDownloader calling httpClient.execute, url: %s", this, this.url);
                    this.call = httpClient.newCall(request);
                    response = this.call.execute();
                    Log.v("RemoteRequest", "%s: BulkDownloader called httpClient.execute, url: %s", this, this.url);
                    this.storeCookie(response);
                    if (response.code() >= 300) {
                        if (response.code() == 409) {
                            Log.w("RemoteRequest", "Got error status: %d for %s.  Reason: %s", response.code(), request, response.message());
                        } else {
                            Log.i("RemoteRequest", "Got error status: %d for %s.  Reason: %s", response.code(), request, response.message());
                        }
                        error = new RemoteRequestResponseException(response.code(), response.message());
                        RequestUtils.closeResponseBody(response);
                        break block19;
                    }
                    ResponseBody responseBody = response.body();
                    InputStream stream = response.body().byteStream();
                    try {
                        MediaType type;
                        if (Utils.isGzip(response)) {
                            stream = new GZIPInputStream(stream);
                        }
                        if ((type = responseBody.contentType()) != null) {
                            if (type.type().equals("multipart")) {
                                int nBytesRead;
                                Log.v("RemoteRequest", "mediaType = %s", type);
                                this._topReader = new MultipartReader(type.toString(), this);
                                byte[] buffer = new byte[1024];
                                while ((nBytesRead = stream.read(buffer)) != -1) {
                                    this._topReader.appendData(buffer, 0, nBytesRead);
                                }
                                this._topReader.finished();
                            } else {
                                Log.v("RemoteRequest", "contentTypeHeader is not multipart = %s", type.toString());
                                fullBody = Manager.getObjectMapper().readValue(stream, Object.class);
                            }
                        }
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    Log.w("RemoteRequest", "%s: executeRequest() Exception: %s.  url: %s", this, e, this.url);
                    error = e;
                }
            }
            this.respondWithResult(fullBody, error, response);
        }
        catch (Throwable throwable) {
            RequestUtils.closeResponseBody(response);
            throw throwable;
        }
        RequestUtils.closeResponseBody(response);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '[' + this.url.getPath() + ']';
    }

    public void startedPart(Map headers) {
        if (this._docReader != null) {
            throw new IllegalStateException("_docReader is already defined");
        }
        Log.v("RemoteRequest", "%s: Starting new document; headers =%s", this, headers);
        this._docReader = new MultipartDocumentReader(this.db);
        this._docReader.setHeaders(headers);
        this._docReader.startedPart(headers);
    }

    @Override
    public void appendToPart(byte[] data) {
        this.appendToPart(data, 0, data.length);
    }

    @Override
    public void appendToPart(byte[] data, int off, int len) {
        if (this._docReader == null) {
            throw new IllegalStateException("_docReader is not defined");
        }
        this._docReader.appendData(data, off, len);
    }

    @Override
    public void finishedPart() {
        if (this._docReader == null) {
            throw new IllegalStateException("_docReader is not defined");
        }
        this._docReader.finish();
        this._onDocument.onDocument(this._docReader.getDocumentProperties());
        this._docReader = null;
        Log.v("RemoteRequest", "%s: Finished document", this);
    }

    private static Map<String, Object> buildJSONBody(List<RevisionInternal> revs, final Database db) {
        Collection<Map<String, Object>> keys = CollectionUtils.transform(revs, new CollectionUtils.Functor<RevisionInternal, Map<String, Object>>(){

            @Override
            public Map<String, Object> invoke(RevisionInternal source) {
                AtomicBoolean hasAttachment = new AtomicBoolean(false);
                List<String> attsSince = db.getPossibleAncestorRevisionIDs(source, 50, hasAttachment);
                if (!hasAttachment.get() || attsSince.size() == 0) {
                    attsSince = null;
                }
                HashMap<String, Object> mapped = new HashMap<String, Object>();
                mapped.put("id", source.getDocID());
                mapped.put("rev", source.getRevID());
                mapped.put("atts_since", attsSince);
                return mapped;
            }
        });
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("docs", keys);
        return retval;
    }

    @InterfaceAudience.Private
    private static String buildRelativeURLString(URL remote, String relativePath) {
        String remoteUrlString = remote.toExternalForm();
        if (remoteUrlString.endsWith("/") && relativePath.startsWith("/")) {
            remoteUrlString = remoteUrlString.substring(0, remoteUrlString.length() - 1);
        }
        return remoteUrlString + relativePath;
    }

    @InterfaceAudience.Private
    public static interface BulkDownloaderDocument {
        public void onDocument(Map<String, Object> var1);
    }
}

