/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.replicator.RemoteRequest;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.RequestUtils;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.MultipartDocumentReader;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RemoteMultipartDownloaderRequest
extends RemoteRequest {
    private static final int BUF_LEN = 1024;
    private Database db;

    public RemoteMultipartDownloaderRequest(HttpClientFactory clientFactory, String method, URL url, boolean cancelable, Map<String, ?> body, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletion onCompletion) {
        super(clientFactory, method, url, cancelable, body, requestHeaders, onCompletion);
        this.db = db;
    }

    @Override
    protected Request.Builder addHeaders(Request.Builder builder) {
        builder.addHeader("Accept", "multipart/related, application/json");
        builder.addHeader("User-Agent", Manager.getUserAgent());
        builder.addHeader("Accept-Encoding", "gzip, deflate");
        builder.addHeader("X-Accept-Part-Encoding", "gzip");
        return this.addRequestHeaders(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeRequest(OkHttpClient httpClient, Request request) {
        Map<String, Object> fullBody = null;
        Exception error = null;
        Response response = null;
        try {
            block17: {
                try {
                    Log.v("RemoteRequest", "%s: RemoteMultipartDownloaderRequest call execute(), url: %s", this, this.url);
                    this.call = httpClient.newCall(request);
                    response = this.call.execute();
                    Log.v("RemoteRequest", "%s: RemoteMultipartDownloaderRequest called execute(), url: %s", this, this.url);
                    this.storeCookie(response);
                    if (response.code() >= 300) {
                        Log.w("RemoteRequest", "%s: Got error status: %d for %s. Reason: %s", this, response.code(), this.url, response.message());
                        error = new RemoteRequestResponseException(response.code(), response.message());
                        RequestUtils.closeResponseBody(response);
                        break block17;
                    }
                    ResponseBody responseBody = response.body();
                    InputStream stream = responseBody.byteStream();
                    try {
                        MediaType type;
                        if (Utils.isGzip(response)) {
                            stream = new GZIPInputStream(stream);
                        }
                        if ((type = responseBody.contentType()) != null) {
                            if (type.type().equals("multipart") && type.subtype().equals("related")) {
                                int numBytesRead;
                                MultipartDocumentReader reader = new MultipartDocumentReader(this.db);
                                reader.setHeaders(Utils.headersToMap(response.headers()));
                                byte[] buffer = new byte[1024];
                                while ((numBytesRead = stream.read(buffer)) != -1) {
                                    reader.appendData(buffer, 0, numBytesRead);
                                }
                                reader.finish();
                                fullBody = reader.getDocumentProperties();
                            } else {
                                fullBody = Manager.getObjectMapper().readValue(stream, Object.class);
                            }
                        }
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    Log.w("RemoteRequest", "%s: executeRequest() Exception: %s.  url: %s", this, e, this.url);
                    error = e;
                }
            }
            this.respondWithResult(fullBody, error, response);
        }
        catch (Throwable throwable) {
            RequestUtils.closeResponseBody(response);
            throw throwable;
        }
        RequestUtils.closeResponseBody(response);
    }
}

