/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.BlobStore;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.replicator.BlobRequestBody;
import com.couchbase.lite.replicator.RemoteRequest;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.util.Log;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RemoteMultipartRequest
extends RemoteRequest {
    private Map<String, Object> attachments;
    private Database db;
    private boolean syncGateway;

    public RemoteMultipartRequest(HttpClientFactory clientFactory, String method, URL url, boolean syncGateway, boolean cancelable, Map<String, ?> body, Map<String, Object> attachments, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletion onCompletion) {
        super(clientFactory, method, url, cancelable, body, requestHeaders, onCompletion);
        this.attachments = attachments;
        this.db = db;
        this.syncGateway = syncGateway;
    }

    @Override
    protected Request.Builder addHeaders(Request.Builder builder) {
        builder.addHeader("Accept", "*/*");
        builder.addHeader("User-Agent", Manager.getUserAgent());
        builder.addHeader("Accept-Encoding", "gzip, deflate");
        return this.addRequestHeaders(builder);
    }

    @Override
    protected Request.Builder setBody(Request.Builder builder) {
        if (this.body != null) {
            MultipartBody.Builder bodyBuilder = this.createMultipartBody();
            MultipartBody requestBody = bodyBuilder.build();
            if ("PUT".equalsIgnoreCase(this.method)) {
                builder.put((RequestBody)requestBody);
            } else if ("POST".equalsIgnoreCase(this.method)) {
                builder.post((RequestBody)requestBody);
            }
        }
        return builder;
    }

    private MultipartBody.Builder createMultipartBody() {
        MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder();
        multipartBodyBuilder.setType(MediaType.parse((String)"multipart/related"));
        byte[] bodyBytes = null;
        try {
            bodyBytes = Manager.getObjectMapper().writeValueAsBytes((Object)this.body);
        }
        catch (Exception e) {
            Log.e("RemoteRequest", "Error serializing body of request", e);
        }
        if (bodyBytes != null) {
            RequestBody requestBody = null;
            if (this.isCompressedRequest() && (requestBody = this.setCompressedBody(bodyBytes)) != null) {
                multipartBodyBuilder.addPart(Headers.of((String[])new String[]{"Content-Encoding", "gzip"}), requestBody);
            }
            if (requestBody == null && (requestBody = RequestBody.create((MediaType)JSON, (byte[])bodyBytes)) != null) {
                multipartBodyBuilder.addPart(requestBody);
            }
        }
        for (String key : this.attachments.keySet()) {
            Map attachment = (Map)this.attachments.get(key);
            if (!attachment.containsKey("follows")) continue;
            BlobStore blobStore = this.db.getAttachmentStore();
            String base64Digest = (String)attachment.get("digest");
            BlobKey blobKey = new BlobKey(base64Digest);
            String contentType = null;
            if (attachment.containsKey("content_type")) {
                contentType = (String)attachment.get("content_type");
            } else if (attachment.containsKey("type")) {
                contentType = (String)attachment.get("type");
            } else if (attachment.containsKey("content-type")) {
                Log.w("Sync", "Found attachment that uses content-type field name instead of content_type (see couchbase-lite-android issue #80): %s", attachment);
            }
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            String contentEncoding = null;
            if (attachment.containsKey("encoding")) {
                contentEncoding = (String)attachment.get("encoding");
            }
            Headers.Builder builder = new Headers.Builder();
            builder.add("Content-Disposition", String.format(Locale.ENGLISH, "attachment; filename=%s", key));
            if (contentEncoding != null) {
                builder.add("Content-Encoding", contentEncoding);
            }
            long declaredLength = 0L;
            if (attachment.containsKey("length")) {
                declaredLength = ((Integer)attachment.get("length")).longValue();
            }
            MediaType type = MediaType.parse((String)contentType);
            RequestBody body = BlobRequestBody.create(type, blobStore, blobKey, declaredLength, this.syncGateway);
            multipartBodyBuilder.addPart(builder.build(), body);
        }
        return multipartBodyBuilder;
    }
}

