/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Manager;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.RequestUtils;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.util.CancellableRunnable;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import okhttp3.Call;
import okhttp3.Cookie;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RemoteRequest
implements CancellableRunnable {
    public static final String TAG = "RemoteRequest";
    public static final int MIN_JSON_LENGTH_TO_COMPRESS = 100;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected final HttpClientFactory factory;
    protected String method;
    protected URL url;
    protected Map<String, ?> body;
    protected Authenticator authenticator;
    protected RemoteRequestCompletion onPreCompletion;
    protected RemoteRequestCompletion onCompletion;
    protected RemoteRequestCompletion onPostCompletion;
    protected Call call;
    private boolean cancelable = true;
    protected Map<String, Object> requestHeaders;
    protected boolean dontLog404;
    protected boolean compressedRequest = false;
    protected String str = null;
    static Pattern re = Pattern.compile("(\\w+)\\s+(\\w+)=((\\w+)|\"([^\"]+))");

    public RemoteRequest(HttpClientFactory factory, String method, URL url, boolean cancelable, Map<String, ?> body, Map<String, Object> requestHeaders, RemoteRequestCompletion onCompletion) {
        this.factory = factory;
        this.method = method;
        this.url = url;
        this.cancelable = cancelable;
        this.body = body;
        this.onCompletion = onCompletion;
        this.requestHeaders = requestHeaders;
        Log.v("Sync", "%s: RemoteRequest created, url: %s", this, url);
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    public void cancel() {
        if (this.call != null && !this.call.isCanceled() && this.cancelable) {
            Log.w(TAG, "%s: aborting request: %s", this, this.call);
            this.call.cancel();
        }
    }

    public String toString() {
        if (this.str == null) {
            String remoteURL = this.url.toExternalForm().replaceAll("://.*:.*@", "://---:---@");
            this.str = String.format(Locale.ENGLISH, "%s {%s, %s}", this.getClass().getName(), this.method, remoteURL);
        }
        return this.str;
    }

    public void setOnPostCompletion(RemoteRequestCompletion onPostCompletion) {
        this.onPostCompletion = onPostCompletion;
    }

    public void setOnPreCompletion(RemoteRequestCompletion onPreCompletion) {
        this.onPreCompletion = onPreCompletion;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setDontLog404(boolean dontLog404) {
        this.dontLog404 = dontLog404;
    }

    public boolean isCompressedRequest() {
        return this.compressedRequest;
    }

    public void setCompressedRequest(boolean compressedRequest) {
        this.compressedRequest = compressedRequest;
    }

    protected void execute() {
        Log.v("Sync", "%s: RemoteRequest execute() called, url: %s", this, this.url);
        this.executeRequest(this.factory.getOkHttpClient(), this.request());
        Log.v("Sync", "%s: RemoteRequest execute() finished, url: %s", this, this.url);
    }

    protected Request request() {
        Request.Builder builder = new Request.Builder().url(this.url);
        builder = RequestUtils.preemptivelySetAuthCredentials(builder, this.url, this.authenticator);
        this.addHeaders(builder);
        this.setBody(builder);
        return builder.build();
    }

    protected Request.Builder addHeaders(Request.Builder builder) {
        builder.addHeader("Accept", "multipart/related, application/json");
        builder.addHeader("User-Agent", Manager.getUserAgent());
        builder.addHeader("Accept-Encoding", "gzip, deflate");
        this.addRequestHeaders(builder);
        return builder;
    }

    protected Request.Builder addRequestHeaders(Request.Builder builder) {
        if (this.requestHeaders != null) {
            for (String key : this.requestHeaders.keySet()) {
                builder.addHeader(key, this.requestHeaders.get(key).toString());
            }
        }
        return builder;
    }

    protected Request.Builder setBody(Request.Builder builder) {
        if (this.body != null) {
            byte[] bodyBytes = null;
            try {
                bodyBytes = Manager.getObjectMapper().writeValueAsBytes(this.body);
            }
            catch (Exception e) {
                Log.e(TAG, "Error serializing body of request", e);
            }
            RequestBody requestBody = null;
            if (this.isCompressedRequest() && (requestBody = this.setCompressedBody(bodyBytes)) != null) {
                builder.addHeader("Content-Encoding", "gzip");
            }
            if (requestBody == null) {
                requestBody = RequestBody.create((MediaType)JSON, (byte[])bodyBytes);
            }
            if ("PUT".equalsIgnoreCase(this.method)) {
                builder.put(requestBody);
            } else if ("POST".equalsIgnoreCase(this.method)) {
                builder.post(requestBody);
            }
        }
        return builder;
    }

    protected RequestBody setCompressedBody(byte[] bodyBytes) {
        if (bodyBytes.length < 100) {
            return null;
        }
        byte[] encodedBytes = Utils.compressByGzip(bodyBytes);
        if (encodedBytes == null || encodedBytes.length >= bodyBytes.length) {
            return null;
        }
        return RequestBody.create((MediaType)JSON, (byte[])encodedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRequest(OkHttpClient httpClient, Request request) {
        Object fullBody = null;
        Exception error = null;
        Response response = null;
        try {
            block15: {
                try {
                    Log.v(TAG, "%s: RemoteRequest calling httpClient.execute, url: %s", this, this.url);
                    this.call = httpClient.newCall(request);
                    response = this.call.execute();
                    Log.v(TAG, "%s: RemoteRequest called httpClient.execute, url: %s", this, this.url);
                    this.storeCookie(response);
                    if (response.code() >= 300) {
                        if (!this.dontLog404) {
                            Log.w(TAG, "%s: Got error status: %d for %s. Reason: %s", this, response.code(), this.url, response.message());
                        }
                        String authHeader = response.header("WWW-Authenticate");
                        Map<String, String> challenge = RemoteRequest.parseAuthHeader(authHeader);
                        HashMap<String, Map<String, String>> extra = null;
                        if (challenge != null) {
                            extra = new HashMap<String, Map<String, String>>();
                            extra.put("AuthChallenge", challenge);
                        }
                        error = new RemoteRequestResponseException(response.code(), response.message(), extra);
                        RequestUtils.closeResponseBody(response);
                        break block15;
                    }
                    InputStream stream = response.body().byteStream();
                    try {
                        if (Utils.isGzip(response)) {
                            stream = new GZIPInputStream(stream);
                        }
                        fullBody = Manager.getObjectMapper().readValue(stream, Object.class);
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    Log.w(TAG, "%s: executeRequest() Exception: %s.  url: %s", e, this, e, this.url);
                    error = e;
                }
            }
            this.respondWithResult(fullBody, error, response);
        }
        catch (Throwable throwable) {
            RequestUtils.closeResponseBody(response);
            throw throwable;
        }
        RequestUtils.closeResponseBody(response);
    }

    protected void respondWithResult(Object result, Throwable error, Response response) {
        try {
            if (this.onPreCompletion != null) {
                this.onPreCompletion.onCompletion(response, null, error);
            }
            this.onCompletion.onCompletion(response, result, error);
            if (this.onPostCompletion != null) {
                this.onPostCompletion.onCompletion(response, null, error);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "RemoteRequestCompletionBlock throw Exception", e);
        }
    }

    protected void storeCookie(Response response) {
        if (!response.headers("Set-Cookie").isEmpty()) {
            HttpUrl rUrl = response.request().url();
            HttpUrl url = new HttpUrl.Builder().scheme(rUrl.scheme()).host(rUrl.host()).build();
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            for (String setCookie : response.headers("Set-Cookie")) {
                cookies.add(Cookie.parse((HttpUrl)url, (String)setCookie));
            }
            this.factory.addCookies(cookies);
        }
    }

    protected static Map<String, String> parseAuthHeader(String authHeader) {
        if (authHeader == null || authHeader.length() == 0) {
            return null;
        }
        HashMap<String, String> challenge = new HashMap<String, String>();
        Matcher m = re.matcher(authHeader);
        while (m.find()) {
            String scheme = m.group(1);
            String key = m.group(2);
            String value = m.group(4);
            if (value == null || value.length() == 0) {
                value = m.group(5);
            }
            challenge.put(key, value);
            challenge.put("Scheme", scheme);
        }
        challenge.put("WWW-Authenticate", authHeader);
        return challenge;
    }
}

