/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.Manager;
import com.couchbase.lite.NetworkReachabilityListener;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.Authorizer;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.replicator.PullerInternal;
import com.couchbase.lite.replicator.PusherInternal;
import com.couchbase.lite.replicator.ReplicationInternal;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.replicator.ReplicationStateTransition;
import com.couchbase.lite.support.CouchbaseLiteHttpClientFactory;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.PersistentCookieJar;
import com.couchbase.lite.util.Log;
import java.net.URL;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Replication
implements ReplicationInternal.ChangeListener,
NetworkReachabilityListener {
    public static final String REPLICATOR_DATABASE_NAME = "_replicator";
    public static long DEFAULT_MAX_TIMEOUT_FOR_SHUTDOWN = 60L;
    public static int DEFAULT_HEARTBEAT = 30;
    protected Database db;
    protected URL remote;
    protected HttpClientFactory clientFactory;
    protected ReplicationInternal replicationInternal;
    protected Lifecycle lifecycle;
    private final List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();
    protected Throwable lastError;
    protected Direction direction;
    private Object lockPendingDocIDs = new Object();
    private Set<String> pendingDocIDs;
    private Map<ReplicationField, Object> properties;

    Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("continuous", this.isContinuous());
        props.put("create_target", this.shouldCreateTarget());
        props.put("filter", this.getFilter());
        props.put("query_params", this.getFilterParams());
        props.put("doc_ids", this.getDocIds());
        URL remoteURL = this.getRemoteUrl();
        HashMap<String, Object> remote = new HashMap<String, Object>();
        remote.put("url", remoteURL.toString());
        remote.put("headers", this.getHeaders());
        if (this.isPull()) {
            props.put("source", remote);
            props.put("target", this.db.getName());
        } else {
            props.put("source", this.db.getName());
            props.put("target", remote);
        }
        return props;
    }

    @InterfaceAudience.Private
    public Replication(Database db, URL remote, Direction direction) {
        this(db, remote, direction, db.getManager().getDefaultHttpClientFactory());
    }

    @InterfaceAudience.Private
    public Replication(Database db, URL remote, Direction direction, HttpClientFactory factory) {
        this.db = db;
        this.remote = remote;
        this.lifecycle = Lifecycle.ONESHOT;
        this.direction = direction;
        this.properties = new EnumMap<ReplicationField, Object>(ReplicationField.class);
        this.setClientFactory(factory);
        this.initReplicationInternal();
    }

    private void initReplicationInternal() {
        switch (this.direction) {
            case PULL: {
                this.replicationInternal = new PullerInternal(this.db, this.remote, this.clientFactory, this.lifecycle, this);
                break;
            }
            case PUSH: {
                this.replicationInternal = new PusherInternal(this.db, this.remote, this.clientFactory, this.lifecycle, this);
                break;
            }
            default: {
                throw new RuntimeException(String.format(Locale.ENGLISH, "Unknown direction: %s", new Object[]{this.direction}));
            }
        }
        this.addProperties(this.replicationInternal);
        this.replicationInternal.addChangeListener(this);
    }

    @InterfaceAudience.Public
    public void start() {
        if (this.replicationInternal == null) {
            this.initReplicationInternal();
        } else if (!this.replicationInternal.stateMachine.isInState((Object)ReplicationState.INITIAL)) {
            if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.STOPPED)) {
                this.initReplicationInternal();
            } else {
                Log.w("Sync", String.format(Locale.ENGLISH, "replicationInternal in unexpected state: %s, ignoring start()", this.replicationInternal.stateMachine.getState()));
            }
        }
        if (this.pendingDocIDs != null) {
            this.db.runAsync(new AsyncTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(Database database) {
                    Object object = Replication.this.lockPendingDocIDs;
                    synchronized (object) {
                        Replication.this.pendingDocIDs = null;
                    }
                }
            });
        }
        this.replicationInternal.triggerStart();
    }

    @InterfaceAudience.Public
    public void restart() {
        if (this.isRunning()) {
            final CountDownLatch stopped = new CountDownLatch(1);
            ChangeListener listener = new ChangeListener(){

                @Override
                public void changed(ChangeEvent event) {
                    if (event.getTransition() != null && event.getTransition().getDestination() == ReplicationState.STOPPED) {
                        stopped.countDown();
                    }
                }
            };
            this.addChangeListener(listener);
            this.stop();
            try {
                boolean ret = stopped.await(60L, TimeUnit.SECONDS);
                if (!ret) {
                    throw new RuntimeException("Replicator is unable to stop.");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.removeChangeListener(listener);
            }
        }
        this.start();
    }

    @InterfaceAudience.Public
    public void goOffline() {
        this.replicationInternal.triggerGoOffline();
    }

    @InterfaceAudience.Public
    public void goOnline() {
        this.replicationInternal.triggerGoOnline();
    }

    @InterfaceAudience.Public
    public boolean isRunning() {
        if (this.replicationInternal == null) {
            return false;
        }
        return this.replicationInternal.isRunning();
    }

    @InterfaceAudience.Public
    public void stop() {
        if (this.replicationInternal != null) {
            this.replicationInternal.triggerStopGraceful();
        }
    }

    @InterfaceAudience.Public
    public boolean isContinuous() {
        return this.lifecycle == Lifecycle.CONTINUOUS;
    }

    @InterfaceAudience.Public
    public void setContinuous(boolean isContinous) {
        if (isContinous) {
            this.lifecycle = Lifecycle.CONTINUOUS;
            this.replicationInternal.setLifecycle(Lifecycle.CONTINUOUS);
        } else {
            this.lifecycle = Lifecycle.ONESHOT;
            this.replicationInternal.setLifecycle(Lifecycle.ONESHOT);
        }
    }

    @InterfaceAudience.Public
    public void setAuthenticator(Authenticator authenticator) {
        this.properties.put(ReplicationField.AUTHENTICATOR, authenticator);
        this.replicationInternal.setAuthenticator(authenticator);
    }

    @InterfaceAudience.Public
    public Authenticator getAuthenticator() {
        return this.replicationInternal.getAuthenticator();
    }

    @InterfaceAudience.Public
    public boolean shouldCreateTarget() {
        return this.replicationInternal.shouldCreateTarget();
    }

    @InterfaceAudience.Public
    public void setCreateTarget(boolean createTarget) {
        this.properties.put(ReplicationField.CREATE_TARGET, createTarget);
        this.replicationInternal.setCreateTarget(createTarget);
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @InterfaceAudience.Public
    public ReplicationStatus getStatus() {
        if (this.replicationInternal == null) {
            return ReplicationStatus.REPLICATION_STOPPED;
        }
        if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.OFFLINE)) {
            return ReplicationStatus.REPLICATION_OFFLINE;
        }
        if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.IDLE)) {
            return ReplicationStatus.REPLICATION_IDLE;
        }
        if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.INITIAL) || this.replicationInternal.stateMachine.isInState((Object)ReplicationState.STOPPED)) {
            return ReplicationStatus.REPLICATION_STOPPED;
        }
        return ReplicationStatus.REPLICATION_ACTIVE;
    }

    @Override
    public void changed(ChangeEvent event) {
        if (this.pendingDocIDs != null) {
            this.db.runAsync(new AsyncTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(Database database) {
                    Object object = Replication.this.lockPendingDocIDs;
                    synchronized (object) {
                        Replication.this.pendingDocIDs = null;
                    }
                }
            });
        }
        for (ChangeListener changeListener : this.changeListeners) {
            try {
                changeListener.changed(event);
            }
            catch (Exception e) {
                Log.e("Sync", "Exception calling changeListener.changed", e);
            }
        }
    }

    @InterfaceAudience.Public
    public Throwable getLastError() {
        return this.lastError;
    }

    @InterfaceAudience.Public
    public int getCompletedChangesCount() {
        return this.replicationInternal.getCompletedChangesCount().get();
    }

    @InterfaceAudience.Public
    public int getChangesCount() {
        return this.replicationInternal.getChangesCount().get();
    }

    protected void setLastError(Throwable lastError) {
        this.lastError = lastError;
    }

    protected String remoteCheckpointDocID() {
        return this.replicationInternal.remoteCheckpointDocID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPendingDocumentIDs() {
        Object object = this.lockPendingDocIDs;
        synchronized (object) {
            if (this.isPull() || this.isRunning() && this.pendingDocIDs != null) {
                return this.pendingDocIDs;
            }
            final CountDownLatch latch = new CountDownLatch(1);
            this.db.getManager().getWorkExecutor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RevisionList revs;
                        Map filterParams = (Map)Replication.this.properties.get("query_params");
                        ReplicationFilter filter = Replication.this.replicationInternal.compilePushReplicationFilter();
                        String lastSequence = Replication.this.replicationInternal.lastSequence;
                        if (lastSequence == null) {
                            lastSequence = Replication.this.db.lastSequenceWithCheckpointId(Replication.this.remoteCheckpointDocID());
                        }
                        if ((revs = Replication.this.db.unpushedRevisionsSince(lastSequence, filter, filterParams)) != null) {
                            Replication.this.pendingDocIDs = new HashSet();
                            Replication.this.pendingDocIDs.addAll(revs.getAllDocIds());
                        } else {
                            Replication.this.pendingDocIDs = null;
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Log.e("Sync", "InterruptedException", e);
            }
            return this.pendingDocIDs;
        }
    }

    public boolean isDocumentPending(Document doc) {
        if (doc == null) {
            return false;
        }
        Set<String> ids = this.getPendingDocumentIDs();
        if (ids == null) {
            return false;
        }
        return ids.contains(doc.getId());
    }

    @InterfaceAudience.Private
    protected void setClientFactory(HttpClientFactory factory) {
        Manager manager = null;
        if (this.db != null) {
            manager = this.db.getManager();
        }
        HttpClientFactory managerClientFactory = null;
        if (manager != null) {
            managerClientFactory = manager.getDefaultHttpClientFactory();
        }
        if (factory != null) {
            this.clientFactory = factory;
        } else if (managerClientFactory != null) {
            this.clientFactory = managerClientFactory;
        } else {
            PersistentCookieJar cookieStore = this.db.getPersistentCookieStore();
            this.clientFactory = new CouchbaseLiteHttpClientFactory(cookieStore);
        }
    }

    @InterfaceAudience.Private
    protected boolean serverIsSyncGatewayVersion(String minVersion) {
        return this.replicationInternal.serverIsSyncGatewayVersion(minVersion);
    }

    @InterfaceAudience.Private
    protected void setServerType(String serverType) {
        this.replicationInternal.setServerType(serverType);
    }

    @InterfaceAudience.Public
    public void setFilter(String filterName) {
        this.properties.put(ReplicationField.FILTER_NAME, filterName);
        this.replicationInternal.setFilter(filterName);
    }

    @InterfaceAudience.Public
    public void setDocIds(List<String> docIds) {
        this.properties.put(ReplicationField.DOC_IDS, docIds);
        this.replicationInternal.setDocIds(docIds);
    }

    public List<String> getDocIds() {
        return this.replicationInternal.getDocIds();
    }

    public void setFilterParams(Map<String, Object> filterParams) {
        this.properties.put(ReplicationField.FILTER_PARAMS, filterParams);
        this.replicationInternal.setFilterParams(filterParams);
    }

    @InterfaceAudience.Public
    public String getUsername() {
        return this.replicationInternal.getUsername();
    }

    @InterfaceAudience.Public
    public void setCookie(String name, String value, String path, long maxAge, boolean secure, boolean httpOnly) {
        this.replicationInternal.setCookie(name, value, path, maxAge, secure, httpOnly);
    }

    @InterfaceAudience.Public
    public void setCookie(String name, String value, String path, Date expirationDate, boolean secure, boolean httpOnly) {
        this.replicationInternal.setCookie(name, value, path, expirationDate, secure, httpOnly);
    }

    @InterfaceAudience.Public
    public void deleteCookie(String name) {
        this.replicationInternal.deleteCookie(name);
    }

    @InterfaceAudience.Public
    public boolean clearAuthenticationStores() {
        if (!(this.getAuthenticator() == null || this.getAuthenticator() instanceof Authorizer && ((Authorizer)this.getAuthenticator()).removeStoredCredentials())) {
            return false;
        }
        this.replicationInternal.deleteCookie(this.remote);
        return true;
    }

    @InterfaceAudience.Public
    public String getRemoteUUID() {
        return this.replicationInternal.getRemoteUUID();
    }

    @InterfaceAudience.Public
    public void setRemoteUUID(String remoteUUID) {
        this.properties.put(ReplicationField.REMOTE_UUID, remoteUUID);
        this.replicationInternal.setRemoteUUID(remoteUUID);
    }

    @InterfaceAudience.Private
    protected HttpClientFactory getClientFactory() {
        return this.replicationInternal.getClientFactory();
    }

    @InterfaceAudience.Private
    protected String buildRelativeURLString(String relativePath) {
        return this.replicationInternal.buildRelativeURLString(relativePath);
    }

    @InterfaceAudience.Public
    public List<String> getChannels() {
        return this.replicationInternal.getChannels();
    }

    @InterfaceAudience.Public
    public void setChannels(List<String> channels) {
        this.replicationInternal.setChannels(channels);
    }

    @InterfaceAudience.Public
    public String getFilter() {
        return this.replicationInternal.getFilter();
    }

    @InterfaceAudience.Public
    public Map<String, Object> getFilterParams() {
        return this.replicationInternal.getFilterParams();
    }

    @InterfaceAudience.Public
    public void setHeaders(Map<String, Object> requestHeadersParam) {
        this.properties.put(ReplicationField.REQUEST_HEADERS, requestHeadersParam);
        this.replicationInternal.setHeaders(requestHeadersParam);
    }

    @InterfaceAudience.Public
    public Map<String, Object> getHeaders() {
        return this.replicationInternal.getHeaders();
    }

    @InterfaceAudience.Private
    public String getSessionID() {
        return this.replicationInternal.getSessionID();
    }

    @InterfaceAudience.Public
    public Database getLocalDatabase() {
        return this.db;
    }

    @InterfaceAudience.Public
    public URL getRemoteUrl() {
        return this.remote;
    }

    @InterfaceAudience.Public
    public boolean isPull() {
        return this.replicationInternal.isPull();
    }

    @Override
    @InterfaceAudience.Private
    public void networkReachable() {
        this.goOnline();
    }

    @Override
    @InterfaceAudience.Private
    public void networkUnreachable() {
        this.goOffline();
    }

    private void addProperties(ReplicationInternal replicationInternal) {
        for (ReplicationField key : this.properties.keySet()) {
            Object value = this.properties.get((Object)key);
            switch (key) {
                case FILTER_NAME: {
                    replicationInternal.setFilter((String)value);
                    break;
                }
                case FILTER_PARAMS: {
                    replicationInternal.setFilterParams((Map)value);
                    break;
                }
                case DOC_IDS: {
                    replicationInternal.setDocIds((List)value);
                    break;
                }
                case AUTHENTICATOR: {
                    replicationInternal.setAuthenticator((Authenticator)value);
                    break;
                }
                case CREATE_TARGET: {
                    replicationInternal.setCreateTarget((Boolean)value);
                    break;
                }
                case REQUEST_HEADERS: {
                    replicationInternal.setHeaders((Map)value);
                    break;
                }
                case REMOTE_UUID: {
                    replicationInternal.setRemoteUUID((String)value);
                }
            }
        }
    }

    public String toString() {
        return "Replication{" + this.remote + ", " + (this.isPull() ? "pull" : "push") + '}';
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private final Replication source;
        private final int changeCount;
        private final int completedChangeCount;
        private final ReplicationStateTransition transition;
        private final Throwable error;

        protected ChangeEvent(ReplicationInternal replInternal) {
            this.source = replInternal.parentReplication;
            this.changeCount = replInternal.getChangesCount().get();
            this.completedChangeCount = replInternal.getCompletedChangesCount().get();
            this.transition = null;
            this.error = null;
        }

        protected ChangeEvent(ReplicationInternal replInternal, ReplicationStateTransition transition) {
            this.source = replInternal.parentReplication;
            this.changeCount = replInternal.getChangesCount().get();
            this.completedChangeCount = replInternal.getCompletedChangesCount().get();
            this.transition = transition;
            this.error = null;
        }

        protected ChangeEvent(ReplicationInternal replInternal, Throwable error) {
            this.source = replInternal.parentReplication;
            this.changeCount = replInternal.getChangesCount().get();
            this.completedChangeCount = replInternal.getCompletedChangesCount().get();
            this.transition = null;
            this.error = error;
        }

        public Replication getSource() {
            return this.source;
        }

        public ReplicationStateTransition getTransition() {
            return this.transition;
        }

        public int getChangeCount() {
            return this.changeCount;
        }

        public int getCompletedChangeCount() {
            return this.completedChangeCount;
        }

        public Throwable getError() {
            return this.error;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.getSource().direction);
            sb.append(" replication event. Source: ");
            sb.append(this.getSource());
            if (this.getTransition() != null) {
                sb.append(" Transition: ");
                sb.append((Object)this.getTransition().getSource());
                sb.append(" -> ");
                sb.append((Object)this.getTransition().getDestination());
            }
            sb.append(" Total changes: ");
            sb.append(this.getChangeCount());
            sb.append(" Completed changes: ");
            sb.append(this.getCompletedChangeCount());
            return sb.toString();
        }
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    public static enum ReplicationField {
        FILTER_NAME,
        FILTER_PARAMS,
        DOC_IDS,
        REQUEST_HEADERS,
        AUTHENTICATOR,
        CREATE_TARGET,
        REMOTE_UUID;

    }

    public static enum ReplicationStatus {
        REPLICATION_STOPPED,
        REPLICATION_OFFLINE,
        REPLICATION_IDLE,
        REPLICATION_ACTIVE;

    }

    public static enum Lifecycle {
        ONESHOT,
        CONTINUOUS;

    }

    public static enum Direction {
        PULL,
        PUSH;

    }
}

