/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.Status;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.Authorizer;
import com.couchbase.lite.auth.LoginAuthorizer;
import com.couchbase.lite.auth.OpenIDConnectAuthorizer;
import com.couchbase.lite.auth.SessionCookieAuthorizer;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.RemoteRequestCompletion;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.RemoteRequestRetry;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.replicator.ReplicationStateTransition;
import com.couchbase.lite.replicator.ReplicationTrigger;
import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.support.Batcher;
import com.couchbase.lite.support.BlockingQueueListener;
import com.couchbase.lite.support.CustomFuture;
import com.couchbase.lite.support.CustomLinkedBlockingQueue;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.util.CancellableRunnable;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.TextUtils;
import com.couchbase.lite.util.URIUtils;
import com.couchbase.lite.util.URLUtils;
import com.couchbase.lite.util.Utils;
import com.github.oxo42.stateless4j.StateMachine;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.transitions.Transition;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Cookie;
import okhttp3.Response;

@InterfaceAudience.Private
abstract class ReplicationInternal
implements BlockingQueueListener {
    private static final String TAG = "Sync";
    public static final String BY_CHANNEL_FILTER_NAME = "sync_gateway/bychannel";
    public static final String CHANNELS_QUERY_PARAM = "channels";
    public static final int EXECUTOR_THREAD_POOL_SIZE = 5;
    public static final int MIN_EXECUTOR_THREAD_POOL_SIZE = 2;
    public static final String SYNC_GATEWAY_PREFIX = "Couchbase Sync Gateway/";
    private static int lastSessionID = 0;
    public static int RETRY_DELAY_SECONDS = 60;
    private static ReplicationStateTransition TRANS_RUNNING_TO_IDLE = new ReplicationStateTransition(ReplicationState.RUNNING, ReplicationState.IDLE, ReplicationTrigger.WAITING_FOR_CHANGES);
    private static ReplicationStateTransition TRANS_IDLE_TO_RUNNING = new ReplicationStateTransition(ReplicationState.IDLE, ReplicationState.RUNNING, ReplicationTrigger.RESUME);
    protected Replication parentReplication;
    protected Database db;
    protected URL remote;
    protected HttpClientFactory clientFactory;
    protected String lastSequence;
    protected Authenticator authenticator;
    protected boolean authenticating = false;
    private String username;
    protected String filterName;
    protected Map<String, Object> filterParams;
    protected List<String> documentIDs;
    private String remoteUUID;
    protected Map<String, Object> requestHeaders;
    private String serverType;
    protected Batcher<RevisionInternal> batcher;
    protected static int PROCESSOR_DELAY = 500;
    protected static int INBOX_CAPACITY = 100;
    protected ScheduledExecutorService remoteRequestExecutor;
    private Throwable error;
    private String remoteCheckpointDocID;
    protected Map<String, Object> remoteCheckpoint;
    protected AtomicInteger completedChangesCount;
    protected AtomicInteger changesCount;
    protected CollectionUtils.Functor<RevisionInternal, RevisionInternal> revisionBodyTransformationBlock;
    protected String sessionID;
    protected BlockingQueue<Future> pendingFutures;
    Map<Future, CancellableRunnable> runnables = new HashMap<Future, CancellableRunnable>();
    private boolean lastSequenceChanged = false;
    private boolean savingCheckpoint;
    private boolean overdueForCheckpointSave;
    protected ScheduledExecutorService executor;
    protected StateMachine<ReplicationState, ReplicationTrigger> stateMachine;
    private final List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();
    protected Replication.Lifecycle lifecycle;
    protected ChangeListenerNotifyStyle changeListenerNotifyStyle;
    private Future retryFuture = null;
    protected boolean waitingForPendingFutures = false;
    protected final Object lockWaitForPendingFutures = new Object();
    private static int SAVE_LAST_SEQUENCE_DELAY = 5;

    ReplicationInternal(Database db, URL remote, HttpClientFactory clientFactory, Replication.Lifecycle lifecycle, Replication parentReplication) {
        Utils.assertNotNull((Object)lifecycle, "Must pass in a non-null lifecycle");
        this.parentReplication = parentReplication;
        this.db = db;
        this.remote = remote;
        this.clientFactory = clientFactory;
        this.lifecycle = lifecycle;
        this.requestHeaders = new HashMap<String, Object>();
        this.authenticating = false;
        this.username = URLUtils.getUser(remote);
        this.changeListenerNotifyStyle = ChangeListenerNotifyStyle.ASYNC;
        this.pendingFutures = new CustomLinkedBlockingQueue<Future>(this);
        this.initializeReplicationExecutor();
        this.initializeStateMachine();
    }

    protected void finalize() throws Throwable {
        if (this.executor != null && !this.executor.isShutdown()) {
            Utils.shutdownAndAwaitTermination(this.executor);
            this.executor = null;
        }
        super.finalize();
    }

    public void triggerStart() {
        this.fireTrigger(ReplicationTrigger.START);
    }

    public void triggerStopGraceful() {
        this.fireTrigger(ReplicationTrigger.STOP_GRACEFUL);
    }

    public void triggerGoOffline() {
        this.fireTrigger(ReplicationTrigger.GO_OFFLINE);
    }

    public void triggerGoOnline() {
        this.fireTrigger(ReplicationTrigger.GO_ONLINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTrigger(final ReplicationTrigger trigger) {
        Log.d(TAG, "%s [fireTrigger()] => " + (Object)((Object)trigger), this);
        ScheduledExecutorService scheduledExecutorService = this.executor;
        synchronized (scheduledExecutorService) {
            if (!this.executor.isShutdown()) {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Log.d(ReplicationInternal.TAG, "firing trigger: %s", new Object[]{trigger});
                            ReplicationInternal.this.stateMachine.fire((Object)trigger);
                        }
                        catch (Exception e) {
                            Log.e(ReplicationInternal.TAG, "Unknown Error in stateMachine.fire(trigger)", e);
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }
    }

    protected void triggerStopImmediate() {
        this.fireTrigger(ReplicationTrigger.STOP_IMMEDIATE);
    }

    protected void start() {
        try {
            if (!this.db.isOpen()) {
                String msg = String.format(Locale.ENGLISH, "Db: %s is not open, abort replication", this.db);
                this.parentReplication.setLastError(new Exception(msg));
                this.fireTrigger(ReplicationTrigger.STOP_IMMEDIATE);
                return;
            }
            this.db.addReplication(this.parentReplication);
            this.db.addActiveReplication(this.parentReplication);
            this.authenticating = false;
            this.initSessionId();
            this.initBatcher();
            this.initAuthorizer();
            this.initializeRequestWorkers();
            if (!this.isContinuous()) {
                this.goOnline();
            } else {
                if (this.isNetworkReachable()) {
                    this.goOnline();
                } else {
                    this.triggerGoOffline();
                }
                this.startNetworkReachabilityManager();
            }
        }
        catch (Exception e) {
            Log.e(TAG, "%s: Exception in start()", e, this);
        }
    }

    private void initSessionId() {
        this.sessionID = String.format(Locale.ENGLISH, "repl%03d", ++lastSessionID);
    }

    protected void goOffline() {
    }

    protected void goOnline() {
        this.error = null;
        this.checkSession();
    }

    protected void close() {
        this.authenticating = false;
        for (Future future : this.pendingFutures) {
            future.cancel(false);
            CancellableRunnable runnable = this.runnables.get(future);
            if (runnable == null) continue;
            runnable.cancel();
            this.runnables.remove(future);
        }
        if (this.remoteRequestExecutor != null && !this.remoteRequestExecutor.isShutdown()) {
            Utils.shutdownAndAwaitTermination(this.remoteRequestExecutor, Replication.DEFAULT_MAX_TIMEOUT_FOR_SHUTDOWN, Replication.DEFAULT_MAX_TIMEOUT_FOR_SHUTDOWN);
        }
    }

    protected void initAuthorizer() {
        if (this.authenticator != null && this.authenticator instanceof Authorizer) {
            Authorizer authorizer = (Authorizer)this.authenticator;
            authorizer.setRemoteURL(this.remote);
            authorizer.setLocalUUID(this.db.publicUUID());
        }
    }

    protected void initBatcher() {
        this.batcher = new Batcher<RevisionInternal>(this.executor, INBOX_CAPACITY, PROCESSOR_DELAY, new BatchProcessor<RevisionInternal>(){

            @Override
            public void process(List<RevisionInternal> inbox) {
                try {
                    Log.v(ReplicationInternal.TAG, "*** %s: BEGIN processInbox (%d sequences)", this, inbox.size());
                    ReplicationInternal.this.processInbox(new RevisionList(inbox));
                    Log.v(ReplicationInternal.TAG, "*** %s: END processInbox (lastSequence=%s)", this, ReplicationInternal.this.lastSequence);
                }
                catch (Exception e) {
                    Log.e(ReplicationInternal.TAG, "ERROR: processInbox failed: ", e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void startNetworkReachabilityManager() {
        this.db.getManager().getContext().getNetworkReachabilityManager().addNetworkReachabilityListener(this.parentReplication);
    }

    protected void stopNetworkReachabilityManager() {
        this.db.getManager().getContext().getNetworkReachabilityManager().removeNetworkReachabilityListener(this.parentReplication);
    }

    protected boolean isNetworkReachable() {
        return this.db.getManager().getContext().getNetworkReachabilityManager().isOnline();
    }

    public abstract boolean shouldCreateTarget();

    public abstract void setCreateTarget(boolean var1);

    protected void initializeReplicationExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    String threadName = "CBLReplicationExecutor";
                    try {
                        String maskedRemote = ReplicationInternal.this.remote.toExternalForm();
                        maskedRemote = maskedRemote.replaceAll("://.*:.*@", "://---:---@");
                        String type = ReplicationInternal.this.isPull() ? "pull" : "push";
                        String replicationIdentifier = Utils.shortenString(ReplicationInternal.this.remoteCheckpointDocID(), 5);
                        threadName = String.format(Locale.ENGLISH, "CBLReplicationExecutor-%s-%s-%s", maskedRemote, type, replicationIdentifier);
                    }
                    catch (Exception e) {
                        Log.e(ReplicationInternal.TAG, "Error creating thread name", e);
                    }
                    return new Thread(r, threadName);
                }
            });
        }
    }

    protected void initializeRequestWorkers() {
        if (this.remoteRequestExecutor == null) {
            int executorThreadPoolSize = this.db.getManager().getExecutorThreadPoolSize() <= 0 ? 5 : this.db.getManager().getExecutorThreadPoolSize();
            executorThreadPoolSize = Math.max(executorThreadPoolSize, 2);
            Log.v(TAG, "executorThreadPoolSize=" + executorThreadPoolSize);
            this.remoteRequestExecutor = Executors.newScheduledThreadPool(executorThreadPoolSize, new ThreadFactory(){
                private int counter = 0;

                @Override
                public Thread newThread(Runnable r) {
                    String threadName = "CBLRequestWorker";
                    try {
                        String maskedRemote = ReplicationInternal.this.remote.toExternalForm();
                        maskedRemote = maskedRemote.replaceAll("://.*:.*@", "://---:---@");
                        String type = ReplicationInternal.this.isPull() ? "pull" : "push";
                        String replicationIdentifier = Utils.shortenString(ReplicationInternal.this.remoteCheckpointDocID(), 5);
                        threadName = String.format(Locale.ENGLISH, "CBLRequestWorker-%s-%s-%s-%d", maskedRemote, type, replicationIdentifier, this.counter++);
                    }
                    catch (Exception e) {
                        Log.e(ReplicationInternal.TAG, "Error creating thread name", e);
                    }
                    return new Thread(r, threadName);
                }
            });
        }
    }

    @InterfaceAudience.Private
    protected void checkSession() {
        if (this.getAuthenticator() != null) {
            Authorizer auth = (Authorizer)this.getAuthenticator();
            auth.setRemoteURL(this.remote);
            auth.setLocalUUID(this.db.publicUUID());
        }
        if (this.getAuthenticator() != null && this.getAuthenticator() instanceof SessionCookieAuthorizer) {
            this.checkSessionAtPath("_session");
        } else {
            this.login();
        }
    }

    @InterfaceAudience.Private
    protected void checkSessionAtPath(final String sessionPath) {
        CustomFuture future = this.sendAsyncRequest("GET", sessionPath, null, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response _response, Object result, Throwable err) {
                try {
                    if (err != null) {
                        if (err instanceof RemoteRequestResponseException && ((RemoteRequestResponseException)err).getCode() == 404 && "_session".equalsIgnoreCase(sessionPath)) {
                            ReplicationInternal.this.checkSessionAtPath("/_session");
                            return;
                        }
                        if (err instanceof RemoteRequestResponseException && ((RemoteRequestResponseException)err).getCode() == 401) {
                            ReplicationInternal.this.login();
                        } else {
                            Log.w(ReplicationInternal.TAG, this + ": Session check failed", err);
                            ReplicationInternal.this.setError(err);
                        }
                    } else {
                        Map response = (Map)result;
                        Log.w(ReplicationInternal.TAG, "%s checkSessionAtPath() response: %s", this, response);
                        Map userCtx = (Map)response.get("userCtx");
                        String username = (String)userCtx.get("name");
                        if (username != null && username.length() > 0) {
                            Log.d(ReplicationInternal.TAG, "%s Active session, logged in as %s", this, username);
                            if (ReplicationInternal.this.authenticator != null && ReplicationInternal.this.authenticator instanceof OpenIDConnectAuthorizer) {
                                ((OpenIDConnectAuthorizer)ReplicationInternal.this.authenticator).setUsername(username);
                            }
                            ReplicationInternal.this.loginFinishedWithError(null);
                        } else {
                            Log.d(ReplicationInternal.TAG, "%s No active session, going to login", this);
                            ReplicationInternal.this.login();
                        }
                    }
                }
                catch (Exception e) {
                    Log.e(ReplicationInternal.TAG, "%s Exception in checkSessionAtPath()", this, e);
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    protected void login() {
        LoginAuthorizer loginAuth;
        List<Object> login = null;
        LoginAuthorizer loginAuthorizer = loginAuth = this.getAuthenticator() instanceof LoginAuthorizer ? (LoginAuthorizer)this.getAuthenticator() : null;
        if (loginAuth != null) {
            login = loginAuth.loginRequest();
        }
        if (login == null) {
            Log.d(TAG, "%s: %s has no login parameters, so skipping login", this, this.getAuthenticator());
            this.fetchRemoteCheckpointDoc();
            return;
        }
        String method = (String)login.get(0);
        String loginPath = (String)login.get(1);
        Map loginParameters = login.size() >= 3 ? (Map)login.get(2) : null;
        this.authenticating = true;
        Log.v(TAG, "%s: Doing login with %s at %s", this.getClass().getName(), this.getAuthenticator().getClass(), loginPath);
        boolean cancelable = false;
        CustomFuture future = this.sendAsyncRequest(method, loginPath, cancelable, loginParameters, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable error) {
                if (loginAuth != null && loginAuth.implementedLoginResponse()) {
                    loginAuth.loginResponse(result, httpResponse != null ? httpResponse.headers() : null, error, new LoginAuthorizer.ContinuationBlock(){

                        @Override
                        public void call(final boolean loginAgain, final Throwable continuationError) {
                            ReplicationInternal.this.db.runAsync(new AsyncTask(){

                                @Override
                                public void run(Database database) {
                                    if (loginAgain) {
                                        ReplicationInternal.this.login();
                                    } else {
                                        ReplicationInternal.this.loginFinishedWithError(continuationError);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    ReplicationInternal.this.loginFinishedWithError(error);
                }
            }
        });
        this.pendingFutures.add(future);
    }

    private void loginFinishedWithError(Throwable error) {
        this.authenticating = false;
        if (error != null) {
            Log.v(TAG, "%s: Login error: %s", this, error.getMessage());
            this.setError(error);
        } else {
            Log.v(TAG, "%s: Successfully logged in!", this);
            if (this.authenticator != null && this.authenticator instanceof OpenIDConnectAuthorizer) {
                this.username = ((OpenIDConnectAuthorizer)this.authenticator).getUsername();
            }
            this.fetchRemoteCheckpointDoc();
        }
    }

    @InterfaceAudience.Private
    protected void setError(Throwable throwable) {
        if (throwable != this.error) {
            Log.w(TAG, "%s: Progress: set error = %s", this, throwable);
            this.parentReplication.setLastError(throwable);
            this.error = throwable;
            if (Utils.isPermanentError(this.error) || !this.isContinuous()) {
                this.triggerStopGraceful();
            }
            Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this, this.error);
            this.notifyChangeListeners(changeEvent);
        }
    }

    @InterfaceAudience.Private
    protected void addToCompletedChangesCount(int delta) {
        int previousVal = this.getCompletedChangesCount().getAndAdd(delta);
        Log.v(TAG, "%s: Incrementing completedChangesCount count from %s by adding %d -> %d", this, previousVal, delta, this.completedChangesCount.get());
        Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this);
        this.notifyChangeListeners(changeEvent);
    }

    @InterfaceAudience.Private
    protected void addToChangesCount(int delta) {
        int previousVal = this.getChangesCount().getAndAdd(delta);
        if (this.getChangesCount().get() < 0) {
            Log.w(TAG, "Changes count is negative, this could indicate an error");
        }
        Log.v(TAG, "%s: Incrementing changesCount count from %s by adding %d -> %d", this, previousVal, delta, this.changesCount.get());
        Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this);
        this.notifyChangeListeners(changeEvent);
    }

    public AtomicInteger getCompletedChangesCount() {
        if (this.completedChangesCount == null) {
            this.completedChangesCount = new AtomicInteger(0);
        }
        return this.completedChangesCount;
    }

    public AtomicInteger getChangesCount() {
        if (this.changesCount == null) {
            this.changesCount = new AtomicInteger(0);
        }
        return this.changesCount;
    }

    @InterfaceAudience.Private
    public CustomFuture sendAsyncRequest(String method, String relativePath, Map<String, ?> body, RemoteRequestCompletion onCompletion) {
        return this.sendAsyncRequest(method, relativePath, true, body, false, onCompletion);
    }

    @InterfaceAudience.Private
    public CustomFuture sendAsyncRequest(String method, String relativePath, boolean cancelable, Map<String, ?> body, RemoteRequestCompletion onCompletion) {
        return this.sendAsyncRequest(method, relativePath, cancelable, body, false, onCompletion);
    }

    @InterfaceAudience.Private
    public CustomFuture sendAsyncRequest(String method, String relativePath, Map<String, ?> body, boolean dontLog404, RemoteRequestCompletion onCompletion) {
        return this.sendAsyncRequest(method, relativePath, true, body, dontLog404, onCompletion);
    }

    @InterfaceAudience.Private
    public CustomFuture sendAsyncRequest(String method, String relativePath, boolean cancelable, Map<String, ?> body, boolean dontLog404, RemoteRequestCompletion onCompletion) {
        try {
            URL url = new URL(this.buildRelativeURLString(relativePath));
            return this.sendAsyncRequest(method, url, cancelable, body, dontLog404, onCompletion);
        }
        catch (MalformedURLException e) {
            Log.e(TAG, "Malformed URL for async request", e);
            return null;
        }
    }

    @InterfaceAudience.Private
    public CustomFuture sendAsyncRequest(String method, URL url, boolean cancelable, Map<String, ?> body, boolean dontLog404, RemoteRequestCompletion onCompletion) {
        Log.d(TAG, "[sendAsyncRequest()] " + method + " => " + url);
        RemoteRequestRetry request = new RemoteRequestRetry(RemoteRequestRetry.RemoteRequestType.REMOTE_REQUEST, this.remoteRequestExecutor, this.executor, this.clientFactory, method, url, this.serverIsSyncGateway(), cancelable, body, null, this.getLocalDatabase(), this.getHeaders(), onCompletion);
        request.setDontLog404(dontLog404);
        request.setAuthenticator(this.getAuthenticator());
        request.setOnPreCompletionCaller(new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response response, Object result, Throwable e) {
                String serverVersion;
                if (ReplicationInternal.this.serverType == null && response != null && (serverVersion = response.header("Server")) != null) {
                    Log.v(ReplicationInternal.TAG, "serverVersion: %s", serverVersion);
                    ReplicationInternal.this.serverType = serverVersion;
                }
            }
        });
        return request.submit(this.canSendCompressedRequests());
    }

    @InterfaceAudience.Private
    public CustomFuture sendAsyncMultipartRequest(String method, String relativePath, Map<String, Object> body, Map<String, Object> attachments, RemoteRequestCompletion onCompletion) {
        URL url;
        try {
            url = new URL(this.buildRelativeURLString(relativePath));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        RemoteRequestRetry request = new RemoteRequestRetry(RemoteRequestRetry.RemoteRequestType.REMOTE_MULTIPART_REQUEST, this.remoteRequestExecutor, this.executor, this.clientFactory, method, url, this.serverIsSyncGateway(), true, body, attachments, this.getLocalDatabase(), this.getHeaders(), onCompletion);
        request.setAuthenticator(this.getAuthenticator());
        return request.submit();
    }

    @InterfaceAudience.Private
    public CustomFuture sendAsyncMultipartDownloaderRequest(String method, String relativePath, Map<String, Object> body, Database db, RemoteRequestCompletion onCompletion) {
        try {
            String urlStr = this.buildRelativeURLString(relativePath);
            URL url = new URL(urlStr);
            RemoteRequestRetry request = new RemoteRequestRetry(RemoteRequestRetry.RemoteRequestType.REMOTE_MULTIPART_DOWNLOADER_REQUEST, this.remoteRequestExecutor, this.executor, this.clientFactory, method, url, this.serverIsSyncGateway(), true, body, null, this.getLocalDatabase(), this.getHeaders(), onCompletion);
            request.setAuthenticator(this.getAuthenticator());
            return request.submit();
        }
        catch (MalformedURLException e) {
            Log.e(TAG, "Malformed URL for async request", e);
            return null;
        }
    }

    protected Database getLocalDatabase() {
        return this.db;
    }

    @InterfaceAudience.Public
    public Map<String, Object> getHeaders() {
        return this.requestHeaders;
    }

    @InterfaceAudience.Public
    public void setHeaders(Map<String, Object> requestHeadersParam) {
        if (requestHeadersParam != null && !this.requestHeaders.equals(requestHeadersParam)) {
            this.requestHeaders = requestHeadersParam;
        }
    }

    @InterfaceAudience.Private
    public void saveLastSequence() {
        if (!this.lastSequenceChanged) {
            return;
        }
        if (this.savingCheckpoint) {
            this.overdueForCheckpointSave = true;
            return;
        }
        this.lastSequenceChanged = false;
        this.overdueForCheckpointSave = false;
        Log.d(TAG, "%s: saveLastSequence() called. lastSequence: %s remoteCheckpoint: %s", this, this.lastSequence, this.remoteCheckpoint);
        final HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.remoteCheckpoint != null) {
            body.putAll(this.remoteCheckpoint);
        }
        body.put("lastSequence", this.lastSequence);
        this.savingCheckpoint = true;
        String remoteCheckpointDocID = this.remoteCheckpointDocID();
        if (remoteCheckpointDocID == null) {
            Log.w(TAG, "%s: remoteCheckpointDocID is null, aborting saveLastSequence()", this);
            return;
        }
        final String checkpointID = remoteCheckpointDocID;
        Log.d(TAG, "%s: start put remote _local document.  checkpointID: %s body: %s", this, checkpointID, body);
        CustomFuture future = this.sendAsyncRequest("PUT", "_local/" + checkpointID, false, body, new RemoteRequestCompletion(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                block13: {
                    Log.d(ReplicationInternal.TAG, "%s: put remote _local document request finished.  checkpointID: %s body: %s", this, checkpointID, body);
                    try {
                        if (e != null) {
                            switch (Utils.getStatusFromError(e)) {
                                case 404: {
                                    Log.i(ReplicationInternal.TAG, "%s: could not save remote checkpoint: 404 NOT FOUND", this);
                                    ReplicationInternal.this.remoteCheckpoint = null;
                                    ReplicationInternal.this.overdueForCheckpointSave = true;
                                    break;
                                }
                                case 409: {
                                    Log.i(ReplicationInternal.TAG, "%s: could not save remote checkpoint: 409 CONFLICT", this);
                                    ReplicationInternal.this.refreshRemoteCheckpointDoc();
                                    break;
                                }
                                default: {
                                    Log.i(ReplicationInternal.TAG, "%s: could not save remote checkpoint: %s", this, e);
                                    break;
                                }
                            }
                            break block13;
                        }
                        Map response = (Map)result;
                        body.put("_rev", response.get("rev"));
                        ReplicationInternal.this.remoteCheckpoint = body;
                        boolean isOpen = false;
                        try {
                            if (ReplicationInternal.this.db != null) {
                                ReplicationInternal.this.db.open();
                                isOpen = true;
                            }
                        }
                        catch (CouchbaseLiteException ex) {
                            Log.w(ReplicationInternal.TAG, "%s: Cannot open the database", ex, this);
                        }
                        if (isOpen) {
                            Log.d(ReplicationInternal.TAG, "%s: saved remote checkpoint, updating local checkpoint. RemoteCheckpoint: %s", this, ReplicationInternal.this.remoteCheckpoint);
                            ReplicationInternal.this.setLastSequenceFromWorkExecutor(ReplicationInternal.this.lastSequence, checkpointID);
                            break block13;
                        }
                        Log.w(ReplicationInternal.TAG, "%s: Database is null or closed, not calling db.setLastSequence() ", this);
                    }
                    catch (Throwable throwable) {
                        ReplicationInternal.this.savingCheckpoint = false;
                        if (ReplicationInternal.this.overdueForCheckpointSave) {
                            Log.i(ReplicationInternal.TAG, "%s: overdueForCheckpointSave == true, calling saveLastSequence()", this);
                            ReplicationInternal.this.overdueForCheckpointSave = false;
                            ReplicationInternal.this.saveLastSequence();
                        }
                        throw throwable;
                    }
                }
                ReplicationInternal.this.savingCheckpoint = false;
                if (ReplicationInternal.this.overdueForCheckpointSave) {
                    Log.i(ReplicationInternal.TAG, "%s: overdueForCheckpointSave == true, calling saveLastSequence()", this);
                    ReplicationInternal.this.overdueForCheckpointSave = false;
                    ReplicationInternal.this.saveLastSequence();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    protected void setLastSequenceFromWorkExecutor(final String lastSequence, final String checkpointId) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (ReplicationInternal.this.db != null && ReplicationInternal.this.db.isOpen()) {
                    ReplicationInternal.this.db.setLastSequence(lastSequence, checkpointId);
                }
            }
        });
    }

    @InterfaceAudience.Private
    private void refreshRemoteCheckpointDoc() {
        Log.i(TAG, "%s: Refreshing remote checkpoint to get its _rev...", this);
        CustomFuture future = this.sendAsyncRequest("GET", "_local/" + this.remoteCheckpointDocID(), null, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                if (ReplicationInternal.this.db == null) {
                    Log.w(ReplicationInternal.TAG, "%s: db == null while refreshing remote checkpoint.  aborting", this);
                    return;
                }
                if (e != null && Utils.getStatusFromError(e) != 404) {
                    Log.e(ReplicationInternal.TAG, "%s: Error refreshing remote checkpoint", e, this);
                } else {
                    Log.d(ReplicationInternal.TAG, "%s: Refreshed remote checkpoint: %s", this, result);
                    ReplicationInternal.this.remoteCheckpoint = (Map)result;
                    ReplicationInternal.this.lastSequenceChanged = true;
                    ReplicationInternal.this.saveLastSequence();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    protected String buildRelativeURLString(String relativePath) {
        if (relativePath.startsWith("/")) {
            try {
                return new URL(this.remote.getProtocol(), this.remote.getHost(), this.remote.getPort(), relativePath).toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        String remoteUrlString = this.remote.toExternalForm();
        if (remoteUrlString.endsWith("/")) {
            return remoteUrlString + relativePath;
        }
        return remoteUrlString + "/" + relativePath;
    }

    @InterfaceAudience.Private
    public void fetchRemoteCheckpointDoc() {
        this.lastSequenceChanged = false;
        String checkpointId = this.remoteCheckpointDocID();
        final String localLastSequence = this.db.lastSequenceWithCheckpointId(checkpointId);
        boolean dontLog404 = true;
        CustomFuture future = this.sendAsyncRequest("GET", "_local/" + checkpointId, null, dontLog404, new RemoteRequestCompletion(){

            @Override
            public void onCompletion(Response httpResponse, Object result, Throwable e) {
                if (e != null && !Utils.is404(e)) {
                    Log.w(ReplicationInternal.TAG, "%s: error getting remote checkpoint", e, this);
                    ReplicationInternal.this.setError(e);
                } else {
                    Map response;
                    if (e != null && Utils.is404(e)) {
                        Log.v(ReplicationInternal.TAG, "%s: Remote checkpoint does not exist on server yet: %s", this, ReplicationInternal.this.remoteCheckpointDocID());
                        ReplicationInternal.this.maybeCreateRemoteDB();
                    }
                    ReplicationInternal.this.remoteCheckpoint = response = (Map)result;
                    String remoteLastSequence = null;
                    if (response != null) {
                        remoteLastSequence = (String)response.get("lastSequence");
                    }
                    if (remoteLastSequence != null && remoteLastSequence.equals(localLastSequence)) {
                        ReplicationInternal.this.lastSequence = localLastSequence;
                        Log.d(ReplicationInternal.TAG, "%s: Replicating from lastSequence=%s", this, ReplicationInternal.this.lastSequence);
                    } else {
                        Log.d(ReplicationInternal.TAG, "%s: lastSequence mismatch: I had: %s, remote had: %s", this, localLastSequence, remoteLastSequence);
                    }
                    ReplicationInternal.this.beginReplicating();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    protected abstract void maybeCreateRemoteDB();

    public String remoteCheckpointDocID() {
        if (this.remoteCheckpointDocID != null) {
            return this.remoteCheckpointDocID;
        }
        if (this.db == null || !this.db.isOpen()) {
            return null;
        }
        return this.remoteCheckpointDocID(this.db.privateUUID());
    }

    public String remoteCheckpointDocID(String localUUID) {
        TreeMap<String, Object> filterParamsCanonical = null;
        if (this.getFilterParams() != null) {
            filterParamsCanonical = new TreeMap<String, Object>(this.getFilterParams());
        }
        ArrayList<String> docIdsSorted = null;
        if (this.getDocIds() != null) {
            docIdsSorted = new ArrayList<String>(this.getDocIds());
            Collections.sort(docIdsSorted);
        }
        TreeMap<String, Object> spec = new TreeMap<String, Object>();
        spec.put("localUUID", localUUID);
        spec.put("push", !this.isPull());
        spec.put("continuous", this.isContinuous());
        if (this.getFilter() != null) {
            spec.put("filter", this.getFilter());
        }
        if (filterParamsCanonical != null) {
            spec.put("filterParams", filterParamsCanonical);
        }
        if (docIdsSorted != null) {
            spec.put("docids", docIdsSorted);
        }
        if (this.remoteUUID != null) {
            spec.put("remoteUUID", this.remoteUUID);
        } else {
            spec.put("remoteURL", this.remote.toExternalForm());
        }
        byte[] inputBytes = null;
        try {
            this.db.getManager();
            inputBytes = Manager.getObjectMapper().writeValueAsBytes(spec);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remoteCheckpointDocID = Misc.HexSHA1Digest(inputBytes);
        return this.remoteCheckpointDocID;
    }

    public String getFilter() {
        return this.filterName;
    }

    public void setFilter(String filterName) {
        this.filterName = filterName;
    }

    public ReplicationFilter compilePushReplicationFilter() {
        if (this.isPull()) {
            return null;
        }
        if (this.filterName != null) {
            return this.db.getFilter(this.filterName);
        }
        if (this.documentIDs != null && this.documentIDs.size() > 0) {
            final List<String> docIDs = this.documentIDs;
            return new ReplicationFilter(){

                @Override
                public boolean filter(SavedRevision revision, Map<String, Object> params) {
                    return docIDs.contains(revision.getDocument().getId());
                }
            };
        }
        return null;
    }

    public abstract boolean isPull();

    public List<String> getDocIds() {
        return this.documentIDs;
    }

    public void setDocIds(List<String> docIds) {
        this.documentIDs = docIds;
    }

    public boolean isContinuous() {
        return this.lifecycle == Replication.Lifecycle.CONTINUOUS;
    }

    public Map<String, Object> getFilterParams() {
        return this.filterParams;
    }

    public void setFilterParams(Map<String, Object> filterParams) {
        this.filterParams = filterParams;
    }

    public String getRemoteUUID() {
        return this.remoteUUID;
    }

    public void setRemoteUUID(String remoteUUID) {
        this.remoteUUID = remoteUUID;
    }

    protected abstract void processInbox(RevisionList var1);

    public boolean canSendCompressedRequests() {
        return this.serverIsSyncGatewayVersion("0.92");
    }

    protected abstract void beginReplicating();

    protected void stop() {
        this.authenticating = false;
        this.batcher.clear();
        this.setLifecycle(Replication.Lifecycle.ONESHOT);
        this.cancelRetryFuture();
        while (!this.pendingFutures.isEmpty()) {
            Future future = (Future)this.pendingFutures.poll();
            if (future == null || future.isCancelled() || future.isDone()) continue;
            future.cancel(true);
            CancellableRunnable runnable = this.runnables.get(future);
            if (runnable == null) continue;
            runnable.cancel();
            this.runnables.remove(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChangeListeners(final Replication.ChangeEvent changeEvent) {
        if (this.changeListenerNotifyStyle == ChangeListenerNotifyStyle.SYNC) {
            for (ChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.changed(changeEvent);
                }
                catch (Exception e) {
                    Log.e(TAG, "Unknown Error in changeListener.changed(changeEvent)", e);
                }
            }
        } else {
            ScheduledExecutorService scheduledExecutorService = this.executor;
            synchronized (scheduledExecutorService) {
                if (!this.executor.isShutdown()) {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                for (ChangeListener changeListener : ReplicationInternal.this.changeListeners) {
                                    changeListener.changed(changeEvent);
                                }
                            }
                            catch (Exception e) {
                                Log.e(ReplicationInternal.TAG, "Exception notifying replication listener: %s", e, this);
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            }
        }
    }

    void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    protected void initializeStateMachine() {
        this.stateMachine = new StateMachine((Object)ReplicationState.INITIAL);
        this.stateMachine.configure((Object)ReplicationState.IDLE).substateOf((Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).substateOf((Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.INITIAL).permit((Object)ReplicationTrigger.START, (Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.IDLE).permit((Object)ReplicationTrigger.RESUME, (Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.WAITING_FOR_CHANGES, (Object)ReplicationState.IDLE);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.STOP_IMMEDIATE, (Object)ReplicationState.STOPPED);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.STOP_GRACEFUL, (Object)ReplicationState.STOPPING);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.GO_OFFLINE, (Object)ReplicationState.OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).permit((Object)ReplicationTrigger.GO_ONLINE, (Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).permit((Object)ReplicationTrigger.STOP_IMMEDIATE, (Object)ReplicationState.STOPPED);
        this.stateMachine.configure((Object)ReplicationState.INITIAL).ignore((Object)ReplicationTrigger.RESUME);
        this.stateMachine.configure((Object)ReplicationState.INITIAL).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.INITIAL).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).ignore((Object)ReplicationTrigger.START);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).ignore((Object)ReplicationTrigger.RESUME);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.IDLE).ignore((Object)ReplicationTrigger.START);
        this.stateMachine.configure((Object)ReplicationState.IDLE).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).ignore((Object)ReplicationTrigger.START);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).ignore((Object)ReplicationTrigger.RESUME);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).ignore((Object)ReplicationTrigger.WAITING_FOR_CHANGES);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.START);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.RESUME);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.WAITING_FOR_CHANGES);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.STOP_GRACEFUL);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.START);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.RESUME);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.WAITING_FOR_CHANGES);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.STOP_GRACEFUL);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.STOP_IMMEDIATE);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onEntry()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
                ReplicationInternal.this.start();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.RUNNING).onExit((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onExit()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
            }
        });
        this.stateMachine.configure((Object)ReplicationState.IDLE).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onEntry()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
                ReplicationInternal.this.retryReplicationIfError();
                if (transition.getSource() == transition.getDestination()) {
                    return;
                }
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
                if (Utils.isPermanentError(ReplicationInternal.this.error) && ReplicationInternal.this.isContinuous()) {
                    Log.d(ReplicationInternal.TAG, "IDLE: triggerStopGraceful() " + ReplicationInternal.this.error.toString());
                    ReplicationInternal.this.triggerStopGraceful();
                }
            }
        });
        this.stateMachine.configure((Object)ReplicationState.IDLE).onExit((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onExit()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
                if (transition.getSource() == transition.getDestination()) {
                    return;
                }
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onEntry()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
                ReplicationInternal.this.goOffline();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).onExit((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onExit()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
                ReplicationInternal.this.goOnline();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.STOPPING).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onEntry()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
                if (transition.getSource() == transition.getDestination()) {
                    return;
                }
                ReplicationInternal.this.stop();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.STOPPED).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.v(ReplicationInternal.TAG, "%s [onEntry()] " + transition.getSource() + " => " + transition.getDestination(), ReplicationInternal.this.toString());
                if (transition.getSource() == transition.getDestination()) {
                    return;
                }
                ReplicationInternal.this.saveLastSequence();
                if (ReplicationInternal.this.isContinuous()) {
                    ReplicationInternal.this.stopNetworkReachabilityManager();
                }
                ReplicationInternal.this.close();
                ReplicationInternal.this.clearDbRef();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
    }

    private void logTransition(Transition<ReplicationState, ReplicationTrigger> transition) {
        Log.d(TAG, "State transition: %s -> %s (via %s).  this: %s", transition.getSource(), transition.getDestination(), transition.getTrigger(), this);
    }

    private void notifyChangeListenersStateTransition(Transition<ReplicationState, ReplicationTrigger> transition) {
        this.logTransition(transition);
        ReplicationStateTransition replStateTrans = new ReplicationStateTransition(transition);
        if ((TRANS_RUNNING_TO_IDLE.equals(replStateTrans) || TRANS_IDLE_TO_RUNNING.equals(replStateTrans)) && this.authenticating) {
            Log.i(TAG, "During middle of authentication, not notify Replicator state change");
            return;
        }
        Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this, replStateTrans);
        this.notifyChangeListeners(changeEvent);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @InterfaceAudience.Private
    protected boolean serverIsSyncGatewayVersion(String minVersion) {
        return ReplicationInternal.serverIsSyncGatewayVersion(this.serverType, minVersion);
    }

    @InterfaceAudience.Private
    protected boolean serverIsSyncGateway() {
        return this.serverType != null && this.serverType.startsWith(SYNC_GATEWAY_PREFIX);
    }

    @InterfaceAudience.Private
    protected static boolean serverIsSyncGatewayVersion(String serverName, String minVersion) {
        if (serverName == null) {
            return false;
        }
        if (serverName.startsWith(SYNC_GATEWAY_PREFIX)) {
            String versionString = serverName.substring(SYNC_GATEWAY_PREFIX.length());
            return versionString.compareTo(minVersion) >= 0;
        }
        return false;
    }

    @InterfaceAudience.Private
    public void addToInbox(RevisionInternal rev) {
        Log.v(TAG, "%s: addToInbox() called, rev: %s.  Thread: %s", this, rev, Thread.currentThread());
        this.batcher.queueObject(rev);
    }

    protected void retry() {
        Log.v(TAG, "[retry()]");
        this.error = null;
        this.checkSession();
    }

    protected void retryIfReady() {
        Log.v(TAG, "[retryIfReady()] stateMachine => " + ((ReplicationState)((Object)this.stateMachine.getState())).toString());
        if (((ReplicationState)((Object)this.stateMachine.getState())).equals((Object)ReplicationState.IDLE)) {
            Log.v(TAG, "%s RETRYING, to transfer missed revisions...", this);
            this.cancelRetryFuture();
            this.retry();
        }
    }

    private void scheduleRetryFuture() {
        Log.v(TAG, "%s: Failed to xfer; will retry in %d sec", this, RETRY_DELAY_SECONDS);
        this.retryFuture = this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                ReplicationInternal.this.retryIfReady();
            }
        }, (long)RETRY_DELAY_SECONDS, TimeUnit.SECONDS);
    }

    private void cancelRetryFuture() {
        if (this.retryFuture != null && !this.retryFuture.isDone()) {
            this.retryFuture.cancel(true);
        }
        this.retryFuture = null;
    }

    protected abstract void onBeforeScheduleRetry();

    protected void retryReplicationIfError() {
        Log.d(TAG, "retryReplicationIfError() state=" + this.stateMachine.getState() + ", error=" + this.error + ", isContinuous()=" + this.isContinuous() + ", isTransientError()=" + Utils.isTransientError(this.error));
        if (!((ReplicationState)((Object)this.stateMachine.getState())).equals((Object)ReplicationState.IDLE)) {
            return;
        }
        if (this.error != null && this.isContinuous() && Utils.isTransientError(this.error)) {
            this.onBeforeScheduleRetry();
            this.cancelRetryFuture();
            this.scheduleRetryFuture();
        }
    }

    @InterfaceAudience.Private
    protected void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public Replication.Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Replication.Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    @InterfaceAudience.Private
    public void setLastSequence(String lastSequenceIn) {
        if (lastSequenceIn != null && !lastSequenceIn.equals(this.lastSequence)) {
            Log.v(TAG, "%s: Setting lastSequence to %s from(%s)", this, lastSequenceIn, this.lastSequence);
            this.lastSequence = lastSequenceIn;
            if (!this.lastSequenceChanged) {
                this.lastSequenceChanged = true;
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ReplicationInternal.this.saveLastSequence();
                    }
                }, (long)SAVE_LAST_SEQUENCE_DELAY, TimeUnit.SECONDS);
            }
        }
    }

    protected RevisionInternal transformRevision(RevisionInternal rev) {
        if (this.revisionBodyTransformationBlock != null) {
            try {
                final int generation = rev.getGeneration();
                RevisionInternal xformed = this.revisionBodyTransformationBlock.invoke(rev);
                if (xformed == null) {
                    return null;
                }
                if (xformed != rev) {
                    Map<String, Object> xformedProps = xformed.getProperties();
                    assert (xformed.getDocID().equals(rev.getDocID()));
                    assert (xformed.getRevID().equals(rev.getRevID()));
                    assert (xformedProps.get("_revisions").equals(rev.getProperties().get("_revisions")));
                    if (xformedProps.get("_attachments") != null) {
                        RevisionInternal mx;
                        xformed = mx = new RevisionInternal(xformedProps);
                        mx.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

                            @Override
                            public Map<String, Object> invoke(Map<String, Object> info) {
                                if (info.get("revpos") != null) {
                                    return info;
                                }
                                if (info.get("data") == null) {
                                    throw new IllegalStateException("Transformer added attachment without adding data");
                                }
                                HashMap<String, Object> nuInfo = new HashMap<String, Object>(info);
                                nuInfo.put("revpos", generation);
                                return nuInfo;
                            }
                        });
                    }
                    rev = xformed;
                }
            }
            catch (Exception e) {
                Log.w(TAG, "%s: Exception transforming a revision of doc '%s", e, this, rev.getDocID());
            }
        }
        return rev;
    }

    @InterfaceAudience.Private
    protected static Status statusFromBulkDocsResponseItem(Map<String, Object> item) {
        try {
            int status;
            if (!item.containsKey("error")) {
                return new Status(200);
            }
            String errorStr = (String)item.get("error");
            if (errorStr == null || errorStr.isEmpty()) {
                return new Status(200);
            }
            Object objStatus = item.get("status");
            if (objStatus instanceof Integer && (status = ((Integer)objStatus).intValue()) >= 400) {
                return new Status(status);
            }
            if ("unauthorized".equalsIgnoreCase(errorStr)) {
                return new Status(401);
            }
            if ("forbidden".equalsIgnoreCase(errorStr)) {
                return new Status(403);
            }
            if ("conflict".equalsIgnoreCase(errorStr)) {
                return new Status(409);
            }
            if ("missing".equalsIgnoreCase(errorStr)) {
                return new Status(404);
            }
            if ("not_found".equalsIgnoreCase(errorStr)) {
                return new Status(404);
            }
            return new Status(589);
        }
        catch (Exception e) {
            Log.e("Database", "Exception getting status from " + item, e);
            return new Status(200);
        }
    }

    private void clearDbRef() {
        try {
            Log.v(TAG, "%s: clearDbRef() called", this);
            if (!this.db.isOpen()) {
                Log.w(TAG, "Not attempting to setLastSequence, db is closed");
            } else {
                this.db.setLastSequence(this.lastSequence, this.remoteCheckpointDocID());
            }
            Log.v(TAG, "%s: clearDbRef() setting db to null", this);
            this.db = null;
        }
        catch (Exception e) {
            Log.e(TAG, "Exception in clearDbRef(): %s", e);
        }
    }

    public void setCookie(String name, String value, String path, long maxAge, boolean secure, boolean httpOnly) {
        Date now = new Date();
        Date expirationDate = new Date(now.getTime() + maxAge);
        this.setCookie(name, value, path, expirationDate, secure, httpOnly);
    }

    public void setCookie(String name, String value, String path, Date expirationDate, boolean secure, boolean httpOnly) {
        if (this.remote == null) {
            throw new IllegalStateException("Cannot setCookie since remote == null");
        }
        if (path == null || path.length() == 0) {
            path = this.remote.getPath();
        }
        Cookie.Builder builder = new Cookie.Builder();
        builder.name(name).value(value).domain(this.remote.getHost()).path(path);
        if (expirationDate != null) {
            builder.expiresAt(expirationDate.getTime());
        }
        List<Cookie> cookies = Collections.singletonList(builder.build());
        this.clientFactory.addCookies(cookies);
    }

    public void deleteCookie(String name) {
        this.clientFactory.deleteCookie(name);
    }

    void deleteCookie(URL url) {
        this.clientFactory.deleteCookie(url);
    }

    void resetCookieStore() {
        this.clientFactory.resetCookieStore();
    }

    protected HttpClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public List<String> getChannels() {
        if (this.filterParams == null || this.filterParams.isEmpty()) {
            return new ArrayList<String>();
        }
        String params = (String)this.filterParams.get(CHANNELS_QUERY_PARAM);
        if (!this.isPull() || this.getFilter() == null || !BY_CHANNEL_FILTER_NAME.equals(this.getFilter()) || params == null || params.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] paramsArray = params.split(",");
        return new ArrayList<String>(Arrays.asList(paramsArray));
    }

    public void setChannels(List<String> channels) {
        if (channels != null && !channels.isEmpty()) {
            if (!this.isPull()) {
                Log.w(TAG, "filterChannels can only be set in pull replications");
                return;
            }
            this.setFilter(BY_CHANNEL_FILTER_NAME);
            HashMap<String, Object> filterParams = new HashMap<String, Object>();
            filterParams.put(CHANNELS_QUERY_PARAM, TextUtils.join(",", channels));
            this.setFilterParams(filterParams);
        } else if (BY_CHANNEL_FILTER_NAME.equals(this.getFilter())) {
            this.setFilter(null);
            this.setFilterParams(null);
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void changed(BlockingQueueListener.EventType type, Object o, BlockingQueue queue) {
        if (!(type != BlockingQueueListener.EventType.PUT && type != BlockingQueueListener.EventType.ADD || queue.isEmpty())) {
            if (this.isContinuous()) {
                this.fireTrigger(ReplicationTrigger.RESUME);
            }
            String threadName = String.format(Locale.ENGLISH, "Thread-waitForPendingFutures[%s]", this.toString());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ReplicationInternal.this.waitForPendingFutures();
                }
            }, threadName).start();
        }
    }

    protected static String encodeDocumentId(String docId) {
        if (docId.startsWith("_design/")) {
            String designDocId = docId.substring("_design/".length());
            return "_design/".concat(URIUtils.encode(designDocId));
        }
        return URIUtils.encode(docId);
    }

    protected boolean isRunning() {
        return this.stateMachine.isInState((Object)ReplicationState.RUNNING) || this.stateMachine.isInState((Object)ReplicationState.IDLE) || this.stateMachine.isInState((Object)ReplicationState.OFFLINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForPendingFutures() {
        Object object = this.lockWaitForPendingFutures;
        synchronized (object) {
            if (this.waitingForPendingFutures) {
                return;
            }
            this.waitingForPendingFutures = true;
        }
        Log.v(TAG, "[waitForPendingFutures()] STARTED - thread id: " + Thread.currentThread().getId());
        try {
            this.waitForAllTasksCompleted();
        }
        catch (Exception e) {
            Log.e(TAG, "Exception waiting for pending futures: %s", e);
        }
        if (this.isContinuous()) {
            this.fireTrigger(ReplicationTrigger.WAITING_FOR_CHANGES);
        } else {
            this.triggerStopGraceful();
        }
        Log.v(TAG, "[waitForPendingFutures()] END - thread id: " + Thread.currentThread().getId());
        object = this.lockWaitForPendingFutures;
        synchronized (object) {
            this.waitingForPendingFutures = false;
        }
    }

    protected void waitForAllTasksCompleted() {
        while (this.batcher != null && !this.batcher.isEmpty() || this.pendingFutures != null && this.pendingFutures.size() > 0) {
            this.waitBatcherCompleted();
            this.waitPendingFuturesCompleted();
        }
    }

    protected void waitBatcherCompleted() {
        ReplicationInternal.waitBatcherCompleted(this.batcher);
    }

    protected static void waitBatcherCompleted(Batcher<RevisionInternal> b) {
        if (b != null) {
            try {
                Thread.sleep(b.getDelay());
            }
            catch (Exception exception) {
                // empty catch block
            }
            b.waitForPendingFutures();
        }
    }

    protected void waitPendingFuturesCompleted() {
        try {
            while (!this.pendingFutures.isEmpty()) {
                Future future = this.pendingFutures.take();
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "InterruptedException in Future.get()", e);
                }
                catch (ExecutionException e) {
                    Log.e(TAG, "ExecutionException in Future.get()", e);
                }
                finally {
                    this.runnables.remove(future);
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Exception waiting for pending futures: %s", e);
        }
    }

    String getUsername() {
        return this.username;
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(Replication.ChangeEvent var1);
    }

    protected static enum ChangeListenerNotifyStyle {
        SYNC,
        ASYNC;

    }
}

