/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.router;

public class ByteBuffer {
    private static final int CHUNK_SIZE = 2048;
    private byte[] buffer = new byte[2048];
    private int readIndex = 0;
    private int writeIndex = 0;

    public void push(byte data) {
        if (this.writeIndex == this.buffer.length) {
            this.resize();
        }
        this.buffer[this.writeIndex++] = data;
    }

    public void push(byte[] data) {
        this.push(data, 0, data.length);
    }

    public void push(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset can not be negative");
        }
        for (int i = 0; i < length; ++i) {
            this.push(data[offset + i]);
        }
    }

    public Byte pop() {
        if (!this.isEmpty()) {
            return this.buffer[this.readIndex++];
        }
        return null;
    }

    public int pop(byte[] array) {
        return this.pop(array, 0, array.length);
    }

    public int pop(byte[] array, int offset, int length) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset can not be negative");
        }
        int count = 0;
        while (count < length && !this.isEmpty()) {
            array[offset + count++] = this.buffer[this.readIndex++];
        }
        return count;
    }

    public boolean isEmpty() {
        return this.readIndex >= this.writeIndex;
    }

    private void resize() {
        byte[] temp = this.buffer;
        int count = 0;
        if (this.readIndex < 1024) {
            this.buffer = new byte[temp.length + 2048];
        }
        count = 0;
        while (this.readIndex + count < this.writeIndex) {
            this.buffer[count] = temp[this.readIndex + count];
            ++count;
        }
        this.readIndex = 0;
        this.writeIndex = count;
    }
}

