/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.router;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.BlobStoreWriter;
import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.Misc;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.Reducer;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.Revision;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.TransactionalTask;
import com.couchbase.lite.View;
import com.couchbase.lite.auth.FacebookAuthorizer;
import com.couchbase.lite.auth.PersonaAuthorizer;
import com.couchbase.lite.internal.AttachmentInternal;
import com.couchbase.lite.internal.Body;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.RemoteRequestResponseException;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.router.Header;
import com.couchbase.lite.router.RouterCallbackBlock;
import com.couchbase.lite.router.URLConnection;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.store.Store;
import com.couchbase.lite.support.RevisionUtils;
import com.couchbase.lite.support.Version;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.StreamUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Router
implements Database.ChangeListener,
Database.DatabaseListener {
    public static final String TAG = "Router";
    private static final long MIN_HEARTBEAT = 5000L;
    private static final String CONTENT_TYPE_JSON = "application/json";
    private Manager manager;
    private Database db;
    private URLConnection connection;
    private Map<String, String> queries;
    private boolean changesIncludesDocs = false;
    private boolean changesIncludesConflicts = false;
    private RouterCallbackBlock callbackBlock;
    private boolean responseSent = false;
    private ReplicationFilter changesFilter;
    Map<String, Object> changesFilterParams = null;
    private boolean longpoll = false;
    private boolean waiting = false;
    private URL source = null;
    private Timer timer = null;
    private boolean dontOverwriteBody = false;
    private final Object databaseChangesLongpollLock = new Object();

    public static String getVersionString() {
        return Version.getVersion();
    }

    public Router(Manager manager, URLConnection connection) {
        this.manager = manager;
        this.connection = connection;
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public void setCallbackBlock(RouterCallbackBlock callbackBlock) {
        this.callbackBlock = callbackBlock;
    }

    private Map<String, String> getQueries() {
        String queryString;
        if (this.queries == null && (queryString = this.connection.getURL().getQuery()) != null && queryString.length() > 0) {
            this.queries = new HashMap<String, String>();
            for (String component : queryString.split("&")) {
                int location = component.indexOf(61);
                if (location <= 0) continue;
                String key = component.substring(0, location);
                String value = component.substring(location + 1);
                this.queries.put(key, value);
            }
        }
        return this.queries;
    }

    private static boolean getBooleanValueFromBody(String paramName, Map<String, Object> bodyDict, boolean defaultVal) {
        boolean value = defaultVal;
        if (bodyDict.containsKey(paramName)) {
            value = Boolean.TRUE.equals(bodyDict.get(paramName));
        }
        return value;
    }

    private String getQuery(String param) {
        String value;
        Map<String, String> queries = this.getQueries();
        if (queries != null && (value = queries.get(param)) != null) {
            return URLDecoder.decode(value);
        }
        return null;
    }

    private boolean getBooleanQuery(String param) {
        String value = this.getQuery(param);
        return value != null && !"false".equals(value) && !"0".equals(value);
    }

    private int getIntQuery(String param, int defaultValue) {
        int result = defaultValue;
        String value = this.getQuery(param);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private List parseJSONRevArrayQuery(String param) {
        Object obj = this.getJSONQuery(param);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    private Object getJSONQuery(String param) {
        String value = this.getQuery(param);
        if (value == null) {
            return null;
        }
        Object result = null;
        try {
            result = Manager.getObjectMapper().readValue(value, Object.class);
        }
        catch (Exception e) {
            Log.w("Unable to parse JSON Query", e);
        }
        return result;
    }

    private boolean cacheWithEtag(String etag) {
        String eTag = String.format(Locale.ENGLISH, "\"%s\"", etag);
        this.connection.getResHeader().add("Etag", eTag);
        String requestIfNoneMatch = this.connection.getRequestProperty("If-None-Match");
        return eTag.equals(requestIfNoneMatch);
    }

    private Map<String, Object> getBodyAsDictionary() throws CouchbaseLiteException {
        String contentType = this.getRequestHeaderContentType();
        if (contentType != null && !contentType.equals(CONTENT_TYPE_JSON)) {
            throw new CouchbaseLiteException(406);
        }
        InputStream contentStream = this.connection.getRequestInputStream();
        try {
            return (Map)Manager.getObjectMapper().readValue(contentStream, Map.class);
        }
        catch (JsonParseException jpe) {
            throw new CouchbaseLiteException(493);
        }
        catch (JsonMappingException jme) {
            throw new CouchbaseLiteException(493);
        }
        catch (IOException ioe) {
            throw new CouchbaseLiteException(408);
        }
    }

    private EnumSet<TDContentOptions> getContentOptions() {
        EnumSet<TDContentOptions> result = EnumSet.noneOf(TDContentOptions.class);
        if (this.getBooleanQuery("attachments")) {
            result.add(TDContentOptions.TDIncludeAttachments);
        }
        if (this.getBooleanQuery("local_seq")) {
            result.add(TDContentOptions.TDIncludeLocalSeq);
        }
        if (this.getBooleanQuery("conflicts")) {
            result.add(TDContentOptions.TDIncludeConflicts);
        }
        if (this.getBooleanQuery("revs")) {
            result.add(TDContentOptions.TDIncludeRevs);
        }
        if (this.getBooleanQuery("revs_info")) {
            result.add(TDContentOptions.TDIncludeRevsInfo);
        }
        return result;
    }

    private boolean getQueryOptions(QueryOptions options) {
        Object key;
        options.setSkip(this.getIntQuery("skip", options.getSkip()));
        options.setLimit(this.getIntQuery("limit", options.getLimit()));
        options.setGroupLevel(this.getIntQuery("group_level", options.getGroupLevel()));
        options.setDescending(this.getBooleanQuery("descending"));
        options.setIncludeDocs(this.getBooleanQuery("include_docs"));
        if (this.getQuery("include_deleted") != null) {
            options.setAllDocsMode(Query.AllDocsMode.INCLUDE_DELETED);
        } else if (this.getQuery("include_conflicts") != null) {
            options.setAllDocsMode(Query.AllDocsMode.SHOW_CONFLICTS);
        } else if (this.getQuery("only_conflicts") != null) {
            options.setAllDocsMode(Query.AllDocsMode.ONLY_CONFLICTS);
        }
        options.setUpdateSeq(this.getBooleanQuery("update_seq"));
        if (this.getQuery("inclusive_end") != null) {
            options.setInclusiveEnd(this.getBooleanQuery("inclusive_end"));
        }
        if (this.getQuery("inclusive_start") != null) {
            options.setInclusiveEnd(this.getBooleanQuery("inclusive_start"));
        }
        options.setPrefixMatchLevel(this.getIntQuery("prefix_match_level", options.getPrefixMatchLevel()));
        if (this.getQuery("reduce") != null) {
            options.setReduceSpecified(true);
            options.setReduce(this.getBooleanQuery("reduce"));
        }
        options.setGroup(this.getBooleanQuery("group"));
        Object keysParam = this.getJSONQuery("keys");
        if (keysParam != null && !(keysParam instanceof List)) {
            return false;
        }
        ArrayList<Object> keys = (ArrayList<Object>)keysParam;
        if (keys == null && (key = this.getJSONQuery("key")) != null) {
            keys = new ArrayList<Object>();
            keys.add(key);
        }
        if (keys != null) {
            options.setKeys((List<Object>)keys);
        } else {
            options.setStartKey(this.getJSONQuery("startkey"));
            options.setEndKey(this.getJSONQuery("endkey"));
            if (this.getJSONQuery("startkey_docid") != null) {
                options.setStartKeyDocId(this.getJSONQuery("startkey_docid").toString());
            }
            if (this.getJSONQuery("endkey_docid") != null) {
                options.setEndKeyDocId(this.getJSONQuery("endkey_docid").toString());
            }
        }
        return true;
    }

    private String getMultipartRequestType() {
        String accept = this.getRequestHeaderValue("Accept");
        if (accept.startsWith("multipart/")) {
            return accept;
        }
        return null;
    }

    private boolean explicitlyAcceptsType(String mimeType) {
        String accept = this.getRequestHeaderValue("Accept");
        return accept != null && accept.indexOf(mimeType) >= 0;
    }

    private Status openDB() {
        if (this.db == null) {
            return new Status(500);
        }
        if (!this.db.exists()) {
            return new Status(404);
        }
        try {
            this.db.open();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        return new Status(200);
    }

    private static List<String> splitPath(URL url) {
        String pathString = url.getPath();
        if (pathString.startsWith("/")) {
            pathString = pathString.substring(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (pathString.length() == 0) {
            return result;
        }
        for (String component : pathString.split("/")) {
            result.add(URLDecoder.decode(component));
        }
        return result;
    }

    private void sendResponse() {
        if (!this.responseSent) {
            this.responseSent = true;
            if (this.callbackBlock != null) {
                this.callbackBlock.onResponseReady();
            }
        }
    }

    private String getRequestHeaderContentType() {
        String contentType = this.getRequestHeaderValue("Content-Type");
        if (contentType != null) {
            int index = contentType.indexOf(59);
            if (index > 0) {
                contentType = contentType.substring(0, index);
            }
            contentType = contentType.trim();
        }
        return contentType;
    }

    private String getRequestHeaderValue(String paramName) {
        String value = this.connection.getRequestProperty(paramName);
        if (value == null) {
            value = this.connection.getRequestProperty(paramName.toLowerCase());
        }
        return value;
    }

    public void start() {
        HashMap<String, Object> result;
        String errorMessage;
        String method = this.connection.getRequestMethod();
        if ("HEAD".equals(method)) {
            method = "GET";
        }
        String message = String.format(Locale.ENGLISH, "do_%s", method);
        List<String> path = Router.splitPath(this.connection.getURL());
        if (path == null) {
            this.connection.setResponseCode(400);
            try {
                this.connection.getResponseOutputStream().close();
            }
            catch (IOException e) {
                Log.e(TAG, "Error closing empty output stream");
            }
            this.sendResponse();
            return;
        }
        int pathLen = path.size();
        if (pathLen > 0) {
            String dbName = path.get(0);
            if (dbName.startsWith("_")) {
                message = message + dbName;
            } else {
                message = message + "_Database";
                if (!Manager.isValidDatabaseName(dbName)) {
                    Header resHeader = this.connection.getResHeader();
                    if (resHeader != null) {
                        resHeader.add("Content-Type", CONTENT_TYPE_JSON);
                    }
                    HashMap<String, Object> result2 = new HashMap<String, Object>();
                    result2.put("error", "Invalid database");
                    result2.put("status", 400);
                    this.connection.setResponseBody(new Body(result2));
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.connection.getResponseBody().getJson());
                    this.connection.setResponseInputStream(bais);
                    this.connection.setResponseCode(400);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
                boolean mustExist = false;
                this.db = this.manager.getDatabase(dbName, mustExist);
                if (this.db == null) {
                    this.connection.setResponseCode(400);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
            }
        } else {
            message = message + "Root";
        }
        String docID = null;
        if (this.db != null && pathLen > 1) {
            message = message.replaceFirst("_Database", "_Document");
            Status status = this.openDB();
            if (!status.isSuccessful()) {
                this.connection.setResponseCode(status.getCode());
                try {
                    this.connection.getResponseOutputStream().close();
                }
                catch (IOException e) {
                    Log.e(TAG, "Error closing empty output stream");
                }
                this.sendResponse();
                return;
            }
            String name = path.get(1);
            if (!name.startsWith("_")) {
                if (!Document.isValidDocumentId(name)) {
                    this.connection.setResponseCode(400);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
                docID = name;
            } else if ("_design".equals(name) || "_local".equals(name)) {
                if (pathLen <= 2) {
                    this.connection.setResponseCode(404);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
                docID = name + '/' + path.get(2);
                path.set(1, docID);
                path.remove(2);
                --pathLen;
            } else if (name.startsWith("_design") || name.startsWith("_local")) {
                docID = name;
            } else if ("_session".equals(name)) {
                message = message.replaceFirst("_Document", name);
            } else {
                message = message + name;
                if (pathLen > 2) {
                    List<String> subList = path.subList(2, pathLen - 1);
                    StringBuilder sb = new StringBuilder();
                    Iterator<String> iter = subList.iterator();
                    while (iter.hasNext()) {
                        sb.append(iter.next());
                        if (!iter.hasNext()) continue;
                        sb.append('/');
                    }
                    docID = sb.toString();
                }
            }
        }
        String attachmentName = null;
        if (docID != null && pathLen > 2) {
            message = message.replaceFirst("_Document", "_Attachment");
            attachmentName = path.get(2);
            if (attachmentName.startsWith("_") && docID.startsWith("_design")) {
                message = message.replaceFirst("_Attachment", "_DesignDocument");
                docID = docID.substring(8);
                attachmentName = pathLen > 3 ? path.get(3) : null;
            } else if (pathLen > 3) {
                List<String> subList = path.subList(2, pathLen);
                StringBuilder sb = new StringBuilder();
                Iterator<String> iter = subList.iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next());
                    if (!iter.hasNext()) continue;
                    sb.append('/');
                }
                attachmentName = sb.toString();
            }
        }
        Status status = null;
        try {
            Method m = Router.class.getMethod(message, Database.class, String.class, String.class);
            status = (Status)m.invoke((Object)this, this.db, docID, attachmentName);
        }
        catch (NoSuchMethodException msme) {
            try {
                String[] methods;
                errorMessage = String.format(Locale.ENGLISH, "Router unable to route request to %s", message);
                Log.w(TAG, errorMessage);
                boolean hasAltMethod = false;
                String curDoMethod = String.format(Locale.ENGLISH, "do_%s", method);
                for (String aMethod : methods = new String[]{"GET", "POST", "PUT", "DELETE"}) {
                    if (aMethod.equals(method)) continue;
                    String altDoMethod = String.format(Locale.ENGLISH, "do_%s", aMethod);
                    String altMessage = message.replaceAll(curDoMethod, altDoMethod);
                    try {
                        Method altMethod = Router.class.getMethod(altMessage, Database.class, String.class, String.class);
                        hasAltMethod = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Method m = Router.class.getMethod(hasAltMethod ? "do_METHOD_NOT_ALLOWED" : "do_UNKNOWN", Database.class, String.class, String.class);
                status = (Status)m.invoke((Object)this, this.db, docID, attachmentName);
            }
            catch (Exception e) {
                Log.e(TAG, "Router attempted do_UNKNWON fallback, but that threw an exception", e);
                status = new Status(404);
                result = new HashMap<String, Object>();
                result.put("status", status.getHTTPCode());
                result.put("error", status.getHTTPMessage());
                result.put("reason", "Router unable to route request");
                this.connection.setResponseBody(new Body(result));
            }
        }
        catch (Exception e) {
            errorMessage = "Router unable to route request to " + message;
            Log.w(TAG, errorMessage, e);
            result = new HashMap();
            if (e.getCause() != null && e.getCause() instanceof CouchbaseLiteException) {
                status = ((CouchbaseLiteException)e.getCause()).getCBLStatus();
                result.put("status", status.getHTTPCode());
                result.put("error", status.getHTTPMessage());
                result.put("reason", errorMessage + e.getCause().toString());
            } else {
                status = new Status(404);
                result.put("status", status.getHTTPCode());
                result.put("error", status.getHTTPMessage());
                result.put("reason", errorMessage + e.toString());
            }
            this.connection.setResponseBody(new Body(result));
        }
        if (status.getCode() != 0) {
            status = this.sendResponseHeaders(status);
            this.connection.setResponseCode(status.getCode());
            if (status.isSuccessful() && this.connection.getResponseBody() == null && this.connection.getHeaderField("Content-Type") == null && !this.dontOverwriteBody) {
                this.connection.setResponseBody(new Body("{\"ok\":true}".getBytes()));
            }
            if (!status.isSuccessful() && this.connection.getResponseBody() == null) {
                HashMap<String, Object> result3 = new HashMap<String, Object>();
                result3.put("status", status.getCode());
                result3.put("error", status.getHTTPMessage());
                this.connection.setResponseBody(new Body(result3));
                this.connection.getResHeader().add("Content-Type", CONTENT_TYPE_JSON);
            }
            this.setResponse();
            this.sendResponse();
        } else {
            this.waiting = true;
        }
        if (this.waiting && this.db != null) {
            Log.v(TAG, "waiting=true & db!=null: call Database.addDatabaseListener()");
            this.db.addDatabaseListener(this);
        }
    }

    @Override
    public void databaseClosing() {
        this.dbClosing();
    }

    private void dbClosing() {
        Log.d(TAG, "Database closing! Returning error 500");
        Status status = new Status(500);
        status = this.sendResponseHeaders(status);
        this.connection.setResponseCode(status.getCode());
        this.setResponse();
        this.sendResponse();
    }

    public void stop() {
        this.stopHeartbeat();
        this.callbackBlock = null;
        if (this.db != null) {
            this.db.removeChangeListener(this);
            this.db.removeDatabaseListener(this);
        }
    }

    public Status do_UNKNOWN(Database db, String docID, String attachmentName) {
        return new Status(404);
    }

    public Status do_METHOD_NOT_ALLOWED(Database db, String docID, String attachmentName) {
        return new Status(405);
    }

    private void setResponse() {
        if (this.connection.getResponseBody() != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.connection.getResponseBody().getJson());
            this.connection.setResponseInputStream(bais);
        } else {
            try {
                this.connection.getResponseOutputStream().close();
            }
            catch (IOException e) {
                Log.e(TAG, "Error closing empty output stream");
            }
        }
    }

    private Status sendResponseHeaders(Status status) {
        this.connection.getResHeader().add("Server", String.format(Locale.ENGLISH, "Couchbase Lite %s", Router.getVersionString()));
        boolean hasJSONBody = this.connection.getResponseBody() != null;
        String contentType = hasJSONBody ? CONTENT_TYPE_JSON : null;
        String accept = this.getRequestHeaderValue("Accept");
        if (accept != null && accept.indexOf("*/*") < 0) {
            String baseContentType = this.connection.getBaseContentType();
            if (baseContentType == null) {
                baseContentType = contentType;
            }
            if (baseContentType != null && baseContentType.indexOf(accept) < 0) {
                Log.w(TAG, "Error 406: Can't satisfy request Accept: %s (Content-Type = %s)", accept, contentType);
                this.connection.setResponseBody(null);
                status = new Status(406);
                return status;
            }
        }
        if (contentType != null) {
            Header resHeader = this.connection.getResHeader();
            if (resHeader != null && resHeader.get("Content-Type") == null) {
                resHeader.add("Content-Type", contentType);
            } else {
                Log.d(TAG, "Cannot add Content-Type header because getResHeader() returned null");
            }
        }
        return status;
    }

    private void setResponseLocation(URL url) {
        int startOfQuery;
        String location = url.getPath();
        String query = url.getQuery();
        if (query != null && (startOfQuery = location.indexOf(query)) > 0) {
            location = location.substring(0, startOfQuery);
        }
        this.connection.getResHeader().add("Location", location);
    }

    public Status do_GETRoot(Database _db, String _docID, String _attachmentName) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("CBLite", "Welcome");
        info.put("couchdb", "Welcome");
        info.put("version", Router.getVersionString());
        this.connection.setResponseBody(new Body(info));
        return new Status(200);
    }

    public Status do_GET_all_dbs(Database _db, String _docID, String _attachmentName) {
        List<String> dbs = this.manager.getAllDatabaseNames();
        this.connection.setResponseBody(new Body(dbs));
        return new Status(200);
    }

    public Status do_GET_session(Database _db, String _docID, String _attachmentName) {
        HashMap<String, Object> session = new HashMap<String, Object>();
        HashMap<String, String[]> userCtx = new HashMap<String, String[]>();
        String[] roles = new String[]{"_admin"};
        session.put("ok", true);
        userCtx.put("name", null);
        userCtx.put("roles", roles);
        session.put("userCtx", userCtx);
        this.connection.setResponseBody(new Body(session));
        return new Status(200);
    }

    public Status do_POST_replicate(Database _db, String _docID, String _attachmentName) {
        boolean cancel;
        Replication replicator;
        Map<String, Object> body = null;
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        try {
            replicator = this.manager.getReplicator(body);
        }
        catch (CouchbaseLiteException e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", e.toString());
            this.connection.setResponseBody(new Body(result));
            return e.getCBLStatus();
        }
        Boolean cancelBoolean = (Boolean)body.get("cancel");
        boolean bl = cancel = cancelBoolean != null && cancelBoolean != false;
        if (!cancel) {
            if (!replicator.isRunning()) {
                final CountDownLatch replicationStarted = new CountDownLatch(1);
                replicator.addChangeListener(new Replication.ChangeListener(){

                    @Override
                    public void changed(Replication.ChangeEvent event) {
                        if (event.getTransition() != null && event.getTransition().getDestination() == ReplicationState.RUNNING) {
                            replicationStarted.countDown();
                        }
                    }
                });
                if (!replicator.isContinuous()) {
                    replicator.addChangeListener(new Replication.ChangeListener(){

                        @Override
                        public void changed(Replication.ChangeEvent event) {
                            if (event.getTransition() != null && event.getTransition().getDestination() == ReplicationState.STOPPED) {
                                Status status = new Status(200);
                                status = Router.this.sendResponseHeaders(status);
                                Router.this.connection.setResponseCode(status.getCode());
                                HashMap<String, Object> result = new HashMap<String, Object>();
                                result.put("session_id", event.getSource().getSessionID());
                                Router.this.connection.setResponseBody(new Body(result));
                                Router.this.setResponse();
                                Router.this.sendResponse();
                            }
                        }
                    });
                }
                replicator.start();
                try {
                    replicationStarted.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (replicator.isContinuous()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("session_id", replicator.getSessionID());
                this.connection.setResponseBody(new Body(result));
                return new Status(200);
            }
            return new Status(0);
        }
        replicator.stop();
        return new Status(200);
    }

    public Status do_GET_uuids(Database _db, String _docID, String _attachmentName) {
        int count = Math.min(1000, this.getIntQuery("count", 1));
        ArrayList<String> uuids = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            uuids.add(Misc.CreateUUID());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("uuids", uuids);
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_GET_active_tasks(Database _db, String _docID, String _attachmentName) {
        String feed = this.getQuery("feed");
        this.longpoll = "longpoll".equals(feed);
        boolean continuous = !this.longpoll && "continuous".equals(feed);
        String session_id = this.getQuery("session_id");
        Replication.ChangeListener listener = new Replication.ChangeListener(){
            Replication.ChangeListener self = this;

            @Override
            public void changed(Replication.ChangeEvent event) {
                Map activity = Router.getActivity(event.getSource());
                if (event.getTransition() != null) {
                    activity.put("transition_source", event.getTransition().getSource());
                    activity.put("transition_destination", event.getTransition().getDestination());
                    activity.put("trigger", event.getTransition().getTrigger());
                    Log.d(Router.TAG, "do_GET_active_tasks Transition [" + (Object)((Object)event.getTransition().getTrigger()) + "] Source:" + (Object)((Object)event.getTransition().getSource()) + ", Destination:" + (Object)((Object)event.getTransition().getDestination()));
                }
                if (Router.this.longpoll) {
                    Log.w(Router.TAG, "Router: Sending longpoll replication response");
                    Router.this.sendResponse();
                    if (Router.this.callbackBlock != null) {
                        byte[] data = null;
                        try {
                            data = Manager.getObjectMapper().writeValueAsBytes((Object)activity);
                        }
                        catch (Exception e) {
                            Log.w(Router.TAG, "Error serializing JSON", e);
                        }
                        OutputStream os = Router.this.connection.getResponseOutputStream();
                        try {
                            os.write(data);
                            os.close();
                        }
                        catch (IOException e) {
                            Log.e(Router.TAG, "IOException writing to internal streams", e);
                        }
                    }
                    event.getSource().removeChangeListener(this.self);
                } else {
                    Log.w(Router.TAG, "Router: Sending continous replication change chunk");
                    Router.this.sendContinuousReplicationChanges(activity);
                }
            }
        };
        ArrayList<Map<String, Object>> activities = new ArrayList<Map<String, Object>>();
        for (Database database : this.manager.allOpenDatabases()) {
            List<Replication> activeReplicators = database.getActiveReplications();
            if (activeReplicators == null) continue;
            for (Replication replicator : activeReplicators) {
                if (!replicator.isRunning()) continue;
                Map<String, Object> activity = Router.getActivity(replicator);
                if (session_id != null) {
                    if (replicator.getSessionID().equals(session_id)) {
                        activities.add(activity);
                    }
                } else {
                    activities.add(activity);
                }
                if (!continuous && !this.longpoll) continue;
                if (session_id != null) {
                    if (!replicator.getSessionID().equals(session_id)) continue;
                    replicator.addChangeListener(listener);
                    continue;
                }
                replicator.addChangeListener(listener);
            }
        }
        if (continuous || this.longpoll) {
            this.connection.setChunked(true);
            this.connection.setResponseCode(200);
            this.sendResponse();
            if (continuous && !activities.isEmpty()) {
                for (Map map : activities) {
                    this.sendContinuousReplicationChanges(map);
                }
            }
            return new Status(0);
        }
        this.connection.setResponseBody(new Body(activities));
        return new Status(200);
    }

    private static Map<String, Object> getActivity(Replication replicator) {
        HashMap<String, Object> activity = new HashMap<String, Object>();
        String source = replicator.getRemoteUrl().toExternalForm();
        String target = replicator.getLocalDatabase().getName();
        if (!replicator.isPull()) {
            String tmp = source;
            source = target;
            target = tmp;
        }
        int processed = replicator.getCompletedChangesCount();
        int total = replicator.getChangesCount();
        String status = String.format(Locale.ENGLISH, "Processed %d / %d changes", processed, total);
        if (!replicator.getStatus().equals((Object)Replication.ReplicationStatus.REPLICATION_ACTIVE)) {
            if (replicator.getStatus().equals((Object)Replication.ReplicationStatus.REPLICATION_IDLE)) {
                status = "Idle";
            } else if (replicator.getStatus().equals((Object)Replication.ReplicationStatus.REPLICATION_STOPPED)) {
                status = "Stopped";
            } else if (replicator.getStatus().equals((Object)Replication.ReplicationStatus.REPLICATION_OFFLINE)) {
                status = "Offline";
            }
        }
        int progress = total > 0 ? Math.round((float)(100 * processed) / (float)total) : 0;
        activity.put("type", "Replication");
        activity.put("task", replicator.getSessionID());
        activity.put("source", source);
        activity.put("target", target);
        activity.put("status", status);
        activity.put("progress", progress);
        activity.put("continuous", replicator.isContinuous());
        if (replicator.getLastError() != null) {
            String msg = String.format(Locale.ENGLISH, "Replicator error: %s.  Repl: %s.  Source: %s, Target: %s", replicator.getLastError(), replicator, source, target);
            Log.w(TAG, msg);
            Throwable error = replicator.getLastError();
            int statusCode = 400;
            if (error instanceof RemoteRequestResponseException) {
                statusCode = ((RemoteRequestResponseException)error).getCode();
            }
            Object[] errorObjects = new Object[]{statusCode, replicator.getLastError().toString()};
            activity.put("error", errorObjects);
        } else {
            activity.put("change_count", total);
            activity.put("completed_change_count", processed);
        }
        return activity;
    }

    private void sendContinuousReplicationChanges(Map<String, Object> activity) {
        try {
            String jsonString = Manager.getObjectMapper().writeValueAsString(activity);
            if (this.callbackBlock != null) {
                byte[] json = (jsonString + '\n').getBytes();
                OutputStream os = this.connection.getResponseOutputStream();
                try {
                    os.write(json);
                    os.flush();
                }
                catch (Exception e) {
                    Log.e(TAG, "IOException writing to internal streams", e);
                }
            }
        }
        catch (Exception e) {
            Log.w("Unable to serialize change to JSON", e);
        }
    }

    public Status do_GET_Database(Database _db, String _docID, String _attachmentName) {
        Status status = this.openDB();
        if (!status.isSuccessful()) {
            return status;
        }
        int num_docs = this.db.getDocumentCount();
        long update_seq = this.db.getLastSequenceNumber();
        long instanceStartTimeMicroseconds = this.db.getStartTime() * 1000L;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("db_name", this.db.getName());
        result.put("db_uuid", this.db.publicUUID());
        result.put("doc_count", num_docs);
        result.put("update_seq", update_seq);
        result.put("disk_size", this.db.totalDataSize());
        result.put("instance_start_time", instanceStartTimeMicroseconds);
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_PUT_Database(Database _db, String _docID, String _attachmentName) {
        if (this.db.exists()) {
            return new Status(412);
        }
        try {
            this.db.open();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        this.setResponseLocation(this.connection.getURL());
        return new Status(201);
    }

    public Status do_DELETE_Database(Database _db, String _docID, String _attachmentName) throws CouchbaseLiteException {
        if (this.getQuery("rev") != null) {
            return new Status(400);
        }
        this.db.delete();
        return new Status(200);
    }

    private static void convertCBLQueryRowsToMaps(Map<String, Object> allDocsResult) {
        ArrayList<Map<String, Object>> rowsAsMaps = new ArrayList<Map<String, Object>>();
        List rows = (List)allDocsResult.get("rows");
        if (rows != null) {
            for (QueryRow row : rows) {
                rowsAsMaps.add(row.asJSONDictionary());
            }
        }
        allDocsResult.put("rows", rowsAsMaps);
    }

    public Status do_POST_Database(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> body;
        Status status = this.openDB();
        if (!status.isSuccessful()) {
            return status;
        }
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        return this.update(this.db, null, new Body(body), false);
    }

    public Status do_GET_Document_all_docs(Database _db, String _docID, String _attachmentName) throws CouchbaseLiteException {
        QueryOptions options = new QueryOptions();
        if (!this.getQueryOptions(options)) {
            return new Status(400);
        }
        Map<String, Object> result = this.db.getAllDocs(options);
        Router.convertCBLQueryRowsToMaps(result);
        if (result == null) {
            return new Status(500);
        }
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_POST_Document_all_docs(Database _db, String _docID, String _attachmentName) throws CouchbaseLiteException {
        QueryOptions options = new QueryOptions();
        if (!this.getQueryOptions(options)) {
            return new Status(400);
        }
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        List keys = (List)body.get("keys");
        options.setKeys(keys);
        Map<String, Object> result = null;
        result = this.db.getAllDocs(options);
        Router.convertCBLQueryRowsToMaps(result);
        if (result == null) {
            return new Status(500);
        }
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_POST_facebook_token(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> body;
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        String email = (String)body.get("email");
        String remoteUrl = (String)body.get("remote_url");
        String accessToken = (String)body.get("access_token");
        if (email != null && remoteUrl != null && accessToken != null) {
            URL siteUrl;
            try {
                siteUrl = new URL(remoteUrl);
            }
            catch (MalformedURLException e) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("error", "invalid remote_url: " + e.getLocalizedMessage());
                this.connection.setResponseBody(new Body(result));
                return new Status(400);
            }
            FacebookAuthorizer.registerToken(accessToken, email, siteUrl);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("ok", "registered");
            this.connection.setResponseBody(new Body(result));
            return new Status(200);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", "required fields: access_token, email, remote_url");
        this.connection.setResponseBody(new Body(result));
        return new Status(400);
    }

    public Status do_POST_persona_assertion(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> body;
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        String assertion = (String)body.get("assertion");
        if (assertion == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "required fields: assertion");
            this.connection.setResponseBody(new Body(result));
            return new Status(400);
        }
        try {
            String email = PersonaAuthorizer.registerAssertion(assertion);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("ok", "registered");
            result.put("email", email);
            this.connection.setResponseBody(new Body(result));
            return new Status(200);
        }
        catch (Exception e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "error registering persona assertion: " + e.getLocalizedMessage());
            this.connection.setResponseBody(new Body(result));
            return new Status(400);
        }
    }

    public Status do_POST_Document_bulk_docs(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> body;
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        final List docs = (List)body.get("docs");
        final boolean noNewEdits = !Router.getBooleanValueFromBody("new_edits", body, true);
        final boolean allOrNothing = Router.getBooleanValueFromBody("all_or_nothing", body, false);
        final Status status = new Status(200);
        final ArrayList results = new ArrayList();
        boolean ret = this.db.getStore().runInTransaction(new TransactionalTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run() {
                boolean ok = false;
                try {
                    for (Map doc : docs) {
                        String docID = (String)doc.get("_id");
                        RevisionInternal rev = null;
                        Body docBody = new Body(doc);
                        if (noNewEdits) {
                            rev = new RevisionInternal(docBody);
                            if (rev.getRevID() == null || rev.getDocID() == null || !rev.getDocID().equals(docID)) {
                                status.setCode(400);
                            } else {
                                List<String> history = Database.parseCouchDBRevisionHistory(doc);
                                Router.this.db.forceInsert(rev, history, Router.this.source);
                            }
                        } else {
                            Status outStatus = new Status();
                            rev = Router.this.update(Router.this.db, docID, docBody, false, allOrNothing, outStatus);
                            status.setCode(outStatus.getCode());
                        }
                        HashMap<String, Object> result = null;
                        if (status.isSuccessful()) {
                            result = new HashMap<String, Object>();
                            result.put("ok", true);
                            result.put("id", docID);
                            if (rev != null) {
                                result.put("rev", rev.getRevID());
                            }
                        } else {
                            if (allOrNothing) {
                                boolean bl = false;
                                return bl;
                            }
                            if (status.getCode() == 403) {
                                result = new HashMap();
                                result.put("error", "validation failed");
                                result.put("id", docID);
                            } else if (status.getCode() == 409) {
                                result = new HashMap();
                                result.put("error", "conflict");
                                result.put("id", docID);
                            } else {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        if (result == null) continue;
                        results.add(result);
                    }
                    Log.w(Router.TAG, "%s finished inserting %d revisions in bulk", this, docs.size());
                    ok = true;
                    return ok;
                }
                catch (Exception e) {
                    Log.e(Router.TAG, "%s: Exception inserting revisions in bulk", e, this);
                }
                finally {
                    return ok;
                }
            }
        });
        if (ret) {
            this.connection.setResponseBody(new Body(results));
            return new Status(201);
        }
        return status;
    }

    public Status do_POST_Document_revs_diff(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> body;
        RevisionList revs = new RevisionList();
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        for (String docID : body.keySet()) {
            List revIDs = (List)body.get(docID);
            for (String revID : revIDs) {
                RevisionInternal rev = new RevisionInternal(docID, revID, false);
                revs.add(rev);
            }
        }
        try {
            this.db.findMissingRevisions(revs);
        }
        catch (SQLException e) {
            Log.e(TAG, "Exception", e);
            return new Status(590);
        }
        HashMap<String, Object> diffs = new HashMap<String, Object>();
        for (RevisionInternal rev : revs) {
            String docID = rev.getDocID();
            ArrayList<String> missingRevs = null;
            HashMap<String, ArrayList<String>> idObj = (HashMap<String, ArrayList<String>>)diffs.get(docID);
            if (idObj != null) {
                missingRevs = (ArrayList<String>)idObj.get("missing");
            } else {
                idObj = new HashMap<String, ArrayList<String>>();
            }
            if (missingRevs == null) {
                missingRevs = new ArrayList<String>();
                idObj.put("missing", missingRevs);
                diffs.put(docID, idObj);
            }
            missingRevs.add(rev.getRevID());
        }
        this.connection.setResponseBody(new Body(diffs));
        return new Status(200);
    }

    public Status do_POST_Document_compact(Database _db, String _docID, String _attachmentName) {
        Status status = new Status(200);
        try {
            _db.compact();
        }
        catch (CouchbaseLiteException e) {
            status = e.getCBLStatus();
        }
        if (status.getCode() < 300) {
            Status outStatus = new Status();
            outStatus.setCode(202);
            return outStatus;
        }
        return status;
    }

    public Status do_POST_Document_purge(Database _db, String ignored1, String ignored2) {
        Map<String, Object> body;
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        final HashMap<String, List> docsToRevs = new HashMap<String, List>();
        for (String key : body.keySet()) {
            Object val = body.get(key);
            if (!(val instanceof List)) continue;
            docsToRevs.put(key, (List)val);
        }
        final ArrayList asyncApiCallResponse = new ArrayList();
        Future future = this.db.runAsync(new AsyncTask(){

            @Override
            public void run(Database database) {
                Map<String, Object> purgedRevisions = Router.this.db.purgeRevisions(docsToRevs);
                asyncApiCallResponse.add(purgedRevisions);
            }
        });
        try {
            future.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.e(TAG, "Exception waiting for future", e);
            return new Status(500);
        }
        catch (ExecutionException e) {
            Log.e(TAG, "Exception waiting for future", e);
            return new Status(500);
        }
        catch (TimeoutException e) {
            Log.e(TAG, "Exception waiting for future", e);
            return new Status(500);
        }
        Map purgedRevisions = (Map)asyncApiCallResponse.get(0);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("purged", purgedRevisions);
        Body responseBody = new Body(responseMap);
        this.connection.setResponseBody(responseBody);
        return new Status(200);
    }

    public Status do_POST_Document_ensure_full_commit(Database _db, String _docID, String _attachmentName) {
        return new Status(200);
    }

    private Map<String, Object> changesDictForRevision(RevisionInternal rev) {
        HashMap<String, String> changesDict = new HashMap<String, String>();
        changesDict.put("rev", rev.getRevID());
        ArrayList<HashMap<String, String>> changes = new ArrayList<HashMap<String, String>>();
        changes.add(changesDict);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("seq", rev.getSequence());
        result.put("id", rev.getDocID());
        result.put("changes", changes);
        if (rev.isDeleted()) {
            result.put("deleted", true);
        }
        if (this.changesIncludesDocs) {
            result.put("doc", rev.getProperties());
        }
        return result;
    }

    private Map<String, Object> responseBodyForChanges(List<RevisionInternal> changes, long since) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (RevisionInternal rev : changes) {
            Map<String, Object> changeDict = this.changesDictForRevision(rev);
            results.add(changeDict);
        }
        if (changes.size() > 0) {
            since = changes.get(changes.size() - 1).getSequence();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("results", results);
        result.put("last_seq", since);
        return result;
    }

    private Map<String, Object> responseBodyForChangesWithConflicts(List<RevisionInternal> changes, long since) {
        Long lastSeq;
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>();
        String lastDocID = null;
        Map<String, Object> lastEntry = null;
        for (RevisionInternal rev : changes) {
            String docID = rev.getDocID();
            if (docID.equals(lastDocID)) {
                HashMap<String, String> changesDict = new HashMap<String, String>();
                changesDict.put("rev", rev.getRevID());
                List inchanges = (List)lastEntry.get("changes");
                inchanges.add(changesDict);
                continue;
            }
            lastEntry = this.changesDictForRevision(rev);
            entries.add(lastEntry);
            lastDocID = docID;
        }
        Collections.sort(entries, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> e1, Map<String, Object> e2) {
                return Misc.SequenceCompare((Long)e1.get("seq"), (Long)e2.get("seq"));
            }
        });
        if (entries.size() == 0) {
            lastSeq = since;
        } else {
            lastSeq = (Long)((Map)entries.get(entries.size() - 1)).get("seq");
            if (lastSeq == null) {
                lastSeq = since;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("results", entries);
        result.put("last_seq", lastSeq);
        return result;
    }

    private void sendContinuousChange(RevisionInternal rev) {
        Map<String, Object> changeDict = this.changesDictForRevision(rev);
        try {
            String jsonString = Manager.getObjectMapper().writeValueAsString(changeDict);
            if (this.callbackBlock != null) {
                byte[] json = (jsonString + '\n').getBytes();
                OutputStream os = this.connection.getResponseOutputStream();
                try {
                    os.write(json);
                    os.flush();
                }
                catch (Exception e) {
                    Log.e(TAG, "IOException writing to internal streams", e);
                }
            }
        }
        catch (Exception e) {
            Log.w("Unable to serialize change to JSON", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(Database.ChangeEvent event) {
        ArrayList<RevisionInternal> revs = new ArrayList<RevisionInternal>();
        List<DocumentChange> changes = event.getChanges();
        for (DocumentChange change : changes) {
            RevisionInternal rev = change.getAddedRevision();
            if (rev == null) continue;
            String winningRevID = change.getWinningRevisionID();
            if (!this.changesIncludesConflicts) {
                if (winningRevID == null) continue;
                if (!winningRevID.equals(rev.getRevID())) {
                    RevisionInternal mRev = this.db.getDocument(rev.getDocID(), winningRevID, this.changesIncludesDocs);
                    mRev.setSequence(rev.getSequence());
                    rev = mRev;
                }
            }
            if (!event.getSource().runFilter(this.changesFilter, this.changesFilterParams, rev)) continue;
            if (this.longpoll) {
                revs.add(rev);
                continue;
            }
            Log.i(TAG, "Router: Sending continous change chunk");
            this.sendContinuousChange(rev);
        }
        if (this.longpoll && revs.size() > 0) {
            Object object = this.databaseChangesLongpollLock;
            synchronized (object) {
                block22: {
                    Log.i(TAG, "Router: Sending longpoll response: START");
                    this.sendResponse();
                    OutputStream os = this.connection.getResponseOutputStream();
                    try {
                        Map<String, Object> body = this.responseBodyForChanges(revs, 0L);
                        if (this.callbackBlock == null) break block22;
                        byte[] data = null;
                        try {
                            data = Manager.getObjectMapper().writeValueAsBytes(body);
                        }
                        catch (Exception e) {
                            Log.w(TAG, "Error serializing JSON", e);
                        }
                        os.write(data);
                        os.flush();
                    }
                    catch (IOException e) {
                        Log.w(TAG, "IOException writing to internal streams: " + e.getMessage());
                    }
                    finally {
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            Log.w(TAG, "Failed to close connection: " + e.getMessage());
                        }
                    }
                }
                Log.i(TAG, "Router: Sending longpoll response: END");
            }
        }
    }

    public Status do_GET_Document_changes(Database _db, String docID, String _attachmentName) {
        return this.doChanges(_db);
    }

    public Status do_POST_Document_changes(Database _db, String docID, String _attachmentName) {
        Map<String, Object> body;
        try {
            body = this.getBodyAsDictionary();
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
        Iterator<String> keys = body.keySet().iterator();
        while (keys.hasNext()) {
            if (this.getQueries() == null) {
                this.queries = new HashMap<String, String>();
            }
            String key = keys.next();
            Object value = body.get(key);
            if (key == null || value == null) continue;
            this.getQueries().put(key, value.toString());
        }
        return this.doChanges(_db);
    }

    private Status doChanges(Database db) {
        boolean continuous;
        RevisionList changes;
        this.changesIncludesDocs = this.getBooleanQuery("include_docs");
        String style = this.getQuery("style");
        if (style != null && "all_docs".equals(style)) {
            this.changesIncludesConflicts = true;
        }
        ChangesOptions options = new ChangesOptions();
        options.setIncludeDocs(this.changesIncludesDocs);
        options.setIncludeConflicts(this.changesIncludesConflicts);
        options.setSortBySequence(!options.isIncludeConflicts());
        options.setLimit(this.getIntQuery("limit", options.getLimit()));
        int since = this.getIntQuery("since", 0);
        String filterName = this.getQuery("filter");
        if (filterName != null) {
            this.changesFilter = db.getFilter(filterName);
            if (this.changesFilter == null) {
                return new Status(404);
            }
            this.changesFilterParams = new HashMap<String, String>(this.queries);
            Log.v(TAG, "Filter params=" + this.changesFilterParams);
        }
        if ((changes = db.changesSince(since, options, this.changesFilter, this.changesFilterParams)) == null) {
            return new Status(500);
        }
        String feed = this.getQuery("feed");
        this.longpoll = "longpoll".equals(feed);
        boolean bl = continuous = !this.longpoll && "continuous".equals(feed);
        if (continuous || this.longpoll && changes.size() == 0) {
            this.connection.setChunked(true);
            this.connection.setResponseCode(200);
            this.sendResponse();
            if (continuous) {
                for (RevisionInternal rev : changes) {
                    this.sendContinuousChange(rev);
                }
            }
            db.addChangeListener(this);
            String heartbeatParam = this.getQuery("heartbeat");
            if (heartbeatParam != null) {
                long heartbeat = 0L;
                try {
                    heartbeat = (long)Double.parseDouble(heartbeatParam);
                }
                catch (Exception e) {
                    return new Status(400);
                }
                if (heartbeat <= 0L) {
                    return new Status(400);
                }
                if (heartbeat < 5000L) {
                    heartbeat = 5000L;
                }
                this.startHeartbeat(heartbeat);
            }
            return new Status(0);
        }
        if (options.isIncludeConflicts()) {
            this.connection.setResponseBody(new Body(this.responseBodyForChangesWithConflicts(changes, since)));
        } else {
            this.connection.setResponseBody(new Body(this.responseBodyForChanges(changes, since)));
        }
        return new Status(200);
    }

    private void startHeartbeat(long interval) {
        if (interval <= 0L) {
            return;
        }
        this.stopHeartbeat();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Router.this.databaseChangesLongpollLock;
                synchronized (object) {
                    OutputStream os = Router.this.connection.getResponseOutputStream();
                    if (os != null) {
                        try {
                            Log.v(Router.TAG, "[%s] Sent heart beat!", this);
                            os.write("\r\n".getBytes());
                            os.flush();
                        }
                        catch (IOException e) {
                            Log.w(Router.TAG, "IOException writing to internal streams: " + e.getMessage());
                        }
                    }
                }
            }
        }, interval, interval);
    }

    private void stopHeartbeat() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    private String getRevIDFromIfMatchHeader() {
        String ifMatch = this.getRequestHeaderValue("If-Match");
        if (ifMatch == null) {
            return null;
        }
        if (ifMatch.length() > 2 && ifMatch.startsWith("\"") && ifMatch.endsWith("\"")) {
            return ifMatch.substring(1, ifMatch.length() - 2);
        }
        return null;
    }

    public Status do_GET_Document(Database _db, String docID, String _attachmentName) {
        try {
            boolean isLocalDoc = docID.startsWith("_local");
            EnumSet<TDContentOptions> options = this.getContentOptions();
            String openRevsParam = this.getQuery("open_revs");
            boolean mustSendJSON = this.explicitlyAcceptsType(CONTENT_TYPE_JSON);
            if (openRevsParam == null || isLocalDoc) {
                RevisionInternal rev;
                String revID = this.getQuery("rev");
                boolean includeAttachments = false;
                boolean sendMultipart = false;
                if (isLocalDoc) {
                    rev = this.db.getLocalDocument(docID, revID);
                } else {
                    includeAttachments = options.contains((Object)TDContentOptions.TDIncludeAttachments);
                    if (includeAttachments) {
                        options.remove((Object)TDContentOptions.TDIncludeAttachments);
                    }
                    if ((rev = this.db.getDocument(docID, revID, true)) != null) {
                        rev = this.applyOptionsToRevision(options, rev);
                    }
                }
                if (rev == null) {
                    return new Status(404);
                }
                if (this.cacheWithEtag(rev.getRevID())) {
                    return new Status(304);
                }
                if (!isLocalDoc && includeAttachments) {
                    int minRevPos = 1;
                    List attsSince = this.parseJSONRevArrayQuery(this.getQuery("atts_since"));
                    String ancestorID = this.db.getStore().findCommonAncestorOf(rev, attsSince);
                    if (ancestorID != null) {
                        minRevPos = Revision.generationFromRevID(ancestorID) + 1;
                    }
                    RevisionInternal expandedRev = rev.copy();
                    Status status = new Status(200);
                    if (!this.db.expandAttachments(expandedRev, minRevPos, sendMultipart, !this.getBooleanQuery("att_encoding_info"), status)) {
                        return status;
                    }
                    rev = expandedRev;
                }
                this.connection.setResponseBody(rev.getBody());
            } else {
                String acceptMultipart;
                ArrayList result = null;
                if ("all".equals(openRevsParam)) {
                    RevisionList allRevs = this.db.getStore().getAllRevisions(docID, true);
                    result = new ArrayList(allRevs.size());
                    for (RevisionInternal rev : allRevs) {
                        try {
                            this.db.loadRevisionBody(rev);
                        }
                        catch (CouchbaseLiteException e) {
                            if (e.getCBLStatus().getCode() != 500) {
                                HashMap<String, String> dict = new HashMap<String, String>();
                                dict.put("missing", rev.getRevID());
                                result.add(dict);
                            }
                            throw e;
                        }
                        HashMap<String, Map<String, Object>> dict = new HashMap<String, Map<String, Object>>();
                        dict.put("ok", rev.getProperties());
                        result.add(dict);
                    }
                } else {
                    List openRevs = (List)this.getJSONQuery("open_revs");
                    if (openRevs == null) {
                        return new Status(400);
                    }
                    result = new ArrayList(openRevs.size());
                    for (String revID : openRevs) {
                        HashMap<String, Object> dict;
                        RevisionInternal rev = this.db.getDocument(docID, revID, true);
                        if (rev != null) {
                            dict = new HashMap<String, Object>();
                            dict.put("ok", rev.getProperties());
                            result.add(dict);
                            continue;
                        }
                        dict = new HashMap();
                        dict.put("missing", revID);
                        result.add(dict);
                    }
                }
                if ((acceptMultipart = this.getMultipartRequestType()) != null) {
                    throw new UnsupportedOperationException();
                }
                this.connection.setResponseBody(new Body(result));
            }
            return new Status(200);
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
    }

    private RevisionInternal applyOptionsToRevision(EnumSet<TDContentOptions> options, RevisionInternal rev) {
        if (options != null && (options.contains((Object)TDContentOptions.TDIncludeLocalSeq) || options.contains((Object)TDContentOptions.TDIncludeRevs) || options.contains((Object)TDContentOptions.TDIncludeRevsInfo) || options.contains((Object)TDContentOptions.TDIncludeConflicts) || options.contains((Object)TDContentOptions.TDBigAttachmentsFollow))) {
            RevisionList revs;
            HashMap<String, Object> dst = new HashMap<String, Object>();
            dst.putAll(rev.getProperties());
            Store store = this.db.getStore();
            if (options.contains((Object)TDContentOptions.TDIncludeLocalSeq)) {
                dst.put("_local_seq", rev.getSequence());
                rev.setProperties(dst);
            }
            if (options.contains((Object)TDContentOptions.TDIncludeRevs)) {
                revs = this.db.getRevisionHistory(rev);
                Map<String, Object> historyDict = RevisionUtils.makeRevisionHistoryDict(revs);
                dst.put("_revisions", historyDict);
                rev.setProperties(dst);
            }
            if (options.contains((Object)TDContentOptions.TDIncludeRevsInfo)) {
                ArrayList revsInfo = new ArrayList();
                List<RevisionInternal> revs2 = this.db.getRevisionHistory(rev);
                for (RevisionInternal historicalRev : revs2) {
                    HashMap<String, String> revHistoryItem = new HashMap<String, String>();
                    String status = "available";
                    if (historicalRev.isDeleted()) {
                        status = "deleted";
                    }
                    if (historicalRev.isMissing()) {
                        status = "missing";
                    }
                    revHistoryItem.put("rev", historicalRev.getRevID());
                    revHistoryItem.put("status", status);
                    revsInfo.add(revHistoryItem);
                }
                dst.put("_revs_info", revsInfo);
                rev.setProperties(dst);
            }
            if (options.contains((Object)TDContentOptions.TDIncludeConflicts)) {
                revs = store.getAllRevisions(rev.getDocID(), true);
                if (revs.size() > 1) {
                    ArrayList<String> conflicts = new ArrayList<String>();
                    for (RevisionInternal aRev : revs) {
                        if (aRev.equals(rev) || aRev.isDeleted()) continue;
                        conflicts.add(aRev.getRevID());
                    }
                    dst.put("_conflicts", conflicts);
                }
                rev.setProperties(dst);
            }
            if (options.contains((Object)TDContentOptions.TDBigAttachmentsFollow)) {
                RevisionInternal nuRev = new RevisionInternal(dst);
                Status outStatus = new Status(200);
                if (!this.db.expandAttachments(nuRev, 0, false, this.getBooleanQuery("att_encoding_info"), outStatus)) {
                    return null;
                }
                rev = nuRev;
            }
        }
        return rev;
    }

    public Status do_GET_Attachment(Database _db, String docID, String _attachmentName) {
        try {
            EnumSet<TDContentOptions> options = this.getContentOptions();
            options.add(TDContentOptions.TDNoBody);
            String revID = this.getQuery("rev");
            RevisionInternal rev = this.db.getDocument(docID, revID, false);
            if (rev == null) {
                return new Status(404);
            }
            if (this.cacheWithEtag(rev.getRevID())) {
                return new Status(304);
            }
            String acceptEncoding = this.connection.getRequestProperty("accept-encoding");
            AttachmentInternal attachment = this.db.getAttachment(rev, _attachmentName);
            if (attachment == null) {
                return new Status(404);
            }
            String type = attachment.getContentType();
            if (type != null) {
                this.connection.getResHeader().add("Content-Type", type);
            }
            if (acceptEncoding != null && acceptEncoding.contains("gzip") && attachment.getEncoding() == AttachmentInternal.AttachmentEncoding.AttachmentEncodingGZIP) {
                this.connection.getResHeader().add("Content-Encoding", "gzip");
            }
            this.dontOverwriteBody = true;
            this.connection.setResponseInputStream(attachment.getContentInputStream());
            return new Status(200);
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
    }

    /*
     * Unable to fully structure code
     */
    private RevisionInternal update(Database _db, String docID, Body body, boolean deleting, boolean allowConflict, Status outStatus) {
        if (body != null && !body.isValidJSON()) {
            outStatus.setCode(493);
            return null;
        }
        v0 = isLocalDoc = docID != null && docID.startsWith("_local") != false;
        if (!deleting) {
            deletingBoolean = (Boolean)body.getPropertyForKey("_deleted");
            v1 = deleting = deletingBoolean != null && deletingBoolean != false;
            if (docID == null) {
                if (isLocalDoc) {
                    outStatus.setCode(405);
                    return null;
                }
                docID = (String)body.getPropertyForKey("_id");
                if (docID == null) {
                    if (deleting) {
                        outStatus.setCode(400);
                        return null;
                    }
                    docID = Misc.CreateUUID();
                }
            }
            prevRevID = (String)body.getPropertyForKey("_rev");
        } else {
            prevRevID = this.getQuery("rev");
        }
        if (prevRevID == null) {
            prevRevID = this.getRevIDFromIfMatchHeader();
        }
        rev = new RevisionInternal(docID, null, deleting);
        rev.setBody(body);
        result = null;
        try {
            if (isLocalDoc) {
                fDb = _db;
                _rev = rev;
                _prevRevID = prevRevID;
                _revs = new ArrayList<E>();
                try {
                    fDb.getStore().runInTransaction(new TransactionalTask(){

                        @Override
                        public boolean run() {
                            try {
                                RevisionInternal r = fDb.getStore().putLocalRevision(_rev, _prevRevID, true);
                                _revs.add(r);
                                return true;
                            }
                            catch (CouchbaseLiteException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    if (_revs.size() <= 0) ** GOTO lbl43
                    result = (RevisionInternal)_revs.get(0);
                }
                catch (RuntimeException ex) {
                    if (ex.getCause() != null && ex.getCause().getCause() != null && ex.getCause().getCause() instanceof CouchbaseLiteException) {
                        throw (CouchbaseLiteException)ex.getCause().getCause();
                    }
                    throw new CouchbaseLiteException((Throwable)ex, 500);
                }
            } else {
                result = _db.putRevision(rev, prevRevID, allowConflict);
            }
lbl43:
            // 3 sources

            if (deleting) {
                outStatus.setCode(200);
            } else {
                outStatus.setCode(201);
            }
        }
        catch (CouchbaseLiteException e) {
            if (e.getCBLStatus() != null && e.getCBLStatus().getCode() == 409) {
                Log.w("Router", "Error updating doc: %s", new Object[]{docID});
            } else {
                Log.e("Router", "Error updating doc: %s", e, new Object[]{docID});
            }
            outStatus.setCode(e.getCBLStatus().getCode());
        }
        return result;
    }

    private Status update(Database _db, String docID, Body body, boolean deleting) {
        Status status = new Status();
        if (docID != null && !docID.isEmpty()) {
            String revParam = this.getQuery("rev");
            String ifMatch = this.getRequestHeaderValue("If-Match");
            if (ifMatch != null) {
                if (revParam == null) {
                    revParam = ifMatch;
                } else if (!ifMatch.equals(revParam)) {
                    return new Status(400);
                }
            }
            if (revParam != null && body != null) {
                String revProp = (String)body.getProperties().get("_rev");
                if (revProp == null) {
                    body.getProperties().put("_rev", revParam);
                } else if (!revParam.equals(revProp)) {
                    throw new IllegalArgumentException("Mismatch between _rev and rev");
                }
            }
        }
        RevisionInternal rev = this.update(_db, docID, body, deleting, false, status);
        if (status.isSuccessful()) {
            this.cacheWithEtag(rev.getRevID());
            if (!deleting) {
                URL url = this.connection.getURL();
                String urlString = url.toExternalForm();
                if (docID != null) {
                    urlString = urlString + '/' + rev.getDocID();
                    try {
                        url = new URL(urlString);
                    }
                    catch (MalformedURLException e) {
                        Log.w("Malformed URL", e);
                    }
                }
                this.setResponseLocation(url);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("ok", true);
            result.put("id", rev.getDocID());
            result.put("rev", rev.getRevID());
            this.connection.setResponseBody(new Body(result));
        }
        return status;
    }

    public Status do_PUT_Document(Database _db, String docID, String _attachmentName) throws CouchbaseLiteException {
        Status status = new Status(201);
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            throw new CouchbaseLiteException(400);
        }
        if (this.getQuery("new_edits") == null || this.getQuery("new_edits") != null && Boolean.valueOf(this.getQuery("new_edits")).booleanValue()) {
            status = this.update(_db, docID, new Body(body), false);
        } else {
            Body revBody = new Body(body);
            RevisionInternal rev = new RevisionInternal(revBody);
            if (rev.getRevID() == null || rev.getDocID() == null || !rev.getDocID().equals(docID)) {
                throw new CouchbaseLiteException(400);
            }
            List<String> history = Database.parseCouchDBRevisionHistory(revBody.getProperties());
            this.db.forceInsert(rev, history, this.source);
        }
        return status;
    }

    public Status do_DELETE_Document(Database _db, String docID, String _attachmentName) {
        return this.update(_db, docID, null, true);
    }

    private Status updateAttachment(String attachment, String docID, InputStream contentStream) throws CouchbaseLiteException {
        Status status = new Status(200);
        String revID = this.getQuery("rev");
        if (revID == null) {
            revID = this.getRevIDFromIfMatchHeader();
        }
        if (revID == null || revID.length() == 0) {
            throw new CouchbaseLiteException(400);
        }
        BlobStoreWriter body = null;
        if (contentStream != null) {
            body = new BlobStoreWriter(this.db.getAttachmentStore());
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyStream(contentStream, dataStream);
                body.appendData(dataStream.toByteArray());
                body.finish();
            }
            catch (Exception e) {
                throw new CouchbaseLiteException(e.getCause(), 491);
            }
            finally {
                try {
                    dataStream.close();
                }
                catch (IOException e) {
                    throw new CouchbaseLiteException(e.getCause(), 491);
                }
            }
        }
        RevisionInternal rev = this.db.updateAttachment(attachment, body, this.getRequestHeaderContentType(), AttachmentInternal.AttachmentEncoding.AttachmentEncodingNone, docID, revID, null);
        HashMap<String, Object> resultDict = new HashMap<String, Object>();
        resultDict.put("ok", true);
        resultDict.put("id", rev.getDocID());
        resultDict.put("rev", rev.getRevID());
        this.connection.setResponseBody(new Body(resultDict));
        this.cacheWithEtag(rev.getRevID());
        if (contentStream != null) {
            this.setResponseLocation(this.connection.getURL());
        }
        return status;
    }

    public Status do_PUT_Attachment(Database _db, String docID, String _attachmentName) throws CouchbaseLiteException {
        return this.updateAttachment(_attachmentName, docID, this.connection.getRequestInputStream());
    }

    public Status do_DELETE_Attachment(Database _db, String docID, String _attachmentName) throws CouchbaseLiteException {
        return this.updateAttachment(_attachmentName, docID, null);
    }

    private View compileView(String viewName, Map<String, Object> viewProps) {
        String mapSource;
        String language = (String)viewProps.get("language");
        if (language == null) {
            language = "javascript";
        }
        if ((mapSource = (String)viewProps.get("map")) == null) {
            return null;
        }
        Mapper mapBlock = View.getCompiler().compileMap(mapSource, language);
        if (mapBlock == null) {
            Log.w(TAG, "View %s has unknown map function: %s", viewName, mapSource);
            return null;
        }
        String reduceSource = (String)viewProps.get("reduce");
        Reducer reduceBlock = null;
        if (reduceSource != null && (reduceBlock = View.getCompiler().compileReduce(reduceSource, language)) == null) {
            Log.w(TAG, "View %s has unknown reduce function: %s", viewName, reduceBlock);
            return null;
        }
        View view = this.db.getView(viewName);
        view.setMapReduce(mapBlock, reduceBlock, "1");
        String collation = (String)viewProps.get("collation");
        if ("raw".equals(collation)) {
            view.setCollation(View.TDViewCollation.TDViewCollationRaw);
        }
        return view;
    }

    private Status queryDesignDoc(String designDoc, String viewName, List<Object> keys) throws CouchbaseLiteException {
        String tdViewName = String.format(Locale.ENGLISH, "%s/%s", designDoc, viewName);
        View view = this.db.getExistingView(tdViewName);
        if (view == null || view.getMap() == null) {
            RevisionInternal rev = this.db.getDocument(String.format(Locale.ENGLISH, "_design/%s", designDoc), null, true);
            if (rev == null) {
                return new Status(404);
            }
            Map views = (Map)rev.getProperties().get("views");
            Map viewProps = (Map)views.get(viewName);
            if (viewProps == null) {
                return new Status(404);
            }
            view = this.compileView(tdViewName, viewProps);
            if (view == null) {
                return new Status(500);
            }
        }
        QueryOptions options = new QueryOptions();
        if (view.getReduce() != null) {
            options.setReduce(true);
        }
        if (!this.getQueryOptions(options)) {
            return new Status(400);
        }
        if (keys != null) {
            options.setKeys(keys);
        }
        view.updateIndex();
        long lastSequenceIndexed = view.getLastSequenceIndexed();
        if (keys == null) {
            long eTag;
            long l = eTag = options.isIncludeDocs() ? this.db.getLastSequenceNumber() : lastSequenceIndexed;
            if (this.cacheWithEtag(String.format(Locale.ENGLISH, "%d", eTag))) {
                return new Status(304);
            }
        }
        List<QueryRow> queryRows = view.query(options);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (QueryRow queryRow : queryRows) {
            rows.add(queryRow.asJSONDictionary());
        }
        HashMap<String, Object> responseBody = new HashMap<String, Object>();
        responseBody.put("rows", rows);
        responseBody.put("total_rows", view.getCurrentTotalRows());
        responseBody.put("offset", options.getSkip());
        if (options.isUpdateSeq()) {
            responseBody.put("update_seq", lastSequenceIndexed);
        }
        this.connection.setResponseBody(new Body(responseBody));
        return new Status(200);
    }

    public Status do_GET_DesignDocument(Database _db, String designDocID, String viewName) throws CouchbaseLiteException {
        return this.queryDesignDoc(designDocID, viewName, null);
    }

    public Status do_POST_DesignDocument(Database _db, String designDocID, String viewName) throws CouchbaseLiteException {
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        List keys = (List)body.get("keys");
        return this.queryDesignDoc(designDocID, viewName, keys);
    }

    public void setSource(URL source) {
        this.source = source;
    }

    public String toString() {
        String url = "Unknown";
        if (this.connection != null && this.connection.getURL() != null) {
            url = this.connection.getURL().toExternalForm();
        }
        return String.format(Locale.ENGLISH, "Router [%s]", url);
    }

    private static enum TDContentOptions {
        TDIncludeAttachments,
        TDIncludeConflicts,
        TDIncludeRevs,
        TDIncludeRevsInfo,
        TDIncludeLocalSeq,
        TDNoBody,
        TDBigAttachmentsFollow,
        TDNoAttachments;

    }
}

