/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.storage;

import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.NativeLibraryUtils;

public class SQLiteNativeLibrary {
    private static final String TAG = "Database";
    public static final String JNI_SQLITE_CUSTOM_LIBRARY = "cbljavasqlitecustom";
    public static final String JNI_SQLCIPHER_LIBRARY = "cbljavasqlcipher";
    public static final String[] NATIVE_LIBRARY_OPTIONS = new String[]{"cbljavasqlcipher", "cbljavasqlitecustom"};
    public static String TEST_NATIVE_LIBRARY_NAME = null;
    private static final String JNI_KEY_LIBRARY = "cbljavakey";
    private static final String SHARED_ANDROID_SQLITE_LIBRARY = "sqlite";
    private static final String SHARED_SQLITE_LIBRARY = "sqlite3";
    private static final String SHARED_SQLCIPHER_LIBRARY = "sqlcipher";

    public static void load() {
        String[] libraryOption = TEST_NATIVE_LIBRARY_NAME != null ? new String[]{TEST_NATIVE_LIBRARY_NAME} : NATIVE_LIBRARY_OPTIONS;
        String loadedLibrary = null;
        boolean success = false;
        for (String libName : libraryOption) {
            if (JNI_SQLCIPHER_LIBRARY.equals(libName)) {
                if (SQLiteNativeLibrary.load(SHARED_SQLCIPHER_LIBRARY) && SQLiteNativeLibrary.load(JNI_KEY_LIBRARY)) {
                    success = SQLiteNativeLibrary.load(libName);
                }
            } else if (JNI_SQLITE_CUSTOM_LIBRARY.equals(libName)) {
                if (SQLiteNativeLibrary.load(SHARED_SQLITE_LIBRARY)) {
                    success = SQLiteNativeLibrary.load(libName);
                }
            } else {
                Log.e(TAG, "Unknown native library name : " + libName);
            }
            if (!success) continue;
            loadedLibrary = libName;
            break;
        }
        if (success) {
            Log.v(TAG, "Successfully load native library: " + loadedLibrary);
        } else {
            Log.e(TAG, "Cannot load native library");
        }
    }

    private static boolean load(String libName) {
        try {
            if (SQLiteNativeLibrary.isAndriod()) {
                return SQLiteNativeLibrary.loadSystemLibrary(libName);
            }
            return NativeLibraryUtils.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    private static boolean loadSystemLibrary(String libName) {
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        return true;
    }

    private static boolean isAndriod() {
        return System.getProperty("java.vm.name").equalsIgnoreCase("Dalvik");
    }
}

