/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.storage;

import com.couchbase.lite.internal.database.ContentValues;
import com.couchbase.lite.internal.database.DatabasePlatformSupport;
import com.couchbase.lite.internal.database.security.Key;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnection;
import com.couchbase.lite.internal.database.sqlite.SQLiteConnectionListener;
import com.couchbase.lite.internal.database.sqlite.SQLiteDatabase;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteConstraintException;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteDatabaseCorruptException;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.storage.SQLiteJsonCollator;
import com.couchbase.lite.storage.SQLiteNativeLibrary;
import com.couchbase.lite.storage.SQLiteRevCollator;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.support.security.SymmetricKey;
import com.couchbase.lite.util.Log;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SQLiteStorageEngineBase
implements SQLiteStorageEngine {
    private static final String TAG = "Database";
    private SQLiteDatabase database;
    private AtomicBoolean isSupportEncryption = null;
    private SymmetricKey encryptionKey;

    protected abstract DatabasePlatformSupport getDatabasePlatformSupport();

    protected abstract String getICUDatabasePath();

    protected abstract int getWALConnectionPoolSize();

    @Override
    public boolean open(String path, SymmetricKey encryptionKey) throws SQLException {
        if (this.database != null && this.database.isOpen()) {
            return true;
        }
        boolean hasError = false;
        try {
            if (encryptionKey != null && !this.supportEncryption()) {
                Log.w(TAG, "Encryption not available (app not built with SQLCipher)");
                throw new SQLException(501, "Encryption not available");
            }
            this.encryptionKey = encryptionKey;
            SQLiteDatabase.setDatabasePlatformSupport(this.getDatabasePlatformSupport());
            this.database = SQLiteDatabase.openDatabase(path, null, 0x30000000, this.getWALConnectionPoolSize(), null, new ConnectionListener());
            Log.v(TAG, "%s: Opened Android sqlite db", this);
        }
        catch (SQLiteDatabaseCorruptException e) {
            hasError = true;
            Log.e(TAG, "Unauthorize to open the SQLite database", e);
            throw new SQLException(401, "Cannot decrypt or access the database");
        }
        catch (com.couchbase.lite.internal.database.SQLException e) {
            hasError = true;
            Log.e(TAG, "Unable to open the SQLite database", e);
            throw new SQLException(e);
        }
        finally {
            if (hasError && this.database != null) {
                this.database.close();
            }
        }
        return this.database.isOpen();
    }

    private static void decrypt(SQLiteConnection connection, SymmetricKey key) throws com.couchbase.lite.internal.database.SQLException {
        if (key != null) {
            try {
                connection.execute("PRAGMA key = \"x'" + key.getHexData() + "'\"", null, null);
            }
            catch (SQLException e) {
                Log.w(TAG, "'pragma key' failed", e);
                throw e;
            }
        }
        try {
            connection.executeForLong("SELECT count(*) FROM sqlite_master", null, null);
        }
        catch (com.couchbase.lite.internal.database.SQLException e) {
            Log.w(TAG, "Decrypting database failed", e);
            throw e;
        }
    }

    @Override
    public int getVersion() {
        return this.database.getVersion();
    }

    @Override
    public void setVersion(int version) {
        this.database.setVersion(version);
    }

    @Override
    public boolean isOpen() {
        return this.database != null && this.database.isOpen();
    }

    @Override
    public void beginTransaction() {
        this.database.beginTransaction();
    }

    @Override
    public void endTransaction() {
        this.database.endTransaction();
    }

    @Override
    public void setTransactionSuccessful() {
        this.database.setTransactionSuccessful();
    }

    @Override
    public void execSQL(String sql) throws SQLException {
        try {
            this.database.execSQL(sql);
        }
        catch (com.couchbase.lite.internal.database.SQLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        try {
            this.database.execSQL(sql, bindArgs);
        }
        catch (com.couchbase.lite.internal.database.SQLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return new SQLiteCursor(this.database.rawQuery(sql, selectionArgs));
    }

    @Override
    public long insert(String table, String nullColumnHack, ContentValues values) {
        return this.database.insert(table, nullColumnHack, values);
    }

    @Override
    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        try {
            return this.database.insertOrThrow(table, nullColumnHack, values);
        }
        catch (com.couchbase.lite.internal.database.SQLException e) {
            if (e instanceof SQLiteConstraintException) {
                throw new SQLException(19, (Throwable)e);
            }
            throw new SQLException(e);
        }
    }

    @Override
    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        return this.database.insertWithOnConflict(table, nullColumnHack, initialValues, conflictAlgorithm);
    }

    @Override
    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.database.update(table, values, whereClause, whereArgs);
    }

    @Override
    public int delete(String table, String whereClause, String[] whereArgs) {
        return this.database.delete(table, whereClause, whereArgs);
    }

    @Override
    public void close() {
        this.database.close();
    }

    @Override
    public boolean supportEncryption() {
        if (this.isSupportEncryption == null) {
            boolean support = SQLiteDatabase.isSupportEncryption();
            this.isSupportEncryption = new AtomicBoolean(support);
        }
        return this.isSupportEncryption.get();
    }

    @Override
    public byte[] derivePBKDF2SHA256Key(String password, byte[] salt, int rounds) {
        if (!this.supportEncryption()) {
            return null;
        }
        return Key.derivePBKDF2SHA256Key(password, salt, rounds);
    }

    public String toString() {
        return "SQLiteStorageEngine {database=" + Integer.toHexString(System.identityHashCode(this.database)) + '}';
    }

    static {
        SQLiteNativeLibrary.load();
    }

    private class SQLiteCursor
    implements Cursor {
        private com.couchbase.lite.internal.database.cursor.Cursor cursor;

        public SQLiteCursor(com.couchbase.lite.internal.database.cursor.Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean moveToNext() {
            return this.cursor.moveToNext();
        }

        @Override
        public boolean isAfterLast() {
            return this.cursor.isAfterLast();
        }

        @Override
        public String getString(int columnIndex) {
            return this.cursor.getString(columnIndex);
        }

        @Override
        public int getInt(int columnIndex) {
            return this.cursor.getInt(columnIndex);
        }

        @Override
        public long getLong(int columnIndex) {
            return this.cursor.getLong(columnIndex);
        }

        @Override
        public byte[] getBlob(int columnIndex) {
            return this.cursor.getBlob(columnIndex);
        }

        @Override
        public void close() {
            this.cursor.close();
        }

        @Override
        public boolean isNull(int columnIndex) {
            return this.cursor.isNull(columnIndex);
        }
    }

    private class ConnectionListener
    implements SQLiteConnectionListener {
        private ConnectionListener() {
        }

        @Override
        public void onOpen(SQLiteConnection connection) {
            SQLiteStorageEngineBase.decrypt(connection, SQLiteStorageEngineBase.this.encryptionKey);
            String icuDataPath = SQLiteStorageEngineBase.this.getICUDatabasePath();
            SQLiteJsonCollator.register(connection.getConnectionHandle(), connection.getLocale().toString(), icuDataPath);
            SQLiteRevCollator.register(connection.getConnectionHandle());
        }

        @Override
        public void onClose(SQLiteConnection connection) {
        }
    }
}

