/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.store;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.Revision;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.TransactionalTask;
import com.couchbase.lite.View;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.internal.database.ContentValues;
import com.couchbase.lite.internal.database.sqlite.exception.SQLiteDatabaseLockedException;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.storage.SQLiteStorageEngineFactory;
import com.couchbase.lite.store.EncryptableStore;
import com.couchbase.lite.store.SQLiteViewStore;
import com.couchbase.lite.store.StorageValidation;
import com.couchbase.lite.store.Store;
import com.couchbase.lite.store.StoreDelegate;
import com.couchbase.lite.store.ViewStore;
import com.couchbase.lite.support.RevisionUtils;
import com.couchbase.lite.support.action.Action;
import com.couchbase.lite.support.action.ActionBlock;
import com.couchbase.lite.support.action.ActionException;
import com.couchbase.lite.support.security.SymmetricKey;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.SQLiteUtils;
import com.couchbase.lite.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SQLiteStore
implements Store,
EncryptableStore {
    public String TAG = "Database";
    public static String kDBFilename = "db.sqlite3";
    private static final int kTransactionMaxRetries = 10;
    private static final int kTransactionRetryDelay = 50;
    private static final int DEFAULT_MAX_REVS = Integer.MAX_VALUE;
    private static final byte[] EMPTY_JSON_OBJECT_CHARS = new byte[]{123, 125};
    public static final String SCHEMA = "CREATE TABLE docs (         doc_id INTEGER PRIMARY KEY,         docid TEXT UNIQUE NOT NULL);     CREATE INDEX docs_docid ON docs(docid);     CREATE TABLE revs (         sequence INTEGER PRIMARY KEY AUTOINCREMENT,         doc_id INTEGER NOT NULL REFERENCES docs(doc_id) ON DELETE CASCADE,         revid TEXT NOT NULL COLLATE REVID,         parent INTEGER REFERENCES revs(sequence) ON DELETE SET NULL,         current BOOLEAN,         deleted BOOLEAN DEFAULT 0,         json BLOB,         no_attachments BOOLEAN,         UNIQUE (doc_id, revid));     CREATE INDEX revs_parent ON revs(parent);     CREATE INDEX revs_by_docid_revid ON revs(doc_id, revid desc, current, deleted);     CREATE INDEX revs_current ON revs(doc_id, current desc, deleted, revid desc);     CREATE TABLE localdocs (         docid TEXT UNIQUE NOT NULL,         revid TEXT NOT NULL COLLATE REVID,         json BLOB);     CREATE INDEX localdocs_by_docid ON localdocs(docid);     CREATE TABLE views (         view_id INTEGER PRIMARY KEY,         name TEXT UNIQUE NOT NULL,        version TEXT,         lastsequence INTEGER DEFAULT 0,        total_docs INTEGER DEFAULT -1);     CREATE INDEX views_by_name ON views(name);     CREATE TABLE info (        key TEXT PRIMARY KEY,        value TEXT);    PRAGMA user_version = 17";
    private String directory;
    private String path;
    private Manager manager;
    private SQLiteStorageEngine storageEngine;
    private TransactionLevel transactionLevel;
    private StoreDelegate delegate;
    private int maxRevTreeDepth;
    private boolean autoCompact;
    private SymmetricKey encryptionKey;
    private final Object compactLock = new Object();

    public SQLiteStore(String directory, Manager manager, StoreDelegate delegate) throws CouchbaseLiteException {
        assert (new File(directory).isAbsolute());
        this.directory = directory;
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("directory '" + directory + "' does not exist or not directory");
        }
        this.path = new File(directory, kDBFilename).getPath();
        this.manager = manager;
        this.storageEngine = null;
        this.transactionLevel = new TransactionLevel();
        this.delegate = delegate;
        this.maxRevTreeDepth = Integer.MAX_VALUE;
    }

    @Override
    public boolean databaseExists(String directory) {
        return new File(directory, kDBFilename).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open() throws CouchbaseLiteException {
        if (this.storageEngine == null) {
            this.storageEngine = this.createStorageEngine();
        }
        if (this.storageEngine.isOpen()) {
            return;
        }
        boolean isOpenSuccess = false;
        try {
            this.storageEngine.open(this.path, this.encryptionKey);
            isOpenSuccess = true;
        }
        catch (SQLException e) {
            String message = "Unable to create a storage engine";
            Log.e(this.TAG, message, e);
            int statusCode = e.getCode() == 401 ? 401 : (e.getCode() == 501 ? 501 : 590);
            throw new CouchbaseLiteException(message, (Throwable)e, statusCode);
        }
        finally {
            if (!isOpenSuccess) {
                this.close();
            }
        }
        try {
            this.initialize("PRAGMA foreign_keys = ON;");
        }
        catch (SQLException e) {
            String message = "Cannot set enforcement of foreign key constraints";
            Log.e(this.TAG, message, e);
            throw new CouchbaseLiteException(message, (Throwable)e, 590);
        }
        int dbVersion = this.storageEngine.getVersion();
        if (dbVersion >= 200) {
            this.close();
            String message = "Database version " + dbVersion + " is newer than I know how to work with";
            Log.e(this.TAG, message);
            throw new CouchbaseLiteException(message, 406);
        }
        boolean isSuccessful = false;
        if (!this.beginTransaction()) {
            this.close();
            String message = "Cannot begin transaction";
            Log.e(this.TAG, message);
            throw new CouchbaseLiteException(message, 590);
        }
        try {
            String upgradeSql;
            boolean isNew;
            boolean bl = isNew = dbVersion == 0;
            if (dbVersion < 17) {
                if (!isNew) {
                    String message = "Database version " + dbVersion + " is older than I know how to work with";
                    Log.e(this.TAG, message);
                    throw new CouchbaseLiteException(message, 406);
                }
                try {
                    this.initialize(SCHEMA);
                }
                catch (SQLException e) {
                    String message = "Cannot initialize database schema";
                    Log.e(this.TAG, message, e);
                    throw new CouchbaseLiteException(message, (Throwable)e, 590);
                }
                dbVersion = 17;
            }
            if (dbVersion < 21) {
                upgradeSql = "ALTER TABLE revs ADD COLUMN doc_type TEXT; PRAGMA user_version = 21";
                try {
                    this.initialize(upgradeSql);
                }
                catch (SQLException e) {
                    String message = "Cannot update revs table";
                    Log.e(this.TAG, message, e);
                    throw new CouchbaseLiteException(message, (Throwable)e, 590);
                }
                dbVersion = 21;
            }
            if (dbVersion < 101) {
                upgradeSql = "PRAGMA user_version = 101";
                try {
                    this.initialize(upgradeSql);
                }
                catch (SQLException e) {
                    String message = "Cannot update user_version to " + dbVersion;
                    Log.e(this.TAG, message, e);
                    throw new CouchbaseLiteException(message, (Throwable)e, 590);
                }
                dbVersion = 101;
            }
            if (dbVersion < 102) {
                upgradeSql = "ALTER TABLE docs ADD COLUMN expiry_timestamp INTEGER; CREATE INDEX IF NOT EXISTS docs_expiry ON docs(expiry_timestamp) WHERE expiry_timestamp not null; PRAGMA user_version = 102";
                try {
                    this.initialize(upgradeSql);
                }
                catch (SQLException e) {
                    String message = "Cannot update user_version to " + dbVersion;
                    Log.e(this.TAG, message, e);
                    throw new CouchbaseLiteException(message, (Throwable)e, 590);
                }
                dbVersion = 102;
            }
            if (isNew) {
                this.setInfo("pruned", "true");
            }
            if (!isNew) {
                this.optimizeSQLIndexes();
            }
            isSuccessful = true;
        }
        finally {
            this.endTransaction(isSuccessful);
            if (!isSuccessful) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        if (this.storageEngine != null && this.storageEngine.isOpen()) {
            this.storageEngine.close();
        }
        this.storageEngine = null;
    }

    private SQLiteStorageEngine createStorageEngine() throws CouchbaseLiteException {
        SQLiteStorageEngineFactory factory = this.manager.getContext().getSQLiteStorageEngineFactory();
        SQLiteStorageEngine engine = factory.createStorageEngine();
        if (engine == null) {
            String message = "Unable to create a storage engine, fatal error";
            Log.e(this.TAG, message);
            throw new CouchbaseLiteException(message, 500);
        }
        return engine;
    }

    @Override
    public void setDelegate(StoreDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public StoreDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setMaxRevTreeDepth(int maxRevTreeDepth) {
        this.maxRevTreeDepth = maxRevTreeDepth;
    }

    @Override
    public int getMaxRevTreeDepth() {
        return this.maxRevTreeDepth;
    }

    @Override
    public void setAutoCompact(boolean value) {
        this.autoCompact = value;
    }

    @Override
    public boolean getAutoCompact() {
        return this.autoCompact;
    }

    private void decrypt(SymmetricKey encryptionKey) throws CouchbaseLiteException {
        if (encryptionKey != null) {
            if (!this.storageEngine.supportEncryption()) {
                Log.w(this.TAG, "SQLiteStore: encryption not available (app not built with SQLCipher)");
                throw new CouchbaseLiteException("Encryption not available", 501);
            }
            try {
                this.storageEngine.execSQL("PRAGMA key = \"x'" + encryptionKey.getHexData() + "'\"");
            }
            catch (SQLException e) {
                Log.w(this.TAG, "SQLiteStore: 'pragma key' failed", e);
                throw e;
            }
        }
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery("SELECT count(*) FROM sqlite_master", null);
            if (cursor == null || !cursor.moveToNext()) {
                Log.w(this.TAG, "SQLiteStore: database is unreadable, unknown error");
                throw new CouchbaseLiteException("Cannot decrypt or access the database", 590);
            }
        }
        catch (Exception e) {
            Log.w(this.TAG, "SQLiteStore: database is unreadable", e);
            if (e.getMessage() != null && e.getMessage().contains("file is encrypted or is not a database (code 26)")) {
                throw new CouchbaseLiteException("Cannot decrypt or access the database", 401);
            }
            throw new CouchbaseLiteException((Throwable)e, 590);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public void setEncryptionKey(SymmetricKey key) {
        this.encryptionKey = key;
    }

    @Override
    public SymmetricKey getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public Action actionToChangeEncryptionKey(final SymmetricKey newKey) {
        if (!this.storageEngine.supportEncryption()) {
            return null;
        }
        Action action = new Action();
        final AtomicBoolean dbWasClosed = new AtomicBoolean(false);
        final File tempDbFile = new File(this.manager.getDirectory(), Misc.CreateUUID());
        action.add(null, new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                if (tempDbFile.exists() && !tempDbFile.delete()) {
                    throw new ActionException("Cannot delete the temp database file " + tempDbFile.getAbsolutePath());
                }
            }
        }, null);
        action.add(new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                String keyStr = newKey != null ? newKey.getHexData() : "";
                String sql = "ATTACH DATABASE ? AS rekeyed_db KEY \"x'" + keyStr + "'\"";
                Object[] args = new String[]{tempDbFile.getAbsolutePath()};
                try {
                    SQLiteStore.this.storageEngine.execSQL(sql, args);
                }
                catch (Exception e) {
                    throw new ActionException(e);
                }
            }
        }, new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                if (dbWasClosed.get()) {
                    return;
                }
                try {
                    SQLiteStore.this.storageEngine.execSQL("DETACH DATABASE rekeyed_db");
                }
                catch (Exception e) {
                    throw new ActionException(e);
                }
            }
        });
        action.add(new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                try {
                    SQLiteStore.this.storageEngine.execSQL("SELECT sqlcipher_export('rekeyed_db')");
                    SQLiteStore.this.storageEngine.execSQL("PRAGMA rekeyed_db.user_version = " + SQLiteStore.this.storageEngine.getVersion());
                }
                catch (Exception e) {
                    throw new ActionException(e);
                }
            }
        }, null, null);
        action.add(new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                SQLiteStore.this.storageEngine.close();
                dbWasClosed.set(true);
            }
        }, new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                try {
                    SQLiteStore.this.open();
                }
                catch (CouchbaseLiteException e) {
                    throw new ActionException("Cannot open the SQLiteStore", e);
                }
            }
        }, new ActionBlock(){

            @Override
            public void execute() throws ActionException {
                SQLiteStore.this.setEncryptionKey(newKey);
                try {
                    SQLiteStore.this.open();
                }
                catch (CouchbaseLiteException e) {
                    throw new ActionException("Cannot open the SQLiteStore", e);
                }
            }
        });
        action.add(Action.moveAndReplaceFile(tempDbFile.getAbsolutePath(), this.path, this.manager.getContext().getTempDir().getAbsolutePath()));
        return action;
    }

    @Override
    public byte[] derivePBKDF2SHA256Key(String password, byte[] salt, int rounds) throws CouchbaseLiteException {
        if (this.storageEngine == null) {
            this.storageEngine = this.createStorageEngine();
        }
        if (!this.storageEngine.supportEncryption()) {
            Log.w(this.TAG, "SQLiteStore: encryption not available (app not built with SQLCipher)");
            throw new CouchbaseLiteException("Encryption not available", 501);
        }
        byte[] result = this.storageEngine.derivePBKDF2SHA256Key(password, salt, rounds);
        if (result == null) {
            throw new CouchbaseLiteException("Cannot derive key for the password", 400);
        }
        return result;
    }

    @Override
    public long setInfo(String key, String info) {
        ContentValues args = new ContentValues();
        args.put("key", key);
        args.put("value", info);
        if (this.storageEngine.insertWithOnConflict("info", null, args, 5) == -1L) {
            return 590L;
        }
        return 200L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo(String key) {
        String result = null;
        Cursor cursor = null;
        try {
            String[] args = new String[]{key};
            cursor = this.storageEngine.rawQuery("SELECT value FROM info WHERE key=?", args);
            if (cursor.moveToNext()) {
                result = cursor.getString(0);
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error querying " + key, e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDocumentCount() {
        String sql = "SELECT COUNT(DISTINCT doc_id) FROM revs WHERE current=1 AND deleted=0";
        Cursor cursor = null;
        int result = 0;
        try {
            cursor = this.storageEngine.rawQuery(sql, null);
            if (cursor.moveToNext()) {
                result = cursor.getInt(0);
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error getting document count", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastSequence() {
        String sql = "SELECT MAX(sequence) FROM revs";
        Cursor cursor = null;
        long result = 0L;
        try {
            cursor = this.storageEngine.rawQuery(sql, null);
            if (cursor.moveToNext()) {
                result = cursor.getLong(0);
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error getting last sequence", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @Override
    public boolean inTransaction() {
        return (Integer)this.transactionLevel.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() throws CouchbaseLiteException {
        Log.v(this.TAG, "Begin database compaction...");
        Object object = this.compactLock;
        synchronized (object) {
            boolean shouldCommit = false;
            this.beginTransaction();
            try {
                if (this.getInfo("pruned") == null) {
                    this.pruneRevsToMaxDepth(this.maxRevTreeDepth);
                    this.setInfo("pruned", "true");
                }
                try {
                    Log.v(this.TAG, "Deleting JSON of old revisions...");
                    ContentValues args = new ContentValues();
                    args.put("json", (String)null);
                    args.put("doc_type", (String)null);
                    args.put("no_attachments", 1);
                    int changes = this.storageEngine.update("revs", args, "current=0", null);
                    Log.v(this.TAG, "... deleted %d revisions", changes);
                }
                catch (SQLException e) {
                    Log.e(this.TAG, "Error compacting", e);
                    throw new CouchbaseLiteException(500);
                }
                shouldCommit = true;
            }
            finally {
                this.endTransaction(shouldCommit);
            }
            Log.v(this.TAG, "Flushing SQLite WAL...");
            try {
                this.storageEngine.execSQL("PRAGMA wal_checkpoint(RESTART)");
            }
            catch (SQLException e) {
                Log.e(this.TAG, "Error PRAGMA wal_checkpoint(RESTART)", e);
                throw new CouchbaseLiteException(500);
            }
            Log.v(this.TAG, "Vacuuming SQLite database...");
            try {
                this.storageEngine.execSQL("VACUUM");
            }
            catch (SQLException e) {
                Log.e(this.TAG, "Error vacuuming sqliteDb", e);
                throw new CouchbaseLiteException(500);
            }
        }
        Log.v(this.TAG, "...Finished database compaction.");
    }

    @Override
    public boolean runInTransaction(TransactionalTask transactionalTask) {
        boolean shouldCommit = true;
        this.beginTransaction();
        try {
            shouldCommit = transactionalTask.run();
        }
        catch (Exception e) {
            shouldCommit = false;
            Log.e(this.TAG, e.toString(), e);
            throw new RuntimeException(e);
        }
        finally {
            this.endTransaction(shouldCommit);
        }
        return shouldCommit;
    }

    boolean runInOuterTransaction(TransactionalTask transactionalTask) {
        if (!this.inTransaction()) {
            return this.runInTransaction(transactionalTask);
        }
        return transactionalTask.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevisionInternal getDocument(String docID, String revID, boolean withBody) {
        long docNumericID = this.getDocNumericID(docID);
        if (docNumericID < 0L) {
            return null;
        }
        RevisionInternal result = null;
        Cursor cursor = null;
        try {
            String[] args;
            cursor = null;
            String cols = "revid, deleted, sequence";
            if (withBody) {
                cols = cols + ", json";
            }
            if (revID != null) {
                String sql = "SELECT " + cols + " FROM revs WHERE revs.doc_id=? AND revid=? AND json notnull LIMIT 1";
                args = new String[]{Long.toString(docNumericID), revID};
                cursor = this.storageEngine.rawQuery(sql, args);
            } else {
                String sql = "SELECT " + cols + " FROM revs WHERE revs.doc_id=? and current=1 and deleted=0 ORDER BY revid DESC LIMIT 1";
                args = new String[]{Long.toString(docNumericID)};
                cursor = this.storageEngine.rawQuery(sql, args);
            }
            if (cursor.moveToNext()) {
                if (revID == null) {
                    revID = cursor.getString(0);
                }
                boolean deleted = cursor.getInt(1) > 0;
                result = new RevisionInternal(docID, revID, deleted);
                result.setSequence(cursor.getLong(2));
                if (withBody) {
                    byte[] json = cursor.getBlob(3);
                    result.setJSON(json);
                }
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error getting document with id and rev", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @Override
    public RevisionInternal loadRevisionBody(RevisionInternal rev) throws CouchbaseLiteException {
        if (rev.getBody() != null && rev.getSequence() != 0L) {
            return rev;
        }
        assert (rev.getDocID() != null && rev.getRevID() != null);
        long docNumericID = this.getDocNumericID(rev.getDocID());
        if (docNumericID <= 0L) {
            throw new CouchbaseLiteException(404);
        }
        Cursor cursor = null;
        Status result = new Status(404);
        try {
            byte[] json;
            String sql = "SELECT sequence, json FROM revs WHERE doc_id=? AND revid=? LIMIT 1";
            String[] args = new String[]{String.valueOf(docNumericID), rev.getRevID()};
            cursor = this.storageEngine.rawQuery(sql, args);
            if (cursor.moveToNext() && (json = cursor.getBlob(1)) != null) {
                result.setCode(200);
                rev.setSequence(cursor.getLong(0));
                rev.setJSON(json);
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error loading revision body", e);
            throw new CouchbaseLiteException(500);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (result.getCode() == 404) {
            throw new CouchbaseLiteException(result);
        }
        return rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevisionInternal getParentRevision(RevisionInternal rev) {
        long seq = rev.getSequence();
        if (seq > 0L) {
            seq = SQLiteUtils.longForQuery(this.storageEngine, "SELECT parent FROM revs WHERE sequence=?", new String[]{Long.toString(seq)});
        } else {
            long docNumericID = this.getDocNumericID(rev.getDocID());
            if (docNumericID <= 0L) {
                return null;
            }
            String[] args = new String[]{Long.toString(docNumericID), rev.getRevID()};
            seq = SQLiteUtils.longForQuery(this.storageEngine, "SELECT parent FROM revs WHERE doc_id=? and revid=?", args);
        }
        if (seq == 0L) {
            return null;
        }
        RevisionInternal result = null;
        String[] args = new String[]{Long.toString(seq)};
        String queryString = "SELECT revid, deleted FROM revs WHERE sequence=?";
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery(queryString, args);
            if (cursor.moveToNext()) {
                String revId = cursor.getString(0);
                boolean deleted = cursor.getInt(1) > 0;
                result = new RevisionInternal(rev.getDocID(), revId, deleted);
                result.setSequence(seq);
            }
        }
        finally {
            cursor.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RevisionInternal> getRevisionHistory(RevisionInternal rev) {
        ArrayList<RevisionInternal> result;
        String docId = rev.getDocID();
        String revId = rev.getRevID();
        assert (docId != null && revId != null);
        long docNumericId = this.getDocNumericID(docId);
        if (docNumericId < 0L) {
            return null;
        }
        if (docNumericId == 0L) {
            return new ArrayList<RevisionInternal>();
        }
        String sql = "SELECT sequence, parent, revid, deleted, json isnull FROM revs WHERE doc_id=? ORDER BY sequence DESC";
        String[] args = new String[]{Long.toString(docNumericId)};
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery(sql, args);
            cursor.moveToNext();
            long lastSequence = 0L;
            result = new ArrayList<RevisionInternal>();
            while (!cursor.isAfterLast()) {
                long sequence = cursor.getLong(0);
                boolean matches = false;
                if (lastSequence == 0L) {
                    matches = revId.equals(cursor.getString(2));
                } else {
                    boolean bl = matches = sequence == lastSequence;
                }
                if (matches) {
                    revId = cursor.getString(2);
                    boolean deleted = cursor.getInt(3) > 0;
                    boolean missing = cursor.getInt(4) > 0;
                    RevisionInternal aRev = new RevisionInternal(docId, revId, deleted);
                    aRev.setMissing(missing);
                    aRev.setSequence(cursor.getLong(0));
                    result.add(aRev);
                    lastSequence = cursor.getLong(1);
                    if (lastSequence == 0L) {
                        break;
                    }
                }
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error getting revision history", e);
            List<RevisionInternal> list = null;
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevisionList getAllRevisions(String docId, long docNumericID, boolean onlyCurrent) {
        String sql = null;
        sql = onlyCurrent ? "SELECT sequence, revid, deleted FROM revs WHERE doc_id=? AND current ORDER BY sequence DESC" : "SELECT sequence, revid, deleted FROM revs WHERE doc_id=? ORDER BY sequence DESC";
        String[] args = new String[]{Long.toString(docNumericID)};
        Cursor cursor = this.storageEngine.rawQuery(sql, args);
        RevisionList result = null;
        try {
            cursor.moveToNext();
            result = new RevisionList();
            while (!cursor.isAfterLast()) {
                RevisionInternal rev = new RevisionInternal(docId, cursor.getString(1), cursor.getInt(2) > 0);
                rev.setSequence(cursor.getLong(0));
                result.add(rev);
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            RevisionList revisionList = null;
            return revisionList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPossibleAncestorRevisionIDs(RevisionInternal rev, int limit, AtomicBoolean onlyAttachments) {
        int generation = rev.getGeneration();
        if (generation <= 1) {
            return null;
        }
        long docNumericID = this.getDocNumericID(rev.getDocID());
        if (docNumericID <= 0L) {
            return null;
        }
        ArrayList<String> revIDs = new ArrayList<String>();
        int sqlLimit = limit > 0 ? limit : -1;
        StringBuilder sql = new StringBuilder("SELECT revid, sequence FROM revs WHERE doc_id=? and revid < ?");
        sql.append(" and deleted=0 and json not null");
        sql.append(" and no_attachments=0");
        sql.append(" ORDER BY sequence DESC LIMIT ?");
        String[] args = new String[]{Long.toString(docNumericID), generation + "-", Integer.toString(sqlLimit)};
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery(sql.toString(), args);
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                if (onlyAttachments != null && revIDs.size() == 0) {
                    onlyAttachments.set(this.sequenceHasAttachments(cursor.getLong(1)));
                }
                revIDs.add(cursor.getString(0));
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error getting all revisions of document", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return revIDs;
    }

    @Override
    public String findCommonAncestorOf(RevisionInternal rev, List<String> revIDs) {
        if (revIDs == null || revIDs.size() == 0) {
            return null;
        }
        long docNumericID = this.getDocNumericID(rev.getDocID());
        if (docNumericID <= 0L) {
            return null;
        }
        String quotedRevIds = TextUtils.joinQuoted(revIDs);
        String sql = String.format(Locale.ENGLISH, "SELECT revid FROM revs WHERE doc_id=? and revid in (%s) and revid <= ? ORDER BY revid DESC LIMIT 1", quotedRevIds);
        String[] args = new String[]{Long.toString(docNumericID), rev.getRevID()};
        return SQLiteUtils.stringForQuery(this.storageEngine, sql, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findMissingRevisions(RevisionList touchRevs) throws SQLException {
        int numRevisionsRemoved = 0;
        if (touchRevs.size() == 0) {
            return numRevisionsRemoved;
        }
        String quotedDocIds = TextUtils.joinQuoted(touchRevs.getAllDocIds());
        String quotedRevIds = TextUtils.joinQuoted(touchRevs.getAllRevIds());
        String sql = "SELECT docid, revid FROM revs, docs WHERE docid IN (" + quotedDocIds + ") AND revid in (" + quotedRevIds + ')' + " AND revs.doc_id == docs.doc_id";
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery(sql, null);
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                RevisionInternal rev = touchRevs.revWithDocIdAndRevId(cursor.getString(0), cursor.getString(1));
                if (rev != null) {
                    touchRevs.remove(rev);
                    ++numRevisionsRemoved;
                }
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return numRevisionsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BlobKey> findAllAttachmentKeys() throws CouchbaseLiteException {
        HashSet<BlobKey> allKeys = new HashSet<BlobKey>();
        String sql = "SELECT json FROM revs WHERE no_attachments != 1";
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery(sql, null);
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                byte[] json = cursor.getBlob(0);
                if (json != null && json.length > 0) {
                    try {
                        Map docProperties = (Map)Manager.getObjectMapper().readValue(json, Map.class);
                        if (docProperties.containsKey("_attachments")) {
                            Map attachments = (Map)docProperties.get("_attachments");
                            for (String name : attachments.keySet()) {
                                Map attachment = (Map)attachments.get(name);
                                String digest = (String)attachment.get("digest");
                                BlobKey key = new BlobKey(digest);
                                allKeys.add(key);
                            }
                        }
                    }
                    catch (IOException e) {
                        Log.e(this.TAG, e.toString(), e);
                    }
                }
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return allKeys;
    }

    @Override
    public Map<String, Object> getAllDocs(QueryOptions options) throws CouchbaseLiteException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<QueryRow> rows = new ArrayList<QueryRow>();
        if (options == null) {
            options = new QueryOptions();
        }
        boolean includeDeletedDocs = options.getAllDocsMode() == Query.AllDocsMode.INCLUDE_DELETED;
        long updateSeq = 0L;
        if (options.isUpdateSeq()) {
            updateSeq = this.getLastSequence();
        }
        StringBuilder sql = new StringBuilder("SELECT revs.doc_id, docid, revid, sequence");
        if (options.isIncludeDocs()) {
            sql.append(", json, no_attachments");
        }
        if (includeDeletedDocs) {
            sql.append(", deleted");
        }
        sql.append(" FROM revs, docs WHERE");
        if (options.getKeys() != null) {
            if (options.getKeys().size() == 0) {
                return result;
            }
            String commaSeperatedIds = TextUtils.joinQuotedObjects(options.getKeys());
            sql.append(String.format(Locale.ENGLISH, " revs.doc_id IN (SELECT doc_id FROM docs WHERE docid IN (%s)) AND", commaSeperatedIds));
        }
        sql.append(" docs.doc_id = revs.doc_id AND current=1");
        if (!includeDeletedDocs) {
            sql.append(" AND deleted=0");
        }
        ArrayList<String> args = new ArrayList<String>();
        Object minKey = options.getStartKey();
        Object maxKey = options.getEndKey();
        boolean inclusiveMin = true;
        boolean inclusiveMax = options.isInclusiveEnd();
        if (options.isDescending()) {
            minKey = maxKey;
            maxKey = options.getStartKey();
            inclusiveMin = inclusiveMax;
            inclusiveMax = true;
        }
        if (minKey != null) {
            assert (minKey instanceof String);
            sql.append(inclusiveMin ? " AND docid >= ?" : " AND docid > ?");
            args.add((String)minKey);
        }
        if (maxKey != null) {
            assert (maxKey instanceof String);
            maxKey = View.keyForPrefixMatch(maxKey, options.getPrefixMatchLevel());
            sql.append(inclusiveMax ? " AND docid <= ?" : " AND docid < ?");
            args.add((String)maxKey);
        }
        sql.append(String.format(Locale.ENGLISH, " ORDER BY docid %s, %s revid DESC LIMIT ? OFFSET ?", options.isDescending() ? "DESC" : "ASC", includeDeletedDocs ? "deleted ASC," : ""));
        args.add(Integer.toString(options.getLimit()));
        args.add(Integer.toString(options.getSkip()));
        Cursor cursor = null;
        HashMap<String, QueryRow> docs = new HashMap<String, QueryRow>();
        try {
            String docID;
            cursor = this.storageEngine.rawQuery(sql.toString(), args.toArray(new String[args.size()]));
            boolean keepGoing = cursor.moveToNext();
            while (keepGoing) {
                long docNumericID = cursor.getLong(0);
                docID = cursor.getString(1);
                String revID = cursor.getString(2);
                long sequence = cursor.getLong(3);
                boolean deleted = includeDeletedDocs && cursor.getInt(SQLiteStore.getDeletedColumnIndex(options)) > 0;
                RevisionInternal docRevision = null;
                if (options.isIncludeDocs()) {
                    byte[] json = cursor.getBlob(4);
                    Map<String, Object> properties = this.documentPropertiesFromJSON(json, docID, revID, false, sequence);
                    docRevision = SQLiteStore.revision(docID, revID, false, sequence, properties);
                }
                ArrayList<String> conflicts = new ArrayList<String>();
                while ((keepGoing = cursor.moveToNext()) && cursor.getLong(0) == docNumericID) {
                    if (options.getAllDocsMode() != Query.AllDocsMode.SHOW_CONFLICTS && options.getAllDocsMode() != Query.AllDocsMode.ONLY_CONFLICTS) continue;
                    if (conflicts.isEmpty()) {
                        conflicts.add(revID);
                    }
                    conflicts.add(cursor.getString(2));
                }
                if (options.getAllDocsMode() == Query.AllDocsMode.ONLY_CONFLICTS && conflicts.isEmpty()) continue;
                HashMap<String, Object> value = new HashMap<String, Object>();
                value.put("rev", revID);
                value.put("_conflicts", conflicts);
                if (includeDeletedDocs) {
                    value.put("deleted", deleted ? Boolean.valueOf(true) : null);
                }
                QueryRow change = new QueryRow(docID, sequence, docID, value, docRevision);
                if (options.getKeys() != null) {
                    docs.put(docID, change);
                    continue;
                }
                if (options.getPostFilter() != null && !options.getPostFilter().apply(change)) continue;
                rows.add(change);
            }
            if (options.getKeys() != null) {
                for (Object docIdObject : options.getKeys()) {
                    if (!(docIdObject instanceof String)) continue;
                    docID = (String)docIdObject;
                    QueryRow change = (QueryRow)docs.get(docID);
                    if (change == null) {
                        AtomicBoolean outIsDeleted;
                        String revID;
                        HashMap<String, Object> value = new HashMap<String, Object>();
                        long docNumericID = this.getDocNumericID(docID);
                        if (docNumericID > 0L && (revID = this.winningRevIDOfDocNumericID(docNumericID, outIsDeleted = new AtomicBoolean(false), null)) != null) {
                            value.put("rev", revID);
                            value.put("deleted", true);
                        }
                        change = new QueryRow(value != null ? docID : null, 0L, docID, value, null);
                    }
                    rows.add(change);
                }
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error getting all docs", e);
            throw new CouchbaseLiteException("Error getting all docs", (Throwable)e, new Status(500));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        result.put("rows", rows);
        result.put("total_rows", rows.size());
        result.put("offset", options.getSkip());
        if (updateSeq != 0L) {
            result.put("update_seq", updateSeq);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevisionList changesSince(long lastSequence, ChangesOptions options, ReplicationFilter filter, Map<String, Object> filterParams) {
        if (options == null) {
            options = new ChangesOptions();
        }
        RevisionList changes = new RevisionList();
        boolean includeDocs = options.isIncludeDocs() || filter != null;
        String additionalSelectColumns = "";
        if (includeDocs) {
            additionalSelectColumns = ", json";
        }
        String sql = "SELECT sequence, revs.doc_id, docid, revid, deleted" + additionalSelectColumns + " FROM revs, docs " + "WHERE sequence > ? AND current=1 " + "AND revs.doc_id = docs.doc_id " + "ORDER BY revs.doc_id, revid DESC";
        String[] args = new String[]{Long.toString(lastSequence)};
        Cursor cursor = this.storageEngine.rawQuery(sql, args);
        cursor.moveToNext();
        long lastDocId = 0L;
        try {
            while (!cursor.isAfterLast()) {
                if (!options.isIncludeConflicts()) {
                    long docNumericId = cursor.getLong(1);
                    if (docNumericId == lastDocId) {
                        cursor.moveToNext();
                        continue;
                    }
                    lastDocId = docNumericId;
                }
                RevisionInternal rev = new RevisionInternal(cursor.getString(2), cursor.getString(3), cursor.getInt(4) > 0);
                rev.setSequence(cursor.getLong(0));
                if (includeDocs) {
                    rev.setJSON(cursor.getBlob(5));
                }
                changes.add(rev);
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error looking for changes", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (filter != null) {
            for (int i = changes.size() - 1; i >= 0; --i) {
                if (this.delegate.runFilter(filter, filterParams, (RevisionInternal)changes.get(i))) continue;
                changes.remove(i);
            }
        }
        if (options.isSortBySequence()) {
            changes.sortBySequence();
        }
        changes.limit(options.getLimit());
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    public RevisionInternal add(String docID, String prevRevID, Map<String, Object> properties, boolean deleting, boolean allowConflict, StorageValidation validationBlock, Status outStatus) throws CouchbaseLiteException {
        byte[] json;
        if (properties != null && properties.size() > 0) {
            json = RevisionUtils.asCanonicalJSON(properties);
            if (json == null) {
                throw new CouchbaseLiteException(493);
            }
        } else {
            json = "{}".getBytes();
        }
        RevisionInternal newRev = null;
        String winningRevID = null;
        boolean inConflict = false;
        this.beginTransaction();
        try {
            int pruned;
            long sequence;
            long parentSequence;
            String oldWinningRevID;
            AtomicBoolean oldWinnerWasDeletion;
            long docNumericID;
            block47: {
                AtomicBoolean isNewDoc = new AtomicBoolean(prevRevID == null);
                docNumericID = -1L;
                if (docID != null) {
                    docNumericID = this.createOrGetDocNumericID(docID, isNewDoc);
                    if (docNumericID <= 0L) {
                        throw new CouchbaseLiteException(-1);
                    }
                } else {
                    docNumericID = 0L;
                    isNewDoc.set(true);
                }
                oldWinnerWasDeletion = new AtomicBoolean(false);
                AtomicBoolean wasConflicted = new AtomicBoolean(false);
                oldWinningRevID = null;
                if (!isNewDoc.get()) {
                    oldWinningRevID = this.winningRevIDOfDocNumericID(docNumericID, oldWinnerWasDeletion, wasConflicted);
                }
                parentSequence = 0L;
                if (prevRevID != null) {
                    if (isNewDoc.get()) {
                        throw new CouchbaseLiteException(404);
                    }
                    parentSequence = this.getSequenceOfDocument(docNumericID, prevRevID, !allowConflict);
                    if (parentSequence <= 0L) {
                        if (!allowConflict && this.existsDocument(docID, null)) {
                            throw new CouchbaseLiteException(409);
                        }
                        throw new CouchbaseLiteException(404);
                    }
                } else {
                    if (deleting && docID != null) {
                        if (this.existsDocument(docID, null)) {
                            throw new CouchbaseLiteException(409);
                        }
                        throw new CouchbaseLiteException(404);
                    }
                    if (docID != null) {
                        if (oldWinnerWasDeletion.get()) {
                            prevRevID = oldWinningRevID;
                            parentSequence = this.getSequenceOfDocument(docNumericID, prevRevID, false);
                        } else if (oldWinningRevID != null) {
                            throw new CouchbaseLiteException(409);
                        }
                    } else {
                        docID = Misc.CreateUUID();
                        docNumericID = this.createOrGetDocNumericID(docID, isNewDoc);
                        if (docNumericID <= 0L) {
                            RevisionInternal revisionInternal = null;
                            return revisionInternal;
                        }
                    }
                }
                inConflict = wasConflicted.get() || !deleting && prevRevID != null && oldWinningRevID != null && !prevRevID.equals(oldWinningRevID);
                String newRevId = this.delegate.generateRevID(json, deleting, prevRevID);
                if (newRevId == null) {
                    throw new CouchbaseLiteException(494);
                }
                assert (docID != null);
                newRev = new RevisionInternal(docID, newRevId, deleting);
                if (properties != null) {
                    properties.put("_id", docID);
                    properties.put("_rev", newRevId);
                    newRev.setProperties(properties);
                }
                if (validationBlock != null) {
                    Status status;
                    RevisionInternal prevRev = null;
                    if (prevRevID != null) {
                        prevRev = new RevisionInternal(docID, prevRevID, false);
                    }
                    if ((status = validationBlock.validate(newRev, prevRev, prevRevID)).isError()) {
                        outStatus.setCode(status.getCode());
                        throw new CouchbaseLiteException(status);
                    }
                }
                if (json == null) {
                    json = new byte[]{};
                }
                boolean hasAttachments = properties == null ? false : properties.get("_attachments") != null;
                String docType = null;
                if (properties != null && properties.containsKey("type") && properties.get("type") instanceof String) {
                    docType = (String)properties.get("type");
                }
                sequence = 0L;
                try {
                    sequence = this.insertRevision(newRev, docNumericID, parentSequence, true, hasAttachments, json, docType);
                }
                catch (SQLException ex) {
                    if (ex.getCode() != 19) {
                        Log.e(this.TAG, "Error inserting revision: ", ex);
                        throw new CouchbaseLiteException(500);
                    }
                    Log.w(this.TAG, "Duplicate rev insertion: " + docID + " / " + newRevId);
                    newRev.setBody(null);
                    if (parentSequence == 0L) break block47;
                    try {
                        ContentValues args = new ContentValues();
                        args.put("parent", parentSequence);
                        this.storageEngine.update("revs", args, "doc_id=? and revid=?", new String[]{String.valueOf(docNumericID), newRevId});
                    }
                    catch (SQLException e) {
                        throw new CouchbaseLiteException((Throwable)e, 500);
                    }
                }
            }
            if (parentSequence > 0L) {
                try {
                    ContentValues args = new ContentValues();
                    args.put("current", 0);
                    args.put("doc_type", (String)null);
                    this.storageEngine.update("revs", args, "sequence=?", new String[]{String.valueOf(parentSequence)});
                }
                catch (SQLException e) {
                    Log.e(this.TAG, "Error setting parent rev non-current", e);
                    this.storageEngine.delete("revs", "sequence=?", new String[]{String.valueOf(sequence)});
                    throw new CouchbaseLiteException((Throwable)e, 500);
                }
            }
            if (sequence <= 0L) {
                outStatus.setCode(200);
                if (newRev.getSequence() != 0L) {
                    this.delegate.databaseStorageChanged(new DocumentChange(newRev, winningRevID, inConflict, null));
                }
                RevisionInternal e = newRev;
                return e;
            }
            int minGenToKeep = newRev.getGeneration() - this.maxRevTreeDepth + 1;
            if (minGenToKeep > 1 && (pruned = this.pruneDocument(docID, docNumericID, minGenToKeep)) > 0) {
                Log.v(this.TAG, "Pruned %d old revisions of doc '%s'", pruned, docID);
            }
            winningRevID = this.winner(docNumericID, oldWinningRevID, oldWinnerWasDeletion.get(), newRev);
            if (deleting) {
                outStatus.setCode(200);
            } else {
                outStatus.setCode(201);
            }
        }
        finally {
            this.endTransaction(outStatus.isSuccessful());
        }
        if (newRev.getSequence() != 0L) {
            this.delegate.databaseStorageChanged(new DocumentChange(newRev, winningRevID, inConflict, null));
        }
        return newRev;
    }

    @Override
    @InterfaceAudience.Private
    public void forceInsert(RevisionInternal inRev, List<String> history, StorageValidation validationBlock, URL source) throws CouchbaseLiteException {
        Status status = new Status(-1);
        RevisionInternal rev = inRev.copy();
        rev.setSequence(0L);
        String docID = rev.getDocID();
        String winningRevID = null;
        AtomicBoolean inConflict = new AtomicBoolean(false);
        boolean success = false;
        this.beginTransaction();
        try {
            HashMap<String, RevisionInternal> localRevs = null;
            String oldWinningRevID = null;
            AtomicBoolean oldWinnerWasDeletion = new AtomicBoolean(false);
            AtomicBoolean isNewDoc = new AtomicBoolean(history.size() == 1);
            long docNumericID = this.createOrGetDocNumericID(docID, isNewDoc);
            if (docNumericID <= 0L) {
                throw new CouchbaseLiteException(500);
            }
            if (!isNewDoc.get()) {
                RevisionList localRevsList = this.getAllRevisions(docID, docNumericID, false);
                if (localRevsList == null) {
                    throw new CouchbaseLiteException(500);
                }
                localRevs = new HashMap<String, RevisionInternal>();
                for (RevisionInternal r : localRevsList) {
                    localRevs.put(r.getRevID(), r);
                }
                oldWinningRevID = this.winningRevIDOfDocNumericID(docNumericID, oldWinnerWasDeletion, inConflict);
            }
            if (validationBlock != null) {
                String parentRevId;
                Status tmpStatus;
                RevisionInternal oldRev = null;
                for (int i = 1; i < history.size(); ++i) {
                    RevisionInternal revisionInternal = oldRev = localRevs != null ? (RevisionInternal)localRevs.get(history.get(i)) : null;
                    if (oldRev != null) break;
                }
                if ((tmpStatus = validationBlock.validate(rev, oldRev, parentRevId = history.size() > 1 ? history.get(1) : null)).isError()) {
                    throw new CouchbaseLiteException(tmpStatus);
                }
            }
            long sequence = 0L;
            long localParentSequence = 0L;
            for (int i = history.size() - 1; i >= 0; --i) {
                RevisionInternal localRev;
                String revID = history.get(i);
                RevisionInternal revisionInternal = localRev = localRevs != null ? (RevisionInternal)localRevs.get(revID) : null;
                if (localRev != null) {
                    sequence = localRev.getSequence();
                    assert (sequence > 0L);
                    localParentSequence = sequence;
                    continue;
                }
                RevisionInternal newRev = null;
                byte[] json = null;
                Object docType = null;
                boolean current = false;
                if (i == 0) {
                    newRev = rev;
                    json = RevisionUtils.asCanonicalJSON(inRev);
                    if (json == null) {
                        throw new CouchbaseLiteException(493);
                    }
                    Object obj = rev.getObject("type");
                    if (obj != null && obj instanceof String) {
                        docType = (String)obj;
                    }
                    current = true;
                } else {
                    newRev = new RevisionInternal(docID, revID, false);
                }
                sequence = this.insertRevision(newRev, docNumericID, sequence, current, newRev.getAttachments() != null && newRev.getAttachments().size() > 0, json, (String)docType);
                if (sequence > 0L) continue;
                throw new CouchbaseLiteException(500);
            }
            if (localParentSequence == sequence) {
                success = true;
                status.setCode(200);
            } else if (localParentSequence > 0L) {
                ContentValues args = new ContentValues();
                args.put("current", 0);
                args.put("doc_type", (String)null);
                String[] whereArgs = new String[]{Long.toString(localParentSequence)};
                int numRowsChanged = 0;
                try {
                    numRowsChanged = this.storageEngine.update("revs", args, "sequence=? AND current!=0", whereArgs);
                    if (numRowsChanged == 0) {
                        inConflict.set(true);
                    }
                }
                catch (SQLException e) {
                    throw new CouchbaseLiteException(500);
                }
            }
            int gen = inRev.getGeneration();
            String oldestRevID = null;
            if (history.size() > 0) {
                oldestRevID = history.get(history.size() - 1);
            }
            int oldGen = Revision.generationFromRevID(oldestRevID);
            if (gen > this.maxRevTreeDepth) {
                int pruned;
                int minGenToKeep;
                int minGen = oldGen;
                int maxGen = gen;
                if (localRevs != null) {
                    for (RevisionInternal r : localRevs.values()) {
                        int generation = r.getGeneration();
                        minGen = Math.min(minGen, generation);
                        maxGen = Math.max(maxGen, generation);
                    }
                }
                if (minGen < (minGenToKeep = maxGen - this.maxRevTreeDepth + 1) && (pruned = this.pruneDocument(docID, docNumericID, minGenToKeep)) > 0) {
                    Log.v(this.TAG, "Pruned %d old revisions of doc '%s'", pruned, docID);
                }
            }
            if (!success) {
                winningRevID = this.winner(docNumericID, oldWinningRevID, oldWinnerWasDeletion.get(), rev);
                success = true;
                status.setCode(201);
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error inserting revisions", e);
            throw new CouchbaseLiteException(500);
        }
        finally {
            this.endTransaction(success);
        }
        if (status.getCode() == 201) {
            this.delegate.databaseStorageChanged(new DocumentChange(rev, winningRevID, inConflict.get(), source));
        } else if (status.isError()) {
            throw new CouchbaseLiteException(status);
        }
    }

    @Override
    @InterfaceAudience.Private
    public Map<String, Object> purgeRevisions(final Map<String, List<String>> docsToRevs) {
        final HashMap<String, Object> result = new HashMap<String, Object>();
        this.runInTransaction(new TransactionalTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run() {
                for (String docID : docsToRevs.keySet()) {
                    long docNumericID = SQLiteStore.this.getDocNumericID(docID);
                    if (docNumericID == -1L) continue;
                    ArrayList<String> revsPurged = new ArrayList<String>();
                    List revIDs = (List)docsToRevs.get(docID);
                    if (revIDs == null) {
                        return false;
                    }
                    if (revIDs.size() == 0) {
                        revsPurged = new ArrayList();
                    } else if (revIDs.contains("*")) {
                        try {
                            Object[] args = new String[]{Long.toString(docNumericID)};
                            SQLiteStore.this.storageEngine.execSQL("DELETE FROM revs WHERE doc_id=?", args);
                        }
                        catch (SQLException e) {
                            Log.e(SQLiteStore.this.TAG, "Error deleting revisions", e);
                            return false;
                        }
                        revsPurged = new ArrayList();
                        revsPurged.add("*");
                    } else {
                        Cursor cursor = null;
                        try {
                            String[] args = new String[]{Long.toString(docNumericID)};
                            String queryString = "SELECT revid, sequence, parent FROM revs WHERE doc_id=? ORDER BY sequence DESC";
                            cursor = SQLiteStore.this.storageEngine.rawQuery(queryString, args);
                            if (!cursor.moveToNext()) {
                                Log.w(SQLiteStore.this.TAG, "No results for query: %s", queryString);
                                boolean bl = false;
                                return bl;
                            }
                            HashSet<Long> seqsToPurge = new HashSet<Long>();
                            HashSet<Long> seqsToKeep = new HashSet<Long>();
                            HashSet<String> revsToPurge = new HashSet<String>();
                            while (!cursor.isAfterLast()) {
                                String revID = cursor.getString(0);
                                long sequence = cursor.getLong(1);
                                long parent = cursor.getLong(2);
                                if (seqsToPurge.contains(sequence) || revIDs.contains(revID) && !seqsToKeep.contains(sequence)) {
                                    seqsToPurge.add(sequence);
                                    revsToPurge.add(revID);
                                    if (parent > 0L) {
                                        seqsToPurge.add(parent);
                                    }
                                } else {
                                    seqsToPurge.remove(sequence);
                                    revsToPurge.remove(revID);
                                    seqsToKeep.add(parent);
                                }
                                cursor.moveToNext();
                            }
                            seqsToPurge.removeAll(seqsToKeep);
                            Log.i(SQLiteStore.this.TAG, "Purging doc '%s' revs (%s)", docID, revIDs);
                            if (!SQLiteStore.this.purgeSequences(seqsToPurge)) {
                                boolean bl = false;
                                return bl;
                            }
                            revsPurged.addAll(revsToPurge);
                        }
                        catch (SQLException e) {
                            Log.e(SQLiteStore.this.TAG, "Error getting revisions", e);
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                    }
                    result.put(docID, revsPurged);
                }
                return true;
            }
        });
        return result;
    }

    private boolean purgeSequences(Set<Long> seqsToPurge) {
        if (seqsToPurge.size() == 0) {
            return true;
        }
        String seqsString = TextUtils.join(",", seqsToPurge);
        Log.v(this.TAG, "    purging %d sequences: %s", seqsToPurge.size(), seqsString);
        String sql = String.format(Locale.ENGLISH, "DELETE FROM revs WHERE sequence in (%s)", seqsString);
        try {
            this.storageEngine.execSQL(sql);
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error deleting revisions via: " + sql, e);
            return false;
        }
        return true;
    }

    @Override
    public long expirationOfDocument(String docID) {
        return SQLiteUtils.longForQuery(this.storageEngine, "SELECT expiry_timestamp FROM docs WHERE docid=?", new String[]{docID}) * 1000L;
    }

    @Override
    public boolean setExpirationOfDocument(long unixTime, String docID) {
        try {
            ContentValues values = new ContentValues();
            values.put("expiry_timestamp", unixTime);
            String[] whereArgs = new String[]{docID};
            int rowsUpdated = this.storageEngine.update("docs", values, "docid=?", whereArgs);
            return rowsUpdated > 0;
        }
        catch (SQLException e) {
            Log.w(this.TAG, "Failed to update expiry_timestamp for docID=%s", e, docID);
            return false;
        }
    }

    @Override
    public long nextDocumentExpiry() {
        return SQLiteUtils.longForQuery(this.storageEngine, "SELECT MIN(expiry_timestamp) FROM docs WHERE expiry_timestamp not null and expiry_timestamp != 0", null) * 1000L;
    }

    @Override
    public int purgeExpiredDocuments() {
        final AtomicInteger nPurged = new AtomicInteger(0);
        this.runInOuterTransaction(new TransactionalTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run() {
                if (SQLiteStore.this.storageEngine == null) {
                    return false;
                }
                long nowUnixTime = System.currentTimeMillis() / 1000L;
                SQLiteStore.this.invalidateDocNumericIDs();
                String[] args = new String[]{String.valueOf(nowUnixTime)};
                ArrayList<String> purgedIDs = new ArrayList<String>();
                String queryString = "SELECT docid FROM docs WHERE expiry_timestamp <= ? and expiry_timestamp != 0";
                Cursor cursor = SQLiteStore.this.storageEngine.rawQuery(queryString, args);
                try {
                    cursor.moveToNext();
                    while (!cursor.isAfterLast()) {
                        purgedIDs.add(cursor.getString(0));
                        cursor.moveToNext();
                    }
                }
                finally {
                    cursor.close();
                }
                try {
                    int count = SQLiteStore.this.storageEngine.delete("docs", "expiry_timestamp <= ? and expiry_timestamp != 0", args);
                    Log.v(SQLiteStore.this.TAG, "purged doc count: %d/%d", count, purgedIDs.size());
                }
                catch (SQLException e) {
                    Log.w(SQLiteStore.this.TAG, "Failed to delete from docs expiry_timestamp <= %d", e, nowUnixTime);
                    return false;
                }
                for (String docID : purgedIDs) {
                    SQLiteStore.this.notifyPurgedDocument(docID);
                }
                nPurged.set(purgedIDs.size());
                return true;
            }
        });
        return nPurged.get();
    }

    private void notifyPurgedDocument(String docID) {
        this.delegate.databaseStorageChanged(new DocumentChange(docID));
    }

    @Override
    public ViewStore getViewStorage(String name, boolean create) throws CouchbaseLiteException {
        return new SQLiteViewStore(this, name, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllViewNames() {
        Cursor cursor = null;
        ArrayList<String> result = null;
        try {
            cursor = this.storageEngine.rawQuery("SELECT name FROM views", null);
            cursor.moveToNext();
            result = new ArrayList<String>();
            while (!cursor.isAfterLast()) {
                result.add(cursor.getString(0));
                cursor.moveToNext();
            }
        }
        catch (Exception e) {
            Log.e(this.TAG, "Error getting all views", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevisionInternal getLocalDocument(String docID, String revID) {
        RevisionInternal revisionInternal;
        RevisionInternal result = null;
        Cursor cursor = null;
        try {
            String[] args = new String[]{docID};
            cursor = this.storageEngine.rawQuery("SELECT revid, json FROM localdocs WHERE docid=?", args);
            if (cursor.moveToNext()) {
                String gotRevID = cursor.getString(0);
                if (revID != null && !revID.equals(gotRevID)) {
                    RevisionInternal revisionInternal2 = null;
                    return revisionInternal2;
                }
                byte[] json = cursor.getBlob(1);
                Map properties = null;
                try {
                    properties = (Map)Manager.getObjectMapper().readValue(json, Map.class);
                    properties.put("_id", docID);
                    properties.put("_rev", gotRevID);
                    result = new RevisionInternal(docID, gotRevID, false);
                    result.setProperties(properties);
                }
                catch (Exception e) {
                    Log.w(this.TAG, "Error parsing local doc JSON", e);
                    RevisionInternal revisionInternal3 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    return revisionInternal3;
                }
            }
            revisionInternal = result;
            return revisionInternal;
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error getting local document", e);
            revisionInternal = null;
            return revisionInternal;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public RevisionInternal putLocalRevision(RevisionInternal revision, String prevRevID, boolean obeyMVCC) throws CouchbaseLiteException {
        String docID = revision.getDocID();
        if (!docID.startsWith("_local/")) {
            throw new CouchbaseLiteException(400);
        }
        if (!obeyMVCC) {
            return this.putLocalRevisionNoMVCC(revision);
        }
        if (!revision.isDeleted()) {
            String newRevID;
            block10: {
                byte[] json = RevisionUtils.asCanonicalJSON(revision);
                if (prevRevID != null) {
                    int generation = RevisionInternal.generationFromRevID(prevRevID);
                    if (generation == 0) {
                        throw new CouchbaseLiteException(400);
                    }
                    newRevID = Integer.toString(++generation) + "-local";
                    ContentValues values = new ContentValues();
                    values.put("revid", newRevID);
                    values.put("json", json);
                    String[] whereArgs = new String[]{docID, prevRevID};
                    try {
                        int rowsUpdated = this.storageEngine.update("localdocs", values, "docid=? AND revid=?", whereArgs);
                        if (rowsUpdated == 0) {
                            throw new CouchbaseLiteException(409);
                        }
                        break block10;
                    }
                    catch (SQLException e) {
                        throw new CouchbaseLiteException((Throwable)e, 500);
                    }
                }
                newRevID = "1-local";
                ContentValues values = new ContentValues();
                values.put("docid", docID);
                values.put("revid", newRevID);
                values.put("json", json);
                try {
                    this.storageEngine.insertWithOnConflict("localdocs", null, values, 4);
                }
                catch (SQLException e) {
                    throw new CouchbaseLiteException((Throwable)e, 500);
                }
            }
            return revision.copyWithDocID(docID, newRevID);
        }
        this.deleteLocalDocument(docID, prevRevID);
        return revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RevisionInternal putLocalRevisionNoMVCC(RevisionInternal revision) throws CouchbaseLiteException {
        RevisionInternal result = null;
        boolean commit = false;
        this.beginTransaction();
        try {
            RevisionInternal prevRev = this.getLocalDocument(revision.getDocID(), null);
            result = this.putLocalRevision(revision, prevRev == null ? null : prevRev.getRevID(), true);
            commit = true;
        }
        finally {
            this.endTransaction(commit);
        }
        return result;
    }

    @Override
    public RevisionList getAllRevisions(String docID, boolean onlyCurrent) {
        long docNumericId = this.getDocNumericID(docID);
        if (docNumericId < 0L) {
            return null;
        }
        if (docNumericId == 0L) {
            return new RevisionList();
        }
        return this.getAllRevisions(docID, docNumericId, onlyCurrent);
    }

    protected SQLiteStorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    private boolean existsDocument(String docID, String revID) {
        return this.getDocument(docID, revID, false) != null;
    }

    private void deleteLocalDocument(String docID, String revID) throws CouchbaseLiteException {
        if (docID == null) {
            throw new CouchbaseLiteException(400);
        }
        if (revID == null) {
            if (this.getLocalDocument(docID, null) != null) {
                throw new CouchbaseLiteException(409);
            }
            throw new CouchbaseLiteException(404);
        }
        String[] whereArgs = new String[]{docID, revID};
        try {
            int rowsDeleted = this.storageEngine.delete("localdocs", "docid=? AND revid=?", whereArgs);
            if (rowsDeleted == 0) {
                if (this.getLocalDocument(docID, null) != null) {
                    throw new CouchbaseLiteException(409);
                }
                throw new CouchbaseLiteException(404);
            }
        }
        catch (SQLException e) {
            throw new CouchbaseLiteException((Throwable)e, 500);
        }
    }

    protected String winningRevIDOfDocNumericID(long docNumericId, AtomicBoolean outIsDeleted, AtomicBoolean outIsConflict) throws CouchbaseLiteException {
        assert (docNumericId > 0L);
        Cursor cursor = null;
        String sql = "SELECT revid, deleted FROM revs WHERE doc_id=? and current=1 ORDER BY deleted asc, revid desc LIMIT ?";
        long limit = outIsConflict != null && outIsConflict.get() ? 2L : 1L;
        String[] args = new String[]{Long.toString(docNumericId), Long.toString(limit)};
        String revID = null;
        try {
            cursor = this.storageEngine.rawQuery(sql, args);
            if (cursor.moveToNext()) {
                revID = cursor.getString(0);
                outIsDeleted.set(cursor.getInt(1) > 0);
                if (outIsConflict != null) {
                    outIsConflict.set(!outIsDeleted.get() && cursor.moveToNext() && cursor.getInt(1) <= 0);
                }
            } else {
                outIsDeleted.set(false);
                if (outIsConflict != null) {
                    outIsConflict.set(false);
                }
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error", e);
            throw new CouchbaseLiteException("Error", (Throwable)e, new Status(500));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return revID;
    }

    protected void optimizeSQLIndexes() {
        long lastOptimized;
        Log.v("Database", "calls optimizeSQLIndexes()");
        final long currentSequence = this.getLastSequence();
        if (currentSequence > 0L && (lastOptimized = this.getLastOptimized()) <= currentSequence / 10L) {
            this.runInTransaction(new TransactionalTask(){

                @Override
                public boolean run() {
                    Log.i("Database", "%s: Optimizing SQL indexes (curSeq=%d, last run at %d)", this, currentSequence, lastOptimized);
                    SQLiteStore.this.storageEngine.execSQL("ANALYZE");
                    SQLiteStore.this.storageEngine.execSQL("ANALYZE sqlite_master");
                    SQLiteStore.this.setInfo("last_optimized", String.valueOf(currentSequence));
                    return true;
                }
            });
        }
    }

    protected boolean beginTransaction() {
        int tLevel = (Integer)this.transactionLevel.get();
        try {
            if (tLevel == 0) {
                boolean retry = true;
                int retries = 0;
                do {
                    try {
                        this.storageEngine.beginTransaction();
                        retry = false;
                    }
                    catch (SQLiteDatabaseLockedException lockedException) {
                        if (++retries > 10) {
                            Log.e(this.TAG, "Db busy, too many retries, giving up");
                            throw lockedException;
                        }
                        Log.i(this.TAG, "Db busy, retrying transaction (#%d)...", retries);
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (retry);
            } else {
                this.storageEngine.execSQL("SAVEPOINT cbl_" + Integer.toString(tLevel));
            }
            Log.v("Database", "%s Begin transaction (level %d)", Thread.currentThread().getName(), tLevel);
            this.transactionLevel.set(++tLevel);
        }
        catch (SQLException e) {
            Log.e("Database", Thread.currentThread().getName() + " Error calling beginTransaction()", e);
            return false;
        }
        return true;
    }

    protected boolean endTransaction(boolean commit) {
        int tLevel = (Integer)this.transactionLevel.get();
        assert (tLevel > 0);
        this.transactionLevel.set(--tLevel);
        if (tLevel == 0) {
            if (commit) {
                Log.v("Database", "%s Committing transaction (level %d)", Thread.currentThread().getName(), tLevel);
                this.storageEngine.setTransactionSuccessful();
                this.storageEngine.endTransaction();
            } else {
                Log.v("Database", "%s CANCEL transaction (level %d)", Thread.currentThread().getName(), tLevel);
                try {
                    this.storageEngine.endTransaction();
                }
                catch (SQLException e) {
                    Log.e("Database", Thread.currentThread().getName() + " Error calling endTransaction()", e);
                    return false;
                }
            }
        } else {
            if (commit) {
                Log.v("Database", "%s Committing transaction (level %d)", Thread.currentThread().getName(), tLevel);
            } else {
                Log.v("Database", "%s CANCEL transaction (level %d)", Thread.currentThread().getName(), tLevel);
                try {
                    this.storageEngine.execSQL(";ROLLBACK TO cbl_" + Integer.toString(tLevel));
                }
                catch (SQLException e) {
                    Log.e("Database", Thread.currentThread().getName() + " Error calling endTransaction()", e);
                    return false;
                }
            }
            try {
                this.storageEngine.execSQL("RELEASE cbl_" + Integer.toString(tLevel));
            }
            catch (SQLException e) {
                Log.e("Database", Thread.currentThread().getName() + " Error calling endTransaction()", e);
                return false;
            }
        }
        if (this.delegate != null) {
            this.delegate.storageExitedTransaction(commit);
        }
        return true;
    }

    protected Map<String, Object> documentPropertiesFromJSON(byte[] json, String docID, String revID, boolean deleted, long sequence) {
        RevisionInternal rev = new RevisionInternal(docID, revID, deleted);
        rev.setSequence(sequence);
        rev.setMissing(json == null);
        Map<String, String> docProperties = null;
        if (json == null || json.length == 0 || json.length == 2 && Arrays.equals(json, EMPTY_JSON_OBJECT_CHARS)) {
            docProperties = new HashMap<String, String>();
        } else {
            try {
                docProperties = (Map)Manager.getObjectMapper().readValue(json, Map.class);
            }
            catch (IOException e) {
                Log.e(this.TAG, String.format(Locale.ENGLISH, "Unparseable JSON for doc=%s, rev=%s: %s", docID, revID, new String(json)), e);
                docProperties = new HashMap();
            }
        }
        docProperties.put("_id", docID);
        docProperties.put("_rev", revID);
        if (deleted) {
            docProperties.put("_deleted", (String)((Object)Boolean.valueOf(true)));
        }
        return docProperties;
    }

    protected int pruneRevsToMaxDepth(int maxDepth) throws CouchbaseLiteException {
        if (maxDepth == 0) {
            maxDepth = this.getMaxRevTreeDepth();
        }
        Log.v(this.TAG, "Pruning revisions to max depth %d...", maxDepth);
        HashMap<Long, Integer> toPrune = new HashMap<Long, Integer>();
        Cursor cursor = null;
        try {
            String[] args = new String[]{};
            cursor = this.storageEngine.rawQuery("SELECT doc_id, MIN(revid), MAX(revid) FROM revs GROUP BY doc_id", args);
            while (cursor.moveToNext()) {
                long docNumericID = cursor.getLong(0);
                String minGenRevId = cursor.getString(1);
                String maxGenRevId = cursor.getString(2);
                int minGen = Revision.generationFromRevID(minGenRevId);
                int maxGen = Revision.generationFromRevID(maxGenRevId);
                if (maxGen - minGen + 1 <= maxDepth) continue;
                toPrune.put(docNumericID, maxGen - maxDepth);
            }
        }
        catch (Exception e) {
            throw new CouchbaseLiteException((Throwable)e, 500);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (toPrune.size() == 0) {
            return 0;
        }
        int outPruned = 0;
        boolean shouldCommit = false;
        try {
            this.beginTransaction();
            for (Long docNumericID : toPrune.keySet()) {
                outPruned += this.pruneDocument("?", docNumericID, (Integer)toPrune.get(docNumericID) + 1);
            }
            shouldCommit = true;
        }
        catch (Throwable e) {
            throw new CouchbaseLiteException(e, 500);
        }
        finally {
            this.endTransaction(shouldCommit);
        }
        return outPruned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int pruneDocument(String docID, long docNumericID, int minGenToKeep) {
        HashSet<Long> leaves = new HashSet<Long>();
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery("SELECT sequence FROM revs WHERE doc_id=? AND current", new String[]{Long.toString(docNumericID)});
            while (cursor.moveToNext()) {
                leaves.add(cursor.getLong(0));
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error querying sequence from revs docNumericID=%d", e, docNumericID);
            int n = -1;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (leaves.size() <= 1) {
            String minIDToKeep = String.format(Locale.ENGLISH, "%d-", minGenToKeep);
            String[] deleteArgs = new String[]{Long.toString(docNumericID), minIDToKeep};
            int pruned = this.storageEngine.delete("revs", "doc_id=? AND revid < ? AND current=0", deleteArgs);
            Log.v(this.TAG, "    pruned %d revs with gen<%d from %s", pruned, minGenToKeep, docID);
            return pruned;
        }
        HashMap<Long, Long> revs = new HashMap<Long, Long>();
        Cursor cursor2 = null;
        try {
            cursor2 = this.storageEngine.rawQuery("SELECT sequence, parent FROM revs WHERE doc_id=?", new String[]{Long.toString(docNumericID)});
            while (cursor2.moveToNext()) {
                long seq = cursor2.getLong(0);
                long parent = cursor2.getLong(1);
                revs.put(seq, parent);
            }
        }
        catch (SQLException e) {
            Log.e(this.TAG, "Error querying sequence and parent from revs docNumericID=%d", e, docNumericID);
            int n = -1;
            return n;
        }
        finally {
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        Log.v(this.TAG, "    pruning %s, scanning %d revs in tree...", docID, revs.size());
        Iterator iterator = leaves.iterator();
        block12: while (iterator.hasNext()) {
            Long leaf;
            Long seq = leaf = (Long)iterator.next();
            for (int i = 0; i < this.maxRevTreeDepth; ++i) {
                Long parent = (Long)revs.get(seq);
                revs.remove(seq);
                if (parent == null || parent == 0L) continue block12;
                seq = parent;
            }
        }
        if (!this.purgeSequences(revs.keySet())) {
            Log.w(this.TAG, "SQLite error: pruning conflicted doc %d", docNumericID);
            return -1;
        }
        return revs.size();
    }

    protected void runStatements(String statements) throws SQLException {
        for (String statement : statements.split(";")) {
            try {
                this.storageEngine.execSQL(statement);
            }
            catch (SQLException e) {
                Log.e(this.TAG, "Failed to execSQL: " + statement, e);
                throw e;
            }
        }
    }

    private void initialize(String statements) throws SQLException {
        try {
            this.runStatements(statements);
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    private long getLastOptimized() {
        String info = this.getInfo("last_optimized");
        if (info != null) {
            return Long.parseLong(info);
        }
        return 0L;
    }

    private boolean sequenceHasAttachments(long sequence) {
        String[] args = new String[]{Long.toString(sequence)};
        return SQLiteUtils.booleanForQuery(this.storageEngine, "SELECT no_attachments=0 FROM revs WHERE sequence=?", args);
    }

    protected long getDocNumericID(String docID) {
        return SQLiteUtils.longForQuery(this.storageEngine, "SELECT doc_id FROM docs WHERE docid=?", new String[]{docID});
    }

    private long createOrGetDocNumericID(String docID, AtomicBoolean isNew) {
        long row;
        long l = row = isNew.get() ? this.createDocNumericID(docID, isNew) : this.getDocNumericID(docID);
        if (row < 0L) {
            return row;
        }
        if (row == 0L) {
            isNew.set(!isNew.get());
            row = isNew.get() ? this.createDocNumericID(docID, isNew) : this.getDocNumericID(docID);
        }
        return row;
    }

    private void invalidateDocNumericID(String docID) {
    }

    private void invalidateDocNumericIDs() {
    }

    private long createDocNumericID(String docID, AtomicBoolean isNew) {
        long docNumericId = this.getDocNumericID(docID);
        if (docNumericId == 0L) {
            docNumericId = this.insertDocumentID(docID);
            isNew.set(true);
        } else {
            isNew.set(false);
        }
        return docNumericId;
    }

    private long insertDocumentID(String docID) {
        long rowId = -1L;
        try {
            ContentValues args = new ContentValues();
            args.put("docid", docID);
            rowId = this.storageEngine.insert("docs", null, args);
        }
        catch (Exception e) {
            Log.e(this.TAG, "Error inserting document id", e);
        }
        return rowId;
    }

    private long insertRevision(RevisionInternal rev, long docNumericID, long parentSequence, boolean current, boolean hasAttachments, byte[] json, String docType) throws SQLException {
        ContentValues args = new ContentValues();
        args.put("doc_id", docNumericID);
        args.put("revid", rev.getRevID());
        if (parentSequence != 0L) {
            args.put("parent", parentSequence);
        }
        args.put("current", current);
        args.put("deleted", rev.isDeleted());
        args.put("no_attachments", !hasAttachments);
        args.put("json", json);
        args.put("doc_type", docType);
        long rowId = this.storageEngine.insertOrThrow("revs", null, args);
        rev.setSequence(rowId);
        return rowId;
    }

    private long getSequenceOfDocument(long docNumericID, String revID, boolean onlyCurrent) {
        String sql = String.format(Locale.ENGLISH, "SELECT sequence FROM revs WHERE doc_id=? AND revid=? %s LIMIT 1", onlyCurrent ? "AND current=1" : "");
        String[] args = new String[]{Long.toString(docNumericID), revID};
        return SQLiteUtils.longForQuery(this.storageEngine, sql, args);
    }

    private static int getDeletedColumnIndex(QueryOptions options) {
        if (options.isIncludeDocs()) {
            return 6;
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RevisionInternal getDocument(String docID, long sequence) {
        RevisionInternal rev = null;
        String[] args = new String[]{Long.toString(sequence)};
        String queryString = "SELECT revid, deleted, json FROM revs WHERE sequence=?";
        Cursor cursor = null;
        try {
            cursor = this.storageEngine.rawQuery(queryString, args);
            if (cursor.moveToNext()) {
                String revID = cursor.getString(0);
                boolean deleted = cursor.getInt(1) > 0;
                byte[] json = cursor.getBlob(2);
                rev = new RevisionInternal(docID, revID, deleted);
                rev.setSequence(sequence);
                rev.setJSON(json);
            }
        }
        finally {
            cursor.close();
        }
        return rev;
    }

    protected static RevisionInternal revision(String docID, String revID, boolean deleted, long sequence, byte[] json) {
        RevisionInternal rev = new RevisionInternal(docID, revID, deleted);
        rev.setSequence(sequence);
        if (json != null) {
            rev.setJSON(json);
        }
        return rev;
    }

    protected static RevisionInternal revision(String docID, String revID, boolean deleted, long sequence, Map<String, Object> properties) {
        RevisionInternal rev = new RevisionInternal(docID, revID, deleted);
        rev.setSequence(sequence);
        if (properties != null) {
            rev.setProperties(properties);
        }
        return rev;
    }

    private String winner(long docNumericID, String oldWinningRevID, boolean oldWinnerWasDeletion, RevisionInternal newRev) throws CouchbaseLiteException {
        String newRevID = newRev.getRevID();
        if (oldWinningRevID == null) {
            return newRevID;
        }
        if (!newRev.isDeleted()) {
            if (oldWinnerWasDeletion || RevisionInternal.CBLCompareRevIDs(newRevID, oldWinningRevID) > 0) {
                return newRevID;
            }
        } else if (oldWinnerWasDeletion) {
            if (RevisionInternal.CBLCompareRevIDs(newRevID, oldWinningRevID) > 0) {
                return newRevID;
            }
        } else {
            AtomicBoolean outIsDeleted = new AtomicBoolean(false);
            String winningRevID = this.winningRevIDOfDocNumericID(docNumericID, outIsDeleted, null);
            if (!winningRevID.equals(oldWinningRevID)) {
                return winningRevID;
            }
        }
        return null;
    }

    static class TransactionLevel
    extends ThreadLocal<Integer> {
        TransactionLevel() {
        }

        @Override
        protected Integer initialValue() {
            return 0;
        }
    }
}

