/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.store;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Emitter;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.Predicate;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.Reducer;
import com.couchbase.lite.Status;
import com.couchbase.lite.TransactionalTask;
import com.couchbase.lite.View;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.internal.database.ContentValues;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.store.QueryRowBlock;
import com.couchbase.lite.store.QueryRowStore;
import com.couchbase.lite.store.SQLiteStore;
import com.couchbase.lite.store.ViewStore;
import com.couchbase.lite.store.ViewStoreDelegate;
import com.couchbase.lite.support.JsonDocument;
import com.couchbase.lite.util.CountDown;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.SQLiteUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SQLiteViewStore
implements ViewStore,
QueryRowStore {
    public static String TAG = "View";
    private static final int REDUCE_BATCH_SIZE = 100;
    private String name;
    private ViewStoreDelegate delegate;
    private SQLiteStore store;
    private int viewID;
    private View.TDViewCollation collation;
    private String _mapTableName;
    private SQLiteViewStore curView;

    protected SQLiteViewStore(SQLiteStore store, String name, boolean create) throws CouchbaseLiteException {
        this.store = store;
        this.name = name;
        this.viewID = -1;
        this.collation = View.TDViewCollation.TDViewCollationUnicode;
        if (!create && this.getViewID() <= 0) {
            throw new CouchbaseLiteException(404);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ViewStoreDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(ViewStoreDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setCollation(View.TDViewCollation collation) {
        this.collation = collation;
    }

    @Override
    public void close() {
        this.store = null;
        this.viewID = -1;
    }

    @Override
    public void deleteIndex() {
        if (this.getViewID() <= 0) {
            return;
        }
        String sql = "DROP TABLE IF EXISTS 'maps_#'; UPDATE views SET lastSequence=0, total_docs=0 WHERE view_id=#";
        if (!this.runStatements(sql)) {
            Log.w(TAG, "Couldn't delete view _index `%s`", this.name);
        }
    }

    @Override
    public void deleteView() {
        this.store.runInTransaction(new TransactionalTask(){

            @Override
            public boolean run() {
                SQLiteViewStore.this.deleteIndex();
                String[] whereArgs = new String[]{SQLiteViewStore.this.name};
                int rowsAffected = SQLiteViewStore.this.store.getStorageEngine().delete("views", "name=?", whereArgs);
                return rowsAffected > 0;
            }
        });
        this.viewID = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setVersion(String version) {
        boolean hasView;
        SQLiteStorageEngine storage = this.store.getStorageEngine();
        Cursor cursor = null;
        try {
            String sql = "SELECT name, version FROM views WHERE name=?";
            String[] args = new String[]{this.name};
            cursor = storage.rawQuery(sql, args);
            hasView = cursor.moveToNext();
        }
        catch (SQLException e) {
            Log.e("View", "Error querying existing view name " + this.name, e);
            boolean args = false;
            return args;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (!hasView) {
            ContentValues insertValues = new ContentValues();
            insertValues.put("name", this.name);
            insertValues.put("version", version);
            insertValues.put("total_docs", 0);
            storage.insert("views", null, insertValues);
            this.createIndex();
            return true;
        }
        ContentValues updateValues = new ContentValues();
        updateValues.put("version", version);
        updateValues.put("lastSequence", 0);
        updateValues.put("total_docs", 0);
        String[] whereArgs = new String[]{this.name, version};
        int rowsAffected = storage.update("views", updateValues, "name=? AND version!=?", whereArgs);
        return rowsAffected > 0;
    }

    @Override
    public int getTotalRows() {
        SQLiteStorageEngine storageEngine = this.store.getStorageEngine();
        String sql = "SELECT total_docs FROM views WHERE name=?";
        String[] args = new String[]{this.name};
        int totalRows = SQLiteUtils.intForQuery(storageEngine, sql, args);
        if (totalRows == -1) {
            this.createIndex();
            totalRows = this.countTotalRows();
            this.updateTotalRows(totalRows);
        }
        return totalRows;
    }

    private int countTotalRows() {
        SQLiteStorageEngine storageEngine = this.store.getStorageEngine();
        String sql = this.queryString("SELECT COUNT(*) FROM 'maps_#'");
        return SQLiteUtils.intForQuery(storageEngine, sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastSequenceIndexed() {
        String sql = "SELECT lastSequence FROM views WHERE name=?";
        String[] args = new String[]{this.name};
        Cursor cursor = null;
        long result = -1L;
        try {
            cursor = this.store.getStorageEngine().rawQuery(sql, args);
            if (cursor.moveToNext()) {
                result = cursor.getLong(0);
            }
        }
        catch (Exception e) {
            Log.e("View", "Error getting last sequence indexed", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @Override
    public long getLastSequenceChangedAt() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    public Status updateIndexes(List<ViewStore> inputViews) throws CouchbaseLiteException {
        Log.v("View", "Re-indexing view: %s", this.name);
        if (this.getViewID() <= 0) {
            String msg = "getViewID() < 0";
            throw new CouchbaseLiteException(msg, new Status(404));
        }
        this.store.beginTransaction();
        boolean success = false;
        Cursor cursor = null;
        try {
            long dbMaxSequence = this.store.getLastSequence();
            long forViewLastSequence = this.getLastSequenceIndexed();
            if (forViewLastSequence >= dbMaxSequence) {
                success = true;
                Status status = new Status(304);
                return status;
            }
            long minLastSequence = dbMaxSequence;
            long[] viewLastSequence = new long[inputViews.size()];
            int deletedCount = 0;
            int i = 0;
            HashSet<String> docTypes = new HashSet<String>();
            HashMap<String, String> viewDocTypes = null;
            boolean allDocTypes = false;
            final HashMap<Integer, Integer> viewTotalRows = new HashMap<Integer, Integer>();
            ArrayList<SQLiteViewStore> views = new ArrayList<SQLiteViewStore>();
            ArrayList<Mapper> mapBlocks = new ArrayList<Mapper>();
            for (ViewStore v : inputViews) {
                Mapper map;
                assert (v != null);
                SQLiteViewStore view = (SQLiteViewStore)v;
                ViewStoreDelegate delegate = view.getDelegate();
                Mapper mapper = map = delegate != null ? delegate.getMap() : null;
                if (map == null) {
                    if (view == this) {
                        String msg = String.format(Locale.ENGLISH, "Cannot index view %s: no map block registered", view.getName());
                        Log.e("View", msg);
                        throw new CouchbaseLiteException(msg, new Status(400));
                    }
                    Log.v("View", "    %s has no map block; skipping it", view.getName());
                    continue;
                }
                views.add(view);
                mapBlocks.add(map);
                int viewID = view.getViewID();
                if (viewID <= 0) {
                    String message = String.format(Locale.ENGLISH, "View '%s' not found in database", view.getName());
                    Log.e("View", message);
                    throw new CouchbaseLiteException(message, new Status(404));
                }
                int totalRows = view.getTotalRows();
                viewTotalRows.put(viewID, totalRows);
                long last = view == this ? forViewLastSequence : view.getLastSequenceIndexed();
                viewLastSequence[i++] = last;
                if (last < 0L) {
                    String msg = String.format(Locale.ENGLISH, "last < 0 (%d)", last);
                    throw new CouchbaseLiteException(msg, new Status(500));
                }
                if (last >= dbMaxSequence) continue;
                if (last == 0L) {
                    view.createIndex();
                }
                minLastSequence = Math.min(minLastSequence, last);
                Log.v("View", "    %s last indexed at #%d", view.getName(), last);
                String docType = delegate.getDocumentType();
                if (docType != null) {
                    docTypes.add(docType);
                    if (viewDocTypes == null) {
                        viewDocTypes = new HashMap<String, String>();
                    }
                    viewDocTypes.put(view.getName(), docType);
                } else {
                    allDocTypes = true;
                }
                int changes = 0;
                if (last == 0L) {
                    changes = this.store.getStorageEngine().delete(view.queryString("maps_#"), null, null);
                } else {
                    this.store.optimizeSQLIndexes();
                    String[] args = new String[]{Long.toString(last), Long.toString(last)};
                    changes = this.store.getStorageEngine().delete(view.queryString("maps_#"), "sequence IN (SELECT parent FROM revs WHERE sequence>? AND +parent>0 AND +parent<=?)", args);
                }
                deletedCount += changes;
                if (last == 0L) continue;
                int newTotalRows = (Integer)viewTotalRows.get(viewID) - changes;
                viewTotalRows.put(viewID, newTotalRows);
            }
            if (minLastSequence == dbMaxSequence) {
                Log.v("View", "minLastSequence (%d) == dbMaxSequence (%d), nothing to do", minLastSequence, dbMaxSequence);
                success = true;
                Status status = new Status(304);
                return status;
            }
            Log.v("View", "Updating indexes of (%s) from #%d to #%d ...", SQLiteViewStore.viewNames(views), minLastSequence, dbMaxSequence);
            AtomicInteger insertedCount = new AtomicInteger(0);
            AbstractMapEmitBlock emitBlock = new AbstractMapEmitBlock(){

                @Override
                public void emit(Object key, Object value) {
                    if (key == null) {
                        Log.w("View", "emit() called with nil key; ignoring");
                        return;
                    }
                    try {
                        SQLiteViewStore.this.curView.emit(key, value, this.sequence);
                        int curViewID = SQLiteViewStore.this.curView.getViewID();
                        viewTotalRows.put(curViewID, (Integer)viewTotalRows.get(curViewID) + 1);
                    }
                    catch (Exception e) {
                        Log.e("View", "Error emitting", e);
                        throw new RuntimeException(e);
                    }
                }
            };
            boolean checkDocTypes = docTypes.size() > 1 || allDocTypes && docTypes.size() > 0;
            StringBuilder sql = new StringBuilder("SELECT revs.doc_id, sequence, docid, revid, no_attachments, deleted ");
            if (checkDocTypes) {
                sql.append(", doc_type ");
            }
            sql.append("FROM revs, docs WHERE sequence>? AND current!=0 ");
            if (minLastSequence == 0L) {
                sql.append("AND deleted=0 ");
            }
            if (!allDocTypes && docTypes.size() > 0) {
                String docTypesString = SQLiteViewStore.getJoinedSQLQuotedStrings(docTypes.toArray(new String[docTypes.size()]));
                sql.append("AND doc_type IN (").append(docTypesString).append(") ");
            }
            sql.append("AND revs.doc_id = docs.doc_id ORDER BY revs.doc_id, deleted ASC, revid DESC");
            String[] selectArgs = new String[]{Long.toString(minLastSequence)};
            cursor = this.store.getStorageEngine().rawQuery(sql.toString(), selectArgs);
            boolean keepGoing = cursor.moveToNext();
            while (keepGoing) {
                boolean isNull;
                if (cursor.isNull(0)) {
                    keepGoing = cursor.moveToNext();
                    continue;
                }
                long docID = cursor.getLong(0);
                long sequence = cursor.getLong(1);
                String docId = cursor.getString(2);
                if (docId.startsWith("_design/")) {
                    keepGoing = cursor.moveToNext();
                    continue;
                }
                String revID = cursor.getString(3);
                boolean deleted = cursor.getInt(5) > 0;
                String docType = checkDocTypes ? cursor.getString(6) : null;
                ArrayList<String> conflicts = null;
                while ((keepGoing = cursor.moveToNext()) && ((isNull = cursor.isNull(0)) || cursor.getLong(0) == docID)) {
                    if (isNull || deleted) continue;
                    if (conflicts == null) {
                        conflicts = new ArrayList<String>();
                    }
                    conflicts.add(cursor.getString(3));
                }
                long realSequence = sequence;
                if (minLastSequence > 0L) {
                    Cursor cursor2 = null;
                    try {
                        String[] selectArgs2 = new String[]{Long.toString(docID), Long.toString(minLastSequence)};
                        cursor2 = this.store.getStorageEngine().rawQuery("SELECT revid, sequence FROM revs WHERE doc_id=? AND sequence<=? AND current!=0 AND deleted=0 ORDER BY revID DESC ", selectArgs2);
                        if (cursor2.moveToNext()) {
                            String oldRevID = cursor2.getString(0);
                            long oldSequence = cursor2.getLong(1);
                            String[] args = new String[]{Long.toString(oldSequence)};
                            for (SQLiteViewStore view : views) {
                                int changes = view.store.getStorageEngine().delete(view.queryString("maps_#"), "sequence=?", args);
                                deletedCount += changes;
                                int thisViewID = view.getViewID();
                                int newTotalRows = (Integer)viewTotalRows.get(thisViewID) - changes;
                                viewTotalRows.put(thisViewID, newTotalRows);
                            }
                            String conflictRevID = oldRevID;
                            if (deleted || RevisionInternal.CBLCompareRevIDs(oldRevID, revID) > 0) {
                                conflictRevID = revID;
                                revID = oldRevID;
                                deleted = false;
                                sequence = oldSequence;
                            }
                            if (!deleted) {
                                if (conflicts == null) {
                                    conflicts = new ArrayList();
                                }
                                conflicts.add(conflictRevID);
                                while (cursor2.moveToNext()) {
                                    conflicts.add(cursor2.getString(0));
                                }
                            }
                        }
                    }
                    finally {
                        if (cursor2 != null) {
                            cursor2.close();
                        }
                    }
                }
                if (deleted) continue;
                String[] selectArgs3 = new String[]{Long.toString(sequence)};
                byte[] json = SQLiteUtils.byteArrayResultForQuery(this.store.getStorageEngine(), "SELECT json FROM revs WHERE sequence=?", selectArgs3);
                Map<String, Object> curDoc = this.store.documentPropertiesFromJSON(json, docId, revID, false, sequence);
                if (curDoc == null) {
                    Log.w("View", "Failed to parse JSON of doc %s rev %s", docID, revID);
                    continue;
                }
                curDoc.put("_local_seq", sequence);
                if (conflicts != null) {
                    curDoc.put("_conflicts", conflicts);
                }
                i = -1;
                Iterator<SQLiteViewStore> iterator = views.iterator();
                while (iterator.hasNext()) {
                    String viewDocType;
                    SQLiteViewStore view;
                    this.curView = view = iterator.next();
                    if (viewLastSequence[++i] >= realSequence || checkDocTypes && (viewDocType = (String)viewDocTypes.get(view.getName())) != null && !viewDocType.equals(docType)) continue;
                    Log.v("View", "#%d: map '%s' for view %s...", sequence, docID, view.getName());
                    try {
                        emitBlock.setSequence(sequence);
                        ((Mapper)mapBlocks.get(i)).map(curDoc, emitBlock);
                    }
                    catch (Throwable e) {
                        String msg = String.format(Locale.ENGLISH, "Error when calling map block of view '%s'", view.getName());
                        Log.e("View", msg, e);
                        throw new CouchbaseLiteException(msg, e, new Status(593));
                    }
                }
            }
            for (SQLiteViewStore view : views) {
                view.finishCreatingIndex();
                int newTotalRows = (Integer)viewTotalRows.get(view.getViewID());
                ContentValues updateValues = new ContentValues();
                updateValues.put("lastSequence", dbMaxSequence);
                updateValues.put("total_docs", newTotalRows);
                String[] whereArgs = new String[]{Integer.toString(view.getViewID())};
                this.store.getStorageEngine().update("views", updateValues, "view_id=?", whereArgs);
            }
            Log.v("View", "...Finished re-indexing (%s) to #%d (deleted %d, added %d)", SQLiteViewStore.viewNames(views), dbMaxSequence, deletedCount, insertedCount.intValue());
            success = true;
            Status status = new Status(200);
            return status;
        }
        catch (SQLException ex) {
            throw new CouchbaseLiteException((Throwable)ex, new Status(590));
        }
        finally {
            this.curView = null;
            if (cursor != null) {
                cursor.close();
            }
            if (this.store != null) {
                this.store.endTransaction(success);
            }
        }
    }

    protected void emit(Object key, Object value, long sequence) throws JsonProcessingException {
        String keyJson = Manager.getObjectMapper().writeValueAsString(key);
        String valueJson = value == null ? null : Manager.getObjectMapper().writeValueAsString(value);
        Object[] args = new String[]{Long.toString(sequence), keyJson, valueJson};
        this.store.getStorageEngine().execSQL(this.queryString("INSERT INTO 'maps_#' (sequence, key, value) VALUES(?,?,?)"), args);
    }

    @Override
    public List<QueryRow> regularQuery(final QueryOptions options) throws CouchbaseLiteException {
        final Predicate<QueryRow> postFilter = options.getPostFilter();
        int tmpLimit = QueryOptions.QUERY_OPTIONS_DEFAULT_LIMIT;
        int tmpSkip = 0;
        if (postFilter != null) {
            tmpLimit = options.getLimit();
            tmpSkip = options.getSkip();
            if (tmpLimit == 0) {
                return new ArrayList<QueryRow>();
            }
            options.setLimit(QueryOptions.QUERY_OPTIONS_DEFAULT_LIMIT);
            options.setSkip(0);
        }
        final CountDown skip = new CountDown(tmpSkip);
        final CountDown limit = new CountDown(tmpLimit);
        final ArrayList<QueryRow> rows = new ArrayList<QueryRow>();
        Status status = this.runQuery(options, new QueryRowBlock(){

            @Override
            public Status onRow(byte[] keyData, byte[] valueData, String docID, Cursor cursor) {
                JsonDocument keyDoc = new JsonDocument(keyData);
                JsonDocument valueDoc = new JsonDocument(valueData);
                long sequence = Long.parseLong(cursor.getString(3));
                RevisionInternal docRevision = null;
                if (options.isIncludeDocs()) {
                    Object valueObject = valueDoc.jsonObject();
                    String linkedID = null;
                    if (valueObject instanceof Map) {
                        linkedID = (String)((Map)valueObject).get("_id");
                    }
                    if (linkedID != null) {
                        String linkedRev = (String)((Map)valueObject).get("_rev");
                        docRevision = SQLiteViewStore.this.store.getDocument(linkedID, linkedRev, true);
                        sequence = docRevision.getSequence();
                    } else {
                        String revID = cursor.getString(4);
                        byte[] json = cursor.getBlob(5);
                        Map<String, Object> properties = SQLiteViewStore.this.store.documentPropertiesFromJSON(json, docID, revID, false, sequence);
                        docRevision = SQLiteStore.revision(docID, revID, false, sequence, properties);
                    }
                }
                QueryRow row = new QueryRow(docID, sequence, keyDoc.jsonObject(), valueDoc.jsonObject(), docRevision);
                if (postFilter != null) {
                    if (!postFilter.apply(row)) {
                        return new Status(200);
                    }
                    if (skip.getCount() > 0) {
                        skip.countDown();
                        return new Status(200);
                    }
                }
                rows.add(row);
                if (limit.countDown() == 0) {
                    return new Status(0);
                }
                return new Status(200);
            }
        });
        if (options.getKeys() != null && options.getKeys().size() > 0) {
            HashMap<Object, ArrayList<QueryRow>> rowsByKey = new HashMap<Object, ArrayList<QueryRow>>();
            for (QueryRow row : rows) {
                ArrayList<QueryRow> rs = (ArrayList<QueryRow>)rowsByKey.get(row.getKey());
                if (rs == null) {
                    rs = new ArrayList<QueryRow>();
                    rowsByKey.put(row.getKey(), rs);
                }
                rs.add(row);
            }
            ArrayList<QueryRow> sortedRows = new ArrayList<QueryRow>();
            for (Object key : options.getKeys()) {
                JsonDocument jsonDoc = null;
                try {
                    byte[] keyBytes = Manager.getObjectMapper().writeValueAsBytes(key);
                    jsonDoc = new JsonDocument(keyBytes);
                }
                catch (JsonProcessingException e) {
                    throw new CouchbaseLiteException(500);
                }
                List rs = (List)rowsByKey.get(jsonDoc.jsonObject());
                if (rs == null) continue;
                sortedRows.addAll(rs);
            }
            return sortedRows;
        }
        return rows;
    }

    @Override
    public List<QueryRow> reducedQuery(QueryOptions options) throws CouchbaseLiteException {
        final Predicate<QueryRow> postFilter = options.getPostFilter();
        final int groupLevel = options.getGroupLevel();
        final boolean group = options.isGroup() || groupLevel > 0;
        final Reducer reduce = this.delegate.getReduce();
        if (options.isReduceSpecified() && options.isReduce() && reduce == null) {
            Log.w(TAG, String.format(Locale.ENGLISH, "Cannot use reduce option in view %s which has no reduce block defined", this.name));
            throw new CouchbaseLiteException(new Status(495));
        }
        final ArrayList<Object> keysToReduce = new ArrayList<Object>(100);
        final ArrayList<Object> valuesToReduce = new ArrayList<Object>(100);
        final Object[] lastKeys = new Object[]{null};
        SQLiteViewStore that = this;
        final ArrayList<QueryRow> rows = new ArrayList<QueryRow>();
        Status status = this.runQuery(options, new QueryRowBlock(){

            @Override
            public Status onRow(byte[] keyData, byte[] valueData, String docID, Cursor cursor) {
                JsonDocument keyDoc = new JsonDocument(keyData);
                JsonDocument valueDoc = new JsonDocument(valueData);
                assert (keyDoc != null);
                Object keyObject = keyDoc.jsonObject();
                if (group && !SQLiteViewStore.groupTogether(keyObject, lastKeys[0], groupLevel)) {
                    if (lastKeys[0] != null) {
                        Object key = SQLiteViewStore.groupKey(lastKeys[0], groupLevel);
                        Object reduced = reduce != null ? reduce.reduce(keysToReduce, valuesToReduce, false) : null;
                        QueryRow row = new QueryRow(null, 0L, key, reduced, null);
                        if (postFilter == null || postFilter.apply(row)) {
                            rows.add(row);
                        }
                        keysToReduce.clear();
                        valuesToReduce.clear();
                    }
                    lastKeys[0] = keyObject;
                }
                keysToReduce.add(keyObject);
                valuesToReduce.add(valueDoc.jsonObject());
                return new Status(200);
            }
        });
        if (keysToReduce != null && keysToReduce.size() > 0) {
            Object key = group ? SQLiteViewStore.groupKey(lastKeys[0], groupLevel) : null;
            Object reduced = reduce != null ? reduce.reduce(keysToReduce, valuesToReduce, false) : null;
            Log.v(TAG, String.format(Locale.ENGLISH, "Query %s: Reduced to key=%s, value=%s", this.name, key, reduced));
            QueryRow row = new QueryRow(null, 0L, key, reduced, null);
            if (postFilter == null || postFilter.apply(row)) {
                rows.add(row);
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> dump() {
        if (this.getViewID() < 0) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String sql = "SELECT sequence, key, value FROM 'maps_#' ORDER BY key";
        Cursor cursor = null;
        try {
            cursor = this.store.getStorageEngine().rawQuery(this.queryString(sql), null);
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("seq", cursor.getInt(0));
                row.put("key", cursor.getString(1));
                row.put("value", cursor.getString(2));
                result.add(row);
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @Override
    public boolean rowValueIsEntireDoc(byte[] valueData) {
        return valueData.length == 1 && new String(valueData).equals("*");
    }

    @Override
    public Object parseRowValue(byte[] valueData) {
        return null;
    }

    @Override
    public Map<String, Object> getDocumentProperties(String docID, long sequence) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getViewID() {
        if (this.viewID < 0) {
            String sql = "SELECT view_id FROM views WHERE name=?";
            String[] args = new String[]{this.name};
            Cursor cursor = null;
            try {
                cursor = this.store.getStorageEngine().rawQuery(sql, args);
                if (cursor.moveToNext()) {
                    this.viewID = cursor.getInt(0);
                }
            }
            catch (SQLException e) {
                Log.e("View", "Error getting view id", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return this.viewID;
    }

    private static String viewNames(List<SQLiteViewStore> views) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ViewStore viewStore : views) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(viewStore.getName());
        }
        return sb.toString();
    }

    private static String getJoinedSQLQuotedStrings(String[] strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("'");
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                sb.append("','");
            }
            sb.append(s.replace("'", "''"));
        }
        sb.append('\'');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runQuery(QueryOptions options, QueryRowBlock block) {
        if (options == null) {
            options = new QueryOptions();
        }
        String collationStr = "";
        if (this.collation == View.TDViewCollation.TDViewCollationASCII) {
            collationStr = collationStr + " COLLATE JSON_ASCII";
        } else if (this.collation == View.TDViewCollation.TDViewCollationRaw) {
            collationStr = collationStr + " COLLATE JSON_RAW";
        }
        StringBuilder sql = new StringBuilder("SELECT key, value, docid, revs.sequence");
        if (options.isIncludeDocs()) {
            sql.append(", revid, json");
        }
        sql.append(String.format(Locale.ENGLISH, " FROM 'maps_%s', revs, docs", this.mapTableName()));
        sql.append(" WHERE 1");
        ArrayList<String> argsList = new ArrayList<String>();
        if (options.getKeys() != null && options.getKeys().size() > 0) {
            sql.append(" AND key in (");
            String item = "?";
            for (Object key : options.getKeys()) {
                if (key == null) continue;
                sql.append(item);
                item = ", ?";
                argsList.add(SQLiteViewStore.toJSONString(key));
            }
            sql.append(')');
        }
        Object minKey = options.getStartKey();
        Object maxKey = options.getEndKey();
        String minKeyDocId = options.getStartKeyDocId();
        String maxKeyDocId = options.getEndKeyDocId();
        boolean inclusiveMin = options.isInclusiveStart();
        boolean inclusiveMax = options.isInclusiveEnd();
        if (options.isDescending()) {
            Object min = minKey;
            minKey = maxKey;
            maxKey = min;
            inclusiveMin = inclusiveMax;
            inclusiveMax = true;
            minKeyDocId = options.getEndKeyDocId();
            maxKeyDocId = options.getStartKeyDocId();
        }
        if (minKey != null) {
            String minKeyJSON = SQLiteViewStore.toJSONString(minKey);
            sql.append(inclusiveMin ? " AND key >= ?" : " AND key > ?");
            sql.append(collationStr);
            argsList.add(minKeyJSON);
            if (minKeyDocId != null && inclusiveMin) {
                sql.append(String.format(Locale.ENGLISH, " AND (key > ? %s OR docid >= ?)", collationStr));
                argsList.add(minKeyJSON);
                argsList.add(minKeyDocId);
            }
        }
        if (maxKey != null) {
            maxKey = View.keyForPrefixMatch(maxKey, options.getPrefixMatchLevel());
            String maxKeyJSON = SQLiteViewStore.toJSONString(maxKey);
            sql.append(inclusiveMax ? " AND key <= ?" : " AND key < ?");
            sql.append(collationStr);
            argsList.add(maxKeyJSON);
            if (maxKeyDocId != null && inclusiveMax) {
                sql.append(String.format(Locale.ENGLISH, " AND (key < ? %s OR docid <= ?)", collationStr));
                argsList.add(maxKeyJSON);
                argsList.add(maxKeyDocId);
            }
        }
        sql.append(String.format(Locale.ENGLISH, " AND revs.sequence = 'maps_%s'.sequence AND docs.doc_id = revs.doc_id ORDER BY key", this.mapTableName()));
        sql.append(collationStr);
        if (options.isDescending()) {
            sql.append(" DESC");
        }
        sql.append(options.isDescending() ? ", docid DESC" : ", docid");
        sql.append(" LIMIT ? OFFSET ?");
        argsList.add(Integer.toString(options.getLimit()));
        argsList.add(Integer.toString(options.getSkip()));
        Log.v("View", "Query %s: %s | args: %s", this.name, sql.toString(), argsList);
        Status status = new Status(200);
        Cursor cursor = null;
        try {
            cursor = this.store.getStorageEngine().rawQuery(sql.toString(), argsList.toArray(new String[argsList.size()]));
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                String docID;
                byte[] valueData;
                byte[] keyData = cursor.getBlob(0);
                status = block.onRow(keyData, valueData = cursor.getBlob(1), docID = cursor.getString(2), cursor);
                if (status.isError()) {
                    break;
                }
                if (status.getCode() <= 0) {
                    status = new Status(200);
                    break;
                }
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return status;
    }

    private static String toJSONString(Object object) {
        if (object == null) {
            return null;
        }
        String result = null;
        try {
            result = Manager.getObjectMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            Log.w("View", "Exception serializing object to json: %s", e, object);
        }
        return result;
    }

    private void updateTotalRows(int totalRows) {
        ContentValues values = new ContentValues();
        values.put("total_docs=", totalRows);
        this.store.getStorageEngine().update("views", values, "view_id=?", new String[]{String.valueOf(this.getViewID())});
    }

    private String mapTableName() {
        if (this._mapTableName == null) {
            this._mapTableName = String.valueOf(this.getViewID());
        }
        return this._mapTableName;
    }

    private String queryString(String sql) {
        return sql.replaceAll("#", this.mapTableName());
    }

    private boolean runStatements(final String sql) {
        final SQLiteStore db = this.store;
        return db.runInTransaction(new TransactionalTask(){

            @Override
            public boolean run() {
                try {
                    db.runStatements(SQLiteViewStore.this.queryString(sql));
                }
                catch (SQLException e) {
                    return false;
                }
                return true;
            }
        });
    }

    private void createIndex() {
        String sql = "CREATE TABLE IF NOT EXISTS 'maps_#' (sequence INTEGER NOT NULL REFERENCES revs(sequence) ON DELETE CASCADE,key TEXT NOT NULL COLLATE JSON,value TEXT)";
        if (!this.runStatements(sql)) {
            Log.w(TAG, "Couldn't create view _index `%s`", this.name);
        }
    }

    private static boolean groupTogether(Object key1, Object key2, int groupLevel) {
        if (groupLevel == 0 || !(key1 instanceof List) || !(key2 instanceof List)) {
            return key1.equals(key2);
        }
        List key1List = (List)key1;
        List key2List = (List)key2;
        if ((key1List.size() < groupLevel || key2List.size() < groupLevel) && key1List.size() != key2List.size()) {
            return false;
        }
        int end = Math.min(groupLevel, Math.min(key1List.size(), key2List.size()));
        for (int i = 0; i < end; ++i) {
            if (key1List.get(i).equals(key2List.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Object groupKey(Object key, int groupLevel) {
        if (groupLevel > 0 && key instanceof List && ((List)key).size() > groupLevel) {
            return ((List)key).subList(0, groupLevel);
        }
        return key;
    }

    private void finishCreatingIndex() {
        String sql = "CREATE INDEX IF NOT EXISTS 'maps_#_keys' on 'maps_#'(key COLLATE JSON);CREATE INDEX IF NOT EXISTS 'maps_#_sequence' ON 'maps_#'(sequence)";
        if (!this.runStatements(sql)) {
            Log.w(TAG, "Couldn't create view SQL index `%s`", this.name);
        }
    }

    private abstract class AbstractMapEmitBlock
    implements Emitter {
        protected long sequence = 0L;

        private AbstractMapEmitBlock() {
        }

        void setSequence(long sequence) {
            this.sequence = sequence;
        }
    }
}

