/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Batcher<T> {
    private static long SMALL_DELAY_AFTER_LONG_PAUSE = 500L;
    private ScheduledExecutorService workExecutor;
    private int capacity = 0;
    private long delay = 0L;
    private List<T> inbox = new ArrayList<T>();
    private boolean scheduled = false;
    private long scheduledDelay = 0L;
    private ScheduledFuture pendingFuture = null;
    private BatchProcessor<T> processor;
    private long lastProcessedTime = 0L;
    private boolean isFlushing = false;
    private final Object mutex = new Object();
    private final Object processMutex = new Object();

    public Batcher(ScheduledExecutorService workExecutor, int capacity, long delay, BatchProcessor<T> processor) {
        this.workExecutor = workExecutor;
        this.capacity = capacity;
        this.delay = delay;
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        Object object = this.mutex;
        synchronized (object) {
            return this.capacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDelay() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.inbox.size() == 0 && (this.pendingFuture == null || this.pendingFuture.isDone() || this.pendingFuture.isCancelled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Object object = this.mutex;
        synchronized (object) {
            return this.inbox.size();
        }
    }

    public void queueObject(T object) {
        this.queueObjects(Collections.singletonList(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueObjects(List<T> objects) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        boolean readyToProcess = false;
        Object object = this.mutex;
        synchronized (object) {
            Log.v("Batcher", "%s: queueObjects called with %d objects (current inbox size = %d)", this, objects.size(), this.inbox.size());
            this.inbox.addAll(objects);
            this.mutex.notifyAll();
            if (this.isFlushing) {
                return;
            }
            this.scheduleBatchProcess(false);
            if (this.inbox.size() >= this.capacity && this.isPendingFutureReadyOrInProcessing()) {
                readyToProcess = true;
            }
        }
        if (readyToProcess) {
            object = this.processMutex;
            synchronized (object) {
                try {
                    this.processMutex.wait(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll(boolean waitForAllToFinish) {
        Log.v("Batcher", "%s: flushing all objects (wait=%b)", this, waitForAllToFinish);
        Object object = this.mutex;
        synchronized (object) {
            this.isFlushing = true;
            this.unschedule();
        }
        while (true) {
            ScheduledFuture<?> future;
            Object object2 = this.mutex;
            synchronized (object2) {
                if (this.inbox.size() == 0) {
                    break;
                }
                final ArrayList<T> toProcess = new ArrayList<T>(this.inbox);
                this.inbox.clear();
                this.mutex.notifyAll();
                future = this.workExecutor.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Batcher.this.processor.process(toProcess);
                        Object object = Batcher.this.mutex;
                        synchronized (object) {
                            Batcher.this.lastProcessedTime = System.currentTimeMillis();
                        }
                    }
                }, 0L, TimeUnit.MILLISECONDS);
            }
            if (!waitForAllToFinish || future == null || future.isDone() || future.isCancelled()) continue;
            try {
                future.get();
            }
            catch (Exception e) {
                Log.e("Batcher", "%s: Error while waiting for pending future when flushing all items", e, this);
            }
        }
        object = this.mutex;
        synchronized (object) {
            this.isFlushing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.unschedule();
            this.inbox.clear();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPendingFutures() {
        Log.v("Batcher", "%s: waitForPendingFutures is called ...", this);
        while (true) {
            ScheduledFuture future;
            Object object = this.mutex;
            synchronized (object) {
                while (!this.inbox.isEmpty()) {
                    try {
                        Log.v("Batcher", "%s: waitForPendingFutures, inbox size: %d", this, this.inbox.size());
                        this.mutex.wait(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                future = this.pendingFuture;
            }
            if (future != null && !future.isDone() && !future.isCancelled()) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    Log.e("Batcher", "%s: Error while waiting for pending futures", e, this);
                }
            }
            object = this.mutex;
            synchronized (object) {
                if (this.inbox.isEmpty()) {
                    break;
                }
            }
        }
        Log.v("Batcher", "%s: waitForPendingFutures done", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleBatchProcess(boolean immediate) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.inbox.size() == 0) {
                return;
            }
            long suggestedDelay = 0L;
            if (!immediate && this.inbox.size() < this.capacity) {
                suggestedDelay = System.currentTimeMillis() - this.lastProcessedTime < this.delay ? this.delay : Math.min(SMALL_DELAY_AFTER_LONG_PAUSE, this.delay);
            }
            this.scheduleWithDelay(suggestedDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleWithDelay(long delay) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.scheduled && delay < this.scheduledDelay) {
                if (this.isPendingFutureReadyOrInProcessing()) {
                    Log.v("Batcher", "%s: scheduleWithDelay: %d ms, ignored as current batch is ready or in process", this, delay);
                    return;
                }
                this.unschedule();
            }
            if (!this.scheduled) {
                this.scheduled = true;
                this.scheduledDelay = delay;
                Log.v("Batcher", "%s: scheduleWithDelay %d ms, scheduled ...", this, delay);
                this.pendingFuture = this.workExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Log.v("Batcher", "%s: call processNow ...", this);
                        Batcher.this.processNow();
                        Log.v("Batcher", "%s: call processNow done", this);
                    }
                }, this.scheduledDelay, TimeUnit.MILLISECONDS);
            } else {
                Log.v("Batcher", "%s: scheduleWithDelay %d ms, ignored", this, delay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unschedule() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.pendingFuture != null && !this.pendingFuture.isDone() && !this.pendingFuture.isCancelled()) {
                Log.v("Batcher", "%s: cancelling the pending future ...", this);
                this.pendingFuture.cancel(false);
            }
            this.scheduled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPendingFutureReadyOrInProcessing() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.pendingFuture != null && !this.pendingFuture.isDone() && !this.pendingFuture.isCancelled()) {
                return this.pendingFuture.getDelay(TimeUnit.MILLISECONDS) <= 0L;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNow() {
        ArrayList<T> toProcess;
        boolean scheduleNextBatchImmediately = false;
        Object object = this.mutex;
        synchronized (object) {
            int count = this.inbox.size();
            Log.v("Batcher", "%s: processNow() called, inbox size: %d", this, count);
            if (count == 0) {
                return;
            }
            if (count <= this.capacity) {
                toProcess = new ArrayList<T>(this.inbox);
                this.inbox.clear();
            } else {
                toProcess = new ArrayList<T>(this.inbox.subList(0, this.capacity));
                for (int i = 0; i < this.capacity; ++i) {
                    this.inbox.remove(0);
                }
                scheduleNextBatchImmediately = true;
            }
            this.mutex.notifyAll();
        }
        object = this.processMutex;
        synchronized (object) {
            if (toProcess != null && toProcess.size() > 0) {
                Log.v("Batcher", "%s: invoking processor %s with %d items", this, this.processor, toProcess.size());
                this.processor.process(toProcess);
            } else {
                Log.v("Batcher", "%s: nothing to process", this);
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                this.lastProcessedTime = System.currentTimeMillis();
                this.scheduled = false;
                this.scheduleBatchProcess(scheduleNextBatchImmediately);
                Log.v("Batcher", "%s: invoking processor done", this, this.processor, toProcess.size());
            }
            this.processMutex.notifyAll();
        }
    }
}

