/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileDirUtils {
    public static boolean removeItemIfExists(String path) {
        File f = new File(path);
        return f.delete() || !f.exists();
    }

    public static boolean deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                FileDirUtils.deleteRecursive(child);
            }
        }
        return fileOrDirectory.delete() || !fileOrDirectory.exists();
    }

    public static boolean cleanDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        for (File file : dir.listFiles()) {
            if (FileDirUtils.deleteRecursive(file)) continue;
            return false;
        }
        return true;
    }

    public static String getDatabaseNameFromPath(String path) {
        String fileName = new File(path).getName();
        int extensionPos = fileName.lastIndexOf(46);
        if (extensionPos < 0) {
            String message = "Unable to determine database name from path: " + path;
            Log.e("Database", message);
            throw new IllegalArgumentException(message);
        }
        return fileName.substring(0, extensionPos);
    }

    public static String getPathWithoutExt(String path) {
        int pos = path.lastIndexOf(46);
        return pos > 0 ? path.substring(0, pos) : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                FileDirUtils.copyFolder(srcFile, destFile);
            }
        } else {
            FileDirUtils.copyFile(src, dest);
        }
    }
}

