/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.BlobStoreWriter;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.support.CustomByteArrayOutputStream;
import com.couchbase.lite.support.MultipartReader;
import com.couchbase.lite.support.MultipartReaderDelegate;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class MultipartDocumentReader
implements MultipartReaderDelegate {
    private MultipartReader multipartReader;
    private BlobStoreWriter curAttachment;
    private CustomByteArrayOutputStream jsonBuffer;
    private boolean jsonCompressed;
    private Map<String, Object> document;
    private Database database;
    private Map<String, BlobStoreWriter> attachmentsByName;
    private Map<String, BlobStoreWriter> attachmentsByMd5Digest;

    public MultipartDocumentReader(Database database) {
        this.database = database;
    }

    public Map<String, Object> getDocumentProperties() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseJsonBuffer() {
        block17: {
            ByteArrayInputStream in = new ByteArrayInputStream(this.jsonBuffer.buf(), 0, this.jsonBuffer.count());
            try {
                try {
                    if (this.jsonCompressed) {
                        GZIPInputStream gzipStream = new GZIPInputStream(in);
                        try {
                            this.document = (Map)Manager.getObjectMapper().readValue((InputStream)gzipStream, Map.class);
                            break block17;
                        }
                        finally {
                            gzipStream.close();
                        }
                    }
                    this.document = (Map)Manager.getObjectMapper().readValue((InputStream)in, Map.class);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse json buffer", e);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                try {
                    this.jsonBuffer.close();
                }
                catch (IOException iOException) {}
                this.jsonBuffer = null;
            }
        }
    }

    public void setHeaders(Map<String, String> headers) {
        String contentType = headers.get("Content-Type");
        if (contentType != null && contentType.startsWith("multipart/")) {
            this.multipartReader = new MultipartReader(contentType, this);
            this.attachmentsByName = new HashMap<String, BlobStoreWriter>();
            this.attachmentsByMd5Digest = new HashMap<String, BlobStoreWriter>();
        } else if (contentType == null || contentType.startsWith("application/json") || contentType.startsWith("text/plain")) {
            this.startJSONBufferWithHeaders(headers);
        } else {
            throw new IllegalArgumentException("Unknown/invalid MIME type");
        }
    }

    protected void startJSONBufferWithHeaders(Map<String, String> headers) {
        this.jsonBuffer = new CustomByteArrayOutputStream(1024);
        this.jsonCompressed = Utils.isGzip(headers.get("Content-Encoding"));
    }

    public void appendData(byte[] data) {
        if (this.multipartReader != null) {
            this.multipartReader.appendData(data);
        } else {
            this.jsonBuffer.write(data, 0, data.length);
        }
    }

    public void appendData(byte[] data, int off, int len) {
        if (this.multipartReader != null) {
            this.multipartReader.appendData(data, off, len);
        } else {
            this.jsonBuffer.write(data, off, len);
        }
    }

    public void finish() {
        if (this.multipartReader != null) {
            if (!this.multipartReader.finished()) {
                throw new IllegalStateException("received incomplete MIME multipart response");
            }
            this.registerAttachments();
        } else {
            this.parseJsonBuffer();
        }
    }

    private void registerAttachments() {
        int numAttachmentsInDoc = 0;
        Map attachments = (Map)this.document.get("_attachments");
        if (attachments == null) {
            return;
        }
        for (String attachmentName : attachments.keySet()) {
            Map attachment = (Map)attachments.get(attachmentName);
            int length = 0;
            if (attachment.containsKey("length")) {
                length = (Integer)attachment.get("length");
            }
            if (attachment.containsKey("encoded_length")) {
                length = (Integer)attachment.get("encoded_length");
            }
            if (attachment.containsKey("follows") && ((Boolean)attachment.get("follows")).booleanValue()) {
                String errMsg;
                String digest = (String)attachment.get("digest");
                BlobStoreWriter writer = this.attachmentsByName.get(attachmentName);
                if (writer != null) {
                    String actualDigest = writer.mD5DigestString();
                    if (digest != null && !digest.equals(actualDigest) && !digest.equals(writer.sHA1DigestString())) {
                        String errMsg2 = String.format(Locale.ENGLISH, "Attachment '%s' has incorrect MD5 getDigest (%s; should be either %s or %s)", attachmentName, digest, actualDigest, writer.sHA1DigestString());
                        throw new IllegalStateException(errMsg2);
                    }
                    attachment.put("digest", actualDigest);
                } else if (digest != null) {
                    writer = this.attachmentsByMd5Digest.get(digest);
                    if (writer == null) {
                        errMsg = String.format(Locale.ENGLISH, "Attachment '%s' does not appear in MIME body", attachmentName);
                        throw new IllegalStateException(errMsg);
                    }
                } else if (attachments.size() == 1 && this.attachmentsByMd5Digest.size() == 1) {
                    writer = this.attachmentsByMd5Digest.values().iterator().next();
                    attachment.put("digest", writer.mD5DigestString());
                } else {
                    errMsg = String.format(Locale.ENGLISH, "Attachment '%s' has no getDigest metadata; cannot identify MIME body", attachmentName);
                    throw new IllegalStateException(errMsg);
                }
                if (writer.getLength() != length) {
                    errMsg = String.format(Locale.ENGLISH, "Attachment '%s' has incorrect length field %d (should be %d)", attachmentName, length, writer.getLength());
                    throw new IllegalStateException(errMsg);
                }
                ++numAttachmentsInDoc;
                continue;
            }
            if (!attachment.containsKey("data") || length <= 1000) continue;
            Log.w("RemoteRequest", "Attachment '%s' sent inline (len=%d).  Large attachments should be sent in MIME parts for reduced memory overhead.", attachmentName, length);
        }
        if (numAttachmentsInDoc < this.attachmentsByMd5Digest.size()) {
            String msg = String.format(Locale.ENGLISH, "More MIME bodies (%d) than attachments (%d) ", this.attachmentsByMd5Digest.size(), numAttachmentsInDoc);
            throw new IllegalStateException(msg);
        }
        this.database.rememberAttachmentWritersForDigests(this.attachmentsByMd5Digest);
    }

    @Override
    public void startedPart(Map<String, String> headers) {
        if (this.document == null) {
            this.startJSONBufferWithHeaders(headers);
        } else {
            String contentDispositionUnquoted;
            String name;
            this.curAttachment = this.database.getAttachmentWriter();
            String contentDisposition = headers.get("Content-Disposition");
            if (contentDisposition != null && contentDisposition.startsWith("attachment; filename=") && (name = (contentDispositionUnquoted = Misc.unquoteString(contentDisposition)).substring(21)) != null) {
                this.attachmentsByName.put(name, this.curAttachment);
            }
        }
    }

    @Override
    public void appendToPart(byte[] data) {
        this.appendToPart(data, 0, data.length);
    }

    @Override
    public void appendToPart(byte[] data, int off, int len) {
        if (this.jsonBuffer != null) {
            this.jsonBuffer.write(data, off, len);
        } else {
            try {
                this.curAttachment.appendData(data, off, len);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to append data", e);
            }
        }
    }

    @Override
    public void finishedPart() {
        if (this.jsonBuffer != null) {
            this.parseJsonBuffer();
        } else {
            try {
                this.curAttachment.finish();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to finish attachment", e);
            }
            String md5String = this.curAttachment.mD5DigestString();
            this.attachmentsByMd5Digest.put(md5String, this.curAttachment);
            this.curAttachment = null;
        }
    }
}

