/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.support.ClearableCookieJar;
import com.couchbase.lite.support.SerializableCookie;
import com.couchbase.lite.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class PersistentCookieJar
implements ClearableCookieJar {
    private static final String SYNC_GATEWAY_SESSION_COOKIE_NAME = "SyncGatewaySession";
    private static final String COOKIE_LOCAL_DOC_NAME = "PersistentCookieStore";
    private final ConcurrentHashMap<String, Cookie> cookies = new ConcurrentHashMap();
    private final WeakReference<Database> dbWeakRef;

    public PersistentCookieJar(Database db) {
        this.dbWeakRef = new WeakReference<Database>(db);
        this.loadPreviouslyStoredCookies(db);
        this.clearExpired(new Date());
    }

    @Override
    public void clear() {
        try {
            this.getDb().putLocalDocument(COOKIE_LOCAL_DOC_NAME, null);
        }
        catch (CouchbaseLiteException e) {
            Log.i("Sync", "Unable to clear Cookies: Status=" + e.getCause(), e);
        }
        this.cookies.clear();
    }

    @Override
    public boolean clearExpired(Date date) {
        boolean clearedAny = false;
        for (Map.Entry<String, Cookie> entry : this.cookies.entrySet()) {
            String name = entry.getKey();
            Cookie cookie = entry.getValue();
            if (cookie.expiresAt() >= date.getTime()) continue;
            this.cookies.remove(name);
            this.deletePersistedCookie(name);
            clearedAny = true;
        }
        return clearedAny;
    }

    public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
        for (Cookie cookie : list) {
            String name = cookie.name() + cookie.domain();
            if (this.cookies.containsKey(name) && this.cookies.get(name).equals((Object)cookie)) {
                return;
            }
            if (SYNC_GATEWAY_SESSION_COOKIE_NAME.equalsIgnoreCase(cookie.name()) && this.cookies.containsKey(name)) {
                Cookie oldCookie = this.cookies.get(name);
                cookie = PersistentCookieJar.createCookie(cookie.name(), cookie.value(), cookie.domain(), oldCookie.path(), cookie.expiresAt());
            }
            if (cookie.expiresAt() > System.currentTimeMillis()) {
                this.cookies.put(name, cookie);
            } else {
                this.cookies.remove(name);
            }
            String encodedCookie = new SerializableCookie().encode(cookie);
            Map<String, Object> cookiesDoc = this.getDb().getExistingLocalDocument(COOKIE_LOCAL_DOC_NAME);
            if (cookiesDoc == null) {
                cookiesDoc = new HashMap<String, Object>();
            }
            Log.v("Sync", "Saving cookie: %s w/ encoded value: %s", name, encodedCookie);
            cookiesDoc.put(name, encodedCookie);
            try {
                this.getDb().putLocalDocument(COOKIE_LOCAL_DOC_NAME, cookiesDoc);
            }
            catch (CouchbaseLiteException e) {
                Log.e("Sync", "Exception saving local doc", e);
                throw new RuntimeException(e);
            }
        }
    }

    public List<Cookie> loadForRequest(HttpUrl httpUrl) {
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        if (httpUrl == null) {
            list.addAll(this.cookies.values());
        } else {
            for (Cookie cookie : this.cookies.values()) {
                if (!cookie.matches(httpUrl)) continue;
                list.add(cookie);
            }
        }
        return list;
    }

    public void deleteCookie(Cookie cookie) {
        this.cookies.remove(cookie.name());
        this.deletePersistedCookie(cookie.name());
    }

    private Database getDb() {
        return (Database)this.dbWeakRef.get();
    }

    private void loadPreviouslyStoredCookies(Database db) {
        Map<String, Object> cookiesDoc = db.getExistingLocalDocument(COOKIE_LOCAL_DOC_NAME);
        if (cookiesDoc == null) {
            return;
        }
        for (String name : cookiesDoc.keySet()) {
            Cookie decodedCookie;
            String encodedCookie;
            if (name.startsWith("_") || (encodedCookie = (String)cookiesDoc.get(name)) == null || (decodedCookie = new SerializableCookie().decode(encodedCookie)) == null) continue;
            this.cookies.put(name, decodedCookie);
        }
    }

    private static Cookie createCookie(String name, String value, String domain, String path, Date expirationDate) {
        return PersistentCookieJar.createCookie(name, value, domain, path, expirationDate.getTime());
    }

    private static Cookie createCookie(String name, String value, String domain, String path, long expiresAt) {
        return new Cookie.Builder().domain(domain).path(path).expiresAt(expiresAt).name(name).value(value).build();
    }

    private void deletePersistedCookie(String name) {
        Map<String, Object> cookiesDoc = this.getDb().getExistingLocalDocument(COOKIE_LOCAL_DOC_NAME);
        if (cookiesDoc == null) {
            return;
        }
        cookiesDoc.remove(name);
        try {
            this.getDb().putLocalDocument(COOKIE_LOCAL_DOC_NAME, cookiesDoc);
        }
        catch (CouchbaseLiteException e) {
            Log.e("Sync", "Exception saving local doc", e);
            throw new RuntimeException(e);
        }
    }
}

