/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Manager;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RevisionUtils {
    static List<String> specialKeysToRemove = Arrays.asList("_id", "_rev", "_deleted", "_revisions", "_revs_info", "_conflicts", "_deleted_conflicts", "_local_seq");
    static List<String> specialKeysToLeave = Arrays.asList("_attachments", "_removed");

    public static Map<String, Object> makeRevisionHistoryDict(List<RevisionInternal> history) {
        if (history == null) {
            return null;
        }
        ArrayList<String> suffixes = new ArrayList<String>();
        int start = -1;
        int lastRevNo = -1;
        for (RevisionInternal rev : history) {
            int revNo = RevisionUtils.parseRevIDNumber(rev.getRevID());
            String suffix = RevisionUtils.parseRevIDSuffix(rev.getRevID());
            if (revNo > 0 && suffix.length() > 0) {
                if (start < 0) {
                    start = revNo;
                } else if (revNo != lastRevNo - 1) {
                    start = -1;
                    break;
                }
                lastRevNo = revNo;
                suffixes.add(suffix);
                continue;
            }
            start = -1;
            break;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (start == -1) {
            suffixes = new ArrayList();
            for (RevisionInternal rev : history) {
                suffixes.add(rev.getRevID());
            }
        } else {
            result.put("start", start);
        }
        result.put("ids", suffixes);
        return result;
    }

    public static int parseRevIDNumber(String rev) {
        int result = -1;
        int dashPos = rev.indexOf(45);
        if (dashPos >= 0) {
            try {
                result = Integer.parseInt(rev.substring(0, dashPos));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String parseRevIDSuffix(String rev) {
        String result = null;
        int dashPos = rev.indexOf(45);
        if (dashPos >= 0) {
            result = rev.substring(dashPos + 1);
        }
        return result;
    }

    @InterfaceAudience.Private
    public static byte[] asCanonicalJSON(RevisionInternal rev) {
        return RevisionUtils.asCanonicalJSON(rev.getProperties());
    }

    @InterfaceAudience.Private
    public static byte[] asCanonicalJSON(Map<String, Object> props) {
        if (props == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(props.size());
        for (String key : props.keySet()) {
            boolean shouldAdd = false;
            if (!key.startsWith("_")) {
                shouldAdd = true;
            } else if (specialKeysToRemove.contains(key)) {
                shouldAdd = false;
            } else if (specialKeysToLeave.contains(key)) {
                shouldAdd = true;
            } else {
                Log.e("Database", "CBLDatabase: Invalid top-level key '%s' in document to be inserted", key);
                return null;
            }
            if (!shouldAdd) continue;
            properties.put(key, props.get(key));
        }
        byte[] json = null;
        try {
            json = Manager.getObjectMapper().writeValueAsBytes(properties);
        }
        catch (Exception e) {
            Log.e("Database", "Error serializing " + properties + " to JSON", e);
        }
        return json;
    }

    @InterfaceAudience.Private
    public static String generateRevID(byte[] json, boolean deleted, String prevID) {
        MessageDigest md5Digest;
        int generation = 0;
        if (prevID != null && (generation = RevisionInternal.generationFromRevID(prevID)) == 0) {
            return null;
        }
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        int length = 0;
        byte[] prevIDUTF8 = null;
        if (prevID != null) {
            prevIDUTF8 = prevID.getBytes(Charset.forName("UTF-8"));
            length = prevIDUTF8.length;
        }
        if (length > 255) {
            return null;
        }
        byte lengthByte = (byte)(length & 0xFF);
        byte[] lengthBytes = new byte[]{lengthByte};
        md5Digest.update(lengthBytes);
        if (length > 0 && prevIDUTF8 != null) {
            md5Digest.update(prevIDUTF8);
        }
        boolean isDeleted = deleted;
        byte[] deletedByte = new byte[]{(byte)(isDeleted ? 1 : 0)};
        md5Digest.update(deletedByte);
        if (json != null) {
            md5Digest.update(json);
        }
        byte[] md5DigestResult = md5Digest.digest();
        String digestAsHex = Utils.bytesToHex(md5DigestResult);
        int generationIncremented = generation + 1;
        return String.format(Locale.ENGLISH, "%d-%s", generationIncremented, digestAsHex).toLowerCase();
    }
}

