/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private HashMap<K, WeakValue<V>> references = new HashMap();
    private ReferenceQueue<V> referenceQueue = new ReferenceQueue();

    public WeakValueHashMap() {
    }

    public WeakValueHashMap(Map<? extends K, ? extends V> map) {
        this();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.pruneDeadReferences();
        WeakValue valueRef = new WeakValue(key, value, this.referenceQueue);
        return (V)this.getReferenceValue(this.references.put(key, valueRef));
    }

    @Override
    public V get(Object key) {
        this.pruneDeadReferences();
        return this.getReferenceValue(this.references.get(key));
    }

    @Override
    public V remove(Object key) {
        V value = this.getReferenceValue(this.references.get(key));
        this.references.remove(key);
        return value;
    }

    @Override
    public void clear() {
        this.references.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.pruneDeadReferences();
        return this.references.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.pruneDeadReferences();
        for (Map.Entry<K, WeakValue<V>> entry : this.references.entrySet()) {
            if (value != this.getReferenceValue(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        this.pruneDeadReferences();
        return this.references.keySet();
    }

    @Override
    public int size() {
        this.pruneDeadReferences();
        return this.references.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.pruneDeadReferences();
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, WeakValue<V>> entry : this.references.entrySet()) {
            entries.add(new AbstractMap.SimpleEntry<K, V>(entry.getKey(), this.getReferenceValue(entry.getValue())));
        }
        return entries;
    }

    @Override
    public Collection<V> values() {
        this.pruneDeadReferences();
        ArrayList<V> values = new ArrayList<V>();
        for (WeakValue<V> valueRef : this.references.values()) {
            values.add(this.getReferenceValue(valueRef));
        }
        return values;
    }

    private V getReferenceValue(WeakValue<V> valueRef) {
        return valueRef == null ? null : (V)valueRef.get();
    }

    private void pruneDeadReferences() {
        WeakValue valueRef;
        while ((valueRef = (WeakValue)this.referenceQueue.poll()) != null) {
            this.references.remove(valueRef.getKey());
        }
    }

    private class WeakValue<T>
    extends WeakReference<T> {
        private final K key;

        private WeakValue(K key, T value, ReferenceQueue<T> queue) {
            super(value, queue);
            this.key = key;
        }

        private K getKey() {
            return this.key;
        }
    }
}

