/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import com.couchbase.lite.util.Logger;
import com.couchbase.lite.util.LoggerFactory;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class Log {
    private static Logger logger = LoggerFactory.createLogger();
    private static ConcurrentHashMap<String, Integer> enabledTags = new ConcurrentHashMap();
    public static final String TAG = "CBLite";
    public static final String TAG_SYNC = "Sync";
    public static final String TAG_BATCHER = "Batcher";
    public static final String TAG_SYNC_ASYNC_TASK = "SyncAsyncTask";
    public static final String TAG_REMOTE_REQUEST = "RemoteRequest";
    public static final String TAG_VIEW = "View";
    public static final String TAG_QUERY = "Query";
    public static final String TAG_CHANGE_TRACKER = "ChangeTracker";
    public static final String TAG_ROUTER = "Router";
    public static final String TAG_DATABASE = "Database";
    public static final String TAG_LISTENER = "Listener";
    public static final String TAG_MULTI_STREAM_WRITER = "MultistreamWriter";
    public static final String TAG_BLOB_STORE = "BlobStore";
    public static final String TAG_SYMMETRIC_KEY = "SymmetricKey";
    public static final String TAG_ACTION = "Action";
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;

    public static void enableLogging(String tag, int logLevel) {
        enabledTags.put(tag, logLevel);
    }

    static boolean isLoggingEnabled(String tag, int logLevel) {
        Integer logLevelForTag = enabledTags.get(tag);
        return logLevel >= (logLevelForTag == null ? 4 : logLevelForTag);
    }

    public static void v(String tag, String msg) {
        if (logger != null && Log.isLoggingEnabled(tag, 2)) {
            logger.v(tag, msg);
        }
    }

    public static void v(String tag, String msg, Throwable tr) {
        if (logger != null && Log.isLoggingEnabled(tag, 2)) {
            logger.v(tag, msg, tr);
        }
    }

    public static void v(String tag, String formatString, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 2)) {
            try {
                logger.v(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.v(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void v(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 2)) {
            try {
                logger.v(tag, String.format(Locale.ENGLISH, formatString, args), tr);
            }
            catch (Exception e) {
                logger.v(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void d(String tag, String msg) {
        if (logger != null && Log.isLoggingEnabled(tag, 3)) {
            logger.d(tag, msg);
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (logger != null && Log.isLoggingEnabled(tag, 3)) {
            logger.d(tag, msg, tr);
        }
    }

    public static void d(String tag, String formatString, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 3)) {
            try {
                logger.d(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.d(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void d(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 3)) {
            try {
                logger.d(tag, String.format(Locale.ENGLISH, formatString, args, tr));
            }
            catch (Exception e) {
                logger.d(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void i(String tag, String msg) {
        if (logger != null && Log.isLoggingEnabled(tag, 4)) {
            logger.i(tag, msg);
        }
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (logger != null && Log.isLoggingEnabled(tag, 4)) {
            logger.i(tag, msg, tr);
        }
    }

    public static void i(String tag, String formatString, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 4)) {
            try {
                logger.i(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.i(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void i(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 4)) {
            try {
                logger.i(tag, String.format(Locale.ENGLISH, formatString, args, tr));
            }
            catch (Exception e) {
                logger.i(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void w(String tag, String msg) {
        if (logger != null && Log.isLoggingEnabled(tag, 5)) {
            logger.w(tag, msg);
        }
    }

    public static void w(String tag, Throwable tr) {
        if (logger != null && Log.isLoggingEnabled(tag, 5)) {
            logger.w(tag, tr);
        }
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (logger != null && Log.isLoggingEnabled(tag, 5)) {
            logger.w(tag, msg, tr);
        }
    }

    public static void w(String tag, String formatString, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 5)) {
            try {
                logger.w(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.w(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void w(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 5)) {
            try {
                logger.w(tag, String.format(Locale.ENGLISH, formatString, args), tr);
            }
            catch (Exception e) {
                logger.w(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void e(String tag, String msg) {
        if (logger != null && Log.isLoggingEnabled(tag, 6)) {
            logger.e(tag, msg);
        }
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (logger != null && Log.isLoggingEnabled(tag, 6)) {
            logger.e(tag, msg, tr);
        }
    }

    public static void e(String tag, String formatString, Throwable tr, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 6)) {
            try {
                logger.e(tag, String.format(Locale.ENGLISH, formatString, args), tr);
            }
            catch (Exception e) {
                logger.e(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    public static void e(String tag, String formatString, Object ... args) {
        if (logger != null && Log.isLoggingEnabled(tag, 6)) {
            try {
                logger.e(tag, String.format(Locale.ENGLISH, formatString, args));
            }
            catch (Exception e) {
                logger.e(tag, String.format(Locale.ENGLISH, "Unable to format log: %s", formatString), e);
            }
        }
    }

    static {
        enabledTags.put(TAG, 5);
        enabledTags.put(TAG_SYNC, 5);
        enabledTags.put(TAG_SYNC_ASYNC_TASK, 5);
        enabledTags.put(TAG_REMOTE_REQUEST, 5);
        enabledTags.put(TAG_VIEW, 5);
        enabledTags.put(TAG_QUERY, 5);
        enabledTags.put(TAG_CHANGE_TRACKER, 5);
        enabledTags.put(TAG_ROUTER, 5);
        enabledTags.put(TAG_DATABASE, 5);
        enabledTags.put(TAG_LISTENER, 5);
        enabledTags.put(TAG_MULTI_STREAM_WRITER, 5);
        enabledTags.put(TAG_BLOB_STORE, 5);
        enabledTags.put(TAG_SYMMETRIC_KEY, 5);
        enabledTags.put(TAG_ACTION, 5);
    }
}

