/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import com.couchbase.lite.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class NativeLibraryUtils {
    private static final Map<String, Boolean> LOADED_LIBRARIES = new HashMap<String, Boolean>();

    public static boolean loadLibrary(String libraryName) {
        if (LOADED_LIBRARIES.containsKey(libraryName)) {
            return true;
        }
        try {
            String libraryPath = NativeLibraryUtils.getConfiguredLibraryPath(libraryName);
            File libraryFile = libraryPath != null ? new File(libraryPath) : NativeLibraryUtils.extractLibrary(libraryName);
            if (libraryFile == null) {
                Log.e("CBLite", "Cannot find library: " + libraryName);
                return false;
            }
            System.load(libraryFile.getAbsolutePath());
            LOADED_LIBRARIES.put(libraryName, true);
        }
        catch (Exception e) {
            Log.e("CBLite", "Error loading library: " + libraryName, e);
            return false;
        }
        return true;
    }

    private static String getConfiguredLibraryPath(String libraryName) {
        String key = String.format(Locale.ENGLISH, "com.couchbase.lite.lib.%s.path", libraryName);
        return System.getProperty(key);
    }

    private static String getLibraryFullName(String libraryName) {
        String name = System.mapLibraryName(libraryName);
        if (name.endsWith(".jnilib")) {
            name = name.replace(".jnilib", ".dylib");
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractLibrary(String libraryName) throws IOException {
        String libraryResourcePath = NativeLibraryUtils.getLibraryResourcePath(libraryName);
        String targetFolder = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        File targetFile = new File(targetFolder, NativeLibraryUtils.getLibraryFullName(libraryName));
        if (targetFile.exists() && !targetFile.delete()) {
            Log.w("CBLite", "Failed to delete existing library file: " + targetFile.getAbsolutePath());
            return targetFile;
        }
        InputStream libraryReader = NativeLibraryUtils.class.getResourceAsStream(libraryResourcePath);
        if (libraryReader == null) {
            System.err.println("Library not found: " + libraryResourcePath);
            return null;
        }
        FileOutputStream libraryWriter = new FileOutputStream(targetFile);
        try {
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = libraryReader.read(buffer)) != -1) {
                libraryWriter.write(buffer, 0, bytesRead);
            }
        }
        finally {
            libraryWriter.close();
            libraryReader.close();
        }
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "755", targetFile.getAbsolutePath()}).waitFor();
            }
            catch (Throwable e) {
                Log.e("CBLite", "Error executing 'chmod 755' on extracted native library", e);
            }
        }
        return targetFile;
    }

    private static String getLibraryResourcePath(String libraryName) {
        String path = "/native";
        String osName = System.getProperty("os.name");
        path = osName.contains("Linux") ? path + "/linux" : (osName.contains("Mac") ? path + "/osx" : (osName.contains("Windows") ? path + "/windows" : path + '/' + osName.replaceAll("\\W", "").toLowerCase()));
        String archName = System.getProperty("os.arch");
        archName = archName.replaceAll("\\W", "");
        archName = archName.replace("-", "_");
        path = path + '/' + archName;
        path = path + '/' + NativeLibraryUtils.getLibraryFullName(libraryName);
        return path;
    }
}

