/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.listener;

import java.util.UUID;

public class Credentials {
    private String login;
    private String password;

    public Credentials() {
        this.setRandomUsernamePassword();
    }

    public Credentials(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setRandomUsernamePassword() {
        this.login = UUID.randomUUID().toString();
        this.password = UUID.randomUUID().toString();
    }

    public boolean empty() {
        boolean loginEmpty = this.login == null || this.login.isEmpty();
        boolean passwordEmpty = this.password == null || this.password.isEmpty();
        return loginEmpty && passwordEmpty;
    }

    public String toString() {
        return String.format("%s:%s", this.login, this.password);
    }

    public boolean equals(Object o) {
        if (o instanceof Credentials) {
            Credentials otherCreds = (Credentials)o;
            boolean sameLogin = false;
            boolean samePassword = false;
            String otherCredsLogin = otherCreds.getLogin();
            String otherCredsPassword = otherCreds.getPassword();
            sameLogin = otherCredsLogin == null || otherCredsLogin.isEmpty() ? this.getLogin() == null || this.getLogin().isEmpty() : this.getLogin().equals(otherCredsLogin);
            samePassword = otherCredsPassword == null || otherCredsPassword.isEmpty() ? this.getPassword() == null || this.getPassword().isEmpty() : this.getPassword().equals(otherCredsPassword);
            return sameLogin && samePassword;
        }
        return super.equals(o);
    }
}

