/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.listener;

import com.couchbase.lite.Manager;
import com.couchbase.lite.listener.Credentials;
import com.couchbase.lite.listener.LiteServer;
import com.couchbase.lite.router.URLStreamHandlerFactory;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;

public class LiteListener
implements Runnable {
    private static int DEF_SOCKET_TIMEOUT = 30000;
    private Thread thread;
    private Manager manager;
    private LiteServer httpServer;
    public static final String TAG = "LiteListener";
    private int listenPort;
    private int serverStatus;
    private int socketTimeout = DEF_SOCKET_TIMEOUT;

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public LiteListener(Manager manager, int suggestedPort, Credentials allowedCredentials, Properties tjwsProperties) {
        URLStreamHandlerFactory.registerSelfIgnoreError();
        this.manager = manager;
        this.httpServer = new LiteServer();
        this.httpServer.setProps(tjwsProperties);
        this.httpServer.setManager(manager);
        this.httpServer.setListener(this);
        this.listenPort = this.discoverEmptyPort(suggestedPort);
        this.httpServer.setPort(this.listenPort);
        this.httpServer.setAllowedCredentials(allowedCredentials);
    }

    public LiteListener(Manager manager, int suggestedPort, Credentials allowedCredentials) {
        this(manager, suggestedPort, allowedCredentials, new Properties());
    }

    public int discoverEmptyPort(int startPort) {
        for (int curPort = startPort; curPort < 65536; ++curPort) {
            try {
                ServerSocket socket = new ServerSocket(curPort);
                socket.close();
                return curPort;
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Could not bind to port: %d.  Trying another port.", (Object[])new Object[]{curPort});
                continue;
            }
        }
        throw new RuntimeException("Could not find empty port starting from: " + startPort);
    }

    @Override
    public void run() {
        this.serverStatus = this.httpServer.serve();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.httpServer.notifyStop();
    }

    public void onServerThread(Runnable r) {
        ScheduledExecutorService workExecutor = this.manager.getWorkExecutor();
        workExecutor.submit(r);
    }

    public int serverStatus() {
        return this.serverStatus;
    }

    public int getListenPort() {
        return this.listenPort;
    }
}

