/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.listener;

import Acme.Serve.Serve;
import com.couchbase.lite.Manager;
import com.couchbase.lite.listener.Credentials;
import com.couchbase.lite.listener.LiteListener;
import com.couchbase.lite.router.Router;
import com.couchbase.lite.router.RouterCallbackBlock;
import com.couchbase.lite.router.URLConnection;
import com.couchbase.lite.support.Base64;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LiteServlet
extends HttpServlet {
    private Manager manager;
    private LiteListener listener;
    private Credentials allowedCredentials;

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public void setListener(LiteListener listener) {
        this.listener = listener;
    }

    public void setAllowedCredentials(Credentials allowedCredentials) {
        this.allowedCredentials = allowedCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        Credentials requestCredentials = this.credentialsWithBasicAuthentication(request);
        if (this.allowedCredentials != null && !this.allowedCredentials.empty()) {
            if (requestCredentials == null || !requestCredentials.equals(this.allowedCredentials)) {
                Log.d((String)"Listener", (String)"Unauthorized -- requestCredentials not given or do not match allowed credentials");
                response.setHeader("WWW-Authenticate", "Basic realm=\"Couchbase Lite\"");
                response.setStatus(401);
                return;
            }
            Log.v((String)"Listener", (String)"Authorized via basic auth");
        } else {
            Log.v((String)"Listener", (String)"Not enforcing basic auth -- allowedCredentials null or empty");
        }
        String urlString = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            urlString = urlString + "?" + queryString;
        }
        URL url = new URL("cblite://" + urlString);
        final URLConnection conn = (URLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod(request.getMethod());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            conn.setRequestProperty(headerName, request.getHeader(headerName));
        }
        ServletInputStream is = request.getInputStream();
        if (is != null) {
            try {
                Field privateServeConnection = Serve.ServeInputStream.class.getDeclaredField("conn");
                privateServeConnection.setAccessible(true);
                Serve.ServeConnection serveConnection = (Serve.ServeConnection)privateServeConnection.get(is);
                Socket socket = serveConnection.getSocket();
                socket.setSoTimeout(this.listener.getSocketTimeout());
            }
            catch (Exception ex) {
                Log.e((String)"Listener", (String)"Exception by reflection", (Throwable)ex);
            }
            conn.setDoInput(true);
            conn.setRequestInputStream((InputStream)is);
        }
        ServletOutputStream os = response.getOutputStream();
        response.setBufferSize(128);
        final CountDownLatch doneSignal = new CountDownLatch(1);
        Router router = new Router(this.manager, conn);
        RouterCallbackBlock callbackBlock = new RouterCallbackBlock(){

            public void onResponseReady() {
                Log.v((String)"Listener", (String)"RouterCallbackBlock.onResponseReady() START");
                response.setStatus(conn.getResponseCode());
                Map headers = conn.getHeaderFields();
                if (headers != null) {
                    for (String headerName : headers.keySet()) {
                        for (String headerValue : (List)headers.get(headerName)) {
                            response.addHeader(headerName, headerValue);
                        }
                    }
                }
                doneSignal.countDown();
                Log.v((String)"Listener", (String)"RouterCallbackBlock.onResponseReady() END");
            }
        };
        router.setCallbackBlock(callbackBlock);
        router.setSource(this.remoteURL(request));
        router.start();
        try {
            int r;
            Log.v((String)"Listener", (String)"CountDownLatch.await() START");
            doneSignal.await();
            Log.v((String)"Listener", (String)"CountDownLatch.await() END");
            InputStream responseInputStream = conn.getResponseInputStream();
            byte[] buffer = new byte[65536];
            while ((r = responseInputStream.read(buffer)) > 0) {
                os.write(buffer, 0, r);
                os.flush();
                response.flushBuffer();
            }
            os.close();
        }
        catch (InterruptedException e) {
            Log.e((String)"Listener", (String)"Interrupted waiting for result", (Throwable)e);
        }
        finally {
            if (router != null) {
                router.stop();
            }
        }
    }

    public Credentials credentialsWithBasicAuthentication(HttpServletRequest req) {
        try {
            String authHeader = req.getHeader("Authorization");
            if (authHeader != null) {
                String basic;
                StringTokenizer st = new StringTokenizer(authHeader);
                if (st.hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                    try {
                        String credentials = new String(Base64.decode((String)st.nextToken()), "UTF-8");
                        Log.v((String)"Listener", (String)"Credentials: ", (Object[])new Object[]{credentials});
                        int p = credentials.indexOf(":");
                        if (p != -1) {
                            String login = credentials.substring(0, p).trim();
                            String password = credentials.substring(p + 1).trim();
                            return new Credentials(login, password);
                        }
                        Log.e((String)"Listener", (String)"Invalid authentication token");
                    }
                    catch (Exception e) {
                        Log.w((String)"Listener", (String)"Couldn't retrieve authentication", (Throwable)e);
                    }
                }
            } else {
                Log.d((String)"Listener", (String)"authHeader is null");
            }
        }
        catch (Exception e) {
            Log.e((String)"Listener", (String)"Exception getting basic auth credentials", (Throwable)e);
        }
        return null;
    }

    private URL remoteURL(HttpServletRequest req) {
        String addr = req.getRemoteAddr();
        Log.v((String)"Listener", (String)("remoteURL() addr=" + addr));
        if (!"127.0.0.1".equals(addr) && !"::1".equals(addr)) {
            if (addr.indexOf(58) >= 0) {
                addr = String.format("[%s]", addr);
            }
            String username = this.allowedCredentials != null ? this.allowedCredentials.getLogin() : null;
            String protocol = req.isSecure() ? "https" : "http";
            String spec = null;
            spec = username != null && username.length() > 0 ? String.format("%s://%s@%s/", protocol, username, addr) : String.format("%s://%s/", protocol, addr);
            try {
                return new URL(spec);
            }
            catch (MalformedURLException e) {
                Log.w((String)"Listener", (String)"failed to create remote URL", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

