/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.javascript;

import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.javascript.scopes.GlobalScope;
import com.couchbase.lite.javascript.wrapper.CustomWrapFactory;
import com.couchbase.lite.util.Log;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

public class ReplicationFilterBlockRhino
implements ReplicationFilter {
    public static String TAG = "ReplicationFilterBlockRhino";
    private static WrapFactory wrapFactory = new CustomWrapFactory();
    private Scriptable scope;
    private GlobalScope globalScope;
    private Function filterFunction;

    public ReplicationFilterBlockRhino(String src) {
        Context ctx = Context.enter();
        try {
            ctx.setOptimizationLevel(-1);
            ctx.setWrapFactory(wrapFactory);
            this.globalScope = new GlobalScope();
            this.scope = ctx.initStandardObjects((ScriptableObject)this.globalScope, true);
            this.filterFunction = ctx.compileFunction(this.scope, src, "filter", 0, null);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filter(SavedRevision revision, Map<String, Object> params) {
        Context ctx = Context.enter();
        try {
            ctx.setOptimizationLevel(-1);
            ctx.setWrapFactory(wrapFactory);
            Scriptable localScope = ctx.newObject(this.scope);
            localScope.setPrototype(this.scope);
            localScope.setParentScope(null);
            Object jsDocument = Context.javaToJS((Object)revision.getProperties(), (Scriptable)localScope);
            Object jsParams = Context.javaToJS(params, (Scriptable)localScope);
            try {
                Object result = this.filterFunction.call(ctx, localScope, null, new Object[]{jsDocument, jsParams});
                boolean bl = (Boolean)result;
                return bl;
            }
            catch (RhinoException e) {
                Log.e((String)TAG, (String)"Error in filterFunction.call()", (Throwable)e);
                boolean bl = false;
                Context.exit();
                return bl;
            }
        }
        finally {
            Context.exit();
        }
    }
}

