/*
 * Decompiled with CFR 0.152.
 */
package com.github.oxo42.stateless4j;

import com.github.oxo42.stateless4j.StateRepresentation;
import com.github.oxo42.stateless4j.delegates.Action;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Action2;
import com.github.oxo42.stateless4j.delegates.Action3;
import com.github.oxo42.stateless4j.delegates.Action4;
import com.github.oxo42.stateless4j.delegates.Func;
import com.github.oxo42.stateless4j.delegates.Func2;
import com.github.oxo42.stateless4j.delegates.Func3;
import com.github.oxo42.stateless4j.delegates.Func4;
import com.github.oxo42.stateless4j.delegates.FuncBoolean;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.github.oxo42.stateless4j.transitions.TransitioningTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.DynamicTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.IgnoredTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters2;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters3;

public class StateConfiguration<TState, TTrigger> {
    private static final FuncBoolean NO_GUARD = new FuncBoolean(){

        @Override
        public boolean call() {
            return true;
        }
    };
    private final StateRepresentation<TState, TTrigger> representation;
    private final Func2<TState, StateRepresentation<TState, TTrigger>> lookup;

    public StateConfiguration(StateRepresentation<TState, TTrigger> representation, Func2<TState, StateRepresentation<TState, TTrigger>> lookup) {
        assert (representation != null) : "representation is null";
        assert (lookup != null) : "lookup is null";
        this.representation = representation;
        this.lookup = lookup;
    }

    public StateConfiguration<TState, TTrigger> permit(TTrigger trigger, TState destinationState) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermit(trigger, destinationState);
    }

    public StateConfiguration<TState, TTrigger> permitIf(TTrigger trigger, TState destinationState, FuncBoolean guard) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermitIf(trigger, destinationState, guard);
    }

    public StateConfiguration<TState, TTrigger> permitReentry(TTrigger trigger) {
        return this.publicPermit(trigger, this.representation.getUnderlyingState());
    }

    public StateConfiguration<TState, TTrigger> permitReentryIf(TTrigger trigger, FuncBoolean guard) {
        return this.publicPermitIf(trigger, this.representation.getUnderlyingState(), guard);
    }

    public StateConfiguration<TState, TTrigger> ignore(TTrigger trigger) {
        return this.ignoreIf(trigger, NO_GUARD);
    }

    public StateConfiguration<TState, TTrigger> ignoreIf(TTrigger trigger, FuncBoolean guard) {
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new IgnoredTriggerBehaviour(trigger, guard));
        return this;
    }

    public StateConfiguration<TState, TTrigger> onEntry(final Action entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntry(new Action1<Transition<TState, TTrigger>>(){

            @Override
            public void doIt(Transition<TState, TTrigger> t) {
                entryAction.doIt();
            }
        });
    }

    public StateConfiguration<TState, TTrigger> onEntry(final Action1<Transition<TState, TTrigger>> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(new Action2<Transition<TState, TTrigger>, Object[]>(){

            @Override
            public void doIt(Transition<TState, TTrigger> arg1, Object[] arg2) {
                entryAction.doIt(arg1);
            }
        });
        return this;
    }

    public StateConfiguration<TState, TTrigger> onEntryFrom(TTrigger trigger, final Action entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action1<Transition<TState, TTrigger>>(){

            @Override
            public void doIt(Transition<TState, TTrigger> arg1) {
                entryAction.doIt();
            }
        });
    }

    public StateConfiguration<TState, TTrigger> onEntryFrom(TTrigger trigger, final Action1<Transition<TState, TTrigger>> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger, new Action2<Transition<TState, TTrigger>, Object[]>(){

            @Override
            public void doIt(Transition<TState, TTrigger> arg1, Object[] arg2) {
                entryAction.doIt(arg1);
            }
        });
        return this;
    }

    public <TArg0> StateConfiguration<TState, TTrigger> onEntryFrom(TriggerWithParameters1<TArg0, TState, TTrigger> trigger, final Action1<TArg0> entryAction, Class<TArg0> classe0) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action2<TArg0, Transition<TState, TTrigger>>(){

            @Override
            public void doIt(TArg0 arg1, Transition<TState, TTrigger> arg2) {
                entryAction.doIt(arg1);
            }
        }, classe0);
    }

    public <TArg0> StateConfiguration<TState, TTrigger> onEntryFrom(TriggerWithParameters1<TArg0, TState, TTrigger> trigger, final Action2<TArg0, Transition<TState, TTrigger>> entryAction, Class<TArg0> classe0) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<TState, TTrigger>, Object[]>(){

            @Override
            public void doIt(Transition<TState, TTrigger> t, Object[] arg2) {
                entryAction.doIt(arg2[0], t);
            }
        });
        return this;
    }

    public <TArg0, TArg1> StateConfiguration<TState, TTrigger> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> trigger, final Action2<TArg0, TArg1> entryAction, Class<TArg0> classe0, Class<TArg1> classe1) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action3<TArg0, TArg1, Transition<TState, TTrigger>>(){

            @Override
            public void doIt(TArg0 a0, TArg1 a1, Transition<TState, TTrigger> t) {
                entryAction.doIt(a0, a1);
            }
        }, classe0, classe1);
    }

    public <TArg0, TArg1> StateConfiguration<TState, TTrigger> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> trigger, final Action3<TArg0, TArg1, Transition<TState, TTrigger>> entryAction, Class<TArg0> classe0, Class<TArg1> classe1) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<TState, TTrigger>, Object[]>(){

            @Override
            public void doIt(Transition<TState, TTrigger> t, Object[] args) {
                entryAction.doIt(args[0], args[1], t);
            }
        });
        return this;
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<TState, TTrigger> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> trigger, final Action3<TArg0, TArg1, TArg2> entryAction, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action4<TArg0, TArg1, TArg2, Transition<TState, TTrigger>>(){

            @Override
            public void doIt(TArg0 a0, TArg1 a1, TArg2 a2, Transition<TState, TTrigger> t) {
                entryAction.doIt(a0, a1, a2);
            }
        }, classe0, classe1, classe2);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<TState, TTrigger> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> trigger, final Action4<TArg0, TArg1, TArg2, Transition<TState, TTrigger>> entryAction, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<TState, TTrigger>, Object[]>(){

            @Override
            public void doIt(Transition<TState, TTrigger> t, Object[] args) {
                entryAction.doIt(args[0], args[1], args[2], t);
            }
        });
        return this;
    }

    public StateConfiguration<TState, TTrigger> onExit(final Action exitAction) {
        assert (exitAction != null) : "exitAction is null";
        return this.onExit(new Action1<Transition<TState, TTrigger>>(){

            @Override
            public void doIt(Transition<TState, TTrigger> arg1) {
                exitAction.doIt();
            }
        });
    }

    public StateConfiguration<TState, TTrigger> onExit(Action1<Transition<TState, TTrigger>> exitAction) {
        assert (exitAction != null) : "exitAction is null";
        this.representation.addExitAction(exitAction);
        return this;
    }

    public StateConfiguration<TState, TTrigger> substateOf(TState superstate) {
        StateRepresentation<TState, TTrigger> superRepresentation = this.lookup.call(superstate);
        this.representation.setSuperstate(superRepresentation);
        superRepresentation.addSubstate(this.representation);
        return this;
    }

    public StateConfiguration<TState, TTrigger> permitDynamic(TTrigger trigger, Func<TState> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0> StateConfiguration<TState, TTrigger> permitDynamic(TriggerWithParameters1<TArg0, TState, TTrigger> trigger, Func2<TArg0, TState> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0, TArg1> StateConfiguration<TState, TTrigger> permitDynamic(TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> trigger, Func3<TArg0, TArg1, TState> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<TState, TTrigger> permitDynamic(TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> trigger, Func4<TArg0, TArg1, TArg2, TState> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public StateConfiguration<TState, TTrigger> permitDynamicIf(TTrigger trigger, final Func<TState> destinationStateSelector, FuncBoolean guard) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger, new Func2<Object[], TState>(){

            @Override
            public TState call(Object[] arg0) {
                return destinationStateSelector.call();
            }
        }, guard);
    }

    public <TArg0> StateConfiguration<TState, TTrigger> permitDynamicIf(TriggerWithParameters1<TArg0, TState, TTrigger> trigger, final Func2<TArg0, TState> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], TState>(){

            @Override
            public TState call(Object[] args) {
                return destinationStateSelector.call(args[0]);
            }
        }, guard);
    }

    public <TArg0, TArg1> StateConfiguration<TState, TTrigger> permitDynamicIf(TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> trigger, final Func3<TArg0, TArg1, TState> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], TState>(){

            @Override
            public TState call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1]);
            }
        }, guard);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<TState, TTrigger> permitDynamicIf(TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> trigger, final Func4<TArg0, TArg1, TArg2, TState> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], TState>(){

            @Override
            public TState call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1], args[2]);
            }
        }, guard);
    }

    void enforceNotIdentityTransition(TState destination) {
        if (destination.equals(this.representation.getUnderlyingState())) {
            throw new IllegalStateException("Permit() (and PermitIf()) require that the destination state is not equal to the source state. To accept a trigger without changing state, use either Ignore() or PermitReentry().");
        }
    }

    StateConfiguration<TState, TTrigger> publicPermit(TTrigger trigger, TState destinationState) {
        return this.publicPermitIf(trigger, destinationState, NO_GUARD);
    }

    StateConfiguration<TState, TTrigger> publicPermitIf(TTrigger trigger, TState destinationState, FuncBoolean guard) {
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new TransitioningTriggerBehaviour<TState, TTrigger>(trigger, destinationState, guard));
        return this;
    }

    StateConfiguration<TState, TTrigger> publicPermitDynamic(TTrigger trigger, Func2<Object[], TState> destinationStateSelector) {
        return this.publicPermitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    StateConfiguration<TState, TTrigger> publicPermitDynamicIf(TTrigger trigger, Func2<Object[], TState> destinationStateSelector, FuncBoolean guard) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new DynamicTriggerBehaviour<TState, TTrigger>(trigger, destinationStateSelector, guard));
        return this;
    }
}

