/*
 * Decompiled with CFR 0.152.
 */
package com.github.oxo42.stateless4j;

import com.github.oxo42.stateless4j.OutVar;
import com.github.oxo42.stateless4j.StateConfiguration;
import com.github.oxo42.stateless4j.StateReference;
import com.github.oxo42.stateless4j.StateRepresentation;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Action2;
import com.github.oxo42.stateless4j.delegates.Func;
import com.github.oxo42.stateless4j.delegates.Func2;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.github.oxo42.stateless4j.transitions.TransitioningTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.TriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters2;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters3;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateMachine<TState, TTrigger> {
    protected final Map<TState, StateRepresentation<TState, TTrigger>> stateConfiguration = new HashMap<TState, StateRepresentation<TState, TTrigger>>();
    protected final Map<TTrigger, TriggerWithParameters<TState, TTrigger>> triggerConfiguration = new HashMap<TTrigger, TriggerWithParameters<TState, TTrigger>>();
    protected final Func<TState> stateAccessor;
    protected final Action1<TState> stateMutator;
    protected Action2<TState, TTrigger> unhandledTriggerAction = new Action2<TState, TTrigger>(){

        @Override
        public void doIt(TState state, TTrigger trigger) {
            throw new IllegalStateException(String.format("No valid leaving transitions are permitted from state '%s' for trigger '%s'. Consider ignoring the trigger.", state, trigger));
        }
    };

    public StateMachine(TState initialState) {
        final StateReference reference = new StateReference();
        reference.setState(initialState);
        this.stateAccessor = new Func<TState>(){

            @Override
            public TState call() {
                return reference.getState();
            }
        };
        this.stateMutator = new Action1<TState>(){

            @Override
            public void doIt(TState s) {
                reference.setState(s);
            }
        };
    }

    public TState getState() {
        return this.stateAccessor.call();
    }

    private void setState(TState value) {
        this.stateMutator.doIt(value);
    }

    public List<TTrigger> getPermittedTriggers() {
        return this.getCurrentRepresentation().getPermittedTriggers();
    }

    StateRepresentation<TState, TTrigger> getCurrentRepresentation() {
        return this.getRepresentation(this.getState());
    }

    protected StateRepresentation<TState, TTrigger> getRepresentation(TState state) {
        StateRepresentation<TState, TTrigger> result = this.stateConfiguration.get(state);
        if (result == null) {
            result = new StateRepresentation(state);
            this.stateConfiguration.put(state, result);
        }
        return result;
    }

    public StateConfiguration<TState, TTrigger> configure(TState state) {
        return new StateConfiguration<TState, TTrigger>(this.getRepresentation(state), new Func2<TState, StateRepresentation<TState, TTrigger>>(){

            @Override
            public StateRepresentation<TState, TTrigger> call(TState arg0) {
                return StateMachine.this.getRepresentation(arg0);
            }
        });
    }

    public void fire(TTrigger trigger) {
        this.publicFire(trigger, new Object[0]);
    }

    public <TArg0> void fire(TriggerWithParameters1<TArg0, TState, TTrigger> trigger, TArg0 arg0) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0);
    }

    public <TArg0, TArg1> void fire(TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> trigger, TArg0 arg0, TArg1 arg1) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0, arg1);
    }

    public <TArg0, TArg1, TArg2> void fire(TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> trigger, TArg0 arg0, TArg1 arg1, TArg2 arg2) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0, arg1, arg2);
    }

    protected void publicFire(TTrigger trigger, Object ... args) {
        OutVar destination;
        TriggerBehaviour<TState, TTrigger> triggerBehaviour;
        TriggerWithParameters<TState, TTrigger> configuration = this.triggerConfiguration.get(trigger);
        if (configuration != null) {
            configuration.validateParameters(args);
        }
        if ((triggerBehaviour = this.getCurrentRepresentation().tryFindHandler(trigger)) == null) {
            this.unhandledTriggerAction.doIt(this.getCurrentRepresentation().getUnderlyingState(), trigger);
            return;
        }
        TState source = this.getState();
        if (triggerBehaviour.resultsInTransitionFrom(source, args, destination = new OutVar())) {
            Transition<TState, TTrigger> transition = new Transition<TState, TTrigger>(source, destination.get(), trigger);
            this.getCurrentRepresentation().exit(transition);
            this.setState(destination.get());
            this.getCurrentRepresentation().enter(transition, args);
        }
    }

    public void onUnhandledTrigger(Action2<TState, TTrigger> unhandledTriggerAction) {
        if (unhandledTriggerAction == null) {
            throw new IllegalStateException("unhandledTriggerAction");
        }
        this.unhandledTriggerAction = unhandledTriggerAction;
    }

    public boolean isInState(TState state) {
        return this.getCurrentRepresentation().isIncludedIn(state);
    }

    public boolean canFire(TTrigger trigger) {
        return this.getCurrentRepresentation().canHandle(trigger);
    }

    public String toString() {
        List<TTrigger> permittedTriggers = this.getPermittedTriggers();
        ArrayList<String> parameters = new ArrayList<String>();
        for (TTrigger tTrigger : permittedTriggers) {
            parameters.add(tTrigger.toString());
        }
        StringBuilder params = new StringBuilder();
        String delim = "";
        for (String param : parameters) {
            params.append(delim);
            params.append(param);
            delim = ", ";
        }
        return String.format("StateMachine {{ State = %s, PermittedTriggers = {{ %s }}}}", this.getState(), params.toString());
    }

    public <TArg0> TriggerWithParameters1<TArg0, TState, TTrigger> setTriggerParameters(TTrigger trigger, Class<TArg0> classe0) {
        TriggerWithParameters1 configuration = new TriggerWithParameters1(trigger, classe0);
        this.saveTriggerConfiguration(configuration);
        return configuration;
    }

    public <TArg0, TArg1> TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> setTriggerParameters(TTrigger trigger, Class<TArg0> classe0, Class<TArg1> classe1) {
        TriggerWithParameters2 configuration = new TriggerWithParameters2(trigger, classe0, classe1);
        this.saveTriggerConfiguration(configuration);
        return configuration;
    }

    public <TArg0, TArg1, TArg2> TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> setTriggerParameters(TTrigger trigger, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        TriggerWithParameters3 configuration = new TriggerWithParameters3(trigger, classe0, classe1, classe2);
        this.saveTriggerConfiguration(configuration);
        return configuration;
    }

    private void saveTriggerConfiguration(TriggerWithParameters<TState, TTrigger> trigger) {
        if (this.triggerConfiguration.containsKey(trigger.getTrigger())) {
            throw new IllegalStateException("Parameters for the trigger '" + trigger + "' have already been configured.");
        }
        this.triggerConfiguration.put(trigger.getTrigger(), trigger);
    }

    public void generateDotFileInto(OutputStream dotFile) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(dotFile, "UTF-8");){
            PrintWriter writer = new PrintWriter(w);
            writer.write("digraph G {\n");
            OutVar<Object> destination = new OutVar<Object>();
            for (Map.Entry<TState, StateRepresentation<TState, TTrigger>> entry : this.stateConfiguration.entrySet()) {
                Map<TTrigger, List<TriggerBehaviour<TState, TTrigger>>> behaviours = entry.getValue().getTriggerBehaviours();
                for (Map.Entry<TTrigger, List<TriggerBehaviour<TState, TTrigger>>> behaviour : behaviours.entrySet()) {
                    for (TriggerBehaviour<Object, TTrigger> triggerBehaviour : behaviour.getValue()) {
                        if (!(triggerBehaviour instanceof TransitioningTriggerBehaviour)) continue;
                        destination.set(null);
                        triggerBehaviour.resultsInTransitionFrom(null, null, destination);
                        writer.write(String.format("\t%s -> %s;\n", entry.getKey(), destination));
                    }
                }
            }
            writer.write("}");
        }
    }
}

