/*
 * Decompiled with CFR 0.152.
 */
package com.github.oxo42.stateless4j;

import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Action2;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.github.oxo42.stateless4j.triggers.TriggerBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StateRepresentation<TState, TTrigger> {
    private final TState state;
    private final Map<TTrigger, List<TriggerBehaviour<TState, TTrigger>>> triggerBehaviours = new HashMap<TTrigger, List<TriggerBehaviour<TState, TTrigger>>>();
    private final List<Action2<Transition<TState, TTrigger>, Object[]>> entryActions = new ArrayList<Action2<Transition<TState, TTrigger>, Object[]>>();
    private final List<Action1<Transition<TState, TTrigger>>> exitActions = new ArrayList<Action1<Transition<TState, TTrigger>>>();
    private final List<StateRepresentation<TState, TTrigger>> substates = new ArrayList<StateRepresentation<TState, TTrigger>>();
    private StateRepresentation<TState, TTrigger> superstate;

    public StateRepresentation(TState state) {
        this.state = state;
    }

    protected Map<TTrigger, List<TriggerBehaviour<TState, TTrigger>>> getTriggerBehaviours() {
        return this.triggerBehaviours;
    }

    public Boolean canHandle(TTrigger trigger) {
        return this.tryFindHandler(trigger) != null;
    }

    public TriggerBehaviour<TState, TTrigger> tryFindHandler(TTrigger trigger) {
        TriggerBehaviour<TState, TTrigger> result = this.tryFindLocalHandler(trigger);
        if (result == null && this.superstate != null) {
            result = this.superstate.tryFindHandler(trigger);
        }
        return result;
    }

    TriggerBehaviour<TState, TTrigger> tryFindLocalHandler(TTrigger trigger) {
        List<TriggerBehaviour<TState, TTrigger>> possible = this.triggerBehaviours.get(trigger);
        if (possible == null) {
            return null;
        }
        ArrayList<TriggerBehaviour<TState, TTrigger>> actual = new ArrayList<TriggerBehaviour<TState, TTrigger>>();
        for (TriggerBehaviour<TState, TTrigger> triggerBehaviour : possible) {
            if (!triggerBehaviour.isGuardConditionMet()) continue;
            actual.add(triggerBehaviour);
        }
        if (actual.size() > 1) {
            throw new IllegalStateException("Multiple permitted exit transitions are configured from state '" + trigger + "' for trigger '" + this.state + "'. Guard clauses must be mutually exclusive.");
        }
        return (TriggerBehaviour)actual.get(0);
    }

    public void addEntryAction(final TTrigger trigger, final Action2<Transition<TState, TTrigger>, Object[]> action) {
        assert (action != null) : "action is null";
        this.entryActions.add(new Action2<Transition<TState, TTrigger>, Object[]>(){

            @Override
            public void doIt(Transition<TState, TTrigger> t, Object[] args) {
                if (t.getTrigger().equals(trigger)) {
                    action.doIt(t, args);
                }
            }
        });
    }

    public void addEntryAction(Action2<Transition<TState, TTrigger>, Object[]> action) {
        assert (action != null) : "action is null";
        this.entryActions.add(action);
    }

    public void insertEntryAction(Action2<Transition<TState, TTrigger>, Object[]> action) {
        assert (action != null) : "action is null";
        this.entryActions.add(0, action);
    }

    public void addExitAction(Action1<Transition<TState, TTrigger>> action) {
        assert (action != null) : "action is null";
        this.exitActions.add(action);
    }

    public void enter(Transition<TState, TTrigger> transition, Object ... entryArgs) {
        assert (transition != null) : "transition is null";
        if (transition.isReentry()) {
            this.executeEntryActions(transition, entryArgs);
        } else if (!this.includes(transition.getSource())) {
            if (this.superstate != null) {
                this.superstate.enter(transition, entryArgs);
            }
            this.executeEntryActions(transition, entryArgs);
        }
    }

    public void exit(Transition<TState, TTrigger> transition) {
        assert (transition != null) : "transition is null";
        if (transition.isReentry()) {
            this.executeExitActions(transition);
        } else if (!this.includes(transition.getDestination())) {
            this.executeExitActions(transition);
            if (this.superstate != null) {
                this.superstate.exit(transition);
            }
        }
    }

    void executeEntryActions(Transition<TState, TTrigger> transition, Object[] entryArgs) {
        assert (transition != null) : "transition is null";
        assert (entryArgs != null) : "entryArgs is null";
        for (Action2<Transition<TState, TTrigger>, Object[]> action : this.entryActions) {
            action.doIt(transition, entryArgs);
        }
    }

    void executeExitActions(Transition<TState, TTrigger> transition) {
        assert (transition != null) : "transition is null";
        for (Action1<Transition<TState, TTrigger>> action : this.exitActions) {
            action.doIt(transition);
        }
    }

    public void addTriggerBehaviour(TriggerBehaviour<TState, TTrigger> triggerBehaviour) {
        List<Object> allowed;
        if (!this.triggerBehaviours.containsKey(triggerBehaviour.getTrigger())) {
            allowed = new ArrayList();
            this.triggerBehaviours.put(triggerBehaviour.getTrigger(), allowed);
        }
        allowed = this.triggerBehaviours.get(triggerBehaviour.getTrigger());
        allowed.add(triggerBehaviour);
    }

    public StateRepresentation<TState, TTrigger> getSuperstate() {
        return this.superstate;
    }

    public void setSuperstate(StateRepresentation<TState, TTrigger> value) {
        this.superstate = value;
    }

    public TState getUnderlyingState() {
        return this.state;
    }

    public void addSubstate(StateRepresentation<TState, TTrigger> substate) {
        assert (substate != null) : "substate is null";
        this.substates.add(substate);
    }

    public boolean includes(TState stateToCheck) {
        for (StateRepresentation<TState, TTrigger> s : this.substates) {
            if (!s.includes(stateToCheck)) continue;
            return true;
        }
        return this.state.equals(stateToCheck);
    }

    public boolean isIncludedIn(TState stateToCheck) {
        return this.state.equals(stateToCheck) || this.superstate != null && this.superstate.isIncludedIn(stateToCheck);
    }

    public List<TTrigger> getPermittedTriggers() {
        HashSet<TTrigger> result = new HashSet<TTrigger>();
        block0: for (TTrigger t : this.triggerBehaviours.keySet()) {
            for (TriggerBehaviour<TState, TTrigger> v : this.triggerBehaviours.get(t)) {
                if (!v.isGuardConditionMet()) continue;
                result.add(t);
                continue block0;
            }
        }
        if (this.getSuperstate() != null) {
            result.addAll(this.getSuperstate().getPermittedTriggers());
        }
        return new ArrayList(result);
    }
}

