'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MOBX_DEVTOOLS = exports.APOLLO_DEVELOPER_TOOLS = exports.CYCLEJS_DEVTOOL = exports.REACT_PERF = exports.REDUX_DEVTOOLS = exports.VUEJS_DEVTOOLS = exports.ANGULARJS_BATARANG = exports.JQUERY_DEBUGGER = exports.BACKBONE_DEBUGGER = exports.REACT_DEVELOPER_TOOLS = exports.EMBER_INSPECTOR = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _electron = require('electron');

var _electron2 = _interopRequireDefault(_electron);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _semver = require('semver');

var _semver2 = _interopRequireDefault(_semver);

var _downloadChromeExtension = require('./downloadChromeExtension');

var _downloadChromeExtension2 = _interopRequireDefault(_downloadChromeExtension);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _ref = _electron.remote || _electron2.default,
    BrowserWindow = _ref.BrowserWindow;

var IDMap = {};
var IDMapPath = _path2.default.resolve((0, _utils.getPath)(), 'IDMap.json');
if (_fs2.default.existsSync(IDMapPath)) {
  try {
    IDMap = JSON.parse(_fs2.default.readFileSync(IDMapPath, 'utf8'));
  } catch (err) {
    console.error('electron-devtools-installer: Invalid JSON present in the IDMap file');
  }
}

var install = function install(extensionReference) {
  var forceDownload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  if (Array.isArray(extensionReference)) {
    return Promise.all(extensionReference.map(function (extension) {
      return install(extension, forceDownload);
    }));
  }
  var chromeStoreID = void 0;
  if ((typeof extensionReference === 'undefined' ? 'undefined' : _typeof(extensionReference)) === 'object' && extensionReference.id) {
    chromeStoreID = extensionReference.id;
    var electronVersion = process.versions.electron.split('-')[0];
    if (!_semver2.default.satisfies(electronVersion, extensionReference.electron)) {
      return Promise.reject(new Error('Version of Electron: ' + electronVersion + ' does not match required range ' + extensionReference.electron + ' for extension ' + chromeStoreID) // eslint-disable-line
      );
    }
  } else if (typeof extensionReference === 'string') {
    chromeStoreID = extensionReference;
  } else {
    return Promise.reject(new Error('Invalid extensionReference passed in: "' + extensionReference + '"'));
  }
  var extensionName = IDMap[chromeStoreID];
  var extensionInstalled = extensionName && BrowserWindow.getDevToolsExtensions && BrowserWindow.getDevToolsExtensions()[extensionName];
  if (!forceDownload && extensionInstalled) {
    return Promise.resolve(IDMap[chromeStoreID]);
  }
  return (0, _downloadChromeExtension2.default)(chromeStoreID, forceDownload).then(function (extensionFolder) {
    // Use forceDownload, but already installed
    if (extensionInstalled) {
      BrowserWindow.removeDevToolsExtension(extensionName);
    }
    var name = BrowserWindow.addDevToolsExtension(extensionFolder); // eslint-disable-line
    _fs2.default.writeFileSync(IDMapPath, JSON.stringify(Object.assign(IDMap, _defineProperty({}, chromeStoreID, name))));
    return Promise.resolve(name);
  });
};

exports.default = install;
var EMBER_INSPECTOR = exports.EMBER_INSPECTOR = {
  id: 'bmdblncegkenkacieihfhpjfppoconhi',
  electron: '^1.2.1'
};
var REACT_DEVELOPER_TOOLS = exports.REACT_DEVELOPER_TOOLS = {
  id: 'fmkadmapgofadopljbjfkapdkoienihi',
  electron: '^1.2.1'
};
var BACKBONE_DEBUGGER = exports.BACKBONE_DEBUGGER = {
  id: 'bhljhndlimiafopmmhjlgfpnnchjjbhd',
  electron: '^1.2.1'
};
var JQUERY_DEBUGGER = exports.JQUERY_DEBUGGER = {
  id: 'dbhhnnnpaeobfddmlalhnehgclcmjimi',
  electron: '^1.2.1'
};
var ANGULARJS_BATARANG = exports.ANGULARJS_BATARANG = {
  id: 'ighdmehidhipcmcojjgiloacoafjmpfk',
  electron: '^1.2.1'
};
var VUEJS_DEVTOOLS = exports.VUEJS_DEVTOOLS = {
  id: 'nhdogjmejiglipccpnnnanhbledajbpd',
  electron: '^1.2.1'
};
var REDUX_DEVTOOLS = exports.REDUX_DEVTOOLS = {
  id: 'lmhkpmbekcpmknklioeibfkpmmfibljd',
  electron: '^1.2.1'
};
var REACT_PERF = exports.REACT_PERF = {
  id: 'hacmcodfllhbnekmghgdlplbdnahmhmm',
  electron: '^1.2.6'
};
var CYCLEJS_DEVTOOL = exports.CYCLEJS_DEVTOOL = {
  id: 'dfgplfmhhmdekalbpejekgfegkonjpfp',
  electron: '^1.2.1'
};
var APOLLO_DEVELOPER_TOOLS = exports.APOLLO_DEVELOPER_TOOLS = {
  id: 'jdkknkkbebbapilgoeccciglkfbmbnfm',
  electron: '^1.2.1'
};
var MOBX_DEVTOOLS = exports.MOBX_DEVTOOLS = {
  id: 'pfgnfdagidkfgccljigdamigbcnndkod',
  electron: '^1.2.1'
};