'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = registerRequireExtension;

var _mimeTypes = require('@paulcbetts/mime-types');

var _mimeTypes2 = _interopRequireDefault(_mimeTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let HMR = false;

const d = require('debug')('electron-compile:require-hook');
let electron = null;

if (process.type === 'renderer') {
  window.__hot = [];
  electron = require('electron');
  HMR = electron.remote.getGlobal('__electron_compile_hmr_enabled__');

  if (HMR) {
    electron.ipcRenderer.on('__electron-compile__HMR', () => {
      d("Got HMR signal!");

      // Reset the module cache
      let cache = require('module')._cache;
      let toEject = Object.keys(cache).filter(x => x && !x.match(/[\\\/](node_modules|.*\.asar)[\\\/]/i));
      toEject.forEach(x => {
        d(`Removing node module entry for ${x}`);
        delete cache[x];
      });

      window.__hot.forEach(fn => fn());
    });
  }
}

/**
 * Initializes the node.js hook that allows us to intercept files loaded by
 * node.js and rewrite them. This method along with {@link initializeProtocolHook}
 * are the top-level methods that electron-compile actually uses to intercept
 * code that Electron loads.
 *
 * @param  {CompilerHost} compilerHost  The compiler host to use for compilation.
 */
function registerRequireExtension(compilerHost, isProduction) {
  if (HMR) {
    try {
      require('module').prototype.hot = {
        accept: cb => window.__hot.push(cb)
      };

      require.main.require('react-hot-loader/patch');
    } catch (e) {
      console.error(`Couldn't require react-hot-loader/patch, you need to add react-hot-loader@3 as a dependency! ${e.message}`);
    }
  }

  let mimeTypeList = isProduction ? Object.keys(compilerHost.mimeTypesToRegister) : Object.keys(compilerHost.compilersByMimeType);

  mimeTypeList.forEach(mimeType => {
    let ext = _mimeTypes2.default.extension(mimeType);

    require.extensions[`.${ext}`] = (module, filename) => {
      var _compilerHost$compile = compilerHost.compileSync(filename);

      let code = _compilerHost$compile.code;


      if (code === null) {
        console.error(`null code returned for "${filename}".  Please raise an issue on 'electron-compile' with the contents of this file.`);
      }

      module._compile(code, filename);
    };
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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