'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeRendererProcess = initializeRendererProcess;

var _compilerHost = require('./compiler-host');

var _compilerHost2 = _interopRequireDefault(_compilerHost);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// NB: These are duped in protocol-hook so we can save startup time, make
// sure to run both!
const magicGlobalForRootCacheDir = '__electron_compile_root_cache_dir';
const magicGlobalForAppRootDir = '__electron_compile_app_root_dir';

const d = require('debug')('electron-compile:initialize-renderer');

let rendererInitialized = false;

/**
 * Called by our rigged script file at the top of every HTML file to set up
 * the same compilers as the browser process that created us
 *
 * @private
 */
function initializeRendererProcess(readOnlyMode) {
  if (rendererInitialized) return;

  let rootCacheDir = require('electron').remote.getGlobal(magicGlobalForRootCacheDir);
  let appRoot = require('electron').remote.getGlobal(magicGlobalForAppRootDir);
  let compilerHost = null;

  // NB: This has to be synchronous because we need to block HTML parsing
  // until we're set up
  if (readOnlyMode) {
    d(`Setting up electron-compile in precompiled mode with cache dir: ${rootCacheDir}`);

    // NB: React cares SUPER HARD about this, and this is the earliest place
    // we can set it up to ensure React picks it up correctly
    process.env.NODE_ENV = 'production';
    compilerHost = _compilerHost2.default.createReadonlyFromConfigurationSync(rootCacheDir, appRoot);
  } else {
    d(`Setting up electron-compile in development mode with cache dir: ${rootCacheDir}`);

    var _require = require('./config-parser');

    const createCompilers = _require.createCompilers;

    const compilersByMimeType = createCompilers();

    compilerHost = _compilerHost2.default.createFromConfigurationSync(rootCacheDir, appRoot, compilersByMimeType);
  }

  require('./x-require');
  require('./require-hook').default(compilerHost, readOnlyMode);
  rendererInitialized = true;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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