'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');
var PropTypes = require('prop-types');
var deepForceUpdate = require('react-deep-force-update');

var Component = React.Component;

var AppContainer = function (_Component) {
  _inherits(AppContainer, _Component);

  function AppContainer(props) {
    _classCallCheck(this, AppContainer);

    var _this = _possibleConstructorReturn(this, (AppContainer.__proto__ || Object.getPrototypeOf(AppContainer)).call(this, props));

    if (props.warnings === false && typeof __REACT_HOT_LOADER__ !== 'undefined') {
      __REACT_HOT_LOADER__.warnings = props.warnings;
    }

    _this.state = { error: null };
    return _this;
  }

  _createClass(AppContainer, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (typeof __REACT_HOT_LOADER__ === 'undefined') {
        console.error('React Hot Loader: It appears that "react-hot-loader/patch" ' + 'did not run immediately before the app started. Make sure that it ' + 'runs before any other code. For example, if you use Webpack, ' + 'you can add "react-hot-loader/patch" as the very first item to the ' + '"entry" array in its config. Alternatively, you can add ' + 'require("react-hot-loader/patch") as the very first line ' + 'in the application code, before any other imports.');
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps() {
      // Hot reload is happening.
      // Retry rendering!
      this.setState({
        error: null
      });
      // Force-update the whole tree, including
      // components that refuse to update.
      deepForceUpdate(this);
    }
  }, {
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(prevProps, prevState) {
      // Don't update the component if the state had an error and still has one.
      // This allows to break an infinite loop of error -> render -> error -> render
      // https://github.com/gaearon/react-hot-loader/issues/696
      if (prevState.error && this.state.error) {
        return false;
      }

      return true;
    }

    // This hook is going to become official in React 15.x.
    // In 15.0, it only catches errors on initial mount.
    // Later it will work for updates as well:
    // https://github.com/facebook/react/pull/6020
    /* eslint-disable camelcase */

  }, {
    key: 'unstable_handleError',
    value: function unstable_handleError(error) {
      this.componentDidCatch(error);
    }
    /* eslint-enable camelcase */

  }, {
    key: 'componentDidCatch',
    value: function componentDidCatch(error) {
      this.setState({
        error: error
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var error = this.state.error;


      if (this.props.errorReporter && error) {
        console.error(error);
        return React.createElement(this.props.errorReporter, { error: error });
      } else if (error) {
        console.error(error);
      }

      return React.Children.only(this.props.children);
    }
  }]);

  return AppContainer;
}(Component);

AppContainer.propTypes = {
  children: function children(props) {
    if (React.Children.count(props.children) !== 1) {
      return new Error('Invalid prop "children" supplied to AppContainer. ' + 'Expected a single React element with your app’s root component, e.g. <App />.');
    }

    return undefined;
  },

  errorReporter: PropTypes.oneOfType([PropTypes.node, PropTypes.func]),
  warnings: PropTypes.bool
};

module.exports = AppContainer;