/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.support.v4.util.SparseArrayCompat;
import android.view.SurfaceHolder;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.CameraViewImpl;
import com.google.android.cameraview.Constants;
import com.google.android.cameraview.PreviewImpl;
import com.google.android.cameraview.Size;
import com.google.android.cameraview.SizeMap;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;

class Camera1
extends CameraViewImpl
implements MediaRecorder.OnInfoListener,
MediaRecorder.OnErrorListener,
Camera.PreviewCallback {
    private static final int INVALID_CAMERA_ID = -1;
    private static final SparseArrayCompat<String> FLASH_MODES = new SparseArrayCompat();
    private static final SparseArrayCompat<String> WB_MODES;
    private int mCameraId;
    private final AtomicBoolean isPictureCaptureInProgress = new AtomicBoolean(false);
    Camera mCamera;
    private Camera.Parameters mCameraParameters;
    private final Camera.CameraInfo mCameraInfo = new Camera.CameraInfo();
    private MediaRecorder mMediaRecorder;
    private String mVideoPath;
    private boolean mIsRecording;
    private final SizeMap mPreviewSizes = new SizeMap();
    private final SizeMap mPictureSizes = new SizeMap();
    private AspectRatio mAspectRatio;
    private boolean mShowingPreview;
    private boolean mAutoFocus;
    private int mFacing;
    private int mFlash;
    private int mDisplayOrientation;
    private float mZoom;
    private int mWhiteBalance;
    private boolean mIsScanning;
    private SurfaceTexture mPreviewTexture;

    Camera1(CameraViewImpl.Callback callback, PreviewImpl preview) {
        super(callback, preview);
        preview.setCallback(new PreviewImpl.Callback(){

            @Override
            public void onSurfaceChanged() {
                if (Camera1.this.mCamera != null) {
                    Camera1.this.setUpPreview();
                    Camera1.this.adjustCameraParameters();
                }
            }

            @Override
            public void onSurfaceDestroyed() {
                Camera1.this.stop();
            }
        });
    }

    @Override
    boolean start() {
        this.chooseCamera();
        if (!this.openCamera()) {
            this.mCallback.onMountError();
            return true;
        }
        if (this.mPreview.isReady()) {
            this.setUpPreview();
        }
        this.mShowingPreview = true;
        this.startCameraPreview();
        return true;
    }

    @Override
    void stop() {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.setPreviewCallback(null);
        }
        this.mShowingPreview = false;
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.stop();
            this.mMediaRecorder.release();
            this.mMediaRecorder = null;
            if (this.mIsRecording) {
                this.mCallback.onVideoRecorded(this.mVideoPath);
                this.mIsRecording = false;
            }
        }
        this.releaseCamera();
    }

    @SuppressLint(value={"NewApi"})
    void setUpPreview() {
        try {
            if (this.mPreviewTexture != null) {
                this.mCamera.setPreviewTexture(this.mPreviewTexture);
            } else if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                boolean needsToStopPreview;
                boolean bl = needsToStopPreview = this.mShowingPreview && Build.VERSION.SDK_INT < 14;
                if (needsToStopPreview) {
                    this.mCamera.stopPreview();
                }
                this.mCamera.setPreviewDisplay(this.mPreview.getSurfaceHolder());
                if (needsToStopPreview) {
                    this.startCameraPreview();
                }
            } else {
                this.mCamera.setPreviewTexture((SurfaceTexture)this.mPreview.getSurfaceTexture());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void startCameraPreview() {
        this.mCamera.startPreview();
        if (this.mIsScanning) {
            this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
        }
    }

    @Override
    boolean isCameraOpened() {
        return this.mCamera != null;
    }

    @Override
    void setFacing(int facing) {
        if (this.mFacing == facing) {
            return;
        }
        this.mFacing = facing;
        if (this.isCameraOpened()) {
            this.stop();
            this.start();
        }
    }

    @Override
    int getFacing() {
        return this.mFacing;
    }

    @Override
    Set<AspectRatio> getSupportedAspectRatios() {
        SizeMap idealAspectRatios = this.mPreviewSizes;
        for (AspectRatio aspectRatio : idealAspectRatios.ratios()) {
            if (this.mPictureSizes.sizes(aspectRatio) != null) continue;
            idealAspectRatios.remove(aspectRatio);
        }
        return idealAspectRatios.ratios();
    }

    @Override
    boolean setAspectRatio(AspectRatio ratio) {
        if (this.mAspectRatio == null || !this.isCameraOpened()) {
            this.mAspectRatio = ratio;
            return true;
        }
        if (!this.mAspectRatio.equals(ratio)) {
            SortedSet<Size> sizes = this.mPreviewSizes.sizes(ratio);
            if (sizes == null) {
                throw new UnsupportedOperationException(ratio + " is not supported");
            }
            this.mAspectRatio = ratio;
            this.adjustCameraParameters();
            return true;
        }
        return false;
    }

    @Override
    AspectRatio getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    void setAutoFocus(boolean autoFocus) {
        if (this.mAutoFocus == autoFocus) {
            return;
        }
        if (this.setAutoFocusInternal(autoFocus)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    boolean getAutoFocus() {
        if (!this.isCameraOpened()) {
            return this.mAutoFocus;
        }
        String focusMode = this.mCameraParameters.getFocusMode();
        return focusMode != null && focusMode.contains("continuous");
    }

    @Override
    void setFlash(int flash) {
        if (flash == this.mFlash) {
            return;
        }
        if (this.setFlashInternal(flash)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    int getFlash() {
        return this.mFlash;
    }

    @Override
    public void setFocusDepth(float value) {
    }

    @Override
    float getFocusDepth() {
        return 0.0f;
    }

    @Override
    void setZoom(float zoom) {
        if (zoom == this.mZoom) {
            return;
        }
        if (this.setZoomInternal(zoom)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    float getZoom() {
        return this.mZoom;
    }

    @Override
    public void setWhiteBalance(int whiteBalance) {
        if (whiteBalance == this.mWhiteBalance) {
            return;
        }
        if (this.setWhiteBalanceInternal(whiteBalance)) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    @Override
    public int getWhiteBalance() {
        return this.mWhiteBalance;
    }

    @Override
    void setScanning(boolean isScanning) {
        if (isScanning == this.mIsScanning) {
            return;
        }
        this.setScanningInternal(isScanning);
    }

    @Override
    boolean getScanning() {
        return this.mIsScanning;
    }

    @Override
    void takePicture() {
        if (!this.isCameraOpened()) {
            throw new IllegalStateException("Camera is not ready. Call start() before takePicture().");
        }
        if (this.getAutoFocus()) {
            this.mCamera.cancelAutoFocus();
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    Camera1.this.takePictureInternal();
                }
            });
        } else {
            this.takePictureInternal();
        }
    }

    void takePictureInternal() {
        if (!this.isPictureCaptureInProgress.getAndSet(true)) {
            this.mCamera.takePicture(null, null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Camera1.this.isPictureCaptureInProgress.set(false);
                    camera.cancelAutoFocus();
                    camera.startPreview();
                    if (Camera1.this.mIsScanning) {
                        camera.setPreviewCallback((Camera.PreviewCallback)Camera1.this);
                    }
                    Camera1.this.mCallback.onPictureTaken(data);
                }
            });
        }
    }

    @Override
    boolean record(String path, int maxDuration, int maxFileSize, boolean recordAudio, CamcorderProfile profile) {
        if (!this.mIsRecording) {
            this.setUpMediaRecorder(path, maxDuration, maxFileSize, recordAudio, profile);
            try {
                this.mMediaRecorder.prepare();
                this.mMediaRecorder.start();
                this.mIsRecording = true;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    void stopRecording() {
        if (this.mIsRecording) {
            this.stopMediaRecorder();
            if (this.mCamera != null) {
                this.mCamera.lock();
            }
        }
    }

    @Override
    void setDisplayOrientation(int displayOrientation) {
        if (this.mDisplayOrientation == displayOrientation) {
            return;
        }
        this.mDisplayOrientation = displayOrientation;
        if (this.isCameraOpened()) {
            boolean needsToStopPreview;
            this.mCameraParameters.setRotation(this.calcCameraRotation(displayOrientation));
            this.mCamera.setParameters(this.mCameraParameters);
            boolean bl = needsToStopPreview = this.mShowingPreview && Build.VERSION.SDK_INT < 14;
            if (needsToStopPreview) {
                this.mCamera.stopPreview();
            }
            this.mCamera.setDisplayOrientation(this.calcDisplayOrientation(displayOrientation));
            if (needsToStopPreview) {
                this.startCameraPreview();
            }
        }
    }

    @Override
    public void setPreviewTexture(SurfaceTexture surfaceTexture) {
        try {
            if (this.mCamera == null) {
                this.mPreviewTexture = surfaceTexture;
                return;
            }
            this.mCamera.stopPreview();
            if (surfaceTexture == null) {
                this.mCamera.setPreviewTexture((SurfaceTexture)this.mPreview.getSurfaceTexture());
            } else {
                this.mCamera.setPreviewTexture(surfaceTexture);
            }
            this.mPreviewTexture = surfaceTexture;
            this.startCameraPreview();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Size getPreviewSize() {
        Camera.Size cameraSize = this.mCameraParameters.getPreviewSize();
        return new Size(cameraSize.width, cameraSize.height);
    }

    private void chooseCamera() {
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.mCameraInfo);
            if (this.mCameraInfo.facing != this.mFacing) continue;
            this.mCameraId = i;
            return;
        }
        this.mCameraId = -1;
    }

    private boolean openCamera() {
        if (this.mCamera != null) {
            this.releaseCamera();
        }
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
            this.mCameraParameters = this.mCamera.getParameters();
            this.mPreviewSizes.clear();
            for (Camera.Size size : this.mCameraParameters.getSupportedPreviewSizes()) {
                this.mPreviewSizes.add(new Size(size.width, size.height));
            }
            this.mPictureSizes.clear();
            for (Camera.Size size : this.mCameraParameters.getSupportedPictureSizes()) {
                this.mPictureSizes.add(new Size(size.width, size.height));
            }
            if (this.mAspectRatio == null) {
                this.mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
            }
            this.adjustCameraParameters();
            this.mCamera.setDisplayOrientation(this.calcDisplayOrientation(this.mDisplayOrientation));
            this.mCallback.onCameraOpened();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private AspectRatio chooseAspectRatio() {
        AspectRatio r = null;
        Iterator<AspectRatio> iterator = this.mPreviewSizes.ratios().iterator();
        while (iterator.hasNext()) {
            AspectRatio ratio;
            r = ratio = iterator.next();
            if (!ratio.equals(Constants.DEFAULT_ASPECT_RATIO)) continue;
            return ratio;
        }
        return r;
    }

    void adjustCameraParameters() {
        SortedSet<Size> sizes = this.mPreviewSizes.sizes(this.mAspectRatio);
        if (sizes == null) {
            this.mAspectRatio = this.chooseAspectRatio();
            sizes = this.mPreviewSizes.sizes(this.mAspectRatio);
        }
        Size size = this.chooseOptimalSize(sizes);
        Size pictureSize = this.mPictureSizes.sizes(this.mAspectRatio).last();
        if (this.mShowingPreview) {
            this.mCamera.stopPreview();
        }
        this.mCameraParameters.setPreviewSize(size.getWidth(), size.getHeight());
        this.mCameraParameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        this.mCameraParameters.setRotation(this.calcCameraRotation(this.mDisplayOrientation));
        this.setAutoFocusInternal(this.mAutoFocus);
        this.setFlashInternal(this.mFlash);
        this.setAspectRatio(this.mAspectRatio);
        this.setZoomInternal(this.mZoom);
        this.setWhiteBalanceInternal(this.mWhiteBalance);
        this.setScanningInternal(this.mIsScanning);
        this.mCamera.setParameters(this.mCameraParameters);
        if (this.mShowingPreview) {
            this.startCameraPreview();
        }
    }

    private Size chooseOptimalSize(SortedSet<Size> sizes) {
        int desiredHeight;
        int desiredWidth;
        if (!this.mPreview.isReady()) {
            return sizes.first();
        }
        int surfaceWidth = this.mPreview.getWidth();
        int surfaceHeight = this.mPreview.getHeight();
        if (this.isLandscape(this.mDisplayOrientation)) {
            desiredWidth = surfaceHeight;
            desiredHeight = surfaceWidth;
        } else {
            desiredWidth = surfaceWidth;
            desiredHeight = surfaceHeight;
        }
        Size result = null;
        for (Size size : sizes) {
            if (desiredWidth <= size.getWidth() && desiredHeight <= size.getHeight()) {
                return size;
            }
            result = size;
        }
        return result;
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mCamera = null;
            this.mCallback.onCameraClosed();
        }
    }

    private int calcDisplayOrientation(int screenOrientationDegrees) {
        if (this.mCameraInfo.facing == 1) {
            return (360 - (this.mCameraInfo.orientation + screenOrientationDegrees) % 360) % 360;
        }
        return (this.mCameraInfo.orientation - screenOrientationDegrees + 360) % 360;
    }

    private int calcCameraRotation(int screenOrientationDegrees) {
        if (this.mCameraInfo.facing == 1) {
            return (this.mCameraInfo.orientation + screenOrientationDegrees) % 360;
        }
        int landscapeFlip = this.isLandscape(screenOrientationDegrees) ? 180 : 0;
        return (this.mCameraInfo.orientation + screenOrientationDegrees + landscapeFlip) % 360;
    }

    private boolean isLandscape(int orientationDegrees) {
        return orientationDegrees == 90 || orientationDegrees == 270;
    }

    private boolean setAutoFocusInternal(boolean autoFocus) {
        this.mAutoFocus = autoFocus;
        if (this.isCameraOpened()) {
            List modes = this.mCameraParameters.getSupportedFocusModes();
            if (autoFocus && modes.contains("continuous-picture")) {
                this.mCameraParameters.setFocusMode("continuous-picture");
            } else if (modes.contains("fixed")) {
                this.mCameraParameters.setFocusMode("fixed");
            } else if (modes.contains("infinity")) {
                this.mCameraParameters.setFocusMode("infinity");
            } else {
                this.mCameraParameters.setFocusMode((String)modes.get(0));
            }
            return true;
        }
        return false;
    }

    private boolean setFlashInternal(int flash) {
        if (this.isCameraOpened()) {
            List modes = this.mCameraParameters.getSupportedFlashModes();
            String mode = (String)FLASH_MODES.get(flash);
            if (modes != null && modes.contains(mode)) {
                this.mCameraParameters.setFlashMode(mode);
                this.mFlash = flash;
                return true;
            }
            String currentMode = (String)FLASH_MODES.get(this.mFlash);
            if (modes == null || !modes.contains(currentMode)) {
                this.mCameraParameters.setFlashMode("off");
                this.mFlash = 0;
                return true;
            }
            return false;
        }
        this.mFlash = flash;
        return false;
    }

    private boolean setZoomInternal(float zoom) {
        if (this.isCameraOpened() && this.mCameraParameters.isZoomSupported()) {
            int maxZoom = this.mCameraParameters.getMaxZoom();
            int scaledValue = (int)(zoom * (float)maxZoom);
            this.mCameraParameters.setZoom(scaledValue);
            this.mZoom = zoom;
            return true;
        }
        this.mZoom = zoom;
        return false;
    }

    private boolean setWhiteBalanceInternal(int whiteBalance) {
        this.mWhiteBalance = whiteBalance;
        if (this.isCameraOpened()) {
            List modes = this.mCameraParameters.getSupportedWhiteBalance();
            String mode = (String)WB_MODES.get(whiteBalance);
            if (modes != null && modes.contains(mode)) {
                this.mCameraParameters.setWhiteBalance(mode);
                return true;
            }
            String currentMode = (String)WB_MODES.get(this.mWhiteBalance);
            if (modes == null || !modes.contains(currentMode)) {
                this.mCameraParameters.setWhiteBalance("auto");
                this.mWhiteBalance = 0;
                return true;
            }
            return false;
        }
        return false;
    }

    private void setScanningInternal(boolean isScanning) {
        this.mIsScanning = isScanning;
        if (this.isCameraOpened()) {
            if (this.mIsScanning) {
                this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
            } else {
                this.mCamera.setPreviewCallback(null);
            }
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Camera.Size previewSize = this.mCameraParameters.getPreviewSize();
        this.mCallback.onFramePreview(data, previewSize.width, previewSize.height, this.mDisplayOrientation);
    }

    private void setUpMediaRecorder(String path, int maxDuration, int maxFileSize, boolean recordAudio, CamcorderProfile profile) {
        this.mMediaRecorder = new MediaRecorder();
        this.mCamera.unlock();
        this.mMediaRecorder.setCamera(this.mCamera);
        this.mMediaRecorder.setVideoSource(1);
        if (recordAudio) {
            this.mMediaRecorder.setAudioSource(5);
        }
        this.mMediaRecorder.setOutputFile(path);
        this.mVideoPath = path;
        if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)profile.quality)) {
            this.setCamcorderProfile(CamcorderProfile.get((int)this.mCameraId, (int)profile.quality), recordAudio);
        } else {
            this.setCamcorderProfile(CamcorderProfile.get((int)this.mCameraId, (int)1), recordAudio);
        }
        this.mMediaRecorder.setOrientationHint(this.calcCameraRotation(this.mDisplayOrientation));
        if (maxDuration != -1) {
            this.mMediaRecorder.setMaxDuration(maxDuration);
        }
        if (maxFileSize != -1) {
            this.mMediaRecorder.setMaxFileSize((long)maxFileSize);
        }
        this.mMediaRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
        this.mMediaRecorder.setOnErrorListener((MediaRecorder.OnErrorListener)this);
    }

    private void stopMediaRecorder() {
        this.mIsRecording = false;
        if (this.mMediaRecorder != null) {
            try {
                this.mMediaRecorder.stop();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
            this.mMediaRecorder.reset();
            this.mMediaRecorder.release();
            this.mMediaRecorder = null;
        }
        if (this.mVideoPath == null || !new File(this.mVideoPath).exists()) {
            this.mCallback.onVideoRecorded(null);
            return;
        }
        this.mCallback.onVideoRecorded(this.mVideoPath);
        this.mVideoPath = null;
    }

    private void setCamcorderProfile(CamcorderProfile profile, boolean recordAudio) {
        this.mMediaRecorder.setOutputFormat(profile.fileFormat);
        this.mMediaRecorder.setVideoFrameRate(profile.videoFrameRate);
        this.mMediaRecorder.setVideoSize(profile.videoFrameWidth, profile.videoFrameHeight);
        this.mMediaRecorder.setVideoEncodingBitRate(profile.videoBitRate);
        this.mMediaRecorder.setVideoEncoder(profile.videoCodec);
        if (recordAudio) {
            this.mMediaRecorder.setAudioEncodingBitRate(profile.audioBitRate);
            this.mMediaRecorder.setAudioChannels(profile.audioChannels);
            this.mMediaRecorder.setAudioSamplingRate(profile.audioSampleRate);
            this.mMediaRecorder.setAudioEncoder(profile.audioCodec);
        }
    }

    public void onInfo(MediaRecorder mr, int what, int extra) {
        if (what == 800 || what == 801) {
            this.stopRecording();
        }
    }

    public void onError(MediaRecorder mr, int what, int extra) {
        this.stopRecording();
    }

    static {
        FLASH_MODES.put(0, (Object)"off");
        FLASH_MODES.put(1, (Object)"on");
        FLASH_MODES.put(2, (Object)"torch");
        FLASH_MODES.put(3, (Object)"auto");
        FLASH_MODES.put(4, (Object)"red-eye");
        WB_MODES = new SparseArrayCompat();
        WB_MODES.put(0, (Object)"auto");
        WB_MODES.put(1, (Object)"cloudy-daylight");
        WB_MODES.put(2, (Object)"daylight");
        WB_MODES.put(3, (Object)"shade");
        WB_MODES.put(4, (Object)"fluorescent");
        WB_MODES.put(5, (Object)"incandescent");
    }
}

