/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.Image;
import android.media.ImageReader;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.Surface;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.CameraViewImpl;
import com.google.android.cameraview.Constants;
import com.google.android.cameraview.PreviewImpl;
import com.google.android.cameraview.Size;
import com.google.android.cameraview.SizeMap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;

@TargetApi(value=21)
class Camera2
extends CameraViewImpl
implements MediaRecorder.OnInfoListener,
MediaRecorder.OnErrorListener {
    private static final String TAG = "Camera2";
    private static final SparseIntArray INTERNAL_FACINGS = new SparseIntArray();
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private final CameraManager mCameraManager;
    private final CameraDevice.StateCallback mCameraDeviceCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
            Camera2.this.mCamera = camera;
            Camera2.this.mCallback.onCameraOpened();
            Camera2.this.startCaptureSession();
        }

        public void onClosed(@NonNull CameraDevice camera) {
            Camera2.this.mCallback.onCameraClosed();
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            Camera2.this.mCamera = null;
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            Log.e((String)Camera2.TAG, (String)("onError: " + camera.getId() + " (" + error + ")"));
            Camera2.this.mCamera = null;
        }
    };
    private final CameraCaptureSession.StateCallback mSessionCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(@NonNull CameraCaptureSession session) {
            if (Camera2.this.mCamera == null) {
                return;
            }
            Camera2.this.mCaptureSession = session;
            Camera2.this.mInitialCropRegion = (Rect)Camera2.this.mPreviewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION);
            Camera2.this.updateAutoFocus();
            Camera2.this.updateFlash();
            Camera2.this.updateFocusDepth();
            Camera2.this.updateWhiteBalance();
            Camera2.this.updateZoom();
            try {
                Camera2.this.mCaptureSession.setRepeatingRequest(Camera2.this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)Camera2.this.mCaptureCallback, null);
            }
            catch (CameraAccessException e) {
                Log.e((String)Camera2.TAG, (String)"Failed to start camera preview because it couldn't access camera", (Throwable)e);
            }
            catch (IllegalStateException e) {
                Log.e((String)Camera2.TAG, (String)"Failed to start camera preview.", (Throwable)e);
            }
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            Log.e((String)Camera2.TAG, (String)"Failed to configure capture session.");
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
            if (Camera2.this.mCaptureSession != null && Camera2.this.mCaptureSession.equals(session)) {
                Camera2.this.mCaptureSession = null;
            }
        }
    };
    PictureCaptureCallback mCaptureCallback = new PictureCaptureCallback(){

        @Override
        public void onPrecaptureRequired() {
            Camera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.setState(3);
            try {
                Camera2.this.mCaptureSession.capture(Camera2.this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this, null);
                Camera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
            }
            catch (CameraAccessException e) {
                Log.e((String)Camera2.TAG, (String)"Failed to run precapture sequence.", (Throwable)e);
            }
        }

        @Override
        public void onReady() {
            Camera2.this.captureStillPicture();
        }
    };
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            try (Image image = reader.acquireNextImage();){
                Image.Plane[] planes = image.getPlanes();
                if (planes.length > 0) {
                    ByteBuffer buffer = planes[0].getBuffer();
                    byte[] data = new byte[buffer.remaining()];
                    buffer.get(data);
                    if (image.getFormat() == 256) {
                        Camera2.this.mCallback.onPictureTaken(data);
                    } else {
                        Camera2.this.mCallback.onFramePreview(data, image.getWidth(), image.getHeight(), Camera2.this.mDisplayOrientation);
                    }
                    image.close();
                }
            }
        }
    };
    private String mCameraId;
    private CameraCharacteristics mCameraCharacteristics;
    CameraDevice mCamera;
    CameraCaptureSession mCaptureSession;
    CaptureRequest.Builder mPreviewRequestBuilder;
    Set<String> mAvailableCameras = new HashSet<String>();
    private ImageReader mStillImageReader;
    private ImageReader mScanImageReader;
    private int mImageFormat;
    private MediaRecorder mMediaRecorder;
    private String mVideoPath;
    private boolean mIsRecording;
    private final SizeMap mPreviewSizes = new SizeMap();
    private final SizeMap mPictureSizes = new SizeMap();
    private int mFacing;
    private AspectRatio mAspectRatio = Constants.DEFAULT_ASPECT_RATIO;
    private AspectRatio mInitialRatio;
    private boolean mAutoFocus;
    private int mFlash;
    private int mDisplayOrientation;
    private float mFocusDepth;
    private float mZoom;
    private int mWhiteBalance;
    private boolean mIsScanning;
    private Surface mPreviewSurface;
    private Rect mInitialCropRegion;

    Camera2(CameraViewImpl.Callback callback, PreviewImpl preview, Context context) {
        super(callback, preview);
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.mCameraManager.registerAvailabilityCallback(new CameraManager.AvailabilityCallback(){

            public void onCameraAvailable(@NonNull String cameraId) {
                super.onCameraAvailable(cameraId);
                Camera2.this.mAvailableCameras.add(cameraId);
            }

            public void onCameraUnavailable(@NonNull String cameraId) {
                super.onCameraUnavailable(cameraId);
                Camera2.this.mAvailableCameras.remove(cameraId);
            }
        }, null);
        this.mImageFormat = this.mIsScanning ? 35 : 256;
        this.mPreview.setCallback(new PreviewImpl.Callback(){

            @Override
            public void onSurfaceChanged() {
                Camera2.this.startCaptureSession();
            }

            @Override
            public void onSurfaceDestroyed() {
                Camera2.this.stop();
            }
        });
    }

    @Override
    boolean start() {
        if (!this.chooseCameraIdByFacing()) {
            this.mAspectRatio = this.mInitialRatio;
            return false;
        }
        this.collectCameraInfo();
        this.setAspectRatio(this.mInitialRatio);
        this.mInitialRatio = null;
        this.prepareStillImageReader();
        this.prepareScanImageReader();
        this.startOpeningCamera();
        return true;
    }

    @Override
    void stop() {
        if (this.mCaptureSession != null) {
            this.mCaptureSession.close();
            this.mCaptureSession = null;
        }
        if (this.mCamera != null) {
            this.mCamera.close();
            this.mCamera = null;
        }
        if (this.mStillImageReader != null) {
            this.mStillImageReader.close();
            this.mStillImageReader = null;
        }
        if (this.mScanImageReader != null) {
            this.mScanImageReader.close();
            this.mScanImageReader = null;
        }
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.stop();
            this.mMediaRecorder.reset();
            this.mMediaRecorder.release();
            this.mMediaRecorder = null;
            if (this.mIsRecording) {
                this.mCallback.onVideoRecorded(this.mVideoPath);
                this.mIsRecording = false;
            }
        }
    }

    @Override
    boolean isCameraOpened() {
        return this.mCamera != null;
    }

    @Override
    void setFacing(int facing) {
        if (this.mFacing == facing) {
            return;
        }
        this.mFacing = facing;
        if (this.isCameraOpened()) {
            this.stop();
            this.start();
        }
    }

    @Override
    int getFacing() {
        return this.mFacing;
    }

    @Override
    Set<AspectRatio> getSupportedAspectRatios() {
        return this.mPreviewSizes.ratios();
    }

    @Override
    boolean setAspectRatio(AspectRatio ratio) {
        if (ratio != null && this.mPreviewSizes.isEmpty()) {
            this.mInitialRatio = ratio;
            return false;
        }
        if (ratio == null || ratio.equals(this.mAspectRatio) || !this.mPreviewSizes.ratios().contains(ratio)) {
            return false;
        }
        this.mAspectRatio = ratio;
        this.prepareStillImageReader();
        this.prepareScanImageReader();
        if (this.mCaptureSession != null) {
            this.mCaptureSession.close();
            this.mCaptureSession = null;
            this.startCaptureSession();
        }
        return true;
    }

    @Override
    AspectRatio getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    void setAutoFocus(boolean autoFocus) {
        if (this.mAutoFocus == autoFocus) {
            return;
        }
        this.mAutoFocus = autoFocus;
        if (this.mPreviewRequestBuilder != null) {
            this.updateAutoFocus();
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
                }
                catch (CameraAccessException e) {
                    this.mAutoFocus = !this.mAutoFocus;
                }
            }
        }
    }

    @Override
    boolean getAutoFocus() {
        return this.mAutoFocus;
    }

    @Override
    void setFlash(int flash) {
        if (this.mFlash == flash) {
            return;
        }
        int saved = this.mFlash;
        this.mFlash = flash;
        if (this.mPreviewRequestBuilder != null) {
            this.updateFlash();
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
                }
                catch (CameraAccessException e) {
                    this.mFlash = saved;
                }
            }
        }
    }

    @Override
    int getFlash() {
        return this.mFlash;
    }

    @Override
    void takePicture() {
        if (this.mAutoFocus) {
            this.lockFocus();
        } else {
            this.captureStillPicture();
        }
    }

    @Override
    boolean record(String path, int maxDuration, int maxFileSize, boolean recordAudio, CamcorderProfile profile) {
        if (!this.mIsRecording) {
            this.setUpMediaRecorder(path, maxDuration, maxFileSize, recordAudio, profile);
            try {
                this.mMediaRecorder.prepare();
                if (this.mCaptureSession != null) {
                    this.mCaptureSession.close();
                    this.mCaptureSession = null;
                }
                Size size = this.chooseOptimalSize();
                this.mPreview.setBufferSize(size.getWidth(), size.getHeight());
                Surface surface = this.getPreviewSurface();
                Surface mMediaRecorderSurface = this.mMediaRecorder.getSurface();
                this.mPreviewRequestBuilder = this.mCamera.createCaptureRequest(3);
                this.mPreviewRequestBuilder.addTarget(surface);
                this.mPreviewRequestBuilder.addTarget(mMediaRecorderSurface);
                this.mCamera.createCaptureSession(Arrays.asList(surface, mMediaRecorderSurface), this.mSessionCallback, null);
                this.mMediaRecorder.start();
                this.mIsRecording = true;
                return true;
            }
            catch (CameraAccessException | IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    void stopRecording() {
        if (this.mIsRecording) {
            this.stopMediaRecorder();
            if (this.mCaptureSession != null) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            this.startCaptureSession();
        }
    }

    @Override
    public void setFocusDepth(float value) {
        if (this.mFocusDepth == value) {
            return;
        }
        float saved = this.mFocusDepth;
        this.mFocusDepth = value;
        if (this.mCaptureSession != null) {
            this.updateFocusDepth();
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            }
            catch (CameraAccessException e) {
                this.mFocusDepth = saved;
            }
        }
    }

    @Override
    float getFocusDepth() {
        return this.mFocusDepth;
    }

    @Override
    public void setZoom(float zoom) {
        if (this.mZoom == zoom) {
            return;
        }
        float saved = this.mZoom;
        this.mZoom = zoom;
        if (this.mCaptureSession != null) {
            this.updateZoom();
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            }
            catch (CameraAccessException e) {
                this.mZoom = saved;
            }
        }
    }

    @Override
    float getZoom() {
        return this.mZoom;
    }

    @Override
    public void setWhiteBalance(int whiteBalance) {
        if (this.mWhiteBalance == whiteBalance) {
            return;
        }
        int saved = this.mWhiteBalance;
        this.mWhiteBalance = whiteBalance;
        if (this.mCaptureSession != null) {
            this.updateWhiteBalance();
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            }
            catch (CameraAccessException e) {
                this.mWhiteBalance = saved;
            }
        }
    }

    @Override
    public int getWhiteBalance() {
        return this.mWhiteBalance;
    }

    @Override
    void setScanning(boolean isScanning) {
        if (this.mIsScanning == isScanning) {
            return;
        }
        this.mIsScanning = isScanning;
        this.mImageFormat = !this.mIsScanning ? 256 : 35;
        if (this.mCaptureSession != null) {
            this.mCaptureSession.close();
            this.mCaptureSession = null;
        }
        this.startCaptureSession();
    }

    @Override
    boolean getScanning() {
        return this.mIsScanning;
    }

    @Override
    void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
        this.mPreview.setDisplayOrientation(this.mDisplayOrientation);
    }

    private boolean chooseCameraIdByFacing() {
        try {
            int internalFacing = INTERNAL_FACINGS.get(this.mFacing);
            String[] ids = this.mCameraManager.getCameraIdList();
            if (ids.length == 0) {
                throw new RuntimeException("No camera available.");
            }
            for (String id : ids) {
                CameraCharacteristics characteristics = this.mCameraManager.getCameraCharacteristics(id);
                Integer level = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (level == null || level == 2) continue;
                Integer internal = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (internal == null) {
                    throw new NullPointerException("Unexpected state: LENS_FACING null");
                }
                if (internal != internalFacing) continue;
                this.mCameraId = id;
                this.mCameraCharacteristics = characteristics;
                return true;
            }
            this.mCameraId = ids[0];
            this.mCameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCameraId);
            Integer level = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (level == null || level == 2) {
                return false;
            }
            Integer internal = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
            if (internal == null) {
                throw new NullPointerException("Unexpected state: LENS_FACING null");
            }
            int count = INTERNAL_FACINGS.size();
            for (int i = 0; i < count; ++i) {
                if (INTERNAL_FACINGS.valueAt(i) != internal.intValue()) continue;
                this.mFacing = INTERNAL_FACINGS.keyAt(i);
                return true;
            }
            this.mFacing = 0;
            return true;
        }
        catch (CameraAccessException e) {
            throw new RuntimeException("Failed to get a list of camera devices", e);
        }
    }

    private void collectCameraInfo() {
        StreamConfigurationMap map = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            throw new IllegalStateException("Failed to get configuration map: " + this.mCameraId);
        }
        this.mPreviewSizes.clear();
        for (android.util.Size size : map.getOutputSizes(this.mPreview.getOutputClass())) {
            int width = size.getWidth();
            int height = size.getHeight();
            if (width > 1920 || height > 1080) continue;
            this.mPreviewSizes.add(new Size(width, height));
        }
        this.mPictureSizes.clear();
        this.collectPictureSizes(this.mPictureSizes, map);
        for (AspectRatio ratio : this.mPreviewSizes.ratios()) {
            if (this.mPictureSizes.ratios().contains(ratio)) continue;
            this.mPreviewSizes.remove(ratio);
        }
        if (!this.mPreviewSizes.ratios().contains(this.mAspectRatio)) {
            this.mAspectRatio = this.mPreviewSizes.ratios().iterator().next();
        }
    }

    protected void collectPictureSizes(SizeMap sizes, StreamConfigurationMap map) {
        for (android.util.Size size : map.getOutputSizes(this.mImageFormat)) {
            this.mPictureSizes.add(new Size(size.getWidth(), size.getHeight()));
        }
    }

    private void prepareStillImageReader() {
        if (this.mStillImageReader != null) {
            this.mStillImageReader.close();
        }
        Size largest = this.mPictureSizes.sizes(this.mAspectRatio).last();
        this.mStillImageReader = ImageReader.newInstance((int)largest.getWidth(), (int)largest.getHeight(), (int)256, (int)1);
        this.mStillImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, null);
    }

    private void prepareScanImageReader() {
        if (this.mScanImageReader != null) {
            this.mScanImageReader.close();
        }
        Size largest = this.mPreviewSizes.sizes(this.mAspectRatio).last();
        this.mScanImageReader = ImageReader.newInstance((int)largest.getWidth(), (int)largest.getHeight(), (int)35, (int)1);
        this.mScanImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, null);
    }

    private void startOpeningCamera() {
        try {
            this.mCameraManager.openCamera(this.mCameraId, this.mCameraDeviceCallback, null);
        }
        catch (CameraAccessException e) {
            throw new RuntimeException("Failed to open camera: " + this.mCameraId, e);
        }
    }

    void startCaptureSession() {
        if (!this.isCameraOpened() || !this.mPreview.isReady() || this.mStillImageReader == null || this.mScanImageReader == null) {
            return;
        }
        Size previewSize = this.chooseOptimalSize();
        this.mPreview.setBufferSize(previewSize.getWidth(), previewSize.getHeight());
        Surface surface = this.getPreviewSurface();
        try {
            this.mPreviewRequestBuilder = this.mCamera.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            if (this.mIsScanning) {
                this.mPreviewRequestBuilder.addTarget(this.mScanImageReader.getSurface());
            }
            this.mCamera.createCaptureSession(Arrays.asList(surface, this.mStillImageReader.getSurface(), this.mScanImageReader.getSurface()), this.mSessionCallback, null);
        }
        catch (CameraAccessException e) {
            this.mCallback.onMountError();
        }
    }

    public Surface getPreviewSurface() {
        if (this.mPreviewSurface != null) {
            return this.mPreviewSurface;
        }
        return this.mPreview.getSurface();
    }

    @Override
    public void setPreviewTexture(SurfaceTexture surfaceTexture) {
        Surface previewSurface;
        this.mPreviewSurface = surfaceTexture != null ? (previewSurface = new Surface(surfaceTexture)) : null;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (Camera2.this.mCaptureSession != null) {
                    Camera2.this.mCaptureSession.close();
                    Camera2.this.mCaptureSession = null;
                }
                Camera2.this.startCaptureSession();
            }
        });
    }

    @Override
    public Size getPreviewSize() {
        return new Size(this.mPreview.getWidth(), this.mPreview.getHeight());
    }

    private Size chooseOptimalSize() {
        int surfaceShorter;
        int surfaceLonger;
        int surfaceHeight;
        int surfaceWidth = this.mPreview.getWidth();
        if (surfaceWidth < (surfaceHeight = this.mPreview.getHeight())) {
            surfaceLonger = surfaceHeight;
            surfaceShorter = surfaceWidth;
        } else {
            surfaceLonger = surfaceWidth;
            surfaceShorter = surfaceHeight;
        }
        SortedSet<Size> candidates = this.mPreviewSizes.sizes(this.mAspectRatio);
        for (Size size : candidates) {
            if (size.getWidth() < surfaceLonger || size.getHeight() < surfaceShorter) continue;
            return size;
        }
        return candidates.last();
    }

    void updateAutoFocus() {
        if (this.mAutoFocus) {
            int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            if (modes == null || modes.length == 0 || modes.length == 1 && modes[0] == 0) {
                this.mAutoFocus = false;
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            }
        } else {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
        }
    }

    void updateFlash() {
        switch (this.mFlash) {
            case 0: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 1: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 2: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                break;
            }
            case 3: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 4: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)4);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
        }
    }

    void updateFocusDepth() {
        if (this.mAutoFocus) {
            return;
        }
        Float minimumLens = (Float)this.mCameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        if (minimumLens == null) {
            throw new NullPointerException("Unexpected state: LENS_INFO_MINIMUM_FOCUS_DISTANCE null");
        }
        float value = this.mFocusDepth * minimumLens.floatValue();
        this.mPreviewRequestBuilder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(value));
    }

    void updateZoom() {
        float maxZoom = ((Float)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        float scaledZoom = this.mZoom * (maxZoom - 1.0f) + 1.0f;
        Rect currentPreview = (Rect)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if (currentPreview != null) {
            int currentWidth = currentPreview.width();
            int currentHeight = currentPreview.height();
            int zoomedWidth = (int)((float)currentWidth / scaledZoom);
            int zoomedHeight = (int)((float)currentHeight / scaledZoom);
            int widthOffset = (currentWidth - zoomedWidth) / 2;
            int heightOffset = (currentHeight - zoomedHeight) / 2;
            Rect zoomedPreview = new Rect(currentPreview.left + widthOffset, currentPreview.top + heightOffset, currentPreview.right - widthOffset, currentPreview.bottom - heightOffset);
            if (scaledZoom != 1.0f) {
                this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoomedPreview);
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)this.mInitialCropRegion);
            }
        }
    }

    void updateWhiteBalance() {
        switch (this.mWhiteBalance) {
            case 0: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
                break;
            }
            case 1: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)6);
                break;
            }
            case 4: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)3);
                break;
            }
            case 5: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)2);
                break;
            }
            case 3: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)8);
                break;
            }
            case 2: {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)5);
            }
        }
    }

    private void lockFocus() {
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        try {
            this.mCaptureCallback.setState(1);
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"Failed to lock focus.", (Throwable)e);
        }
    }

    void captureStillPicture() {
        try {
            CaptureRequest.Builder captureRequestBuilder = this.mCamera.createCaptureRequest(2);
            if (this.mIsScanning) {
                this.mImageFormat = 256;
                captureRequestBuilder.removeTarget(this.mScanImageReader.getSurface());
            }
            captureRequestBuilder.addTarget(this.mStillImageReader.getSurface());
            captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, this.mPreviewRequestBuilder.get(CaptureRequest.CONTROL_AF_MODE));
            switch (this.mFlash) {
                case 0: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    break;
                }
                case 1: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                    break;
                }
                case 2: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                    break;
                }
                case 3: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                    break;
                }
                case 4: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                }
            }
            captureRequestBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getOutputRotation());
            captureRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, this.mPreviewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION));
            this.mCaptureSession.stopRepeating();
            this.mCaptureSession.capture(captureRequestBuilder.build(), new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Camera2.this.unlockFocus();
                }
            }, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"Cannot capture a still picture.", (Throwable)e);
        }
    }

    private int getOutputRotation() {
        int sensorOrientation = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        return (sensorOrientation + this.mDisplayOrientation * (this.mFacing == 1 ? 1 : -1) + 360) % 360;
    }

    private void setUpMediaRecorder(String path, int maxDuration, int maxFileSize, boolean recordAudio, CamcorderProfile profile) {
        this.mMediaRecorder = new MediaRecorder();
        this.mMediaRecorder.setVideoSource(2);
        if (recordAudio) {
            this.mMediaRecorder.setAudioSource(1);
        }
        this.mMediaRecorder.setOutputFile(path);
        this.mVideoPath = path;
        if (CamcorderProfile.hasProfile((int)Integer.parseInt(this.mCameraId), (int)profile.quality)) {
            this.setCamcorderProfile(profile, recordAudio);
        } else {
            this.setCamcorderProfile(CamcorderProfile.get((int)1), recordAudio);
        }
        this.mMediaRecorder.setOrientationHint(this.getOutputRotation());
        if (maxDuration != -1) {
            this.mMediaRecorder.setMaxDuration(maxDuration);
        }
        if (maxFileSize != -1) {
            this.mMediaRecorder.setMaxFileSize((long)maxFileSize);
        }
        this.mMediaRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
        this.mMediaRecorder.setOnErrorListener((MediaRecorder.OnErrorListener)this);
    }

    private void setCamcorderProfile(CamcorderProfile profile, boolean recordAudio) {
        this.mMediaRecorder.setOutputFormat(profile.fileFormat);
        this.mMediaRecorder.setVideoFrameRate(profile.videoFrameRate);
        this.mMediaRecorder.setVideoSize(profile.videoFrameWidth, profile.videoFrameHeight);
        this.mMediaRecorder.setVideoEncodingBitRate(profile.videoBitRate);
        this.mMediaRecorder.setVideoEncoder(profile.videoCodec);
        if (recordAudio) {
            this.mMediaRecorder.setAudioEncodingBitRate(profile.audioBitRate);
            this.mMediaRecorder.setAudioChannels(profile.audioChannels);
            this.mMediaRecorder.setAudioSamplingRate(profile.audioSampleRate);
            this.mMediaRecorder.setAudioEncoder(profile.audioCodec);
        }
    }

    private void stopMediaRecorder() {
        this.mIsRecording = false;
        try {
            this.mCaptureSession.stopRepeating();
            this.mCaptureSession.abortCaptures();
            this.mMediaRecorder.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mMediaRecorder.reset();
        this.mMediaRecorder.release();
        this.mMediaRecorder = null;
        if (this.mVideoPath == null || !new File(this.mVideoPath).exists()) {
            this.mCallback.onVideoRecorded(null);
            return;
        }
        this.mCallback.onVideoRecorded(this.mVideoPath);
        this.mVideoPath = null;
    }

    void unlockFocus() {
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        try {
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
            this.updateAutoFocus();
            this.updateFlash();
            if (this.mIsScanning) {
                this.mImageFormat = 35;
                this.startCaptureSession();
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.mCaptureCallback, null);
                this.mCaptureCallback.setState(0);
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"Failed to restart camera preview.", (Throwable)e);
        }
    }

    public void onInfo(MediaRecorder mr, int what, int extra) {
        if (what == 800 || what == 801) {
            this.stopRecording();
        }
    }

    public void onError(MediaRecorder mr, int what, int extra) {
        this.stopRecording();
    }

    static {
        INTERNAL_FACINGS.put(0, 1);
        INTERNAL_FACINGS.put(1, 0);
    }

    private static abstract class PictureCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        static final int STATE_PREVIEW = 0;
        static final int STATE_LOCKING = 1;
        static final int STATE_LOCKED = 2;
        static final int STATE_PRECAPTURE = 3;
        static final int STATE_WAITING = 4;
        static final int STATE_CAPTURING = 5;
        private int mState;

        PictureCaptureCallback() {
        }

        void setState(int state) {
            this.mState = state;
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }

        private void process(@NonNull CaptureResult result) {
            switch (this.mState) {
                case 1: {
                    Integer af = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (af == null || af != 4 && af != 5) break;
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae == null || ae == 2) {
                        this.setState(5);
                        this.onReady();
                        break;
                    }
                    this.setState(2);
                    this.onPrecaptureRequired();
                    break;
                }
                case 3: {
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae != null && ae != 5 && ae != 4 && ae != 2) break;
                    this.setState(4);
                    break;
                }
                case 4: {
                    Integer ae = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (ae != null && ae == 5) break;
                    this.setState(5);
                    this.onReady();
                    break;
                }
            }
        }

        public abstract void onReady();

        public abstract void onPrecaptureRequired();
    }
}

