/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.CamcorderProfile;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.Camera1;
import com.google.android.cameraview.Camera2;
import com.google.android.cameraview.Camera2Api23;
import com.google.android.cameraview.CameraViewImpl;
import com.google.android.cameraview.DisplayOrientationDetector;
import com.google.android.cameraview.PreviewImpl;
import com.google.android.cameraview.Size;
import com.google.android.cameraview.SurfaceViewPreview;
import com.google.android.cameraview.TextureViewPreview;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;

public class CameraView
extends FrameLayout {
    public static final int FACING_BACK = 0;
    public static final int FACING_FRONT = 1;
    public static final int FLASH_OFF = 0;
    public static final int FLASH_ON = 1;
    public static final int FLASH_TORCH = 2;
    public static final int FLASH_AUTO = 3;
    public static final int FLASH_RED_EYE = 4;
    CameraViewImpl mImpl;
    private final CallbackBridge mCallbacks;
    private boolean mAdjustViewBounds;
    private Context mContext;
    private final DisplayOrientationDetector mDisplayOrientationDetector;

    public CameraView(Context context, boolean fallbackToOldApi) {
        this(context, null, fallbackToOldApi);
    }

    public CameraView(Context context, AttributeSet attrs, boolean fallbackToOldApi) {
        this(context, attrs, 0, fallbackToOldApi);
    }

    public CameraView(Context context, AttributeSet attrs, int defStyleAttr, boolean fallbackToOldApi) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            this.mCallbacks = null;
            this.mDisplayOrientationDetector = null;
            return;
        }
        this.mAdjustViewBounds = true;
        this.mContext = context;
        PreviewImpl preview = this.createPreviewImpl(context);
        this.mCallbacks = new CallbackBridge();
        this.mImpl = fallbackToOldApi || Build.VERSION.SDK_INT < 21 ? new Camera1(this.mCallbacks, preview) : (Build.VERSION.SDK_INT < 23 ? new Camera2(this.mCallbacks, preview, context) : new Camera2Api23(this.mCallbacks, preview, context));
        this.mDisplayOrientationDetector = new DisplayOrientationDetector(context){

            @Override
            public void onDisplayOrientationChanged(int displayOrientation) {
                CameraView.this.mImpl.setDisplayOrientation(displayOrientation);
            }
        };
    }

    @NonNull
    private PreviewImpl createPreviewImpl(Context context) {
        PreviewImpl preview = Build.VERSION.SDK_INT < 14 ? new SurfaceViewPreview(context, (ViewGroup)this) : new TextureViewPreview(context, (ViewGroup)this);
        return preview;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.enable(ViewCompat.getDisplay((View)this));
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.mDisplayOrientationDetector.disable();
        }
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        AspectRatio ratio;
        if (this.isInEditMode()) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (this.mAdjustViewBounds) {
            if (!this.isCameraOpened()) {
                this.mCallbacks.reserveRequestLayoutOnOpen();
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (widthMode == 0x40000000 && heightMode != 0x40000000) {
                ratio = this.getAspectRatio();
                assert (ratio != null);
                int height = (int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * ratio.toFloat());
                if (heightMode == Integer.MIN_VALUE) {
                    height = Math.min(height, View.MeasureSpec.getSize((int)heightMeasureSpec));
                }
                super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
            } else if (widthMode != 0x40000000 && heightMode == 0x40000000) {
                ratio = this.getAspectRatio();
                assert (ratio != null);
                int width = (int)((float)View.MeasureSpec.getSize((int)heightMeasureSpec) * ratio.toFloat());
                if (widthMode == Integer.MIN_VALUE) {
                    width = Math.min(width, View.MeasureSpec.getSize((int)widthMeasureSpec));
                }
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), heightMeasureSpec);
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        ratio = this.getAspectRatio();
        if (this.mDisplayOrientationDetector.getLastKnownDisplayOrientation() % 180 == 0) {
            ratio = ratio.inverse();
        }
        assert (ratio != null);
        if (height < width * ratio.getY() / ratio.getX()) {
            this.mImpl.getView().measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(width * ratio.getY() / ratio.getX()), (int)0x40000000));
        } else {
            this.mImpl.getView().measure(View.MeasureSpec.makeMeasureSpec((int)(height * ratio.getX() / ratio.getY()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        state.facing = this.getFacing();
        state.ratio = this.getAspectRatio();
        state.autoFocus = this.getAutoFocus();
        state.flash = this.getFlash();
        state.focusDepth = this.getFocusDepth();
        state.zoom = this.getZoom();
        state.whiteBalance = this.getWhiteBalance();
        state.scanning = this.getScanning();
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setFacing(ss.facing);
        this.setAspectRatio(ss.ratio);
        this.setAutoFocus(ss.autoFocus);
        this.setFlash(ss.flash);
        this.setFocusDepth(ss.focusDepth);
        this.setZoom(ss.zoom);
        this.setWhiteBalance(ss.whiteBalance);
        this.setScanning(ss.scanning);
    }

    public void setUsingCamera2Api(boolean useCamera2) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        boolean wasOpened = this.isCameraOpened();
        Parcelable state = this.onSaveInstanceState();
        if (useCamera2) {
            if (wasOpened) {
                this.stop();
            }
            this.mImpl = Build.VERSION.SDK_INT < 23 ? new Camera2(this.mCallbacks, this.mImpl.mPreview, this.mContext) : new Camera2Api23(this.mCallbacks, this.mImpl.mPreview, this.mContext);
        } else {
            if (this.mImpl instanceof Camera1) {
                return;
            }
            if (wasOpened) {
                this.stop();
            }
            this.mImpl = new Camera1(this.mCallbacks, this.mImpl.mPreview);
        }
        this.onRestoreInstanceState(state);
        if (wasOpened) {
            this.start();
        }
    }

    public void start() {
        if (!this.mImpl.start()) {
            if (this.mImpl.getView() != null) {
                this.removeView(this.mImpl.getView());
            }
            Parcelable state = this.onSaveInstanceState();
            this.mImpl = new Camera1(this.mCallbacks, this.createPreviewImpl(this.getContext()));
            this.onRestoreInstanceState(state);
            this.mImpl.start();
        }
    }

    public void stop() {
        this.mImpl.stop();
    }

    public boolean isCameraOpened() {
        return this.mImpl.isCameraOpened();
    }

    public void addCallback(@NonNull Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeCallback(@NonNull Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (this.mAdjustViewBounds != adjustViewBounds) {
            this.mAdjustViewBounds = adjustViewBounds;
            this.requestLayout();
        }
    }

    public boolean getAdjustViewBounds() {
        return this.mAdjustViewBounds;
    }

    public View getView() {
        if (this.mImpl != null) {
            return this.mImpl.getView();
        }
        return null;
    }

    public void setFacing(int facing) {
        this.mImpl.setFacing(facing);
    }

    public int getFacing() {
        return this.mImpl.getFacing();
    }

    public Set<AspectRatio> getSupportedAspectRatios() {
        return this.mImpl.getSupportedAspectRatios();
    }

    public void setAspectRatio(@NonNull AspectRatio ratio) {
        if (this.mImpl.setAspectRatio(ratio)) {
            this.requestLayout();
        }
    }

    @Nullable
    public AspectRatio getAspectRatio() {
        return this.mImpl.getAspectRatio();
    }

    public void setAutoFocus(boolean autoFocus) {
        this.mImpl.setAutoFocus(autoFocus);
    }

    public boolean getAutoFocus() {
        return this.mImpl.getAutoFocus();
    }

    public void setFlash(@Flash int flash) {
        this.mImpl.setFlash(flash);
    }

    @Flash
    public int getFlash() {
        return this.mImpl.getFlash();
    }

    public void setFocusDepth(float value) {
        this.mImpl.setFocusDepth(value);
    }

    public float getFocusDepth() {
        return this.mImpl.getFocusDepth();
    }

    public void setZoom(float zoom) {
        this.mImpl.setZoom(zoom);
    }

    public float getZoom() {
        return this.mImpl.getZoom();
    }

    public void setWhiteBalance(int whiteBalance) {
        this.mImpl.setWhiteBalance(whiteBalance);
    }

    public int getWhiteBalance() {
        return this.mImpl.getWhiteBalance();
    }

    public void setScanning(boolean isScanning) {
        this.mImpl.setScanning(isScanning);
    }

    public boolean getScanning() {
        return this.mImpl.getScanning();
    }

    public void takePicture() {
        this.mImpl.takePicture();
    }

    public boolean record(String path, int maxDuration, int maxFileSize, boolean recordAudio, CamcorderProfile profile) {
        return this.mImpl.record(path, maxDuration, maxFileSize, recordAudio, profile);
    }

    public void stopRecording() {
        this.mImpl.stopRecording();
    }

    public void setPreviewTexture(SurfaceTexture surfaceTexture) {
        this.mImpl.setPreviewTexture(surfaceTexture);
    }

    public Size getPreviewSize() {
        return this.mImpl.getPreviewSize();
    }

    public static abstract class Callback {
        public void onCameraOpened(CameraView cameraView) {
        }

        public void onCameraClosed(CameraView cameraView) {
        }

        public void onPictureTaken(CameraView cameraView, byte[] data) {
        }

        public void onVideoRecorded(CameraView cameraView, String path) {
        }

        public void onFramePreview(CameraView cameraView, byte[] data, int width, int height, int orientation) {
        }

        public void onMountError(CameraView cameraView) {
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        int facing;
        AspectRatio ratio;
        boolean autoFocus;
        @Flash
        int flash;
        float focusDepth;
        float zoom;
        int whiteBalance;
        boolean scanning;
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        });

        public SavedState(Parcel source, ClassLoader loader) {
            super(source);
            this.facing = source.readInt();
            this.ratio = (AspectRatio)source.readParcelable(loader);
            this.autoFocus = source.readByte() != 0;
            this.flash = source.readInt();
            this.focusDepth = source.readFloat();
            this.zoom = source.readFloat();
            this.whiteBalance = source.readInt();
            this.scanning = source.readByte() != 0;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.facing);
            out.writeParcelable((Parcelable)this.ratio, 0);
            out.writeByte((byte)(this.autoFocus ? 1 : 0));
            out.writeInt(this.flash);
            out.writeFloat(this.focusDepth);
            out.writeFloat(this.zoom);
            out.writeInt(this.whiteBalance);
            out.writeByte((byte)(this.scanning ? 1 : 0));
        }
    }

    private class CallbackBridge
    implements CameraViewImpl.Callback {
        private final ArrayList<Callback> mCallbacks = new ArrayList();
        private boolean mRequestLayoutOnOpen;

        CallbackBridge() {
        }

        public void add(Callback callback) {
            this.mCallbacks.add(callback);
        }

        public void remove(Callback callback) {
            this.mCallbacks.remove(callback);
        }

        @Override
        public void onCameraOpened() {
            if (this.mRequestLayoutOnOpen) {
                this.mRequestLayoutOnOpen = false;
                CameraView.this.requestLayout();
            }
            for (Callback callback : this.mCallbacks) {
                callback.onCameraOpened(CameraView.this);
            }
        }

        @Override
        public void onCameraClosed() {
            for (Callback callback : this.mCallbacks) {
                callback.onCameraClosed(CameraView.this);
            }
        }

        @Override
        public void onPictureTaken(byte[] data) {
            for (Callback callback : this.mCallbacks) {
                callback.onPictureTaken(CameraView.this, data);
            }
        }

        @Override
        public void onVideoRecorded(String path) {
            for (Callback callback : this.mCallbacks) {
                callback.onVideoRecorded(CameraView.this, path);
            }
        }

        @Override
        public void onFramePreview(byte[] data, int width, int height, int orientation) {
            for (Callback callback : this.mCallbacks) {
                callback.onFramePreview(CameraView.this, data, width, height, orientation);
            }
        }

        @Override
        public void onMountError() {
            for (Callback callback : this.mCallbacks) {
                callback.onMountError(CameraView.this);
            }
        }

        public void reserveRequestLayoutOnOpen() {
            this.mRequestLayoutOnOpen = true;
        }
    }

    public static @interface Flash {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Facing {
    }
}

