/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.graphics.SurfaceTexture;
import android.media.CamcorderProfile;
import android.view.View;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.PreviewImpl;
import com.google.android.cameraview.Size;
import java.util.Set;

abstract class CameraViewImpl {
    protected final Callback mCallback;
    protected final PreviewImpl mPreview;

    CameraViewImpl(Callback callback, PreviewImpl preview) {
        this.mCallback = callback;
        this.mPreview = preview;
    }

    View getView() {
        return this.mPreview.getView();
    }

    abstract boolean start();

    abstract void stop();

    abstract boolean isCameraOpened();

    abstract void setFacing(int var1);

    abstract int getFacing();

    abstract Set<AspectRatio> getSupportedAspectRatios();

    abstract boolean setAspectRatio(AspectRatio var1);

    abstract AspectRatio getAspectRatio();

    abstract void setAutoFocus(boolean var1);

    abstract boolean getAutoFocus();

    abstract void setFlash(int var1);

    abstract int getFlash();

    abstract void takePicture();

    abstract boolean record(String var1, int var2, int var3, boolean var4, CamcorderProfile var5);

    abstract void stopRecording();

    abstract void setDisplayOrientation(int var1);

    abstract void setFocusDepth(float var1);

    abstract float getFocusDepth();

    abstract void setZoom(float var1);

    abstract float getZoom();

    abstract void setWhiteBalance(int var1);

    abstract int getWhiteBalance();

    abstract void setScanning(boolean var1);

    abstract boolean getScanning();

    public abstract void setPreviewTexture(SurfaceTexture var1);

    public abstract Size getPreviewSize();

    static interface Callback {
        public void onCameraOpened();

        public void onCameraClosed();

        public void onPictureTaken(byte[] var1);

        public void onVideoRecorded(String var1);

        public void onFramePreview(byte[] var1, int var2, int var3, int var4);

        public void onMountError();
    }
}

