/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;

abstract class PreviewImpl {
    private Callback mCallback;
    private int mWidth;
    private int mHeight;

    PreviewImpl() {
    }

    void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    abstract Surface getSurface();

    abstract View getView();

    abstract Class getOutputClass();

    abstract void setDisplayOrientation(int var1);

    abstract boolean isReady();

    protected void dispatchSurfaceChanged() {
        this.mCallback.onSurfaceChanged();
    }

    protected void dispatchSurfaceDestroyed() {
        this.mCallback.onSurfaceDestroyed();
    }

    SurfaceHolder getSurfaceHolder() {
        return null;
    }

    Object getSurfaceTexture() {
        return null;
    }

    void setBufferSize(int width, int height) {
    }

    void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    static interface Callback {
        public void onSurfaceChanged();

        public void onSurfaceDestroyed();
    }
}

