/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.support.v4.util.ArrayMap;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.Size;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

class SizeMap {
    private final ArrayMap<AspectRatio, SortedSet<Size>> mRatios = new ArrayMap();

    SizeMap() {
    }

    public boolean add(Size size) {
        for (AspectRatio ratio : this.mRatios.keySet()) {
            if (!ratio.matches(size)) continue;
            SortedSet sizes = (SortedSet)this.mRatios.get((Object)ratio);
            if (sizes.contains(size)) {
                return false;
            }
            sizes.add(size);
            return true;
        }
        TreeSet<Size> sizes = new TreeSet<Size>();
        sizes.add(size);
        this.mRatios.put((Object)AspectRatio.of(size.getWidth(), size.getHeight()), sizes);
        return true;
    }

    public void remove(AspectRatio ratio) {
        this.mRatios.remove((Object)ratio);
    }

    Set<AspectRatio> ratios() {
        return this.mRatios.keySet();
    }

    SortedSet<Size> sizes(AspectRatio ratio) {
        return (SortedSet)this.mRatios.get((Object)ratio);
    }

    void clear() {
        this.mRatios.clear();
    }

    boolean isEmpty() {
        return this.mRatios.isEmpty();
    }
}

