/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.cameraview.PreviewImpl;
import org.reactnative.camera.R;

@TargetApi(value=14)
class TextureViewPreview
extends PreviewImpl {
    private final TextureView mTextureView;
    private int mDisplayOrientation;

    TextureViewPreview(Context context, ViewGroup parent) {
        View view = View.inflate((Context)context, (int)R.layout.texture_view, (ViewGroup)parent);
        this.mTextureView = (TextureView)view.findViewById(R.id.texture_view);
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                TextureViewPreview.this.setSize(width, height);
                TextureViewPreview.this.configureTransform();
                TextureViewPreview.this.dispatchSurfaceChanged();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                TextureViewPreview.this.setSize(width, height);
                TextureViewPreview.this.configureTransform();
                TextureViewPreview.this.dispatchSurfaceChanged();
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                TextureViewPreview.this.setSize(0, 0);
                TextureViewPreview.this.dispatchSurfaceDestroyed();
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
    }

    @Override
    @TargetApi(value=15)
    void setBufferSize(int width, int height) {
        this.mTextureView.getSurfaceTexture().setDefaultBufferSize(width, height);
    }

    @Override
    Surface getSurface() {
        return new Surface(this.mTextureView.getSurfaceTexture());
    }

    SurfaceTexture getSurfaceTexture() {
        return this.mTextureView.getSurfaceTexture();
    }

    @Override
    View getView() {
        return this.mTextureView;
    }

    @Override
    Class getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
        this.configureTransform();
    }

    @Override
    boolean isReady() {
        return this.mTextureView.getSurfaceTexture() != null;
    }

    void configureTransform() {
        Matrix matrix = new Matrix();
        if (this.mDisplayOrientation % 180 == 90) {
            float[] fArray;
            int width = this.getWidth();
            int height = this.getHeight();
            float[] fArray2 = new float[]{0.0f, 0.0f, width, 0.0f, 0.0f, height, width, height};
            if (this.mDisplayOrientation == 90) {
                float[] fArray3 = new float[8];
                fArray3[0] = 0.0f;
                fArray3[1] = height;
                fArray3[2] = 0.0f;
                fArray3[3] = 0.0f;
                fArray3[4] = width;
                fArray3[5] = height;
                fArray3[6] = width;
                fArray = fArray3;
                fArray3[7] = 0.0f;
            } else {
                float[] fArray4 = new float[8];
                fArray4[0] = width;
                fArray4[1] = 0.0f;
                fArray4[2] = width;
                fArray4[3] = height;
                fArray4[4] = 0.0f;
                fArray4[5] = 0.0f;
                fArray4[6] = 0.0f;
                fArray = fArray4;
                fArray4[7] = height;
            }
            matrix.setPolyToPoly(fArray2, 0, fArray, 0, 4);
        } else if (this.mDisplayOrientation == 180) {
            matrix.postRotate(180.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        }
        this.mTextureView.setTransform(matrix);
    }
}

