/*
 * Decompiled with CFR 0.152.
 */
package org.reactnative.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerModule;
import com.google.android.cameraview.AspectRatio;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.reactnative.camera.RNCameraView;
import org.reactnative.camera.RNCameraViewHelper;
import org.reactnative.camera.tasks.ResolveTakenPictureAsyncTask;
import org.reactnative.camera.utils.ScopedContext;

public class CameraModule
extends ReactContextBaseJavaModule {
    private static final String TAG = "CameraModule";
    private ScopedContext mScopedContext;
    static final int VIDEO_2160P = 0;
    static final int VIDEO_1080P = 1;
    static final int VIDEO_720P = 2;
    static final int VIDEO_480P = 3;
    static final int VIDEO_4x3 = 4;

    public CameraModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mScopedContext = new ScopedContext((Context)reactContext);
    }

    public ScopedContext getScopedContext() {
        return this.mScopedContext;
    }

    public String getName() {
        return "RNCameraModule";
    }

    @Nullable
    public Map<String, Object> getConstants() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(){
            {
                this.put("Type", this.getTypeConstants());
                this.put("FlashMode", this.getFlashModeConstants());
                this.put("AutoFocus", this.getAutoFocusConstants());
                this.put("WhiteBalance", this.getWhiteBalanceConstants());
                this.put("VideoQuality", this.getVideoQualityConstants());
            }

            private Map<String, Object> getTypeConstants() {
                return Collections.unmodifiableMap(new HashMap<String, Object>(){
                    {
                        this.put("front", 1);
                        this.put("back", 0);
                    }
                });
            }

            private Map<String, Object> getFlashModeConstants() {
                return Collections.unmodifiableMap(new HashMap<String, Object>(){
                    {
                        this.put("off", 0);
                        this.put("on", 1);
                        this.put("auto", 3);
                        this.put("torch", 2);
                    }
                });
            }

            private Map<String, Object> getAutoFocusConstants() {
                return Collections.unmodifiableMap(new HashMap<String, Object>(){
                    {
                        this.put("on", true);
                        this.put("off", false);
                    }
                });
            }

            private Map<String, Object> getWhiteBalanceConstants() {
                return Collections.unmodifiableMap(new HashMap<String, Object>(){
                    {
                        this.put("auto", 0);
                        this.put("cloudy", 1);
                        this.put("sunny", 2);
                        this.put("shadow", 3);
                        this.put("fluorescent", 4);
                        this.put("incandescent", 5);
                    }
                });
            }

            private Map<String, Object> getVideoQualityConstants() {
                return Collections.unmodifiableMap(new HashMap<String, Object>(){
                    {
                        this.put("2160p", 0);
                        this.put("1080p", 1);
                        this.put("720p", 2);
                        this.put("480p", 3);
                        this.put("4:3", 4);
                    }
                });
            }
        });
    }

    @ReactMethod
    public void takePicture(final ReadableMap options, final int viewTag, final Promise promise) {
        ReactApplicationContext context = this.getReactApplicationContext();
        final File cacheDirectory = this.mScopedContext.getCacheDirectory();
        UIManagerModule uiManager = (UIManagerModule)context.getNativeModule(UIManagerModule.class);
        uiManager.addUIBlock(new UIBlock(){

            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                RNCameraView cameraView = (RNCameraView)nativeViewHierarchyManager.resolveView(viewTag);
                try {
                    if (!Build.FINGERPRINT.contains("generic")) {
                        if (cameraView.isCameraOpened()) {
                            cameraView.takePicture(options, promise, cacheDirectory);
                        } else {
                            promise.reject("E_CAMERA_UNAVAILABLE", "Camera is not running");
                        }
                    } else {
                        Bitmap image = RNCameraViewHelper.generateSimulatorPhoto(cameraView.getWidth(), cameraView.getHeight());
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
                        new ResolveTakenPictureAsyncTask(stream.toByteArray(), promise, options, cacheDirectory).execute(new Void[0]);
                    }
                }
                catch (Exception e) {
                    promise.reject("E_CAMERA_BAD_VIEWTAG", "takePictureAsync: Expected a Camera component");
                }
            }
        });
    }

    @ReactMethod
    public void record(final ReadableMap options, final int viewTag, final Promise promise) {
        ReactApplicationContext context = this.getReactApplicationContext();
        final File cacheDirectory = this.mScopedContext.getCacheDirectory();
        UIManagerModule uiManager = (UIManagerModule)context.getNativeModule(UIManagerModule.class);
        uiManager.addUIBlock(new UIBlock(){

            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                try {
                    RNCameraView cameraView = (RNCameraView)nativeViewHierarchyManager.resolveView(viewTag);
                    if (cameraView.isCameraOpened()) {
                        cameraView.record(options, promise, cacheDirectory);
                    } else {
                        promise.reject("E_CAMERA_UNAVAILABLE", "Camera is not running");
                    }
                }
                catch (Exception e) {
                    promise.reject("E_CAMERA_BAD_VIEWTAG", "recordAsync: Expected a Camera component");
                }
            }
        });
    }

    @ReactMethod
    public void stopRecording(final int viewTag) {
        ReactApplicationContext context = this.getReactApplicationContext();
        UIManagerModule uiManager = (UIManagerModule)context.getNativeModule(UIManagerModule.class);
        uiManager.addUIBlock(new UIBlock(){

            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                try {
                    RNCameraView cameraView = (RNCameraView)nativeViewHierarchyManager.resolveView(viewTag);
                    if (cameraView.isCameraOpened()) {
                        cameraView.stopRecording();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @ReactMethod
    public void getSupportedRatios(final int viewTag, final Promise promise) {
        ReactApplicationContext context = this.getReactApplicationContext();
        UIManagerModule uiManager = (UIManagerModule)context.getNativeModule(UIManagerModule.class);
        uiManager.addUIBlock(new UIBlock(){

            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                try {
                    RNCameraView cameraView = (RNCameraView)nativeViewHierarchyManager.resolveView(viewTag);
                    WritableArray result = Arguments.createArray();
                    if (cameraView.isCameraOpened()) {
                        Set<AspectRatio> ratios = cameraView.getSupportedAspectRatios();
                        for (AspectRatio ratio : ratios) {
                            result.pushString(ratio.toString());
                        }
                        promise.resolve((Object)result);
                    } else {
                        promise.reject("E_CAMERA_UNAVAILABLE", "Camera is not running");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

